/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.core;

import gnu.gcj.Core;
import gnu.gcj.RawData;
import java.io.InputStream;

public class CoreInputStream
extends InputStream {
    protected RawData ptr;
    protected int pos;
    protected int mark;
    protected int count;

    private native int unsafeGetByte(long var1);

    private native int copyIntoByteArray(byte[] var1, int var2, int var3);

    public CoreInputStream(Core core) {
        this.ptr = core.ptr;
        this.count = core.length;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public synchronized void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() {
        if (this.pos < this.count) {
            return this.unsafeGetByte(this.pos++) & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] b, int off, int len) {
        if (this.pos >= this.count) {
            return -1;
        }
        int numBytes = Math.min(this.count - this.pos, len);
        this.copyIntoByteArray(b, off, numBytes);
        this.pos += numBytes;
        return numBytes;
    }

    public synchronized void reset() {
        this.pos = this.mark;
    }

    public synchronized long skip(long n) {
        long numBytes = Math.min((long)(this.count - this.pos), n < 0L ? 0L : n);
        this.pos += (int)numBytes;
        return numBytes;
    }
}

