/*-
 * customsL2A.c --
 *	Convert a lst of strings to an argv-style string
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#ifndef lint
static char *rcsid =
"$Id: customsL2A.c,v 1.1 1994/05/18 23:00:01 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    <string.h>

#include    "customs.h"


/*-
 *-----------------------------------------------------------------------
 * Customs_LstToArgv
 *	Convert a lst of strings to an argv-style string.
 *
 * Results:
 *	The argv string, and its length.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
char *
Customs_LstToArgv (lst, lenPtr)
    Lst		lst;
    int		*lenPtr;
{
    int		size = 1;
    char	*result, *cp;
    LstNode	ln;

    if (Lst_Open (lst) == FAILURE) {
	result = cp = (char *)emalloc (1);
    } else {
	/*
	 * Determine total string size
	 */
	for (ln = Lst_Next(lst); ! Lst_IsAtEnd(lst); ln = Lst_Next(lst)) {
	    size += strlen ((char *)Lst_Datum (ln)) + 1;
	}
	Lst_Close (lst);

	result = cp = (char *)emalloc (size);
	Lst_Open (lst);
	for (ln = Lst_Next(lst); ! Lst_IsAtEnd(lst); ln = Lst_Next(lst)) {
	    strcpy (cp, (char *)Lst_Datum (ln));
	    cp += strlen (cp) + 1;
	}
	Lst_Close (lst);
    }

    /*
     * End of list is marked by an extra null byte
     */
    *cp = '\0';

    if (lenPtr) {
	*lenPtr = size;
    }
    return (result);
}

