/*-
 * customsHostA.c --
 *	Request a host with attributes 
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#ifndef lint
static char *rcsid =
"$Id: customsHostA.c,v 1.1 1994/05/18 23:00:01 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    "customs.h"


/*-
 *-----------------------------------------------------------------------
 * Customs_HostAttr --
 *	Request a host with specific attributes for exportation from the
 *	local agent.
 *
 * Results:
 *	As for Customs_Host.  If no host could be found, permitPtr->id
 *	will be non-zero iff the local host can satisfy the requested
 *	attributes.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
Rpc_Stat
Customs_HostAttr(flags, attributes, permitPtr)
    short   	  flags;
    Lst		  attributes;
    ExportPermit  *permitPtr;
{
    char	  *attr;
    int		  attrLen;
    Host_Data	  *dataPtr;
    int		  dataLen;
    
    attr = Customs_LstToArgv (attributes, &attrLen);
    dataLen = sizeof(Host_Data) + attrLen - 1;
    dataPtr = (Host_Data *)emalloc (dataLen);
    memcpy (dataPtr->attrs, attr, attrLen);
    free (attr);

    dataPtr->uid = geteuid();
    dataPtr->flags = flags;

    if (customs_Socket == -1) {
	Customs_Init();
    }
    customs_Status = Rpc_Call(customs_Socket, &customs_AgentAddr,
			  (Rpc_Proc)CUSTOMS_HOST,
			  dataLen, (Rpc_Opaque)dataPtr,
			  sizeof(ExportPermit), (Rpc_Opaque)permitPtr,
			  CUSTOMS_NRETRY, &customs_RetryTimeOut);

    free (dataPtr);
    return(customs_Status);
}

