/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.19
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#if defined(__GNUC__)
    typedef long long __int64; /*For gcc on Windows */
#endif
#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;

#if defined(SWIG_NOINCLUDE)
void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg);
#else


void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  (*jenv)->ExceptionClear(jenv);
  excep = (*jenv)->FindClass(jenv, except_ptr->java_exception);
  if (excep)
    (*jenv)->ThrowNew(jenv, excep, msg);
}


#endif


#include "db_config.h"
#include "db_int.h"
#include "dbinc/txn.h"


/* don't use SWIG's array handling - save code space */
#define	SWIG_NOINCLUDE 1

#define	DB_ENV_INTERNAL(dbenv) ((dbenv)->api2_internal)
#define	DB_INTERNAL(db) ((db)->api_internal)

#define	DB_PKG "com/sleepycat/db/"

/* Forward declarations */
static int __dbj_throw(JNIEnv *jenv, int err, const char *msg, jobject obj, jobject jdbenv);

/* Global data - JVM handle, classes, fields and methods */
static JavaVM *javavm;

static jclass db_class, dbc_class, dbenv_class, dbt_class, dblsn_class;
static jclass dbpreplist_class, dbtxn_class;
static jclass keyrange_class;
static jclass btree_stat_class, hash_stat_class, lock_stat_class;
static jclass log_stat_class, mpool_stat_class, mpool_fstat_class;
static jclass queue_stat_class, rep_stat_class, txn_stat_class;
static jclass txn_active_class;
static jclass lock_class, lockreq_class, rep_processmsg_class;
static jclass dbex_class, deadex_class, lockex_class, memex_class;
static jclass runrecex_class;
static jclass filenotfoundex_class, illegalargex_class;
static jclass bytearray_class, string_class, outputstream_class;

static jfieldID dbc_cptr_fid;
static jfieldID dbt_data_fid, dbt_size_fid, dbt_ulen_fid, dbt_dlen_fid;
static jfieldID dbt_doff_fid, dbt_flags_fid, dbt_offset_fid;
static jfieldID kr_less_fid, kr_equal_fid, kr_greater_fid;
static jfieldID lock_cptr_fid;
static jfieldID lockreq_op_fid, lockreq_mode_fid, lockreq_timeout_fid;
static jfieldID lockreq_obj_fid, lockreq_lock_fid;
static jfieldID rep_processmsg_envid;
static jfieldID txn_stat_active_fid;

static jmethodID dbenv_construct, dbt_construct, dblsn_construct;
static jmethodID dbpreplist_construct, dbtxn_construct;
static jmethodID btree_stat_construct, hash_stat_construct;
static jmethodID lock_stat_construct, log_stat_construct, mpool_stat_construct;
static jmethodID mpool_fstat_construct, queue_stat_construct;
static jmethodID rep_stat_construct, txn_stat_construct, txn_active_construct;
static jmethodID dbex_construct, deadex_construct, lockex_construct;
static jmethodID memex_construct, memex_update_method, runrecex_construct;
static jmethodID filenotfoundex_construct, illegalargex_construct;
static jmethodID lock_construct;

static jmethodID app_dispatch_method, errcall_method, env_feedback_method;
static jmethodID paniccall_method, rep_transport_method;
static jmethodID append_recno_method, bt_compare_method, bt_prefix_method;
static jmethodID db_feedback_method, dup_compare_method, h_hash_method;
static jmethodID seckey_create_method;

static jmethodID outputstream_write_method;

const struct {
	jclass *cl;
	const char *name;
} all_classes[] = {
	{ &dbenv_class, DB_PKG "DbEnv" },
	{ &db_class, DB_PKG "Db" },
	{ &dbc_class, DB_PKG "Dbc" },
	{ &dbt_class, DB_PKG "Dbt" },
	{ &dblsn_class, DB_PKG "DbLsn" },
	{ &dbpreplist_class, DB_PKG "DbPreplist" },
	{ &dbtxn_class, DB_PKG "DbTxn" },

	{ &btree_stat_class, DB_PKG "DbBtreeStat" },
	{ &hash_stat_class, DB_PKG "DbHashStat" },
	{ &lock_stat_class, DB_PKG "DbLockStat" },
	{ &log_stat_class, DB_PKG "DbLogStat" },
	{ &mpool_fstat_class, DB_PKG "DbMpoolFStat" },
	{ &mpool_stat_class, DB_PKG "DbMpoolStat" },
	{ &queue_stat_class, DB_PKG "DbQueueStat" },
	{ &rep_stat_class, DB_PKG "DbRepStat" },
	{ &txn_stat_class, DB_PKG "DbTxnStat" },
	{ &txn_active_class, DB_PKG "DbTxnStat$Active" },

	{ &keyrange_class, DB_PKG "DbKeyRange" },
	{ &lock_class, DB_PKG "DbLock" },
	{ &lockreq_class, DB_PKG "DbLockRequest" },
	{ &rep_processmsg_class, DB_PKG "DbEnv$RepProcessMessage" },

	{ &dbex_class, DB_PKG "DbException" },
	{ &deadex_class, DB_PKG "DbDeadlockException" },
	{ &lockex_class, DB_PKG "DbLockNotGrantedException" },
	{ &memex_class, DB_PKG "DbMemoryException" },
	{ &runrecex_class, DB_PKG "DbRunRecoveryException" },
	{ &filenotfoundex_class, "java/io/FileNotFoundException" },
	{ &illegalargex_class, "java/lang/IllegalArgumentException" },

	{ &bytearray_class, "[B" },
	{ &string_class, "java/lang/String" },
	{ &outputstream_class, "java/io/OutputStream" }
};

const struct {
	jfieldID *fid;
	jclass *cl;
	const char *name;
	const char *sig;
} all_fields[] = {
	{ &dbc_cptr_fid, &dbc_class, "swigCPtr", "J" },
	
	{ &dbt_data_fid, &dbt_class, "data", "[B" },
	{ &dbt_size_fid, &dbt_class, "size", "I" },
	{ &dbt_ulen_fid, &dbt_class, "ulen", "I" },
	{ &dbt_dlen_fid, &dbt_class, "dlen", "I" },
	{ &dbt_doff_fid, &dbt_class, "doff", "I" },
	{ &dbt_flags_fid, &dbt_class, "flags", "I" },
	{ &dbt_offset_fid, &dbt_class, "offset", "I" },

	{ &kr_less_fid, &keyrange_class, "less", "D" },
	{ &kr_equal_fid, &keyrange_class, "equal", "D" },
	{ &kr_greater_fid, &keyrange_class, "greater", "D" },

	{ &lock_cptr_fid, &lock_class, "swigCPtr", "J" },

	{ &lockreq_op_fid, &lockreq_class, "op", "I" },
	{ &lockreq_mode_fid, &lockreq_class, "mode", "I" },
	{ &lockreq_timeout_fid, &lockreq_class, "timeout", "I" },
	{ &lockreq_obj_fid, &lockreq_class, "obj", "L" DB_PKG "Dbt;" },
	{ &lockreq_lock_fid, &lockreq_class, "lock", "L" DB_PKG "DbLock;" },

	{ &rep_processmsg_envid, &rep_processmsg_class, "envid", "I" },
	{ &txn_stat_active_fid, &txn_stat_class, "st_txnarray",
	    "[L" DB_PKG "DbTxnStat$Active;" }
};

const struct {
	jmethodID *mid;
	jclass *cl;
	const char *name;
	const char *sig;
} all_methods[] = {
	{ &dbenv_construct, &dbenv_class, "<init>", "(JZ)V" },
	{ &dbt_construct, &dbt_class, "<init>", "()V" },
	{ &dblsn_construct, &dblsn_class, "<init>", "(JZ)V" },
	{ &dbpreplist_construct, &dbpreplist_class, "<init>",
	    "(L" DB_PKG "DbTxn;[B)V" },
	{ &dbtxn_construct, &dbtxn_class, "<init>", "(JZ)V" },

	{ &btree_stat_construct, &btree_stat_class, "<init>", "()V" },
	{ &hash_stat_construct, &hash_stat_class, "<init>", "()V" },
	{ &lock_stat_construct, &lock_stat_class, "<init>", "()V" },
	{ &log_stat_construct, &log_stat_class, "<init>", "()V" },
	{ &mpool_stat_construct, &mpool_stat_class, "<init>", "()V" },
	{ &mpool_fstat_construct, &mpool_fstat_class, "<init>", "()V" },
	{ &queue_stat_construct, &queue_stat_class, "<init>", "()V" },
	{ &rep_stat_construct, &rep_stat_class, "<init>", "()V" },
	{ &txn_stat_construct, &txn_stat_class, "<init>", "()V" },
	{ &txn_active_construct, &txn_active_class, "<init>", "()V" },

	{ &dbex_construct, &dbex_class, "<init>", "(Ljava/lang/String;IL" DB_PKG "DbEnv;)V" },
	{ &deadex_construct, &deadex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "DbEnv;)V" },
	{ &lockex_construct, &lockex_class, "<init>",
	    "(Ljava/lang/String;IIL" DB_PKG "Dbt;L" DB_PKG "DbLock;IL" DB_PKG "DbEnv;)V" },
	{ &memex_construct, &memex_class, "<init>",
	    "(Ljava/lang/String;L" DB_PKG "Dbt;IL" DB_PKG "DbEnv;)V" },
	{ &memex_update_method, &memex_class, "update_dbt",
	    "(L" DB_PKG "Dbt;)V" },
	{ &runrecex_construct, &runrecex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "DbEnv;)V" },
	{ &filenotfoundex_construct, &filenotfoundex_class, "<init>",
	    "(Ljava/lang/String;)V" },
	{ &illegalargex_construct, &illegalargex_class, "<init>",
	    "(Ljava/lang/String;)V" },

	{ &lock_construct, &lock_class, "<init>", "(JZ)V" },

	{ &app_dispatch_method, &dbenv_class, "handle_app_dispatch",
	    "(L" DB_PKG "Dbt;L" DB_PKG "DbLsn;I)I" },
	{ &env_feedback_method, &dbenv_class, "handle_env_feedback", "(II)V" },
	{ &errcall_method, &dbenv_class, "handle_error",
	    "(Ljava/lang/String;)V" },
	{ &paniccall_method, &dbenv_class, "handle_panic",
	    "(L" DB_PKG "DbException;)V" },
	{ &rep_transport_method, &dbenv_class, "handle_rep_transport",
	    "(L" DB_PKG "Dbt;L" DB_PKG "Dbt;L" DB_PKG "DbLsn;II)I" },

	{ &append_recno_method, &db_class, "handle_append_recno",
	    "(L" DB_PKG "Dbt;I)V" },
	{ &bt_compare_method, &db_class, "handle_bt_compare",
	    "(L" DB_PKG "Dbt;L" DB_PKG "Dbt;)I" },
	{ &bt_prefix_method, &db_class, "handle_bt_prefix",
	    "(L" DB_PKG "Dbt;L" DB_PKG "Dbt;)I" },
	{ &db_feedback_method, &db_class, "handle_db_feedback", "(II)V" },
	{ &dup_compare_method, &db_class, "handle_dup_compare",
	    "(L" DB_PKG "Dbt;L" DB_PKG "Dbt;)I" },
	{ &h_hash_method, &db_class, "handle_h_hash", "([BI)I" },
	{ &seckey_create_method, &db_class, "handle_seckey_create",
	    "(L" DB_PKG "Dbt;L" DB_PKG "Dbt;L" DB_PKG "Dbt;)I" },

	{ &outputstream_write_method, &outputstream_class, "write", "([BII)V" }
};

#define NELEM(x) (sizeof (x) / sizeof (x[0]))

JNIEXPORT void JNICALL
Java_com_sleepycat_db_db_1javaJNI_initialize(JNIEnv *jenv, jclass clazz)
{
	jclass cl;
	unsigned int i;
	
	COMPQUIET(clazz, NULL);
	
	if ((*jenv)->GetJavaVM(jenv, &javavm) != 0) {
		__db_err(NULL, "Cannot get Java VM");
		return;
	}
	
	for (i = 0; i < NELEM(all_classes); i++) {
		cl = (*jenv)->FindClass(jenv, all_classes[i].name);
		if (cl == NULL) {
			__db_err(NULL,
			    "Failed to load class %s - check CLASSPATH",
			    all_classes[i].name);
			return;
		}

		/*
		 * Wrap classes in GlobalRefs so we keep the reference between
		 * calls.
		 */
		*all_classes[i].cl = (jclass)(*jenv)->NewGlobalRef(jenv, cl);

		if (*all_classes[i].cl == NULL) {
			__db_err(NULL,
			    "Failed to create a global reference for class %s",
			    all_classes[i].name);
			return;
		}
	}


	/* Get field IDs */
	for (i = 0; i < NELEM(all_fields); i++) {
		*all_fields[i].fid = (*jenv)->GetFieldID(jenv,
		    *all_fields[i].cl, all_fields[i].name, all_fields[i].sig);
		
		if (*all_fields[i].fid == NULL) {
			__db_err(NULL, "Failed to look up field %s",
			    all_fields[i].name);
			return;
		}
	}
	
	/* Get method IDs */
	for (i = 0; i < NELEM(all_methods); i++) {
		*all_methods[i].mid = (*jenv)->GetMethodID(jenv,
		    *all_methods[i].cl, all_methods[i].name,
		    all_methods[i].sig);
		
		if (*all_methods[i].mid == NULL) {
			__db_err(NULL, "Failed to look up method %s",
			    all_methods[i].name);
			return;
		}
	}
}

static JNIEnv *__dbj_get_jnienv(void)
{
	/*
	 * Note: Different versions of the JNI disagree on the signature for
	 * AttachCurrentThread.  The most recent documentation seems to say
	 * that (JNIEnv **) is correct, but newer JNIs seem to use (void **),
	 * oddly enough.
	 */
#ifdef JNI_VERSION_1_2
	void *jenv = 0;
#else
	JNIEnv *jenv = 0;
#endif

	/*
	 * This should always succeed, as we are called via some Java activity.
	 * I think therefore I am (a thread).
	 */
	if ((*javavm)->AttachCurrentThread(javavm, &jenv, 0) != 0)
		return (0);

	return ((JNIEnv *)jenv);
}

static jobject __dbj_wrap_DB_LSN(JNIEnv *jenv, DB_LSN *lsn)
{
	jlong jptr;
	DB_LSN *lsn_copy;
	int err;

	if ((err = __os_malloc(NULL, sizeof(DB_LSN), &lsn_copy)) != 0) {
		__dbj_throw(jenv, err, NULL, NULL, NULL);
		return NULL;
	}
	memset(lsn_copy, 0, sizeof(DB_LSN));
	*lsn_copy = *lsn;
	/* Magic to convert a pointer to a long - must match SWIG */
	*(DB_LSN **)&jptr = lsn_copy;
	return (*jenv)->NewObject(jenv, dblsn_class, dblsn_construct,
	    jptr, JNI_TRUE);
}


/*
 * Macros to find the Java DbEnv object for methods in various classes.
 * Note that "arg1" is from the code SWIG generates for the "this"/"self".
 */
#define	JDBENV (arg1 ? (jobject)DB_ENV_INTERNAL(arg1) : NULL)
#define	DB2JDBENV ((jobject)DB_ENV_INTERNAL(arg1->dbenv))
#define	DBC2JDBENV ((jobject)DB_ENV_INTERNAL(arg1->dbp->dbenv))
#define	TXN2JDBENV ((jobject)DB_ENV_INTERNAL(arg1->mgrp->dbenv))



static jthrowable __dbj_get_except(JNIEnv *jenv,
    int err, const char *msg, jobject obj, jobject jdbenv) {
	jobject jmsg;

	if (msg == NULL)
		msg = db_strerror(err);
	
	jmsg = (*jenv)->NewStringUTF(jenv, msg);

	switch (err) {
	case EINVAL:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    illegalargex_class, illegalargex_construct, jmsg);

	case ENOENT:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    filenotfoundex_class, filenotfoundex_construct, jmsg);

	case ENOMEM:
		return (jthrowable)(*jenv)->NewObject(jenv, memex_class,
		    memex_construct, jmsg, obj, err, jdbenv);

	case DB_RUNRECOVERY:
		return (jthrowable)(*jenv)->NewObject(jenv, runrecex_class,
		    runrecex_construct, jmsg, err, jdbenv);

	case DB_LOCK_DEADLOCK:
		return (jthrowable)(*jenv)->NewObject(jenv, deadex_class,
		    deadex_construct, jmsg, err, jdbenv);
	
	case DB_LOCK_NOTGRANTED:
		return (jthrowable)(*jenv)->NewObject(jenv, lockex_class,
		    lockex_construct, jmsg, 0, 0, NULL, NULL, 0, jdbenv);
	
	default:
		return (jthrowable)(*jenv)->NewObject(jenv, dbex_class,
		    dbex_construct, jmsg, err, jdbenv);
	}
}

static int __dbj_throw(JNIEnv *jenv, int err, const char *msg, jobject obj, jobject jdbenv)
{
	jthrowable t;

	/* If an exception is pending, ignore requests to throw a new one. */
	if ((*jenv)->ExceptionOccurred(jenv) == NULL) {
		if ((t = __dbj_get_except(jenv, err, msg, obj, jdbenv)) == NULL) {
			/*
			 * This is a problem - something went wrong creating an
			 * exception.  We have to assume there is an exception
			 * created by the JVM that is pending as a result
			 * (e.g., OutOfMemoryError), but we don't want to lose
			 * this error, so we just call __db_err here.
			 */
			if (msg == NULL)
				msg = db_strerror(err);
	
			 __db_err(NULL, "Couldn't create exception for: '%s'",
			     msg);
		} else
			(*jenv)->Throw(jenv, t);
	}
	
	return (err);
}


typedef struct __dbt_locked {
	DBT dbt;
	jbyteArray jarr;
	jbyte *orig_data;
	jint offset;
	u_int32_t orig_size;
} DBT_LOCKED;

static int __dbj_dbt_copyin(
    JNIEnv *jenv, DBT_LOCKED *ldbt, jobject jdbt)
{
	DBT *dbt;
	jsize array_len;
	
	dbt = &ldbt->dbt;
	ldbt->offset = (*jenv)->GetIntField(jenv, jdbt, dbt_offset_fid);
	ldbt->jarr = (jbyteArray)(*jenv)->GetObjectField(jenv,
	    jdbt, dbt_data_fid);
	if (ldbt->jarr == NULL) {
		ldbt->orig_data = dbt->data = NULL;
		array_len = 0;
	} else {
		ldbt->orig_data = (*jenv)->GetByteArrayElements(jenv,
		    ldbt->jarr, NULL);
		array_len = (*jenv)->GetArrayLength(jenv, ldbt->jarr);
		dbt->data = ldbt->orig_data + ldbt->offset;
	}

	dbt->size = (*jenv)->GetIntField(jenv, jdbt, dbt_size_fid);
	ldbt->orig_size = dbt->size;
	dbt->ulen = (*jenv)->GetIntField(jenv, jdbt, dbt_ulen_fid);
	dbt->dlen = (*jenv)->GetIntField(jenv, jdbt, dbt_dlen_fid);
	dbt->doff = (*jenv)->GetIntField(jenv, jdbt, dbt_doff_fid);
	dbt->flags = (*jenv)->GetIntField(jenv, jdbt, dbt_flags_fid);

	/*
	 * We don't support DB_DBT_REALLOC - map anything that's not USERMEM to
	 * MALLOC.
	 */
	if (!F_ISSET(dbt, DB_DBT_USERMEM)) {
		F_CLR(dbt, DB_DBT_REALLOC);
		F_SET(dbt, DB_DBT_MALLOC);
	}
	
	/*
	 * Some code makes the assumption that if dbt->size is non-zero, there
	 * is data to copy from dbt->data.  We may have set dbt->size to a
	 * non-zero integer above but decided not to point dbt->data at
	 * anything.
	 *
	 * Clean up the dbt fields so we don't run into trouble.  (Note that
	 * doff, dlen, and flags all may contain meaningful values.)
	 */
	if (dbt->data == NULL)
		dbt->size = dbt->ulen = 0;

	/* Verify other parameters */
	if (ldbt->offset < 0)
		return (__dbj_throw(jenv, EINVAL, "Dbt.offset illegal", NULL, NULL));
	else if ((jsize)(dbt->size + ldbt->offset) > array_len)
		return (__dbj_throw(jenv, EINVAL,
		    "Dbt.size + Dbt.offset greater than array length", NULL, NULL));
	else if ((jint)dbt->doff < 0)
		return (__dbj_throw(jenv, EINVAL, "Dbt.doff illegal", NULL, NULL));
	else if ((jsize)dbt->ulen > array_len)
		return (__dbj_throw(jenv, EINVAL,
		    "Dbt.ulen greater than array length", NULL, NULL));
	
	return (0);
}

static void __dbj_dbt_copyout(
    JNIEnv *jenv, const DBT *dbt, jbyteArray *jarr, jobject jdbt)
{
	jbyteArray newarr = (*jenv)->NewByteArray(jenv, (jsize)dbt->size);
	if (newarr == NULL)
		return; /* An exception is pending */
	(*jenv)->SetByteArrayRegion(jenv, newarr, 0, (jsize)dbt->size,
	    (jbyte *)dbt->data);
	(*jenv)->SetObjectField(jenv, jdbt, dbt_data_fid, newarr);
	(*jenv)->SetIntField(jenv, jdbt, dbt_size_fid, (jint)dbt->size);
	if (jarr != NULL)
		*jarr = newarr;
	else
		(*jenv)->DeleteLocalRef(jenv, newarr);
}

static void __dbj_dbt_release(
    JNIEnv *jenv, jobject jdbt, DBT *dbt, DBT_LOCKED *ldbt) {
	jthrowable t;
	
	if (ldbt->jarr != NULL) {
		(*jenv)->ReleaseByteArrayElements(jenv, ldbt->jarr,
		    ldbt->orig_data, 0);
	}

	if (dbt->size != ldbt->orig_size)
		(*jenv)->SetIntField(jenv, jdbt, dbt_size_fid, (jint)dbt->size);
	    
	if (F_ISSET(dbt, DB_DBT_USERMEM) &&
	    dbt->size > dbt->ulen &&
	    (t = (*jenv)->ExceptionOccurred(jenv)) != NULL &&
	    (*jenv)->IsInstanceOf(jenv, t, memex_class)) {
		(*jenv)->CallNonvirtualVoidMethod(jenv, t, memex_class,
		    memex_update_method, jdbt);
		/*
		 * We have to rethrow the exception because calling into Java
		 * clears it.
		 */
		(*jenv)->Throw(jenv, t);
	}
	if (ldbt->dbt.data != ldbt->orig_data + ldbt->offset) {
		__dbj_dbt_copyout(jenv, &ldbt->dbt, NULL, jdbt);
		(*jenv)->SetIntField(jenv, jdbt, dbt_offset_fid, 0);
		__os_ufree(NULL, ldbt->dbt.data);
	}
}


struct __dbj_verify_data {
	JNIEnv *jenv;
	jobject streamobj;
	jbyteArray bytes;
	int nbytes;
};

static int __dbj_verify_callback(void *handle, const void *str_arg) {
	char *str;
	struct __dbj_verify_data *vd;
	int len;
	JNIEnv *jenv;

	str = (char *)str_arg;
	vd = (struct __dbj_verify_data *)handle;
	jenv = vd->jenv;
	len = strlen(str) + 1;
	if (len > vd->nbytes) {
		vd->nbytes = len;
		if (vd->bytes != NULL)
			(*jenv)->DeleteLocalRef(jenv, vd->bytes);
		if ((vd->bytes = (*jenv)->NewByteArray(jenv, (jsize)len))
		    == NULL)
			return (ENOMEM);
	}

	if (vd->bytes != NULL) {
		(*jenv)->SetByteArrayRegion(jenv, vd->bytes, 0, (jsize)len,
		    (jbyte*)str);
		(*jenv)->CallVoidMethod(jenv, vd->streamobj,
		    outputstream_write_method, vd->bytes, 0, len - 1);
	}

	if ((*jenv)->ExceptionOccurred(jenv) != NULL)
		return (EIO);

	return (0);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1lock_1vec
    (JNIEnv *jenv, jclass jcls, jlong jdbenvp, jint locker,
    jint flags, jobjectArray list, jint offset, jint count) {
	DB_ENV *dbenv;
	DB_LOCKREQ *lockreq;
	DB_LOCKREQ *prereq;	/* preprocessed requests */
	DB_LOCKREQ *failedreq;
	DB_LOCK *lockp;
	DBT_LOCKED *locked_dbts;
	int err, alloc_err, i;
	size_t bytesize, ldbtsize;
	jobject jlockreq;
	db_lockop_t op;
	jobject jobj, jlock, jdbenv;
	jlong jlockp;
	int completed;

	COMPQUIET(jcls, NULL);
	dbenv = *(DB_ENV **)&jdbenvp;
	jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);

	if (dbenv == NULL) {
		__dbj_throw(jenv, EINVAL, "null object", NULL, jdbenv);
		return;
	}

	if ((*jenv)->GetArrayLength(jenv, list) < offset + count) {
		__dbj_throw(jenv, EINVAL,
		    "DbEnv.lock_vec array not large enough", NULL, jdbenv);
		goto out0;
	}

	bytesize = sizeof(DB_LOCKREQ) * count;
	if ((err = __os_malloc(dbenv, bytesize, &lockreq)) != 0) {
		__dbj_throw(jenv, err, NULL, NULL, jdbenv);
		goto out0;
	}
	memset(lockreq, 0, bytesize);

	ldbtsize = sizeof(DBT_LOCKED) * count;
	if ((err = __os_malloc(dbenv, ldbtsize, &locked_dbts)) != 0) {
		__dbj_throw(jenv, err, NULL, NULL, jdbenv);
		goto out1;
	}
	memset(locked_dbts, 0, ldbtsize);
	prereq = &lockreq[0];

	/* fill in the lockreq array */
	for (i = 0, prereq = &lockreq[0]; i < count; i++, prereq++) {
		jlockreq = (*jenv)->GetObjectArrayElement(jenv, list,
		    offset + i);
		if (jlockreq == NULL) {
			__dbj_throw(jenv, EINVAL,
			    "DbEnv.lock_vec list entry is null", NULL, jdbenv);
			goto out2;
		}
		op = (*jenv)->GetIntField(jenv, jlockreq, lockreq_op_fid);
		prereq->op = op;

		switch (op) {
		case DB_LOCK_GET_TIMEOUT:
			/* Needed: mode, timeout, obj.  Returned: lock. */
			prereq->op = (*jenv)->GetIntField(jenv, jlockreq,
			    lockreq_timeout_fid);
			/* FALLTHROUGH */
		case DB_LOCK_GET:
			/* Needed: mode, obj.  Returned: lock. */
			prereq->mode = (*jenv)->GetIntField(jenv, jlockreq,
			    lockreq_mode_fid);
			jobj = (*jenv)->GetObjectField(jenv, jlockreq,
			    lockreq_obj_fid);
			if ((err =
			    __dbj_dbt_copyin(jenv, &locked_dbts[i], jobj)) != 0)
				goto out2;
			prereq->obj = &locked_dbts[i].dbt;
			break;
		case DB_LOCK_PUT:
			/* Needed: lock.  Ignored: mode, obj. */
			jlock = (*jenv)->GetObjectField(jenv, jlockreq,
				lockreq_lock_fid);
			if (jlock == NULL ||
			    (jlockp = (*jenv)->GetLongField(jenv, jlock,
			    lock_cptr_fid)) == 0L) {
				__dbj_throw(jenv, EINVAL,
				    "DbLockRequest lock field is NULL", NULL, jdbenv);
				goto out2;
			}
			lockp = *(DB_LOCK **)&jlockp;
			prereq->lock = *lockp;
			break;
		case DB_LOCK_PUT_ALL:
		case DB_LOCK_TIMEOUT:
			/* Needed: (none).  Ignored: lock, mode, obj. */
			break;
		case DB_LOCK_PUT_OBJ:
			/* Needed: obj.  Ignored: lock, mode. */
			jobj = (*jenv)->GetObjectField(jenv, jlockreq,
			    lockreq_obj_fid);
			if ((err =
			    __dbj_dbt_copyin(jenv, &locked_dbts[i], jobj)) != 0)
				goto out2;
			prereq->obj = &locked_dbts[i].dbt;
			break;
		default:
			__dbj_throw(jenv, EINVAL,
			    "DbEnv.lock_vec bad op value", NULL, jdbenv);
			goto out2;
		}
	}

	err = dbenv->lock_vec(dbenv, (u_int32_t)locker, (u_int32_t)flags,
	    lockreq, count, &failedreq);
	if (err == 0)
		completed = count;
	else
		completed = failedreq - lockreq;

	/* do post processing for any and all requests that completed */
	for (i = 0; i < completed; i++) {
		op = lockreq[i].op;
		if (op == DB_LOCK_PUT) {
			/*
			 * After a successful put, the DbLock can no longer be
			 * used, so we release the storage related to it.
			 */
			jlockreq = (*jenv)->GetObjectArrayElement(jenv,
			    list, i + offset);
			jlock = (*jenv)->GetObjectField(jenv, jlockreq,
			    lockreq_lock_fid);
			jlockp = (*jenv)->GetLongField(jenv, jlock,
			    lock_cptr_fid);
			lockp = *(DB_LOCK **)&jlockp;
			__os_free(NULL, lockp);
			(*jenv)->SetLongField(jenv, jlock, lock_cptr_fid,
			    (jlong)0);
		}
		else if (op == DB_LOCK_GET) {
			/*
			 * Store the lock that was obtained.  We need to create
			 * storage for it since the lockreq array only exists
			 * during this method call.
			 */
			if ((alloc_err =
			    __os_malloc(dbenv, sizeof(DB_LOCK), &lockp)) != 0) {
				__dbj_throw(jenv, alloc_err, NULL, NULL, jdbenv);
				goto out2;
			}

			*lockp = lockreq[i].lock;
			*(DB_LOCK **)&jlockp = lockp;

			jlockreq = (*jenv)->GetObjectArrayElement(jenv,
			    list, i + offset);
			jlock = (*jenv)->NewObject(jenv, lock_class,
			    lock_construct, jlockp, JNI_TRUE);
			if (jlock == NULL)
				goto out2; /* An exception is pending */
			(*jenv)->SetLongField(jenv, jlock, lock_cptr_fid,
			    jlockp);
			(*jenv)->SetObjectField(jenv, jlockreq,
			    lockreq_lock_fid, jlock);
		}
	}

	/* If one of the locks was not granted, build the exception now. */
	if (err == DB_LOCK_NOTGRANTED && i < count) {
		jlockreq = (*jenv)->GetObjectArrayElement(jenv, list,
		    i + offset);
		jobj = (*jenv)->GetObjectField(jenv, jlockreq,
		    lockreq_obj_fid);
		jlock = (*jenv)->GetObjectField(jenv, jlockreq,
		    lockreq_lock_fid);
		(*jenv)->Throw(jenv,
		    (*jenv)->NewObject(jenv, lockex_class, lockex_construct,
		    (*jenv)->NewStringUTF(jenv, "DbEnv.lock_vec incomplete"),
		    lockreq[i].op, lockreq[i].mode, jobj, jlock, i, jdbenv));
	} else if (err != 0)
		__dbj_throw(jenv, err, NULL, NULL, jdbenv);

out2:	/* Free the dbts that we have locked */
	for (i = 0 ; i < (prereq - lockreq); i++) {
		if (((op = lockreq[i].op) == DB_LOCK_GET ||
		    op == DB_LOCK_PUT_OBJ) &&
		    locked_dbts[i].jarr != NULL)
			(*jenv)->ReleaseByteArrayElements(jenv,
			    locked_dbts[i].jarr, locked_dbts[i].orig_data, 0);
	}
	__os_free(dbenv, locked_dbts);
out1:	__os_free(dbenv, lockreq);
out0:	return;
}


/*
 * These macros are used by code generated by the s_java script.
 */
#define JAVADB_STAT_INT(jenv, cl, jobj, statp, name)			\
		(*jenv)->SetIntField(jenv, jobj,			\
		    (*jenv)->GetFieldID(jenv, cl, #name, "I"),		\
		    (jint)statp->name)

#define JAVADB_STAT_STRING(jenv, cl, jobj, statp, name)			\
		(*jenv)->SetObjectField(jenv, jobj,			\
		    (*jenv)->GetFieldID(jenv, cl, #name,		\
		        "Ljava/lang/String;"),				\
		    (*jenv)->NewStringUTF(jenv, statp->name))

#define JAVADB_STAT_LSN(jenv, cl, jobj, statp, name)			\
		(*jenv)->SetObjectField(jenv, jobj,			\
		(*jenv)->GetFieldID(jenv, cl, #name, "L" DB_PKG "DbLsn;"), \
		    __dbj_wrap_DB_LSN(jenv, &statp->name))

#define JAVADB_STAT_LONG(jenv, cl, jobj, statp, name)			\
		(*jenv)->SetLongField(jenv, jobj,			\
		    (*jenv)->GetFieldID(jenv, cl, #name, "J"),		\
		    (jlong)statp->name)

#define JAVADB_STAT_XID(jenv, cl, jobj, statp, name) {			\
	jobject jarr = (*jenv)->NewByteArray(jenv, (jsize)DB_XIDDATASIZE); \
	(*jenv)->SetByteArrayRegion(jenv, jarr, 0, (jsize)DB_XIDDATASIZE, \
	    (jbyte *)statp->name);					\
	(*jenv)->SetObjectField(jenv, jobj,				\
	    (*jenv)->GetFieldID(jenv, cl, #name, "[B"), jarr);		\
	}

/*
 * We build the active list separately.
 */
#define JAVADB_STAT_ACTIVE(jenv, cl, jobj, statp, name) \
	do {} while(0)

#include "java_stat_auto.c"


/*
 * We do a dance so that the prefix in the C API points to the DB_ENV.
 * The real prefix is stored as a Java string in the DbEnv object.
 */
static void __dbj_error(const char *prefix, char *msg)
{
	DB_ENV *dbenv = (DB_ENV *)prefix;
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);

	if (jdbenv != NULL)
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv, dbenv_class,
		    errcall_method, (*jenv)->NewStringUTF(jenv, msg));
}

static void __dbj_env_feedback(DB_ENV *dbenv, int opcode, int percent)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);

	(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv, dbenv_class,
	    env_feedback_method, opcode, percent);
}

static void __dbj_panic(DB_ENV *dbenv, int err)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);

	(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv, dbenv_class,
	    paniccall_method, __dbj_get_except(jenv, err, NULL, NULL, jdbenv));
}

static int __dbj_app_dispatch(DB_ENV *dbenv,
    DBT *dbt, DB_LSN *lsn, db_recops recops)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	jobject jdbt, jlsn;
	jbyteArray jdbtarr;
	int ret;

	jdbt = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	__dbj_dbt_copyout(jenv, dbt, &jdbtarr, jdbt);
	if (jdbt == NULL)
		return (ENOMEM); /* An exception is pending */

	jlsn = (lsn == NULL) ? NULL : __dbj_wrap_DB_LSN(jenv, lsn);

	ret = (*jenv)->CallNonvirtualIntMethod(jenv, jdbenv, dbenv_class,
	    app_dispatch_method, jdbt, jlsn, recops);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}
	
	(*jenv)->DeleteLocalRef(jenv, jdbtarr);
	(*jenv)->DeleteLocalRef(jenv, jdbt);
	if (jlsn != NULL)
		(*jenv)->DeleteLocalRef(jenv, jlsn);

	return (ret);
}

static int __dbj_rep_transport(DB_ENV *dbenv,
    const DBT *control, const DBT *rec, const DB_LSN *lsn, int envid,
    u_int32_t flags)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	jobject jcontrol, jrec, jlsn;
	jbyteArray jcontrolarr, jrecarr;
	int ret;

	jcontrol = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	jrec = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	if (jcontrol == NULL || jrec == NULL)
		return (ENOMEM); /* An exception is pending */

	__dbj_dbt_copyout(jenv, control, &jcontrolarr, jcontrol);
	__dbj_dbt_copyout(jenv, rec, &jrecarr, jrec);
	jlsn = (lsn == NULL) ? NULL : __dbj_wrap_DB_LSN(jenv, (DB_LSN *)lsn);

	if (jcontrolarr == NULL || jrecarr == NULL)
		return (ENOMEM); /* An exception is pending */

	ret = (*jenv)->CallNonvirtualIntMethod(jenv, jdbenv, dbenv_class,
	    rep_transport_method, jcontrol, jrec, jlsn, envid, flags);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}
	
	(*jenv)->DeleteLocalRef(jenv, jrecarr);
	(*jenv)->DeleteLocalRef(jenv, jcontrolarr);
	(*jenv)->DeleteLocalRef(jenv, jrec);
	(*jenv)->DeleteLocalRef(jenv, jcontrol);
	if (jlsn != NULL)
		(*jenv)->DeleteLocalRef(jenv, jlsn);

	return (ret);
}

static int __dbj_seckey_create(DB *db,
    const DBT *key, const DBT *data, DBT *result)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jkey, jdata, jresult;
	jbyteArray jkeyarr, jdataarr;
	DBT_LOCKED lresult;
	void *data_copy;
	int ret;

	jkey = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	jdata = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	jresult = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	if (jkey == NULL || jdata == NULL || jresult == NULL)
		return (ENOMEM); /* An exception is pending */
	
	__dbj_dbt_copyout(jenv, key, &jkeyarr, jkey);
	__dbj_dbt_copyout(jenv, data, &jdataarr, jdata);

	if (jkeyarr == NULL || jdataarr == NULL)
		return (ENOMEM); /* An exception is pending */
	
	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    seckey_create_method, jkey, jdata, jresult);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
		goto err;
	}
	
	if ((ret = __dbj_dbt_copyin(jenv, &lresult, jresult)) != 0)
		goto err;

	if (lresult.jarr != NULL) {
		/*
		 * If there's data, we need to make a copy because we can't
		 * keep the Java array pinned.
		 */
		memset(result, 0, sizeof (DBT));
		*result = lresult.dbt;
		if ((ret = __os_umalloc(NULL, result->size, &data_copy)) == 0)
			memcpy(data_copy, result->data, result->size);
		(*jenv)->ReleaseByteArrayElements(jenv, lresult.jarr,
		    lresult.orig_data, 0);
		(*jenv)->DeleteLocalRef(jenv, lresult.jarr);
		result->data = data_copy;
		result->flags |= DB_DBT_APPMALLOC;
	}
	
err:	(*jenv)->DeleteLocalRef(jenv, jkeyarr);
	(*jenv)->DeleteLocalRef(jenv, jkey);
	(*jenv)->DeleteLocalRef(jenv, jdataarr);
	(*jenv)->DeleteLocalRef(jenv, jdata);
	(*jenv)->DeleteLocalRef(jenv, jresult);

	return (ret);
}

static int __dbj_append_recno(DB *db, DBT *dbt, db_recno_t recno)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jdbt;
	DBT_LOCKED lresult;
	void *data_copy;
	jbyteArray jdbtarr;
	int ret;

	jdbt = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	if (jdbt == NULL)
		return (ENOMEM); /* An exception is pending */

	__dbj_dbt_copyout(jenv, dbt, &jdbtarr, jdbt);
	if (jdbtarr == NULL)
		return (ENOMEM); /* An exception is pending */

	ret = 0;
	(*jenv)->CallNonvirtualVoidMethod(jenv, jdb, db_class,
 	    append_recno_method, jdbt, recno);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
		goto err;
	}

	if ((ret = __dbj_dbt_copyin(jenv, &lresult, jdbt)) != 0)
		goto err;

	if (lresult.jarr != NULL) {
		/*
		 * If there's data, we need to make a copy because we can't
		 * keep the Java array pinned.
		 */
		*dbt = lresult.dbt;
		if ((ret = __os_umalloc(db->dbenv, dbt->size, &data_copy)) == 0)
			memcpy(data_copy, dbt->data, dbt->size);
		(*jenv)->ReleaseByteArrayElements(jenv, lresult.jarr,
		    lresult.orig_data, 0);
		(*jenv)->DeleteLocalRef(jenv, lresult.jarr);
		dbt->data = data_copy;
		dbt->flags |= DB_DBT_APPMALLOC;
	}

err:	(*jenv)->DeleteLocalRef(jenv, jdbtarr);
	(*jenv)->DeleteLocalRef(jenv, jdbt);

	return (ret);
}

static int __dbj_bt_compare(DB *db, const DBT *dbt1, const DBT *dbt2)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jdbt1, jdbt2;
	jbyteArray jdbtarr1, jdbtarr2;
	int ret;

	jdbt1 = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	jdbt2 = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	if (jdbt1 == NULL || jdbt2 == NULL)
		return ENOMEM; /* An exception is pending */

	__dbj_dbt_copyout(jenv, dbt1, &jdbtarr1, jdbt1);
	__dbj_dbt_copyout(jenv, dbt2, &jdbtarr2, jdbt2);
	if (jdbtarr1 == NULL || jdbtarr2 == NULL)
		return ENOMEM; /* An exception is pending */
	
	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    bt_compare_method, jdbt1, jdbt2);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}
	
	(*jenv)->DeleteLocalRef(jenv, jdbtarr2);
	(*jenv)->DeleteLocalRef(jenv, jdbtarr1);
	(*jenv)->DeleteLocalRef(jenv, jdbt2);
	(*jenv)->DeleteLocalRef(jenv, jdbt1);

	return (ret);
}

static size_t __dbj_bt_prefix(DB *db, const DBT *dbt1, const DBT *dbt2)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jdbt1, jdbt2;
	jbyteArray jdbtarr1, jdbtarr2;
	int ret;

	jdbt1 = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	jdbt2 = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	if (jdbt1 == NULL || jdbt2 == NULL)
		return ENOMEM; /* An exception is pending */

	__dbj_dbt_copyout(jenv, dbt1, &jdbtarr1, jdbt1);
	__dbj_dbt_copyout(jenv, dbt2, &jdbtarr2, jdbt2);
	if (jdbtarr1 == NULL || jdbtarr2 == NULL)
		return ENOMEM; /* An exception is pending */
	
	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    bt_prefix_method, jdbt1, jdbt2);
	
	(*jenv)->DeleteLocalRef(jenv, jdbtarr2);
	(*jenv)->DeleteLocalRef(jenv, jdbtarr1);
	(*jenv)->DeleteLocalRef(jenv, jdbt2);
	(*jenv)->DeleteLocalRef(jenv, jdbt1);

	return (ret);
}

static int __dbj_dup_compare(DB *db, const DBT *dbt1, const DBT *dbt2)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jdbt1, jdbt2;
	jbyteArray jdbtarr1, jdbtarr2;
	int ret;

	jdbt1 = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	jdbt2 = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	if (jdbt1 == NULL || jdbt2 == NULL)
		return ENOMEM; /* An exception is pending */

	__dbj_dbt_copyout(jenv, dbt1, &jdbtarr1, jdbt1);
	__dbj_dbt_copyout(jenv, dbt2, &jdbtarr2, jdbt2);
	if (jdbtarr1 == NULL || jdbtarr2 == NULL)
		return ENOMEM; /* An exception is pending */

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    dup_compare_method, jdbt1, jdbt2);
	
	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}
	
	(*jenv)->DeleteLocalRef(jenv, jdbtarr2);
	(*jenv)->DeleteLocalRef(jenv, jdbtarr1);
	(*jenv)->DeleteLocalRef(jenv, jdbt2);
	(*jenv)->DeleteLocalRef(jenv, jdbt1);

	return (ret);
}

static void __dbj_db_feedback(DB *db, int opcode, int percent)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);

	(*jenv)->CallNonvirtualVoidMethod(jenv, jdb, db_class,
	    db_feedback_method, opcode, percent);
}

static u_int32_t __dbj_h_hash(DB *db, const void *data, u_int32_t len)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);
	jbyteArray jarr = (*jenv)->NewByteArray(jenv, (jsize)len);
	int ret;

	if (jarr == NULL)
		return ENOMEM; /* An exception is pending */

	(*jenv)->SetByteArrayRegion(jenv, jarr, 0, (jsize)len, (jbyte *)data);

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    h_hash_method, jarr, len);

	(*jenv)->DeleteLocalRef(jenv, jarr);

	return (ret);
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_db_1javaJNI_initDbEnvRef0(
    JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
	DB_ENV *self = *(DB_ENV **)&jarg1;
	COMPQUIET(jcls, NULL);

	DB_ENV_INTERNAL(self) = (void *)(*jenv)->NewGlobalRef(jenv, jarg2);
	self->set_errpfx(self, (const char*)self);
	return (jobject)DB_ENV_INTERNAL(self);
}

JNIEXPORT jobject JNICALL Java_com_sleepycat_db_db_1javaJNI_initDbRef0(
    JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
	DB *self = *(DB **)&jarg1;
	COMPQUIET(jcls, NULL);

	DB_INTERNAL(self) = (void *)(*jenv)->NewGlobalRef(jenv, jarg2);
	return (jobject)DB_INTERNAL(self);
}

JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_deleteRef0(
    JNIEnv *jenv, jclass jcls, jobject jref) {
	COMPQUIET(jcls, NULL);

	if (jref != NULL)
		(*jenv)->DeleteGlobalRef(jenv, jref);
}

JNIEXPORT jobject JNICALL Java_com_sleepycat_db_db_1javaJNI_getDbRef0(
    JNIEnv *jenv, jclass jcls, jlong jarg1) {
	DB *self = *(DB **)&jarg1;
	COMPQUIET(jcls, NULL);
	COMPQUIET(jenv, NULL);

	return (jobject)DB_INTERNAL(self);
}

JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_getDbEnv0(
    JNIEnv *jenv, jclass jcls, jlong jarg1) {
	DB *self = *(DB **)&jarg1;
	jlong env_cptr;

	COMPQUIET(jenv, NULL);
	COMPQUIET(jcls, NULL);

	*(DB_ENV **)&env_cptr = self->dbenv;
	return env_cptr;
}

JNIEXPORT jboolean JNICALL
Java_com_sleepycat_db_DbUtil_is_1big_1endian(JNIEnv *jenv, jclass clazz)
{
	COMPQUIET(jenv, NULL);
	COMPQUIET(clazz, NULL);

	return (__db_isbigendian() ? JNI_TRUE : JNI_FALSE);
}


typedef int db_ret_t;
typedef int int_bool;

struct __db_lk_conflicts {
	u_int8_t *lk_conflicts;
	int lk_modes;
};

struct __db_out_stream {
	void *handle;
	int (*callback) __P((void *, const void *));
};

struct __db *new___db(DB_ENV *dbenv,u_int32_t flags){
		DB *self;
		errno = db_create(&self, dbenv, flags);
		return (errno == 0) ? self : NULL;
	}
static db_ret_t __db_associate(struct __db *self,DB_TXN *txnid,DB *secondary,int (*callback)(DB *,DBT const *,DBT const *,DBT *),u_int32_t flags){
		return self->associate(self, txnid, secondary, callback, flags);
	}
static int __db_close(struct __db *self,u_int32_t flags){
		errno = self->close(self, flags);
		return errno;
	}
static DBC *__db_cursor(struct __db *self,DB_TXN *txnid,u_int32_t flags){
		DBC *cursorp;
		errno = self->cursor(self, txnid, &cursorp, flags);
		return (errno == 0) ? cursorp : NULL;
	}
static int __db_del(struct __db *self,DB_TXN *txnid,DBT *key,u_int32_t flags){
		return self->del(self, txnid, key, flags);
	}
static void __db_err_internal(struct __db *self,int error,char const *message){
		self->err(self, error, message);
	}
static void __db_errx(struct __db *self,char const *message){
		self->errx(self, message);
	}
static int __db_get__SWIG_0(struct __db *self,DB_TXN *txnid,DBT *key,DBT *data,u_int32_t flags){
		return self->get(self, txnid, key, data, flags);
	}
static int_bool __db_get_byteswapped(struct __db *self){
		int ret;
		errno = self->get_byteswapped(self, &ret);
		return ret;
	}
static jlong __db_get_cachesize(struct __db *self){
		u_int32_t gbytes, bytes;
		errno = self->get_cachesize(self, &gbytes, &bytes, NULL);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
static u_int32_t __db_get_cachesize_ncache(struct __db *self){
		int ret;
		errno = self->get_cachesize(self, NULL, NULL, &ret);
		return ret;
	}
static char const *__db_get_filename(struct __db *self){
		const char *ret;
		errno = self->get_dbname(self, &ret, NULL);
		return ret;
	}
static char const *__db_get_dbname(struct __db *self){
		const char *ret;
		errno = self->get_dbname(self, NULL, &ret);
		return ret;
	}
static u_int32_t __db_get_encrypt_flags(struct __db *self){
		u_int32_t ret;
		errno = self->get_encrypt_flags(self, &ret);
		return ret;
	}
static u_int32_t __db_get_flags(struct __db *self){
		u_int32_t ret;
		errno = self->get_flags(self, &ret);
		return ret;
	}
static int __db_get_lorder(struct __db *self){
		int ret;
		errno = self->get_lorder(self, &ret);
		return ret;
	}
static DB_MPOOLFILE *__db_get_mpf(struct __db *self){
		errno = 0;
		return self->mpf;
	}
static u_int32_t __db_get_open_flags(struct __db *self){
		u_int32_t ret;
		errno = self->get_open_flags(self, &ret);
		return ret;
	}
static u_int32_t __db_get_pagesize(struct __db *self){
		u_int32_t ret;
		errno = self->get_pagesize(self, &ret);
		return ret;
	}
static u_int32_t __db_get_bt_minkey(struct __db *self){
		u_int32_t ret;
		errno = self->get_bt_minkey(self, &ret);
		return ret;
	}
static u_int32_t __db_get_h_ffactor(struct __db *self){
		u_int32_t ret;
		errno = self->get_h_ffactor(self, &ret);
		return ret;
	}
static u_int32_t __db_get_h_nelem(struct __db *self){
		u_int32_t ret;
		errno = self->get_h_nelem(self, &ret);
		return ret;
	}
static int __db_get_re_delim(struct __db *self){
		int ret;
		errno = self->get_re_delim(self, &ret);
		return ret;
	}
static u_int32_t __db_get_re_len(struct __db *self){
		u_int32_t ret;
		errno = self->get_re_len(self, &ret);
		return ret;
	}
static int __db_get_re_pad(struct __db *self){
		int ret;
		errno = self->get_re_pad(self, &ret);
		return ret;
	}
static char const *__db_get_re_source(struct __db *self){
		const char *ret;
		errno = self->get_re_source(self, &ret);
		return ret;
	}
static u_int32_t __db_get_q_extentsize(struct __db *self){
		u_int32_t ret;
		errno = self->get_q_extentsize(self, &ret);
		return ret;
	}
static u_int32_t __db_get_flags_raw(struct __db *self){
		errno = 0;
		return self->flags;
	}
static int_bool __db_get_transactional(struct __db *self){
		int ret;
		errno = self->get_transactional(self, &ret);
		return ret;
	}
static DBTYPE __db_get_type(struct __db *self){
		DBTYPE type;
		errno = self->get_type(self, &type);
		return type;
	}
static DBC *__db_join(struct __db *self,DBC **curslist,u_int32_t flags){
		DBC *dbcp;
		errno = self->join(self, curslist, &dbcp, flags);
		return (errno == 0) ? dbcp : NULL;
	}
static db_ret_t __db_key_range(struct __db *self,DB_TXN *txnid,DBT *key,DB_KEY_RANGE *key_range,u_int32_t flags){
		return self->key_range(self, txnid, key, key_range, flags);
	}
static db_ret_t __db_open(struct __db *self,DB_TXN *txnid,char const *file,char const *database,DBTYPE type,u_int32_t flags,int mode){
		return self->open(self, txnid, file, database,
		    type, flags, mode);
	}
static int __db_pget__SWIG_1(struct __db *self,DB_TXN *txnid,DBT *key,DBT *pkey,DBT *data,u_int32_t flags){
		return self->pget(self, txnid, key, pkey, data, flags);
	}
static int __db_put(struct __db *self,DB_TXN *txnid,DBT *key,DBT *data,u_int32_t flags){
		return self->put(self, txnid, key, data, flags);
	}
static db_ret_t __db_remove(struct __db *self,char const *file,char const *database,u_int32_t flags){
		return self->remove(self, file, database, flags);
	}
static db_ret_t __db_rename(struct __db *self,char const *file,char const *database,char const *newname,u_int32_t flags){
		return self->rename(self, file, database, newname, flags);
	}
static db_ret_t __db_set_append_recno(struct __db *self,int (*db_append_recno_fcn)(DB *,DBT *,db_recno_t)){
		return self->set_append_recno(self, db_append_recno_fcn);
	}
static db_ret_t __db_set_bt_compare(struct __db *self,int (*bt_compare_fcn)(DB *,DBT const *,DBT const *)){
		return self->set_bt_compare(self, bt_compare_fcn);
	}
static db_ret_t __db_set_bt_maxkey(struct __db *self,u_int32_t maxkey){
		return self->set_bt_maxkey(self, maxkey);
	}
static db_ret_t __db_set_bt_minkey(struct __db *self,u_int32_t bt_minkey){
		return self->set_bt_minkey(self, bt_minkey);
	}
static db_ret_t __db_set_bt_prefix(struct __db *self,size_t (*bt_prefix_fcn)(DB *,DBT const *,DBT const *)){
		return self->set_bt_prefix(self, bt_prefix_fcn);
	}
static db_ret_t __db_set_cachesize(struct __db *self,jlong bytes,int ncache){
		return self->set_cachesize(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE), ncache);
	}
static db_ret_t __db_set_dup_compare(struct __db *self,int (*dup_compare_fcn)(DB *,DBT const *,DBT const *)){
		return self->set_dup_compare(self, dup_compare_fcn);
	}
static db_ret_t __db_set_encrypt(struct __db *self,char const *passwd,u_int32_t flags){
		return self->set_encrypt(self, passwd, flags);
	}
static db_ret_t __db_set_feedback(struct __db *self,void (*db_feedback_fcn)(DB *,int,int)){
		return self->set_feedback(self, db_feedback_fcn);
	}
static db_ret_t __db_set_flags(struct __db *self,u_int32_t flags){
		return self->set_flags(self, flags);
	}
static db_ret_t __db_set_h_ffactor(struct __db *self,u_int32_t h_ffactor){
		return self->set_h_ffactor(self, h_ffactor);
	}
static db_ret_t __db_set_h_hash(struct __db *self,u_int32_t (*h_hash_fcn)(DB *,void const *,u_int32_t)){
		return self->set_h_hash(self, h_hash_fcn);
	}
static db_ret_t __db_set_h_nelem(struct __db *self,u_int32_t h_nelem){
		return self->set_h_nelem(self, h_nelem);
	}
static db_ret_t __db_set_lorder(struct __db *self,int lorder){
		return self->set_lorder(self, lorder);
	}
static db_ret_t __db_set_pagesize(struct __db *self,u_int32_t pagesize){
		return self->set_pagesize(self, pagesize);
	}
static db_ret_t __db_set_re_delim(struct __db *self,int re_delim){
		return self->set_re_delim(self, re_delim);
	}
static db_ret_t __db_set_re_len(struct __db *self,u_int32_t re_len){
		return self->set_re_len(self, re_len);
	}
static db_ret_t __db_set_re_pad(struct __db *self,int re_pad){
		return self->set_re_pad(self, re_pad);
	}
static db_ret_t __db_set_re_source(struct __db *self,char *source){
		return self->set_re_source(self, source);
	}
static db_ret_t __db_set_q_extentsize(struct __db *self,u_int32_t extentsize){
		return self->set_q_extentsize(self, extentsize);
	}
static void *__db_stat(struct __db *self,u_int32_t flags){
		void *statp;
		errno = self->stat(self, &statp, flags);
		return (errno == 0) ? statp : NULL;
	}
static db_ret_t __db_sync(struct __db *self,u_int32_t flags){
		return self->sync(self, flags);
	}
static int __db_truncate(struct __db *self,DB_TXN *txnid,u_int32_t flags){
		u_int32_t count;
		errno = self->truncate(self, txnid, &count, flags);
		return count;
	}
static db_ret_t __db_upgrade(struct __db *self,char const *file,u_int32_t flags){
		return self->upgrade(self, file, flags);
	}
static db_ret_t __db_verify(struct __db *self,char const *file,char const *database,struct __db_out_stream outfile,u_int32_t flags){
		/*
		 * We can't easily #include "dbinc/db_ext.h" because of name
		 * clashes, so we declare this explicitly.
		 */
		extern int __db_verify_internal __P((DB *, const char *, const
		    char *, void *, int (*)(void *, const void *), u_int32_t));
		return __db_verify_internal(self, file, database,
		    outfile.handle, outfile.callback, flags);
	}
static db_ret_t __dbc_close(struct __dbc *self){
		return self->c_close(self);
	}
static db_recno_t __dbc_count(struct __dbc *self,u_int32_t flags){
		db_recno_t count;
		errno = self->c_count(self, &count, flags);
		return count;
	}
static int __dbc_del(struct __dbc *self,u_int32_t flags){
		return self->c_del(self, flags);
	}
static DBC *__dbc_dup(struct __dbc *self,u_int32_t flags){
		DBC *newcurs;
		errno = self->c_dup(self, &newcurs, flags);
		return (errno == 0) ? newcurs : NULL;
	}
static int __dbc_get__SWIG_0(struct __dbc *self,DBT *key,DBT *data,u_int32_t flags){
		return self->c_get(self, key, data, flags);
	}
static int __dbc_pget__SWIG_1(struct __dbc *self,DBT *key,DBT *pkey,DBT *data,u_int32_t flags){
		return self->c_pget(self, key, pkey, data, flags);
	}
static int __dbc_put(struct __dbc *self,DBT *key,DBT *data,u_int32_t flags){
		return self->c_put(self, key, data, flags);
	}
struct __db_env *new___db_env(u_int32_t flags){
		DB_ENV *self = NULL;
		errno = db_env_create(&self, flags);
		return (errno == 0) ? self : NULL;
	}
static db_ret_t __db_env_close(struct __db_env *self,u_int32_t flags){
		return self->close(self, flags);
	}
static db_ret_t __db_env_dbremove(struct __db_env *self,DB_TXN *txnid,char const *file,char const *database,u_int32_t flags){
		return self->dbremove(self, txnid, file, database, flags);
	}
static db_ret_t __db_env_dbrename(struct __db_env *self,DB_TXN *txnid,char const *file,char const *database,char const *newname,u_int32_t flags){
		return self->dbrename(self,
		    txnid, file, database, newname, flags);
	}
static void __db_env_err(struct __db_env *self,int error,char const *message){
		self->err(self, error, message);
	}
static void __db_env_errx(struct __db_env *self,char const *message){
		self->errx(self, message);
	}
static char const **__db_env_get_data_dirs(struct __db_env *self){
		const char **ret;
		errno = self->get_data_dirs(self, &ret);
		return ret;
	}
static u_int32_t __db_env_get_encrypt_flags(struct __db_env *self){
		u_int32_t ret;
		errno = self->get_encrypt_flags(self, &ret);
		return ret;
	}
static u_int32_t __db_env_get_flags(struct __db_env *self){
		u_int32_t ret;
		errno = self->get_flags(self, &ret);
		return ret;
	}
static char const *__db_env_get_home(struct __db_env *self){
		const char *ret;
		errno = self->get_home(self, &ret);
		return ret;
	}
static u_int32_t __db_env_get_open_flags(struct __db_env *self){
		u_int32_t ret;
		errno = self->get_open_flags(self, &ret);
		return ret;
	}
static long __db_env_get_shm_key(struct __db_env *self){
		long ret;
		errno = self->get_shm_key(self, &ret);
		return ret;
	}
static u_int32_t __db_env_get_tas_spins(struct __db_env *self){
		u_int32_t ret;
		errno = self->get_tas_spins(self, &ret);
		return ret;
	}
static char const *__db_env_get_tmp_dir(struct __db_env *self){
		const char *ret;
		errno = self->get_tmp_dir(self, &ret);
		return ret;
	}
static int_bool __db_env_get_verbose(struct __db_env *self,u_int32_t which){
		int ret;
		errno = self->get_verbose(self, which, &ret);
		return ret;
	}
static db_ret_t __db_env_open(struct __db_env *self,char const *db_home,u_int32_t flags,int mode){
		return self->open(self, db_home, flags, mode);
	}
static db_ret_t __db_env_remove(struct __db_env *self,char const *db_home,u_int32_t flags){
		return self->remove(self, db_home, flags);
	}
static db_ret_t __db_env_set_cachesize(struct __db_env *self,jlong bytes,int ncache){
		return self->set_cachesize(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE), ncache);
	}
static db_ret_t __db_env_set_data_dir(struct __db_env *self,char const *dir){
		return self->set_data_dir(self, dir);
	}
static db_ret_t __db_env_set_encrypt(struct __db_env *self,char const *passwd,u_int32_t flags){
		return self->set_encrypt(self, passwd, flags);
	}
static void __db_env_set_errcall(struct __db_env *self,void (*db_errcall_fcn)(char const *,char *)){
		self->set_errcall(self, db_errcall_fcn);
	}
static db_ret_t __db_env_set_flags(struct __db_env *self,u_int32_t flags,int_bool onoff){
		return self->set_flags(self, flags, onoff);
	}
static db_ret_t __db_env_set_feedback(struct __db_env *self,void (*db_feedback_fcn)(DB_ENV *,int,int)){
		return self->set_feedback(self, db_feedback_fcn);
	}
static db_ret_t __db_env_set_mp_mmapsize(struct __db_env *self,size_t mp_mmapsize){
		return self->set_mp_mmapsize(self, mp_mmapsize);
	}
static db_ret_t __db_env_set_paniccall(struct __db_env *self,void (*db_panic_fcn)(DB_ENV *,int)){
		return self->set_paniccall(self, db_panic_fcn);
	}
static db_ret_t __db_env_set_rpc_server(struct __db_env *self,void *client,char *host,long cl_timeout,long sv_timeout,u_int32_t flags){
		return self->set_rpc_server(self, client, host,
		    cl_timeout, sv_timeout, flags);
	}
static db_ret_t __db_env_set_shm_key(struct __db_env *self,long shm_key){
		return self->set_shm_key(self, shm_key);
	}
static db_ret_t __db_env_set_tas_spins(struct __db_env *self,u_int32_t tas_spins){
		return self->set_tas_spins(self, tas_spins);
	}
static db_ret_t __db_env_set_timeout(struct __db_env *self,db_timeout_t timeout,u_int32_t flags){
		return self->set_timeout(self, timeout, flags);
	}
static db_ret_t __db_env_set_tmp_dir(struct __db_env *self,char const *dir){
		return self->set_tmp_dir(self, dir);
	}
static db_ret_t __db_env_set_tx_max(struct __db_env *self,u_int32_t max){
		return self->set_tx_max(self, max);
	}
static db_ret_t __db_env_set_app_dispatch(struct __db_env *self,int (*tx_recover)(DB_ENV *,DBT *,DB_LSN *,db_recops)){
		return self->set_app_dispatch(self, tx_recover);
	}
static db_ret_t __db_env_set_tx_timestamp(struct __db_env *self,time_t *timestamp){
		return self->set_tx_timestamp(self, timestamp);
	}
static db_ret_t __db_env_set_verbose(struct __db_env *self,u_int32_t which,int_bool onoff){
		return self->set_verbose(self, which, onoff);
	}
static struct __db_lk_conflicts __db_env_get_lk_conflicts(struct __db_env *self){
		struct __db_lk_conflicts ret;
		errno = self->get_lk_conflicts(self,
		    (const u_int8_t **)&ret.lk_conflicts, &ret.lk_modes);
		return ret;
	}
static u_int32_t __db_env_get_lk_detect(struct __db_env *self){
		u_int32_t ret;
		errno = self->get_lk_detect(self, &ret);
		return ret;
	}
static u_int32_t __db_env_get_lk_max_locks(struct __db_env *self){
		u_int32_t ret;
		errno = self->get_lk_max_locks(self, &ret);
		return ret;
	}
static u_int32_t __db_env_get_lk_max_lockers(struct __db_env *self){
		u_int32_t ret;
		errno = self->get_lk_max_lockers(self, &ret);
		return ret;
	}
static u_int32_t __db_env_get_lk_max_objects(struct __db_env *self){
		u_int32_t ret;
		errno = self->get_lk_max_objects(self, &ret);
		return ret;
	}
static int __db_env_lock_detect(struct __db_env *self,u_int32_t flags,u_int32_t atype){
		int aborted;
		errno = self->lock_detect(self, flags, atype, &aborted);
		return aborted;
	}
static DB_LOCK *__db_env_lock_get(struct __db_env *self,u_int32_t locker,u_int32_t flags,DBT const *object,db_lockmode_t lock_mode){
		DB_LOCK *lock = NULL;
		if ((errno = __os_malloc(self, sizeof (DB_LOCK), &lock)) == 0)
			errno = self->lock_get(self, locker, flags, object,
			    lock_mode, lock);
		return lock;
	}
static u_int32_t __db_env_lock_id(struct __db_env *self){
		u_int32_t id;
		errno = self->lock_id(self, &id);
		return id;
	}
static db_ret_t __db_env_lock_id_free(struct __db_env *self,u_int32_t id){
		return self->lock_id_free(self, id);
	}
static db_ret_t __db_env_lock_put(struct __db_env *self,DB_LOCK *lock){
		return self->lock_put(self, lock);
	}
static DB_LOCK_STAT *__db_env_lock_stat(struct __db_env *self,u_int32_t flags){
		DB_LOCK_STAT *statp;
		errno = self->lock_stat(self, &statp, flags);
		return (errno == 0) ? statp : NULL;
	}
static db_ret_t __db_env_set_lk_conflicts(struct __db_env *self,struct __db_lk_conflicts conflicts){
		return self->set_lk_conflicts(self,
		    conflicts.lk_conflicts, conflicts.lk_modes);
	}
static db_ret_t __db_env_set_lk_detect(struct __db_env *self,u_int32_t detect){
		return self->set_lk_detect(self, detect);
	}
static db_ret_t __db_env_set_lk_max_lockers(struct __db_env *self,u_int32_t max){
		return self->set_lk_max_lockers(self, max);
	}
static db_ret_t __db_env_set_lk_max_locks(struct __db_env *self,u_int32_t max){
		return self->set_lk_max_locks(self, max);
	}
static db_ret_t __db_env_set_lk_max_objects(struct __db_env *self,u_int32_t max){
		return self->set_lk_max_objects(self, max);
	}
static u_int32_t __db_env_get_lg_bsize(struct __db_env *self){
		u_int32_t ret;
		errno = self->get_lg_bsize(self, &ret);
		return ret;
	}
static char const *__db_env_get_lg_dir(struct __db_env *self){
		const char *ret;
		errno = self->get_lg_dir(self, &ret);
		return ret;
	}
static u_int32_t __db_env_get_lg_max(struct __db_env *self){
		u_int32_t ret;
		errno = self->get_lg_max(self, &ret);
		return ret;
	}
static u_int32_t __db_env_get_lg_regionmax(struct __db_env *self){
		u_int32_t ret;
		errno = self->get_lg_regionmax(self, &ret);
		return ret;
	}
static char **__db_env_log_archive(struct __db_env *self,u_int32_t flags){
		char **list;
		errno = self->log_archive(self, &list, flags);
		return (errno == 0) ? list : NULL;
	}
int DbEnv_log_compare(DB_LSN const *lsn0,DB_LSN const *lsn1){
		return log_compare(lsn0, lsn1);
	}
static DB_LOGC *__db_env_log_cursor(struct __db_env *self,u_int32_t flags){
		DB_LOGC *cursor;
		errno = self->log_cursor(self, &cursor, flags);
		return (errno == 0) ? cursor : NULL;
	}
static char *__db_env_log_file(struct __db_env *self,DB_LSN *lsn){
		char namebuf[MAXPATHLEN];
		errno = self->log_file(self, lsn, namebuf, sizeof namebuf);
		return (errno == 0) ? strdup(namebuf) : NULL;
	}
static db_ret_t __db_env_log_flush(struct __db_env *self,DB_LSN const *lsn){
		return self->log_flush(self, lsn);
	}
static db_ret_t __db_env_log_put(struct __db_env *self,DB_LSN *lsn,DBT const *data,u_int32_t flags){
		return self->log_put(self, lsn, data, flags);
	}
static DB_LOG_STAT *__db_env_log_stat(struct __db_env *self,u_int32_t flags){
		DB_LOG_STAT *sp;
		errno = self->log_stat(self, &sp, flags);
		return (errno == 0) ? sp : NULL;
	}
static db_ret_t __db_env_set_lg_bsize(struct __db_env *self,u_int32_t lg_bsize){
		return self->set_lg_bsize(self, lg_bsize);
	}
static db_ret_t __db_env_set_lg_dir(struct __db_env *self,char const *dir){
		return self->set_lg_dir(self, dir);
	}
static db_ret_t __db_env_set_lg_max(struct __db_env *self,u_int32_t lg_max){
		return self->set_lg_max(self, lg_max);
	}
static db_ret_t __db_env_set_lg_regionmax(struct __db_env *self,u_int32_t lg_regionmax){
		return self->set_lg_regionmax(self, lg_regionmax);
	}
static jlong __db_env_get_cachesize(struct __db_env *self){
		u_int32_t gbytes, bytes;
		errno = self->get_cachesize(self, &gbytes, &bytes, NULL);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
static int __db_env_get_cachesize_ncache(struct __db_env *self){
		int ret;
		errno = self->get_cachesize(self, NULL, NULL, &ret);
		return ret;
	}
static size_t __db_env_get_mp_mmapsize(struct __db_env *self){
		size_t ret;
		errno = self->get_mp_mmapsize(self, &ret);
		return ret;
	}
static DB_MPOOL_STAT *__db_env_memp_stat(struct __db_env *self,u_int32_t flags){
		DB_MPOOL_STAT *mp_stat;
		errno = self->memp_stat(self, &mp_stat, NULL, flags);
		return (errno == 0) ? mp_stat : NULL;
	}
static DB_MPOOL_FSTAT **__db_env_memp_fstat(struct __db_env *self,u_int32_t flags){
		DB_MPOOL_FSTAT **mp_fstat;
		errno = self->memp_stat(self, NULL, &mp_fstat, flags);
		return (errno == 0) ? mp_fstat : NULL;
	}
static int __db_env_memp_trickle(struct __db_env *self,int percent){
		int ret;
		errno = self->memp_trickle(self, percent, &ret);
		return ret;
	}
static u_int32_t __db_env_get_tx_max(struct __db_env *self){
		u_int32_t ret;
		errno = self->get_tx_max(self, &ret);
		return ret;
	}
static time_t __db_env_get_tx_timestamp(struct __db_env *self){
		time_t ret;
		errno = self->get_tx_timestamp(self, &ret);
		return ret;
	}
static db_timeout_t __db_env_get_timeout(struct __db_env *self,u_int32_t flag){
		db_timeout_t ret;
		errno = self->get_timeout(self, &ret, flag);
		return ret;
	}
static DB_TXN *__db_env_txn_begin(struct __db_env *self,DB_TXN *parent,u_int32_t flags){
		DB_TXN *tid;
		errno = self->txn_begin(self, parent, &tid, flags);
		return (errno == 0) ? tid : NULL;
	}
static db_ret_t __db_env_txn_checkpoint(struct __db_env *self,u_int32_t kbyte,u_int32_t min,u_int32_t flags){
		return self->txn_checkpoint(self, kbyte, min, flags);
	}
static DB_PREPLIST *__db_env_txn_recover(struct __db_env *self,int count,u_int32_t flags){
		DB_PREPLIST *preplist;
		long retcount;

		/* Add a NULL element to terminate the array. */
		if ((errno = __os_malloc(self,
		    (count + 1) * sizeof(DB_PREPLIST), &preplist)) != 0)
			return NULL;

		if ((errno = self->txn_recover(self, preplist, count,
		    &retcount, flags)) != 0) {
			__os_free(self, preplist);
			return NULL;
		}
		
		preplist[retcount].txn = NULL;
		return preplist;
	}
static DB_TXN_STAT *__db_env_txn_stat(struct __db_env *self,u_int32_t flags){
		DB_TXN_STAT *statp;
		errno = self->txn_stat(self, &statp, flags);
		return (errno == 0) ? statp : NULL;
	}
static jlong __db_env_get_rep_limit(struct __db_env *self){
		u_int32_t gbytes, bytes;
		errno = self->get_rep_limit(self, &gbytes, &bytes);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
static int __db_env_rep_elect(struct __db_env *self,int nsites,int priority,u_int32_t timeout){
		int id;
		errno = self->rep_elect(self, nsites, priority, timeout, &id);
		return id;
	}
static int __db_env_rep_process_message(struct __db_env *self,DBT *control,DBT *rec,int *envid,DB_LSN *ret_lsn){
		return self->rep_process_message(self, control, rec, envid, ret_lsn);
	}
static db_ret_t __db_env_rep_start(struct __db_env *self,DBT *cdata,u_int32_t flags){
		return self->rep_start(self, cdata, flags);
	}
static DB_REP_STAT *__db_env_rep_stat(struct __db_env *self,u_int32_t flags){
		DB_REP_STAT *statp;
		errno = self->rep_stat(self, &statp, flags);
		return (errno == 0) ? statp : NULL;
	}
static db_ret_t __db_env_set_rep_limit(struct __db_env *self,jlong bytes){
		return self->set_rep_limit(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE));
	}
static db_ret_t __db_env_set_rep_transport(struct __db_env *self,int envid,int (*send)(DB_ENV *,DBT const *,DBT const *,DB_LSN const *,int,u_int32_t)){
		return self->set_rep_transport(self, envid, send);
	}
char const *DbEnv_strerror(int error){
		return db_strerror(error);
	}
int DbEnv_get_version_major(){
		return DB_VERSION_MAJOR;
	}
int DbEnv_get_version_minor(){
		return DB_VERSION_MINOR;
	}
int DbEnv_get_version_patch(){
		return DB_VERSION_PATCH;
	}
char const *DbEnv_get_version_string(){
		return DB_VERSION_STRING;
	}
static db_ret_t __db_txn_abort(struct __db_txn *self){
		return self->abort(self);
	}
static db_ret_t __db_txn_commit(struct __db_txn *self,u_int32_t flags){
		return self->commit(self, flags);
	}
static db_ret_t __db_txn_discard(struct __db_txn *self,u_int32_t flags){
		return self->discard(self, flags);
	}
static u_int32_t __db_txn_id(struct __db_txn *self){
		return self->id(self);
	}
static db_ret_t __db_txn_prepare(struct __db_txn *self,u_int8_t *gid){
		return self->prepare(self, gid);
	}
static db_ret_t __db_txn_set_timeout(struct __db_txn *self,db_timeout_t timeout,u_int32_t flags){
		return self->set_timeout(self, timeout, flags);
	}
static db_ret_t __db_log_cursor_close(struct __db_log_cursor *self,u_int32_t flags){
		return self->close(self, flags);
	}
static int __db_log_cursor_get(struct __db_log_cursor *self,DB_LSN *lsn,DBT *data,u_int32_t flags){
		return self->get(self, lsn, data, flags);
	}
void delete___db_lock_u(struct __db_lock_u *self){
		__os_free(NULL, self);
	}
struct __db_lsn *new___db_lsn(u_int32_t file,u_int32_t offset){
		DB_LSN *self = NULL;
		errno = __os_malloc(NULL, sizeof (DB_LSN), &self);
		if (errno == 0) {
			self->file = file;
			self->offset = offset;
		}
		return self;
	}
void delete___db_lsn(struct __db_lsn *self){
		__os_free(NULL, self);
	}
static u_int32_t __db_lsn_get_file(struct __db_lsn *self){
		return self->file;
	}
static u_int32_t __db_lsn_get_offset(struct __db_lsn *self){
		return self->offset;
	}
static DB_CACHE_PRIORITY __db_mpoolfile_get_priority(struct __db_mpoolfile *self){
		DB_CACHE_PRIORITY ret;
		errno = self->get_priority(self, &ret);
		return ret;
	}
static db_ret_t __db_mpoolfile_set_priority(struct __db_mpoolfile *self,DB_CACHE_PRIORITY priority){
		return self->set_priority(self, priority);
	}
static u_int32_t __db_mpoolfile_get_flags(struct __db_mpoolfile *self){
		u_int32_t ret;
		errno = self->get_flags(self, &ret);
		return ret;
	}
static db_ret_t __db_mpoolfile_set_flags(struct __db_mpoolfile *self,u_int32_t flags,int_bool onoff){
		return self->set_flags(self, flags, onoff);
	}
static jlong __db_mpoolfile_get_maxsize(struct __db_mpoolfile *self){
		u_int32_t gbytes, bytes;
		errno = self->get_maxsize(self, &gbytes, &bytes);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
static db_ret_t __db_mpoolfile_set_maxsize(struct __db_mpoolfile *self,jlong bytes){
		return self->set_maxsize(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE));
	}
#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_new_1Db(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    DB_ENV *arg1 = (DB_ENV *) 0 ;
    u_int32_t arg2 ;
    struct __db *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DB_ENV **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    errno = 0;
    result = (struct __db *)new___db(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    *(struct __db **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1associate(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jobject jarg4, jint jarg5) {
    struct __db *arg1 = (struct __db *) 0 ;
    DB_TXN *arg2 = (DB_TXN *) 0 ;
    DB *arg3 = (DB *) 0 ;
    int (*arg4)(DB *,DBT const *,DBT const *,DBT *) = (int (*)(DB *,DBT const *,DBT const *,DBT *)) 0 ;
    u_int32_t arg5 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = *(DB_TXN **)&jarg2; 
    arg3 = *(DB **)&jarg3; 
    
    arg4 = (jarg4 == NULL) ? NULL : __dbj_seckey_create;
    
    arg5 = (u_int32_t)jarg5; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_associate(arg1,arg2,arg3,arg4,arg5);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (int)__db_close(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1cursor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    jlong jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    DB_TXN *arg2 = (DB_TXN *) 0 ;
    u_int32_t arg3 ;
    DBC *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = *(DB_TXN **)&jarg2; 
    arg3 = (u_int32_t)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DBC *)__db_cursor(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    *(DBC **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1del(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jint jarg4) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    DB_TXN *arg2 = (DB_TXN *) 0 ;
    DBT *arg3 = (DBT *) 0 ;
    u_int32_t arg4 ;
    int result;
    DBT_LOCKED ldbt3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = *(DB_TXN **)&jarg2; 
    
    if (__dbj_dbt_copyin(jenv, &ldbt3, jarg3) != 0)
    return 0;
    arg3 = &ldbt3.dbt;
    
    arg4 = (u_int32_t)jarg4; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    result = (int)__db_del(arg1,arg2,arg3,arg4);
    
    if (!DB_RETOK_DBDEL(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    
    __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3);
    
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1err(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
    struct __db *arg1 = (struct __db *) 0 ;
    int arg2 ;
    char *arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    __db_err_internal(arg1,arg2,(char const *)arg3);
    
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1errx(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    __db_errx(arg1,(char const *)arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jobject jarg4, jint jarg5) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    DB_TXN *arg2 = (DB_TXN *) 0 ;
    DBT *arg3 = (DBT *) 0 ;
    DBT *arg4 = (DBT *) 0 ;
    u_int32_t arg5 ;
    int result;
    DBT_LOCKED ldbt3 ;
    DBT_LOCKED ldbt4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = *(DB_TXN **)&jarg2; 
    
    if (__dbj_dbt_copyin(jenv, &ldbt3, jarg3) != 0)
    return 0;
    arg3 = &ldbt3.dbt;
    
    
    if (__dbj_dbt_copyin(jenv, &ldbt4, jarg4) != 0)
    return 0;
    arg4 = &ldbt4.dbt;
    
    arg5 = (u_int32_t)jarg5; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    result = (int)__db_get__SWIG_0(arg1,arg2,arg3,arg4,arg5);
    
    if (!DB_RETOK_DBGET(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    
    __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3);
    
    
    __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4);
    
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1byteswapped(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    int_bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (int_bool)__db_get_byteswapped(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    
    jresult = (result) ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    jlong result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = __db_get_cachesize(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1cachesize_1ncache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_get_cachesize_ncache(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1filename(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (char *)__db_get_filename(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1dbname(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (char *)__db_get_dbname(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1encrypt_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_get_encrypt_flags(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_get_flags(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1lorder(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (int)__db_get_lorder(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1mpf(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    DB_MPOOLFILE *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DB_MPOOLFILE *)__db_get_mpf(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    *(DB_MPOOLFILE **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1open_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_get_open_flags(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1pagesize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_get_pagesize(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1bt_1minkey(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_get_bt_minkey(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1h_1ffactor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_get_h_ffactor(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1h_1nelem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_get_h_nelem(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1re_1delim(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (int)__db_get_re_delim(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1re_1len(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_get_re_len(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1re_1pad(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (int)__db_get_re_pad(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1re_1source(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (char *)__db_get_re_source(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1q_1extentsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_get_q_extentsize(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1flags_1raw(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_get_flags_raw(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1transactional(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    int_bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (int_bool)__db_get_transactional(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    
    jresult = (result) ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    DBTYPE result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DBTYPE)__db_get_type(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1join(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2, jint jarg3) {
    jlong jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    DBC **arg2 = (DBC **) 0 ;
    u_int32_t arg3 ;
    DBC *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    {
        int i, count, err;
        
        count = (*jenv)->GetArrayLength(jenv, jarg2);
        if ((err = __os_malloc(NULL, (count + 1) * sizeof(DBC *), &arg2)) != 0) {
            __dbj_throw(jenv, err, NULL, NULL, DB2JDBENV);
            return 0;
        }
        for (i = 0; i < count; i++) {
            jobject jobj = (*jenv)->GetObjectArrayElement(jenv, jarg2, i);
            /*
            		 * A null in the array is treated as an endpoint.
            		 */
            if (jobj == NULL) {
                arg2[i] = NULL;
                break;
            }else {
                jlong jptr = (*jenv)->GetLongField(jenv, jobj,
                dbc_cptr_fid);
                arg2[i] = *(DBC **)&jptr;
            }
        }
        arg2[count] = NULL;
    }
    arg3 = (u_int32_t)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DBC *)__db_join(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    *(DBC **)&jresult = result; 
    
    __os_free(NULL, arg2);
    
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1key_1range(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jobject jarg4, jint jarg5) {
    struct __db *arg1 = (struct __db *) 0 ;
    DB_TXN *arg2 = (DB_TXN *) 0 ;
    DBT *arg3 = (DBT *) 0 ;
    DB_KEY_RANGE *arg4 = (DB_KEY_RANGE *) 0 ;
    u_int32_t arg5 ;
    db_ret_t result;
    DBT_LOCKED ldbt3 ;
    DB_KEY_RANGE range4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = *(DB_TXN **)&jarg2; 
    
    if (__dbj_dbt_copyin(jenv, &ldbt3, jarg3) != 0)
    return ;
    arg3 = &ldbt3.dbt;
    
    {
        arg4 = &range4;
    }
    arg5 = (u_int32_t)jarg5; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_key_range(arg1,arg2,arg3,arg4,arg5);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
    {
        (*jenv)->SetDoubleField(jenv, jarg4, kr_less_fid, arg4->less);
        (*jenv)->SetDoubleField(jenv, jarg4, kr_equal_fid, arg4->equal);
        (*jenv)->SetDoubleField(jenv, jarg4, kr_greater_fid, arg4->greater);
    }
    
    __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1open0(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jint jarg5, jint jarg6, jint jarg7) {
    struct __db *arg1 = (struct __db *) 0 ;
    DB_TXN *arg2 = (DB_TXN *) 0 ;
    char *arg3 ;
    char *arg4 ;
    DBTYPE arg5 ;
    u_int32_t arg6 ;
    int arg7 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = *(DB_TXN **)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return ;
        }
    }
    arg5 = (DBTYPE)jarg5; 
    arg6 = (u_int32_t)jarg6; 
    arg7 = (int)jarg7; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_open(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5,arg6,arg7);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1get_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jint jarg6) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    DB_TXN *arg2 = (DB_TXN *) 0 ;
    DBT *arg3 = (DBT *) 0 ;
    DBT *arg4 = (DBT *) 0 ;
    DBT *arg5 = (DBT *) 0 ;
    u_int32_t arg6 ;
    int result;
    DBT_LOCKED ldbt3 ;
    DBT_LOCKED ldbt4 ;
    DBT_LOCKED ldbt5 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = *(DB_TXN **)&jarg2; 
    
    if (__dbj_dbt_copyin(jenv, &ldbt3, jarg3) != 0)
    return 0;
    arg3 = &ldbt3.dbt;
    
    
    if (__dbj_dbt_copyin(jenv, &ldbt4, jarg4) != 0)
    return 0;
    arg4 = &ldbt4.dbt;
    
    
    if (__dbj_dbt_copyin(jenv, &ldbt5, jarg5) != 0)
    return 0;
    arg5 = &ldbt5.dbt;
    
    arg6 = (u_int32_t)jarg6; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    result = (int)__db_pget__SWIG_1(arg1,arg2,arg3,arg4,arg5,arg6);
    
    if (!DB_RETOK_DBGET(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    
    __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3);
    
    
    __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4);
    
    
    __dbj_dbt_release(jenv, jarg5, arg5, &ldbt5);
    
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1put(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jobject jarg4, jint jarg5) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    DB_TXN *arg2 = (DB_TXN *) 0 ;
    DBT *arg3 = (DBT *) 0 ;
    DBT *arg4 = (DBT *) 0 ;
    u_int32_t arg5 ;
    int result;
    DBT_LOCKED ldbt3 ;
    DBT_LOCKED ldbt4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = *(DB_TXN **)&jarg2; 
    
    if (__dbj_dbt_copyin(jenv, &ldbt3, jarg3) != 0)
    return 0;
    arg3 = &ldbt3.dbt;
    
    
    if (__dbj_dbt_copyin(jenv, &ldbt4, jarg4) != 0)
    return 0;
    arg4 = &ldbt4.dbt;
    
    arg5 = (u_int32_t)jarg5; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    result = (int)__db_put(arg1,arg2,arg3,arg4,arg5);
    
    if (!DB_RETOK_DBPUT(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    
    __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3);
    
    
    __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4);
    
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1remove0(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jint jarg4) {
    struct __db *arg1 = (struct __db *) 0 ;
    char *arg2 ;
    char *arg3 ;
    u_int32_t arg4 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    arg4 = (u_int32_t)jarg4; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_remove(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1rename0(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jint jarg5) {
    struct __db *arg1 = (struct __db *) 0 ;
    char *arg2 ;
    char *arg3 ;
    char *arg4 ;
    u_int32_t arg5 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return ;
        }
    }
    arg5 = (u_int32_t)jarg5; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_rename(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4,arg5);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1append_1recno(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    int (*arg2)(DB *,DBT *,db_recno_t) = (int (*)(DB *,DBT *,db_recno_t)) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    arg2 = (jarg2 == NULL) ? NULL : __dbj_append_recno;
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_append_recno(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1bt_1compare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    int (*arg2)(DB *,DBT const *,DBT const *) = (int (*)(DB *,DBT const *,DBT const *)) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    arg2 = (jarg2 == NULL) ? NULL : __dbj_bt_compare;
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_bt_compare(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1bt_1maxkey(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_bt_maxkey(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1bt_1minkey(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_bt_minkey(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1bt_1prefix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    size_t (*arg2)(DB *,DBT const *,DBT const *) = (size_t (*)(DB *,DBT const *,DBT const *)) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    arg2 = (jarg2 == NULL) ? NULL : __dbj_bt_prefix;
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_bt_prefix(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    struct __db *arg1 = (struct __db *) 0 ;
    jlong arg2 ;
    int arg3 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = jarg2; 
    arg3 = (int)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_cachesize(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1dup_1compare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    int (*arg2)(DB *,DBT const *,DBT const *) = (int (*)(DB *,DBT const *,DBT const *)) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    arg2 = (jarg2 == NULL) ? NULL : __dbj_dup_compare;
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_dup_compare(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1encrypt(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    struct __db *arg1 = (struct __db *) 0 ;
    char *arg2 ;
    u_int32_t arg3 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (u_int32_t)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_encrypt(arg1,(char const *)arg2,arg3);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1setFeedbackHandler(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    void (*arg2)(DB *,int,int) = (void (*)(DB *,int,int)) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    arg2 = (jarg2 == NULL) ? NULL : __dbj_db_feedback;
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_feedback(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_flags(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1h_1ffactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_h_ffactor(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1h_1hash(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t (*arg2)(DB *,void const *,u_int32_t) = (u_int32_t (*)(DB *,void const *,u_int32_t)) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    
    arg2 = (jarg2 == NULL) ? NULL : __dbj_h_hash;
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_h_hash(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1h_1nelem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_h_nelem(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1lorder(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    int arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (int)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_lorder(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1pagesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_pagesize(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1re_1delim(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    int arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (int)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_re_delim(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1re_1len(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_re_len(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1re_1pad(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    int arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (int)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_re_pad(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1re_1source(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    char *arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_re_source(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1set_1q_1extentsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_set_q_extentsize(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jobject jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t arg2 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (void *)__db_stat(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    
    if (result == NULL)
    jresult = NULL;
    else {
        DB *db = (DB *)arg1;
        DBTYPE dbtype;
        int err;
        
        if ((err = db->get_type(db, &dbtype)) != 0) {
            __dbj_throw(jenv, err, NULL, NULL, DB2JDBENV);
            return 0;
        }
        
        switch (dbtype) {
            /* Btree and recno share the same stat structure */
            case DB_BTREE:
            case DB_RECNO:
            jresult = (*jenv)->NewObject(jenv, btree_stat_class,
            btree_stat_construct);
            if (jresult != NULL)
            __dbj_fill_bt_stat(jenv, btree_stat_class,
            jresult, (DB_BTREE_STAT *)result);
            break;
            
            /* Hash stat structure */
            case DB_HASH:
            jresult = (*jenv)->NewObject(jenv, hash_stat_class,
            hash_stat_construct);
            if (jresult != NULL)
            __dbj_fill_h_stat(jenv, hash_stat_class,
            jresult, (DB_HASH_STAT *)result);
            break;
            
            case DB_QUEUE:
            jresult = (*jenv)->NewObject(jenv, queue_stat_class,
            queue_stat_construct);
            if (jresult != NULL)
            __dbj_fill_qam_stat(jenv, queue_stat_class,
            jresult, (DB_QUEUE_STAT *)result);
            break;
            
            /* That's all the database types we're aware of! */
            default:
            __dbj_throw(jenv, EINVAL, "Db.stat only implemented for"
            " BTREE, HASH, QUEUE and RECNO", NULL, DB2JDBENV);
            break;
        }
        
        __os_ufree(db->dbenv, result);
    }
    
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1sync(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db *arg1 = (struct __db *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_sync(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1truncate(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    jint jresult = 0 ;
    struct __db *arg1 = (struct __db *) 0 ;
    DB_TXN *arg2 = (DB_TXN *) 0 ;
    u_int32_t arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    arg2 = *(DB_TXN **)&jarg2; 
    arg3 = (u_int32_t)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (int)__db_truncate(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1upgrade(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    struct __db *arg1 = (struct __db *) 0 ;
    char *arg2 ;
    u_int32_t arg3 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (u_int32_t)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_upgrade(arg1,(char const *)arg2,arg3);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Db_1verify0(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jobject jarg4, jint jarg5) {
    struct __db *arg1 = (struct __db *) 0 ;
    char *arg2 ;
    char *arg3 ;
    struct __db_out_stream arg4 ;
    u_int32_t arg5 ;
    db_ret_t result;
    struct __dbj_verify_data data4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    {
        data4.jenv = jenv;
        data4.streamobj = jarg4;
        data4.bytes = NULL;
        data4.nbytes = 0;
        (&arg4)->handle = &data4;
        (&arg4)->callback = __dbj_verify_callback;
    }
    arg5 = (u_int32_t)jarg5; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_verify(arg1,(char const *)arg2,(char const *)arg3,arg4,arg5);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_Dbc_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    struct __dbc *arg1 = (struct __dbc *) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __dbc **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__dbc_close(arg1);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Dbc_1count(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    struct __dbc *arg1 = (struct __dbc *) 0 ;
    u_int32_t arg2 ;
    db_recno_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __dbc **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (db_recno_t)__dbc_count(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DBC2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Dbc_1del(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    struct __dbc *arg1 = (struct __dbc *) 0 ;
    u_int32_t arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __dbc **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    result = (int)__dbc_del(arg1,arg2);
    
    if (!DB_RETOK_DBCDEL(result))
    __dbj_throw(jenv, result, NULL, NULL, DBC2JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_Dbc_1dup(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    struct __dbc *arg1 = (struct __dbc *) 0 ;
    u_int32_t arg2 ;
    DBC *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __dbc **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DBC *)__dbc_dup(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, DBC2JDBENV);
    
    *(DBC **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Dbc_1get_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jobject jarg3, jint jarg4) {
    jint jresult = 0 ;
    struct __dbc *arg1 = (struct __dbc *) 0 ;
    DBT *arg2 = (DBT *) 0 ;
    DBT *arg3 = (DBT *) 0 ;
    u_int32_t arg4 ;
    int result;
    DBT_LOCKED ldbt2 ;
    DBT_LOCKED ldbt3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __dbc **)&jarg1; 
    
    if (__dbj_dbt_copyin(jenv, &ldbt2, jarg2) != 0)
    return 0;
    arg2 = &ldbt2.dbt;
    
    
    if (__dbj_dbt_copyin(jenv, &ldbt3, jarg3) != 0)
    return 0;
    arg3 = &ldbt3.dbt;
    
    arg4 = (u_int32_t)jarg4; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    result = (int)__dbc_get__SWIG_0(arg1,arg2,arg3,arg4);
    
    if (!DB_RETOK_DBCGET(result))
    __dbj_throw(jenv, result, NULL, NULL, DBC2JDBENV);
    
    jresult = (jint)result; 
    
    __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2);
    
    
    __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3);
    
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Dbc_1get_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jint jarg5) {
    jint jresult = 0 ;
    struct __dbc *arg1 = (struct __dbc *) 0 ;
    DBT *arg2 = (DBT *) 0 ;
    DBT *arg3 = (DBT *) 0 ;
    DBT *arg4 = (DBT *) 0 ;
    u_int32_t arg5 ;
    int result;
    DBT_LOCKED ldbt2 ;
    DBT_LOCKED ldbt3 ;
    DBT_LOCKED ldbt4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __dbc **)&jarg1; 
    
    if (__dbj_dbt_copyin(jenv, &ldbt2, jarg2) != 0)
    return 0;
    arg2 = &ldbt2.dbt;
    
    
    if (__dbj_dbt_copyin(jenv, &ldbt3, jarg3) != 0)
    return 0;
    arg3 = &ldbt3.dbt;
    
    
    if (__dbj_dbt_copyin(jenv, &ldbt4, jarg4) != 0)
    return 0;
    arg4 = &ldbt4.dbt;
    
    arg5 = (u_int32_t)jarg5; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    result = (int)__dbc_pget__SWIG_1(arg1,arg2,arg3,arg4,arg5);
    
    if (!DB_RETOK_DBCGET(result))
    __dbj_throw(jenv, result, NULL, NULL, DBC2JDBENV);
    
    jresult = (jint)result; 
    
    __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2);
    
    
    __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3);
    
    
    __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4);
    
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_Dbc_1put(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jobject jarg3, jint jarg4) {
    jint jresult = 0 ;
    struct __dbc *arg1 = (struct __dbc *) 0 ;
    DBT *arg2 = (DBT *) 0 ;
    DBT *arg3 = (DBT *) 0 ;
    u_int32_t arg4 ;
    int result;
    DBT_LOCKED ldbt2 ;
    DBT_LOCKED ldbt3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __dbc **)&jarg1; 
    
    if (__dbj_dbt_copyin(jenv, &ldbt2, jarg2) != 0)
    return 0;
    arg2 = &ldbt2.dbt;
    
    
    if (__dbj_dbt_copyin(jenv, &ldbt3, jarg3) != 0)
    return 0;
    arg3 = &ldbt3.dbt;
    
    arg4 = (u_int32_t)jarg4; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    result = (int)__dbc_put(arg1,arg2,arg3,arg4);
    
    if (!DB_RETOK_DBCPUT(result))
    __dbj_throw(jenv, result, NULL, NULL, DBC2JDBENV);
    
    jresult = (jint)result; 
    
    __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2);
    
    
    __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3);
    
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_new_1DbEnv(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    u_int32_t arg1 ;
    struct __db_env *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (u_int32_t)jarg1; 
    
    errno = 0;
    result = (struct __db_env *)new___db_env(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
    
    *(struct __db_env **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_close(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1dbremove(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jint jarg5) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    DB_TXN *arg2 = (DB_TXN *) 0 ;
    char *arg3 ;
    char *arg4 ;
    u_int32_t arg5 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = *(DB_TXN **)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return ;
        }
    }
    arg5 = (u_int32_t)jarg5; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_dbremove(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1dbrename(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jint jarg6) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    DB_TXN *arg2 = (DB_TXN *) 0 ;
    char *arg3 ;
    char *arg4 ;
    char *arg5 ;
    u_int32_t arg6 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = *(DB_TXN **)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return ;
        }
    }
    {
        arg5 = 0;
        if (jarg5) {
            arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
            if (!arg5) return ;
        }
    }
    arg6 = (u_int32_t)jarg6; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_dbrename(arg1,arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5,arg6);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
    {
        if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, arg5); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1err(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    int arg2 ;
    char *arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    __db_env_err(arg1,arg2,(char const *)arg3);
    
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1errx(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    __db_env_errx(arg1,(char const *)arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jobjectArray JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1data_1dirs(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jobjectArray jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    char **result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (char **)__db_env_get_data_dirs(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    {
        if(result != NULL) {
            /*@../libdb_java/java_typemaps.i,229,STRING_ARRAY_OUT@*/	int i, len;
            
            len = 0;
            while (result[len] != NULL)
            len++;
            if ((jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, string_class,
            NULL)) == NULL)
            return 0; /* an exception is pending */
            for (i = 0; i < len; i++) {
                jstring str = (*jenv)->NewStringUTF(jenv, result[i]);
                (*jenv)->SetObjectArrayElement(jenv, jresult, (jsize)i, str);
            }
            /*@@*/
        }
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1encrypt_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_env_get_encrypt_flags(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_env_get_flags(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1home(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (char *)__db_env_get_home(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1open_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_env_get_open_flags(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1shm_1key(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    long result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (long)__db_env_get_shm_key(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1tas_1spins(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_env_get_tas_spins(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1tmp_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (char *)__db_env_get_tmp_dir(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1verbose(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jboolean jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    int_bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (int_bool)__db_env_get_verbose(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    
    jresult = (result) ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1open0(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    char *arg2 ;
    u_int32_t arg3 ;
    int arg4 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (u_int32_t)jarg3; 
    arg4 = (int)jarg4; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_open(arg1,(char const *)arg2,arg3,arg4);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1remove0(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    char *arg2 ;
    u_int32_t arg3 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (u_int32_t)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_remove(arg1,(char const *)arg2,arg3);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    jlong arg2 ;
    int arg3 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = jarg2; 
    arg3 = (int)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_cachesize(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1data_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    char *arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_data_dir(arg1,(char const *)arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1encrypt(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    char *arg2 ;
    u_int32_t arg3 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (u_int32_t)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_encrypt(arg1,(char const *)arg2,arg3);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1setErrorHandler(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    void (*arg2)(char const *,char *) = (void (*)(char const *,char *)) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    arg2 = (jarg2 == NULL) ? NULL : __dbj_error;
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    __db_env_set_errcall(arg1,arg2);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jboolean jarg3) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    int_bool arg3 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    arg3 = (jarg3 == JNI_TRUE);
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_flags(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1setFeedbackHandler(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    void (*arg2)(DB_ENV *,int,int) = (void (*)(DB_ENV *,int,int)) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    arg2 = (jarg2 == NULL) ? NULL : __dbj_env_feedback;
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_feedback(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1mp_1mmapsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    size_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (size_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_mp_mmapsize(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1setPanicHandler(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    void (*arg2)(DB_ENV *,int) = (void (*)(DB_ENV *,int)) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    arg2 = (jarg2 == NULL) ? NULL : __dbj_panic;
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_paniccall(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1rpc_1server(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jstring jarg3, jlong jarg4, jlong jarg5, jint jarg6) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    void *arg2 = (void *) 0 ;
    char *arg3 ;
    long arg4 ;
    long arg5 ;
    u_int32_t arg6 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = *(void **)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    arg4 = (long)jarg4; 
    arg5 = (long)jarg5; 
    arg6 = (u_int32_t)jarg6; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    if (arg2 != NULL) {
        __dbj_throw(jenv, EINVAL, "DbEnv.set_rpc_server client arg "
        "must be null; reserved for future use", NULL, JDBENV);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_rpc_server(arg1,arg2,arg3,arg4,arg5,arg6);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1shm_1key(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    long arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (long)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_shm_key(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1tas_1spins(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_tas_spins(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    db_timeout_t arg2 ;
    u_int32_t arg3 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (db_timeout_t)jarg2; 
    arg3 = (u_int32_t)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_timeout(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1tmp_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    char *arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_tmp_dir(arg1,(char const *)arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1tx_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_tx_max(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1app_1dispatch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    int (*arg2)(DB_ENV *,DBT *,DB_LSN *,db_recops) = (int (*)(DB_ENV *,DBT *,DB_LSN *,db_recops)) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    arg2 = (jarg2 == NULL) ? NULL : __dbj_app_dispatch;
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_app_dispatch(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1tx_1timestamp0(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    time_t *arg2 = (time_t *) 0 ;
    db_ret_t result;
    time_t time2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    time2 = (time_t)jarg2;
    arg2 = &time2;
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_tx_timestamp(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1verbose(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jboolean jarg3) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    int_bool arg3 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    arg3 = (jarg3 == JNI_TRUE);
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_verbose(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT jobjectArray JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1lk_1conflicts(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jobjectArray jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    struct __db_lk_conflicts result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = __db_env_get_lk_conflicts(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    {
        int i;
        jbyteArray bytes;
        
        jresult = (*jenv)->NewObjectArray(jenv,
        (jsize)(&result)->lk_modes, bytearray_class, NULL);
        if (jresult == NULL)
        return 0; /* an exception is pending */
        for (i = 0; i < (&result)->lk_modes; i++) {
            bytes = (*jenv)->NewByteArray(jenv, (jsize)(&result)->lk_modes);
            if (bytes == NULL)
            return 0; /* an exception is pending */
            (*jenv)->SetByteArrayRegion(jenv, bytes, 0, (jsize)(&result)->lk_modes,
            (jbyte *)((&result)->lk_conflicts + i * (&result)->lk_modes));
            (*jenv)->SetObjectArrayElement(jenv, jresult, (jsize)i, bytes);
        }
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1lk_1detect(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_env_get_lk_detect(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1lk_1max_1locks(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_env_get_lk_max_locks(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1lk_1max_1lockers(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_env_get_lk_max_lockers(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1lk_1max_1objects(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_env_get_lk_max_objects(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1lock_1detect(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    u_int32_t arg3 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    arg3 = (u_int32_t)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (int)__db_env_lock_detect(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1lock_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jobject jarg4, jint jarg5) {
    jlong jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    u_int32_t arg3 ;
    DBT *arg4 = (DBT *) 0 ;
    db_lockmode_t arg5 ;
    DB_LOCK *result;
    DBT_LOCKED ldbt4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    arg3 = (u_int32_t)jarg3; 
    
    if (__dbj_dbt_copyin(jenv, &ldbt4, jarg4) != 0)
    return 0;
    arg4 = &ldbt4.dbt;
    
    arg5 = (db_lockmode_t)jarg5; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DB_LOCK *)__db_env_lock_get(arg1,arg2,arg3,(DBT const *)arg4,arg5);
    
    if (errno == DB_LOCK_NOTGRANTED) {
        (*jenv)->Throw(jenv,
        (*jenv)->NewObject(jenv, lockex_class, lockex_construct,
        (*jenv)->NewStringUTF(jenv, "DbEnv.lock_get not granted"),
        DB_LOCK_GET, arg5, jarg4, NULL, -1, JDBENV));
    }else if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    *(DB_LOCK **)&jresult = result; 
    
    if (ldbt4.jarr != NULL) {
        (*jenv)->ReleaseByteArrayElements(jenv, ldbt4.jarr,
        ldbt4.orig_data, 0);
    }
    
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1lock_1id(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_env_lock_id(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1lock_1id_1free(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_lock_id_free(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1lock_1put(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    DB_LOCK *arg2 = (DB_LOCK *) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = *(DB_LOCK **)&jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_lock_put(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1lock_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jobject jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    DB_LOCK_STAT *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DB_LOCK_STAT *)__db_env_lock_stat(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    
    jresult = (*jenv)->NewObject(jenv, lock_stat_class, lock_stat_construct);
    if (jresult != NULL)
    __dbj_fill_lock_stat(jenv, lock_stat_class, jresult, result);
    __os_ufree(NULL, result);
    
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1lk_1conflicts(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    struct __db_lk_conflicts arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    {
        int i, len, err;
        size_t bytesize;
        
        len = (&arg2)->lk_modes = (*jenv)->GetArrayLength(jenv, jarg2);
        bytesize = sizeof(u_char) * len * len;
        
        if ((err = __os_malloc(NULL, bytesize, &(&arg2)->lk_conflicts)) != 0) {
            __dbj_throw(jenv, err, NULL, NULL, JDBENV);
            return ;
        }
        
        for (i = 0; i < len; i++) {
            jobject sub_array = (*jenv)->GetObjectArrayElement(jenv,
            jarg2, i);
            (*jenv)->GetByteArrayRegion(jenv,(jbyteArray)sub_array, 0, len,
            (jbyte *)&(&arg2)->lk_conflicts[i * len]);
        }
    }
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_lk_conflicts(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
    
    __os_free(NULL, (&arg2)->lk_conflicts);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1lk_1detect(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_lk_detect(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1lk_1max_1lockers(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_lk_max_lockers(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1lk_1max_1locks(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_lk_max_locks(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1lk_1max_1objects(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_lk_max_objects(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1lg_1bsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_env_get_lg_bsize(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1lg_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (char *)__db_env_get_lg_dir(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1lg_1max(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_env_get_lg_max(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1lg_1regionmax(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_env_get_lg_regionmax(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jobjectArray JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1log_1archive(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jobjectArray jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    char **result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (char **)__db_env_log_archive(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    {
        if(result != NULL) {
            /*@../libdb_java/java_typemaps.i,229,STRING_ARRAY_OUT@*/	int i, len;
            
            len = 0;
            while (result[len] != NULL)
            len++;
            if ((jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, string_class,
            NULL)) == NULL)
            return 0; /* an exception is pending */
            for (i = 0; i < len; i++) {
                jstring str = (*jenv)->NewStringUTF(jenv, result[i]);
                (*jenv)->SetObjectArrayElement(jenv, jresult, (jsize)i, str);
            }
            /*@@*/
            __os_ufree(NULL, result);
        }
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1log_1compare(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    DB_LSN *arg1 = (DB_LSN *) 0 ;
    DB_LSN *arg2 = (DB_LSN *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DB_LSN **)&jarg1; 
    arg2 = *(DB_LSN **)&jarg2; 
    result = (int)DbEnv_log_compare((DB_LSN const *)arg1,(DB_LSN const *)arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1log_1cursor(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    DB_LOGC *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DB_LOGC *)__db_env_log_cursor(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    *(DB_LOGC **)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1log_1file(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jstring jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    DB_LSN *arg2 = (DB_LSN *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = *(DB_LSN **)&jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (char *)__db_env_log_file(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1log_1flush(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    DB_LSN *arg2 = (DB_LSN *) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = *(DB_LSN **)&jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_log_flush(arg1,(DB_LSN const *)arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1log_1put(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jint jarg4) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    DB_LSN *arg2 = (DB_LSN *) 0 ;
    DBT *arg3 = (DBT *) 0 ;
    u_int32_t arg4 ;
    db_ret_t result;
    DBT_LOCKED ldbt3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = *(DB_LSN **)&jarg2; 
    
    if (__dbj_dbt_copyin(jenv, &ldbt3, jarg3) != 0)
    return ;
    arg3 = &ldbt3.dbt;
    
    arg4 = (u_int32_t)jarg4; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_log_put(arg1,arg2,(DBT const *)arg3,arg4);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
    
    if (ldbt3.jarr != NULL) {
        (*jenv)->ReleaseByteArrayElements(jenv, ldbt3.jarr,
        ldbt3.orig_data, 0);
    }
    
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1log_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jobject jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    DB_LOG_STAT *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DB_LOG_STAT *)__db_env_log_stat(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    
    jresult = (*jenv)->NewObject(jenv, log_stat_class, log_stat_construct);
    if (jresult != NULL)
    __dbj_fill_log_stat(jenv, log_stat_class, jresult, result);
    __os_ufree(NULL, result);
    
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1lg_1bsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_lg_bsize(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1lg_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    char *arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_lg_dir(arg1,(char const *)arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1lg_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_lg_max(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1lg_1regionmax(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_lg_regionmax(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    jlong result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = __db_env_get_cachesize(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1cachesize_1ncache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (int)__db_env_get_cachesize_ncache(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1mp_1mmapsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = __db_env_get_mp_mmapsize(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1memp_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jobject jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    DB_MPOOL_STAT *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DB_MPOOL_STAT *)__db_env_memp_stat(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    
    jresult = (*jenv)->NewObject(jenv, mpool_stat_class, mpool_stat_construct);
    if (jresult != NULL)
    __dbj_fill_mpool_stat(jenv, mpool_stat_class, jresult, result);
    __os_ufree(NULL, result);
    
    return jresult;
}


JNIEXPORT jobjectArray JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1memp_1fstat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jobjectArray jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    DB_MPOOL_FSTAT **result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DB_MPOOL_FSTAT **)__db_env_memp_fstat(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    {
        int i, len;
        
        len = 0;
        while (result[len] != NULL)
        len++;
        jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, mpool_fstat_class, 0);
        if (jresult == NULL) {
            __os_ufree(NULL, result);
            return 0;
        }
        for (i = 0; i < len; i++) {
            jobject obj = (*jenv)->NewObject(jenv, mpool_fstat_class,
            mpool_fstat_construct);
            if (obj == NULL) {
                __os_ufree(NULL, result);
                return 0; /* an exception is pending */
            }
            (*jenv)->SetObjectArrayElement(jenv, jresult, i, obj);
            __dbj_fill_mpool_fstat(jenv, mpool_fstat_class, obj, result[i]);
        }
        __os_ufree(NULL, result);
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1memp_1trickle(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (int)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (int)__db_env_memp_trickle(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1tx_1max(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_env_get_tx_max(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1tx_1timestamp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    time_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = __db_env_get_tx_timestamp(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    db_timeout_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (db_timeout_t)__db_env_get_timeout(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1txn_1begin(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    jlong jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    DB_TXN *arg2 = (DB_TXN *) 0 ;
    u_int32_t arg3 ;
    DB_TXN *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = *(DB_TXN **)&jarg2; 
    arg3 = (u_int32_t)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DB_TXN *)__db_env_txn_begin(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    *(DB_TXN **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1txn_1checkpoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    u_int32_t arg3 ;
    u_int32_t arg4 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    arg3 = (u_int32_t)jarg3; 
    arg4 = (u_int32_t)jarg4; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_txn_checkpoint(arg1,arg2,arg3,arg4);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT jobjectArray JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1txn_1recover(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
    jobjectArray jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    int arg2 ;
    u_int32_t arg3 ;
    DB_PREPLIST *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (u_int32_t)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DB_PREPLIST *)__db_env_txn_recover(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    {
        int i, len;
        
        len = 0;
        while (result[len].txn != NULL)
        len++;
        jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, dbpreplist_class,
        NULL);
        if (jresult == NULL)
        return 0; /* an exception is pending */
        for (i = 0; i < len; i++) {
            jobject jtxn = (*jenv)->NewObject(jenv, dbtxn_class,
            dbtxn_construct, result[i].txn, JNI_FALSE);
            jobject bytearr = (*jenv)->NewByteArray(jenv,
            (jsize)sizeof(result[i].gid));
            jobject obj = (*jenv)->NewObject(jenv, dbpreplist_class,
            dbpreplist_construct, jtxn, bytearr);
            
            if (jtxn == NULL || bytearr == NULL || obj == NULL)
            return 0; /* An exception is pending */
            
            (*jenv)->SetByteArrayRegion(jenv, bytearr, 0,
            (jsize)sizeof(result[i].gid), (jbyte *)result[i].gid);
            (*jenv)->SetObjectArrayElement(jenv, jresult, i, obj);
        }
        __os_ufree(NULL, result);
    }
    return jresult;
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1txn_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jobject jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    DB_TXN_STAT *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DB_TXN_STAT *)__db_env_txn_stat(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    {
        unsigned int i;
        jobjectArray actives;
        jresult = (*jenv)->NewObject(jenv, txn_stat_class, txn_stat_construct);
        if (jresult != NULL)
        __dbj_fill_txn_stat(jenv, txn_stat_class, jresult, result);
        
        actives = (*jenv)->NewObjectArray(jenv, (jsize)result->st_nactive,
        txn_active_class, 0);
        if (actives == NULL) {
            __os_ufree(NULL, result);
            return 0;
        }
        (*jenv)->SetObjectField(jenv, jresult, txn_stat_active_fid, actives);
        for (i = 0; i < result->st_nactive; i++) {
            jobject obj = (*jenv)->NewObject(jenv, txn_active_class,
            txn_active_construct);
            if (obj == NULL) {
                __os_ufree(NULL, result);
                return 0; /* an exception is pending */
            }
            (*jenv)->SetObjectArrayElement(jenv, actives, (jsize)i, obj);
            __dbj_fill_txn_active(jenv, txn_active_class, obj,
            &result->st_txnarray[i]);
        }
        __os_ufree(NULL, result);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1rep_1limit(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    jlong result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = __db_env_get_rep_limit(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1rep_1elect(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    int arg2 ;
    int arg3 ;
    u_int32_t arg4 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    arg4 = (u_int32_t)jarg4; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (int)__db_env_rep_elect(arg1,arg2,arg3,arg4);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1rep_1process_1message(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jlong jarg5) {
    jint jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    DBT *arg2 = (DBT *) 0 ;
    DBT *arg3 = (DBT *) 0 ;
    int *arg4 = (int *) 0 ;
    DB_LSN *arg5 = (DB_LSN *) 0 ;
    int result;
    DBT_LOCKED ldbt2 ;
    DBT_LOCKED ldbt3 ;
    int id4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (__dbj_dbt_copyin(jenv, &ldbt2, jarg2) != 0)
    return 0;
    arg2 = &ldbt2.dbt;
    
    
    if (__dbj_dbt_copyin(jenv, &ldbt3, jarg3) != 0)
    return 0;
    arg3 = &ldbt3.dbt;
    
    
    id4 = (*jenv)->GetIntField(jenv, jarg4, rep_processmsg_envid);
    arg4 = &id4;
    
    arg5 = *(DB_LSN **)&jarg5; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    result = (int)__db_env_rep_process_message(arg1,arg2,arg3,arg4,arg5);
    
    if (!DB_RETOK_REPPMSG(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
    jresult = (jint)result; 
    
    (*jenv)->SetIntField(jenv, jarg4, rep_processmsg_envid, *arg4);
    
    
    __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2);
    
    
    __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3);
    
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1rep_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jint jarg3) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    DBT *arg2 = (DBT *) 0 ;
    u_int32_t arg3 ;
    db_ret_t result;
    DBT_LOCKED ldbt2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    
    if (__dbj_dbt_copyin(jenv, &ldbt2, jarg2) != 0)
    return ;
    arg2 = &ldbt2.dbt;
    
    arg3 = (u_int32_t)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_rep_start(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
    
    __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2);
    
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1rep_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jobject jresult = 0 ;
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    u_int32_t arg2 ;
    DB_REP_STAT *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DB_REP_STAT *)__db_env_rep_stat(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
    
    
    jresult = (*jenv)->NewObject(jenv, rep_stat_class, rep_stat_construct);
    if (jresult != NULL)
    __dbj_fill_rep_stat(jenv, rep_stat_class, jresult, result);
    __os_ufree(NULL, result);
    
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1rep_1limit(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    jlong arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_rep_limit(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1set_1rep_1transport(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jobject jarg3) {
    struct __db_env *arg1 = (struct __db_env *) 0 ;
    int arg2 ;
    int (*arg3)(DB_ENV *,DBT const *,DBT const *,DB_LSN const *,int,u_int32_t) = (int (*)(DB_ENV *,DBT const *,DBT const *,DB_LSN const *,int,u_int32_t)) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_env **)&jarg1; 
    arg2 = (int)jarg2; 
    
    arg3 = (jarg3 == NULL) ? NULL : __dbj_rep_transport;
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_env_set_rep_transport(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
    
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1strerror(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jstring jresult = 0 ;
    int arg1 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    result = (char *)DbEnv_strerror(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1version_1major(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)DbEnv_get_version_major();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1version_1minor(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)DbEnv_get_version_minor();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1version_1patch(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)DbEnv_get_version_patch();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_db_1javaJNI_DbEnv_1get_1version_1string(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *)DbEnv_get_version_string();
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbTxn_1abort0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    struct __db_txn *arg1 = (struct __db_txn *) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_txn **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_txn_abort(arg1);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbTxn_1commit0(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_txn *arg1 = (struct __db_txn *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_txn **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_txn_commit(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbTxn_1discard0(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_txn *arg1 = (struct __db_txn *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_txn **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_txn_discard(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbTxn_1id(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_txn *arg1 = (struct __db_txn *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_txn **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    result = (u_int32_t)__db_txn_id(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbTxn_1prepare(JNIEnv *jenv, jclass jcls, jlong jarg1, jbyteArray jarg2) {
    struct __db_txn *arg1 = (struct __db_txn *) 0 ;
    u_int8_t *arg2 = (u_int8_t *) 0 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_txn **)&jarg1; 
    
    arg2 = (u_int8_t *)(*jenv)->GetByteArrayElements(jenv, jarg2, NULL);
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    if ((*jenv)->GetArrayLength(jenv, jarg2) < DB_XIDDATASIZE) {
        __dbj_throw(jenv, EINVAL,
        "DbTxn.prepare gid array must be >= 128 bytes", NULL, TXN2JDBENV);
        return ;
    }
    
    
    result = (db_ret_t)__db_txn_prepare(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, TXN2JDBENV);
    
    
    (*jenv)->ReleaseByteArrayElements(jenv, jarg2, (jbyte *)arg2, 0);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbTxn_1set_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    struct __db_txn *arg1 = (struct __db_txn *) 0 ;
    db_timeout_t arg2 ;
    u_int32_t arg3 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_txn **)&jarg1; 
    arg2 = (db_timeout_t)jarg2; 
    arg3 = (u_int32_t)jarg3; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_txn_set_timeout(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, TXN2JDBENV);
    
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbLogc_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_log_cursor *arg1 = (struct __db_log_cursor *) 0 ;
    u_int32_t arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_log_cursor **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_log_cursor_close(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbLogc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jint jarg4) {
    jint jresult = 0 ;
    struct __db_log_cursor *arg1 = (struct __db_log_cursor *) 0 ;
    DB_LSN *arg2 = (DB_LSN *) 0 ;
    DBT *arg3 = (DBT *) 0 ;
    u_int32_t arg4 ;
    int result;
    DBT_LOCKED ldbt3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_log_cursor **)&jarg1; 
    arg2 = *(DB_LSN **)&jarg2; 
    
    if (__dbj_dbt_copyin(jenv, &ldbt3, jarg3) != 0)
    return 0;
    arg3 = &ldbt3.dbt;
    
    arg4 = (u_int32_t)jarg4; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    result = (int)__db_log_cursor_get(arg1,arg2,arg3,arg4);
    
    if (!DB_RETOK_LGGET(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
    jresult = (jint)result; 
    
    __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3);
    
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_delete_1DbLock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    struct __db_lock_u *arg1 = (struct __db_lock_u *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_lock_u **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    delete___db_lock_u(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_new_1DbLsn(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    jlong jresult = 0 ;
    u_int32_t arg1 ;
    u_int32_t arg2 ;
    struct __db_lsn *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (u_int32_t)jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    errno = 0;
    result = (struct __db_lsn *)new___db_lsn(arg1,arg2);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
    
    *(struct __db_lsn **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_delete_1DbLsn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    struct __db_lsn *arg1 = (struct __db_lsn *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_lsn **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    delete___db_lsn(arg1);
    
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbLsn_1get_1file(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_lsn *arg1 = (struct __db_lsn *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_lsn **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    result = (u_int32_t)__db_lsn_get_file(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbLsn_1get_1offset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_lsn *arg1 = (struct __db_lsn *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_lsn **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    result = (u_int32_t)__db_lsn_get_offset(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbMpoolFile_1get_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_mpoolfile *arg1 = (struct __db_mpoolfile *) 0 ;
    DB_CACHE_PRIORITY result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_mpoolfile **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (DB_CACHE_PRIORITY)__db_mpoolfile_get_priority(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbMpoolFile_1set_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    struct __db_mpoolfile *arg1 = (struct __db_mpoolfile *) 0 ;
    DB_CACHE_PRIORITY arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_mpoolfile **)&jarg1; 
    arg2 = (DB_CACHE_PRIORITY)jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_mpoolfile_set_priority(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_db_1javaJNI_DbMpoolFile_1get_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    struct __db_mpoolfile *arg1 = (struct __db_mpoolfile *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_mpoolfile **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = (u_int32_t)__db_mpoolfile_get_flags(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbMpoolFile_1set_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jboolean jarg3) {
    struct __db_mpoolfile *arg1 = (struct __db_mpoolfile *) 0 ;
    u_int32_t arg2 ;
    int_bool arg3 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_mpoolfile **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    arg3 = (jarg3 == JNI_TRUE);
    
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_mpoolfile_set_flags(arg1,arg2,arg3);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_db_1javaJNI_DbMpoolFile_1get_1maxsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    struct __db_mpoolfile *arg1 = (struct __db_mpoolfile *) 0 ;
    jlong result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_mpoolfile **)&jarg1; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return 0;
    }
    
    
    errno = 0;
    result = __db_mpoolfile_get_maxsize(arg1);
    
    if (!DB_RETOK_STD(errno))
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
    
    jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_db_1javaJNI_DbMpoolFile_1set_1maxsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    struct __db_mpoolfile *arg1 = (struct __db_mpoolfile *) 0 ;
    jlong arg2 ;
    db_ret_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(struct __db_mpoolfile **)&jarg1; 
    arg2 = jarg2; 
    
    if (jarg1 == 0) {
        __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
        return ;
    }
    
    
    result = (db_ret_t)__db_mpoolfile_set_maxsize(arg1,arg2);
    
    if (!DB_RETOK_STD(result))
    __dbj_throw(jenv, result, NULL, NULL, NULL);
    
}


#ifdef __cplusplus
}
#endif

