/*
 *  ----------------------------------------------------------------------------
 *  This file was automatically generated by SWIG (http://www.swig.org).
 *  Version: 1.3.19
 *
 *  Do not make changes to this file unless you know what you are doing--modify
 *  the SWIG interface file instead.
 *  -----------------------------------------------------------------------------
 */
package com.sleepycat.db;

/**
 *  The DbLogc object is the handle for a cursor into the log files,
 *  supporting sequential access to the records stored in log files.
 *  The handle is not free-threaded. Once the {@link
 *  com.sleepycat.db.DbLogc#close DbLogc.close} method is called, the
 *  handle may not be accessed again, regardless of that method's
 *  return.</p>
 */
public class DbLogc {
    private long swigCPtr;
    protected boolean swigCMemOwn;


    protected DbLogc(long cPtr, boolean cMemoryOwn) {
        swigCMemOwn = cMemoryOwn;
        swigCPtr = cPtr;
    }


    protected DbLogc() {
        this(0, false);
    }


    protected void delete() {
        if (swigCPtr != 0 && swigCMemOwn) {
            swigCMemOwn = false;
        }
        swigCPtr = 0;
    }


    protected static long getCPtr(DbLogc obj) {
        return (obj == null) ? 0 : obj.swigCPtr;
    }


    /**
     *  The DbLogc.close method discards the log cursor. After
     *  DbLogc.close has been called, regardless of its return, the
     *  cursor handle may not be used again.</p>
     *
     * @param  flags                      currently unused, and must
     *      be set to 0.
     * @throws  IllegalArgumentException  The DbLogc.close method will
     *      fail and throw a IllegalArgumentException exception if the
     *      cursor was previously closed; or if an invalid flag value
     *      or parameter was specified.
     */
    public synchronized void close(int flags) throws DbException {
        try {
            close0(flags);
        } finally {
            swigCPtr = 0;
        }
    }


    void close0(int flags) {
        db_javaJNI.DbLogc_close0(swigCPtr, flags);
    }


    /**
     *  The DbLogc.get method returns records from the log.</p>
     *
     * @param  data                       The data field of the <b>
     *      data</b> structure is set to the record retrieved, and the
     *      size field indicates the number of bytes in the record.
     *      See {@link com.sleepycat.db.Dbt Dbt} for a description of
     *      other fields in the <b>data</b> structure. The {@link
     *      com.sleepycat.db.Db#DB_DBT_MALLOC Db.DB_DBT_MALLOC},
     *      {@link com.sleepycat.db.Db#DB_DBT_REALLOC
     *      Db.DB_DBT_REALLOC} and {@link
     *      com.sleepycat.db.Db#DB_DBT_USERMEM Db.DB_DBT_USERMEM}
     *      flags may be specified for any {@link com.sleepycat.db.Dbt
     *      Dbt} used for data retrieval.
     * @param  flags                      must be set to one of the
     *      following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_CURRENT
     *        Db.DB_CURRENT}<p>
     *
     *        Return the log record to which the log currently refers.
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_FIRST Db.DB_FIRST}<p>
     *
     *        The first record from any of the log files found in the
     *        log directory is returned in the <b>data</b> parameter.
     *        overwritten with the {@link com.sleepycat.db.DbLsn
     *        DbLsn} of the record returned. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LAST Db.DB_LAST}<p>
     *
     *        The last record in the log is returned in the <b>data
     *        </b> parameter. overwritten with the {@link
     *        com.sleepycat.db.DbLsn DbLsn} of the record returned.
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NEXT Db.DB_NEXT}<p>
     *
     *        The current log position is advanced to the next record
     *        in the log, and that record is returned in the <b>data
     *        </b> parameter. overwritten with the {@link
     *        com.sleepycat.db.DbLsn DbLsn} of the record returned.
     *        <p>
     *
     *        If the cursor has not been initialized via DB_FIRST,
     *        DB_LAST, DB_SET, DB_NEXT, or DB_PREV, DbLogc.get will
     *        return the first record in the log.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_PREV Db.DB_PREV}<p>
     *
     *        The current log position is advanced to the previous
     *        record in the log, and that record is returned in the
     *        <b>data</b> parameter. overwritten with the {@link
     *        com.sleepycat.db.DbLsn DbLsn} of the record returned.
     *        <p>
     *
     *        If the cursor has not been initialized via DB_FIRST,
     *        DB_LAST, DB_SET, DB_NEXT, or DB_PREV, DbLogc.get will
     *        return the last record in the log.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SET Db.DB_SET}<p>
     *
     *        Retrieve the record specified by the <b>lsn</b>
     *        parameter. </li>
     *      </ul>
     *
     * @param  lsn                        When the <b>flag</b>
     *      parameter is set to Db.DB_CURRENT, Db.DB_FIRST,
     *      Db.DB_LAST, Db.DB_NEXT or Db.DB_PREV, the <b>lsn</b>
     *      parameter is overwritten with the {@link
     *      com.sleepycat.db.DbLsn DbLsn} value of the record
     *      retrieved. When <b>flag</b> is set to Db.DB_SET, the <b>
     *      lsn</b> parameter is the {@link com.sleepycat.db.DbLsn
     *      DbLsn} value of the record to be retrieved.
     * @throws  IllegalArgumentException  The DbLogc.get method will
     *      fail and throw a IllegalArgumentException exception if the
     *      Db.DB_CURRENT flag was set and the log cursor has not yet
     *      been initialized; the Db.DB_CURRENT, Db.DB_NEXT, or
     *      Db.DB_PREV flags were set and the log was opened with the
     *      DB_THREAD flag set; the Db.DB_SET flag was set and the
     *      specified log sequence number does not appear in the log;
     *      or if an invalid flag value or parameter was specified.
     * @return                            Unless otherwise specified,
     *      the DbLogc.get method throws an exception that
     *      encapsulates a non-zero error value on failure. </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The DbLogc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_FIRST</code>
     *        is set and the log is empty. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The DbLogc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_LAST</code>
     *        is set and the log is empty. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The DbLogc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_NEXT</code>
     *        is set and the last log record has already been returned
     *        or the log is empty. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The DbLogc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_PREV</code>
     *        is set and the first log record has already been
     *        returned or the log is empty. </li>
     *      </ul>
     *      </p>
     */
    public int get(DbLsn lsn, Dbt data, int flags) throws DbException {
        return db_javaJNI.DbLogc_get(swigCPtr, DbLsn.getCPtr(lsn), data, flags);
    }

}
