
using namespace System.Management.Automation
using namespace System.Management.Automation.Language

Register-ArgumentCompleter -Native -CommandName 'onefetch' -ScriptBlock {
    param($wordToComplete, $commandAst, $cursorPosition)

    $commandElements = $commandAst.CommandElements
    $command = @(
        'onefetch'
        for ($i = 1; $i -lt $commandElements.Count; $i++) {
            $element = $commandElements[$i]
            if ($element -isnot [StringConstantExpressionAst] -or
                $element.StringConstantType -ne [StringConstantType]::BareWord -or
                $element.Value.StartsWith('-') -or
                $element.Value -eq $wordToComplete) {
                break
        }
        $element.Value
    }) -join ';'

    $completions = @(switch ($command) {
        'onefetch' {
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'Allows you to disable FIELD(s) from appearing in the output')
            [CompletionResult]::new('--disabled-fields', '--disabled-fields', [CompletionResultType]::ParameterName, 'Allows you to disable FIELD(s) from appearing in the output')
            [CompletionResult]::new('--number-of-authors', '--number-of-authors', [CompletionResultType]::ParameterName, 'Maximum NUM of authors to be shown')
            [CompletionResult]::new('--number-of-languages', '--number-of-languages', [CompletionResultType]::ParameterName, 'Maximum NUM of languages to be shown')
            [CompletionResult]::new('--number-of-file-churns', '--number-of-file-churns', [CompletionResultType]::ParameterName, 'Maximum NUM of file churns to be shown')
            [CompletionResult]::new('--churn-pool-size', '--churn-pool-size', [CompletionResultType]::ParameterName, 'Minimum NUM of commits from HEAD used to compute the churn summary')
            [CompletionResult]::new('-e', '-e', [CompletionResultType]::ParameterName, 'Ignore all files & directories matching EXCLUDE')
            [CompletionResult]::new('--exclude', '--exclude', [CompletionResultType]::ParameterName, 'Ignore all files & directories matching EXCLUDE')
            [CompletionResult]::new('--no-bots', '--no-bots', [CompletionResultType]::ParameterName, 'Exclude [bot] commits. Use <REGEX> to override the default pattern')
            [CompletionResult]::new('-T', '-T ', [CompletionResultType]::ParameterName, 'Filters output by language type')
            [CompletionResult]::new('--type', '--type', [CompletionResultType]::ParameterName, 'Filters output by language type')
            [CompletionResult]::new('-t', '-t', [CompletionResultType]::ParameterName, 'Changes the text colors (X X X...)')
            [CompletionResult]::new('--text-colors', '--text-colors', [CompletionResultType]::ParameterName, 'Changes the text colors (X X X...)')
            [CompletionResult]::new('--number-separator', '--number-separator', [CompletionResultType]::ParameterName, 'Which thousands SEPARATOR to use')
            [CompletionResult]::new('--ascii-input', '--ascii-input', [CompletionResultType]::ParameterName, 'Takes a non-empty STRING as input to replace the ASCII logo')
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'Colors (X X X...) to print the ascii art')
            [CompletionResult]::new('--ascii-colors', '--ascii-colors', [CompletionResultType]::ParameterName, 'Colors (X X X...) to print the ascii art')
            [CompletionResult]::new('-a', '-a', [CompletionResultType]::ParameterName, 'Which LANGUAGE''s ascii art to print')
            [CompletionResult]::new('--ascii-language', '--ascii-language', [CompletionResultType]::ParameterName, 'Which LANGUAGE''s ascii art to print')
            [CompletionResult]::new('--true-color', '--true-color', [CompletionResultType]::ParameterName, 'Specify when to use true color')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Path to the IMAGE file')
            [CompletionResult]::new('--image', '--image', [CompletionResultType]::ParameterName, 'Path to the IMAGE file')
            [CompletionResult]::new('--image-protocol', '--image-protocol', [CompletionResultType]::ParameterName, 'Which image PROTOCOL to use')
            [CompletionResult]::new('--color-resolution', '--color-resolution', [CompletionResultType]::ParameterName, 'VALUE of color resolution to use with SIXEL backend')
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'Outputs Onefetch in a specific format')
            [CompletionResult]::new('--output', '--output', [CompletionResultType]::ParameterName, 'Outputs Onefetch in a specific format')
            [CompletionResult]::new('--generate', '--generate', [CompletionResultType]::ParameterName, 'If provided, outputs the completion file for given SHELL')
            [CompletionResult]::new('--no-title', '--no-title', [CompletionResultType]::ParameterName, 'Hides the title')
            [CompletionResult]::new('--no-merges', '--no-merges', [CompletionResultType]::ParameterName, 'Ignores merge commits')
            [CompletionResult]::new('-E', '-E ', [CompletionResultType]::ParameterName, 'Show the email address of each author')
            [CompletionResult]::new('--email', '--email', [CompletionResultType]::ParameterName, 'Show the email address of each author')
            [CompletionResult]::new('--http-url', '--http-url', [CompletionResultType]::ParameterName, 'Display repository URL as HTTP')
            [CompletionResult]::new('--hide-token', '--hide-token', [CompletionResultType]::ParameterName, 'Hide token in repository URL')
            [CompletionResult]::new('--include-hidden', '--include-hidden', [CompletionResultType]::ParameterName, 'Count hidden files and directories')
            [CompletionResult]::new('-z', '-z', [CompletionResultType]::ParameterName, 'Use ISO 8601 formatted timestamps')
            [CompletionResult]::new('--iso-time', '--iso-time', [CompletionResultType]::ParameterName, 'Use ISO 8601 formatted timestamps')
            [CompletionResult]::new('--no-bold', '--no-bold', [CompletionResultType]::ParameterName, 'Turns off bold formatting')
            [CompletionResult]::new('--no-color-palette', '--no-color-palette', [CompletionResultType]::ParameterName, 'Hides the color palette')
            [CompletionResult]::new('--no-art', '--no-art', [CompletionResultType]::ParameterName, 'Hides the ascii art or image if provided')
            [CompletionResult]::new('--nerd-fonts', '--nerd-fonts', [CompletionResultType]::ParameterName, 'Use Nerd Font icons')
            [CompletionResult]::new('-l', '-l', [CompletionResultType]::ParameterName, 'Prints out supported languages')
            [CompletionResult]::new('--languages', '--languages', [CompletionResultType]::ParameterName, 'Prints out supported languages')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'Prints out supported package managers')
            [CompletionResult]::new('--package-managers', '--package-managers', [CompletionResultType]::ParameterName, 'Prints out supported package managers')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help (see more with ''--help'')')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help (see more with ''--help'')')
            [CompletionResult]::new('-V', '-V ', [CompletionResultType]::ParameterName, 'Print version')
            [CompletionResult]::new('--version', '--version', [CompletionResultType]::ParameterName, 'Print version')
            break
        }
    })

    $completions.Where{ $_.CompletionText -like "$wordToComplete*" } |
        Sort-Object -Property ListItemText
}
