# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_ncspot_global_optspecs
	string join \n d/debug= b/basepath= c/config= h/help V/version
end

function __fish_ncspot_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_ncspot_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_ncspot_using_subcommand
	set -l cmd (__fish_ncspot_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c ncspot -n "__fish_ncspot_needs_command" -s d -l debug -d 'Enable debug logging to the specified file' -r -F
complete -c ncspot -n "__fish_ncspot_needs_command" -s b -l basepath -d 'custom basepath to config/cache files' -r -F
complete -c ncspot -n "__fish_ncspot_needs_command" -s c -l config -d 'Filename of config file in basepath' -r
complete -c ncspot -n "__fish_ncspot_needs_command" -s h -l help -d 'Print help'
complete -c ncspot -n "__fish_ncspot_needs_command" -s V -l version -d 'Print version'
complete -c ncspot -n "__fish_ncspot_needs_command" -f -a "info" -d 'Print platform information like paths'
complete -c ncspot -n "__fish_ncspot_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ncspot -n "__fish_ncspot_using_subcommand info" -s h -l help -d 'Print help'
complete -c ncspot -n "__fish_ncspot_using_subcommand help; and not __fish_seen_subcommand_from info help" -f -a "info" -d 'Print platform information like paths'
complete -c ncspot -n "__fish_ncspot_using_subcommand help; and not __fish_seen_subcommand_from info help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
