/*  XFC: Xfce Foundation Classes (User Interface Library)
 *  Copyright (C) 2004-2005 The XFC Development Team.
 *
 *  spinbuttonsignals.cc - Gtk::SpinButton virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "spinbutton.hh"
#include "spinbuttonsignals.hh"
#include "private/spinbuttonclass.hh"

using namespace Xfc;

/*  Gtk::SpinButtonSignals
 */

Gtk::SpinButtonSignals::SpinButtonSignals(SpinButton *spin_button)
: EntrySignals(spin_button)
{
}

Gtk::SpinButtonSignals::~SpinButtonSignals()
{
}

int
Gtk::SpinButtonSignals::on_input(double *new_value)
{
	GtkSpinButtonClass *g_class = SpinButtonClass::get_parent_class(instance_);
	gint result = 0;
	if (g_class && g_class->input)
		result = g_class->input((GtkSpinButton*)instance_, new_value);
	return result;
}

int
Gtk::SpinButtonSignals::on_output()
{
	GtkSpinButtonClass *g_class = SpinButtonClass::get_parent_class(instance_);
	gint result = 0;
	if (g_class && g_class->output)
		result = g_class->output((GtkSpinButton*)instance_);
	return result;
}

void
Gtk::SpinButtonSignals::on_value_changed()
{
	GtkSpinButtonClass *g_class = SpinButtonClass::get_parent_class(instance_);
	if (g_class && g_class->value_changed)
		g_class->value_changed((GtkSpinButton*)instance_);
}

