#!/bin/sh
# Copyright (c), 2024, Huawei Technologies Co, Ltd.
# Author: Zhihao Cheng <chengzhihao1@huawei.com>
#
# Test Description:
# Refuse checking authenticated UBIFS image
# Running time: 10s

TESTBINDIR=/usr/libexec/mtd-utils
source $TESTBINDIR/common.sh

ID="0xec,0xa1,0x00,0x15" # 128M 128KB 2KB 512-sub-page

function run_test()
{
	echo "Do authentication_refused test"

	modprobe nandsim id_bytes=$ID
	mtdnum="$(find_mtd_device "$nandsim_patt")"
	flash_eraseall /dev/mtd$mtdnum

	modprobe ubi mtd="$mtdnum,2048" || fatal "modprobe ubi fail"
	ubimkvol -N vol_test -m -n 0 /dev/ubi$UBI_NUM || fatal "mkvol fail"
	modprobe ubifs || fatal "modprobe ubifs fail"

	mount_ubifs $DEV $MNT "authentication" || fatal "mount ubifs failed"
	fsstress -d $MNT/fsstress -l0 -p4 -n10000 &
	sleep $((RANDOM % 5))

	ps -e | grep -w fsstress > /dev/null 2>&1
	while [ $? -eq 0 ]
	do
		killall -9 fsstress > /dev/null 2>&1
		sleep 1
		ps -e | grep -w fsstress > /dev/null 2>&1
	done

	while true
	do
		res=`mount | grep "$MNT"`
		if [[ "$res" == "" ]]
		then
			break;
		fi
		umount $MNT
		sleep 0.1
	done

	fsck.ubifs -a $DEV # 'fsck.ubifs $DEV' is fine too.
	res=$?
	if [[ $res == $FSCK_OK ]]
	then
		fatal "fsck should not be success!"
	fi

	modprobe -r ubifs
	modprobe -r ubi
	modprobe -r nandsim
}

start_t=$(date +%s)
run_test
end_t=$(date +%s)
time_cost=$(( end_t - start_t ))
echo "Success, cost $time_cost seconds"
exit 0
