/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSOverflowEvent.h"

#include "OverflowEvent.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSOverflowEvent);

/* Hash table */

static const HashTableValue JSOverflowEventTableValues[5] =
{
    { "orient", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventOrient), (intptr_t)0 },
    { "horizontalOverflow", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventHorizontalOverflow), (intptr_t)0 },
    { "verticalOverflow", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventVerticalOverflow), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSOverflowEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSOverflowEventTableValues, 0 };
#else
    { 9, 7, JSOverflowEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSOverflowEventConstructorTableValues[4] =
{
    { "HORIZONTAL", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventHORIZONTAL), (intptr_t)0 },
    { "VERTICAL", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventVERTICAL), (intptr_t)0 },
    { "BOTH", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventBOTH), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSOverflowEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSOverflowEventConstructorTableValues, 0 };
#else
    { 9, 7, JSOverflowEventConstructorTableValues, 0 };
#endif

class JSOverflowEventConstructor : public DOMConstructorObject {
public:
    JSOverflowEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSOverflowEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSOverflowEventPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSOverflowEventConstructor::s_info = { "OverflowEventConstructor", 0, &JSOverflowEventConstructorTable, 0 };

bool JSOverflowEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSOverflowEventConstructor, DOMObject>(exec, &JSOverflowEventConstructorTable, this, propertyName, slot);
}

bool JSOverflowEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSOverflowEventConstructor, DOMObject>(exec, &JSOverflowEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSOverflowEventPrototypeTableValues[5] =
{
    { "HORIZONTAL", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventHORIZONTAL), (intptr_t)0 },
    { "VERTICAL", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventVERTICAL), (intptr_t)0 },
    { "BOTH", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventBOTH), (intptr_t)0 },
    { "initOverflowEvent", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsOverflowEventPrototypeFunctionInitOverflowEvent), (intptr_t)3 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSOverflowEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSOverflowEventPrototypeTableValues, 0 };
#else
    { 9, 7, JSOverflowEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSOverflowEventPrototype::s_info = { "OverflowEventPrototype", 0, &JSOverflowEventPrototypeTable, 0 };

JSObject* JSOverflowEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSOverflowEvent>(exec, globalObject);
}

bool JSOverflowEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSOverflowEventPrototype, JSObject>(exec, &JSOverflowEventPrototypeTable, this, propertyName, slot);
}

bool JSOverflowEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSOverflowEventPrototype, JSObject>(exec, &JSOverflowEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSOverflowEvent::s_info = { "OverflowEvent", &JSEvent::s_info, &JSOverflowEventTable, 0 };

JSOverflowEvent::JSOverflowEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<OverflowEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

JSObject* JSOverflowEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSOverflowEventPrototype(JSOverflowEventPrototype::createStructure(JSEventPrototype::self(exec, globalObject)));
}

bool JSOverflowEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSOverflowEvent, Base>(exec, &JSOverflowEventTable, this, propertyName, slot);
}

bool JSOverflowEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSOverflowEvent, Base>(exec, &JSOverflowEventTable, this, propertyName, descriptor);
}

JSValue jsOverflowEventOrient(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSOverflowEvent* castedThis = static_cast<JSOverflowEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OverflowEvent* imp = static_cast<OverflowEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->orient());
    return result;
}

JSValue jsOverflowEventHorizontalOverflow(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSOverflowEvent* castedThis = static_cast<JSOverflowEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OverflowEvent* imp = static_cast<OverflowEvent*>(castedThis->impl());
    JSValue result = jsBoolean(imp->horizontalOverflow());
    return result;
}

JSValue jsOverflowEventVerticalOverflow(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSOverflowEvent* castedThis = static_cast<JSOverflowEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OverflowEvent* imp = static_cast<OverflowEvent*>(castedThis->impl());
    JSValue result = jsBoolean(imp->verticalOverflow());
    return result;
}

JSValue jsOverflowEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSOverflowEvent* domObject = static_cast<JSOverflowEvent*>(asObject(slotBase));
    return JSOverflowEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSOverflowEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOverflowEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsOverflowEventPrototypeFunctionInitOverflowEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSOverflowEvent::s_info))
        return throwError(exec, TypeError);
    JSOverflowEvent* castedThisObj = static_cast<JSOverflowEvent*>(asObject(thisValue));
    OverflowEvent* imp = static_cast<OverflowEvent*>(castedThisObj->impl());
    unsigned short orient = args.at(0).toInt32(exec);
    bool horizontalOverflow = args.at(1).toBoolean(exec);
    bool verticalOverflow = args.at(2).toBoolean(exec);

    imp->initOverflowEvent(orient, horizontalOverflow, verticalOverflow);
    return jsUndefined();
}

// Constant getters

JSValue jsOverflowEventHORIZONTAL(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsOverflowEventVERTICAL(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsOverflowEventBOTH(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}


}
