/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDocument.h"

#include "Attr.h"
#include "CDATASection.h"
#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "Comment.h"
#include "DOMImplementation.h"
#include "DOMSelection.h"
#include "DOMWindow.h"
#include "Document.h"
#include "DocumentFragment.h"
#include "DocumentType.h"
#include "Element.h"
#include "EntityReference.h"
#include "Event.h"
#include "EventListener.h"
#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "HTMLHeadElement.h"
#include "JSAttr.h"
#include "JSCDATASection.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCanvasRenderingContext2D.h"
#include "JSComment.h"
#include "JSCustomXPathNSResolver.h"
#include "JSDOMImplementation.h"
#include "JSDOMSelection.h"
#include "JSDOMWindow.h"
#include "JSDocumentFragment.h"
#include "JSDocumentType.h"
#include "JSElement.h"
#include "JSEntityReference.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "JSHTMLHeadElement.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "JSNodeIterator.h"
#include "JSNodeList.h"
#include "JSProcessingInstruction.h"
#include "JSRange.h"
#include "JSStyleSheetList.h"
#include "JSText.h"
#include "JSTreeWalker.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeFilter.h"
#include "NodeIterator.h"
#include "NodeList.h"
#include "PlatformString.h"
#include "ProcessingInstruction.h"
#include "Range.h"
#include "StyleSheetList.h"
#include "Text.h"
#include "TreeWalker.h"
#include "XPathExpression.h"
#include "XPathNSResolver.h"
#include "XPathResult.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDocument);

/* Hash table */

static const HashTableValue JSDocumentTableValues[75] =
{
    { "doctype", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDoctype), (intptr_t)0 },
    { "implementation", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentImplementation), (intptr_t)0 },
    { "documentElement", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDocumentElement), (intptr_t)0 },
    { "inputEncoding", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentInputEncoding), (intptr_t)0 },
    { "xmlEncoding", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLEncoding), (intptr_t)0 },
    { "xmlVersion", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLVersion), (intptr_t)setJSDocumentXMLVersion },
    { "xmlStandalone", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLStandalone), (intptr_t)setJSDocumentXMLStandalone },
    { "documentURI", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDocumentURI), (intptr_t)setJSDocumentDocumentURI },
    { "defaultView", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDefaultView), (intptr_t)0 },
    { "styleSheets", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentStyleSheets), (intptr_t)0 },
    { "title", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTitle), (intptr_t)setJSDocumentTitle },
    { "referrer", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentReferrer), (intptr_t)0 },
    { "domain", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDomain), (intptr_t)setJSDocumentDomain },
    { "URL", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentURL), (intptr_t)0 },
    { "cookie", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCookie), (intptr_t)setJSDocumentCookie },
    { "body", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentBody), (intptr_t)setJSDocumentBody },
    { "head", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentHead), (intptr_t)0 },
    { "images", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentImages), (intptr_t)0 },
    { "applets", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentApplets), (intptr_t)0 },
    { "links", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLinks), (intptr_t)0 },
    { "forms", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentForms), (intptr_t)0 },
    { "anchors", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentAnchors), (intptr_t)0 },
    { "lastModified", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLastModified), (intptr_t)0 },
    { "location", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLocation), (intptr_t)setJSDocumentLocation },
    { "charset", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCharset), (intptr_t)setJSDocumentCharset },
    { "defaultCharset", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDefaultCharset), (intptr_t)0 },
    { "readyState", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentReadyState), (intptr_t)0 },
    { "characterSet", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCharacterSet), (intptr_t)0 },
    { "preferredStylesheetSet", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentPreferredStylesheetSet), (intptr_t)0 },
    { "selectedStylesheetSet", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentSelectedStylesheetSet), (intptr_t)setJSDocumentSelectedStylesheetSet },
    { "onabort", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnabort), (intptr_t)setJSDocumentOnabort },
    { "onblur", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnblur), (intptr_t)setJSDocumentOnblur },
    { "onchange", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnchange), (intptr_t)setJSDocumentOnchange },
    { "onclick", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnclick), (intptr_t)setJSDocumentOnclick },
    { "oncontextmenu", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncontextmenu), (intptr_t)setJSDocumentOncontextmenu },
    { "ondblclick", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndblclick), (intptr_t)setJSDocumentOndblclick },
    { "ondrag", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndrag), (intptr_t)setJSDocumentOndrag },
    { "ondragend", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragend), (intptr_t)setJSDocumentOndragend },
    { "ondragenter", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragenter), (intptr_t)setJSDocumentOndragenter },
    { "ondragleave", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragleave), (intptr_t)setJSDocumentOndragleave },
    { "ondragover", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragover), (intptr_t)setJSDocumentOndragover },
    { "ondragstart", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragstart), (intptr_t)setJSDocumentOndragstart },
    { "ondrop", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndrop), (intptr_t)setJSDocumentOndrop },
    { "onerror", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnerror), (intptr_t)setJSDocumentOnerror },
    { "onfocus", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnfocus), (intptr_t)setJSDocumentOnfocus },
    { "oninput", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOninput), (intptr_t)setJSDocumentOninput },
    { "oninvalid", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOninvalid), (intptr_t)setJSDocumentOninvalid },
    { "onkeydown", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeydown), (intptr_t)setJSDocumentOnkeydown },
    { "onkeypress", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeypress), (intptr_t)setJSDocumentOnkeypress },
    { "onkeyup", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeyup), (intptr_t)setJSDocumentOnkeyup },
    { "onload", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnload), (intptr_t)setJSDocumentOnload },
    { "onmousedown", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousedown), (intptr_t)setJSDocumentOnmousedown },
    { "onmousemove", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousemove), (intptr_t)setJSDocumentOnmousemove },
    { "onmouseout", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseout), (intptr_t)setJSDocumentOnmouseout },
    { "onmouseover", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseover), (intptr_t)setJSDocumentOnmouseover },
    { "onmouseup", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseup), (intptr_t)setJSDocumentOnmouseup },
    { "onmousewheel", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousewheel), (intptr_t)setJSDocumentOnmousewheel },
    { "onscroll", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnscroll), (intptr_t)setJSDocumentOnscroll },
    { "onselect", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnselect), (intptr_t)setJSDocumentOnselect },
    { "onsubmit", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnsubmit), (intptr_t)setJSDocumentOnsubmit },
    { "onbeforecut", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforecut), (intptr_t)setJSDocumentOnbeforecut },
    { "oncut", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncut), (intptr_t)setJSDocumentOncut },
    { "onbeforecopy", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforecopy), (intptr_t)setJSDocumentOnbeforecopy },
    { "oncopy", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncopy), (intptr_t)setJSDocumentOncopy },
    { "onbeforepaste", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforepaste), (intptr_t)setJSDocumentOnbeforepaste },
    { "onpaste", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpaste), (intptr_t)setJSDocumentOnpaste },
    { "onreset", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnreset), (intptr_t)setJSDocumentOnreset },
    { "onsearch", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnsearch), (intptr_t)setJSDocumentOnsearch },
    { "onselectstart", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnselectstart), (intptr_t)setJSDocumentOnselectstart },
#if ENABLE(TOUCH_EVENTS)
    { "ontouchstart", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchstart), (intptr_t)setJSDocumentOntouchstart },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchmove", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchmove), (intptr_t)setJSDocumentOntouchmove },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchend", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchend), (intptr_t)setJSDocumentOntouchend },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchcancel", DontDelete|DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchcancel), (intptr_t)setJSDocumentOntouchcancel },
#endif
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDocumentTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 8191, JSDocumentTableValues, 0 };
#else
    { 262, 255, JSDocumentTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSDocumentConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDocumentConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSDocumentConstructorTableValues, 0 };
#else
    { 1, 0, JSDocumentConstructorTableValues, 0 };
#endif

class JSDocumentConstructor : public DOMConstructorObject {
public:
    JSDocumentConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSDocumentConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSDocumentPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDocumentConstructor::s_info = { "DocumentConstructor", 0, &JSDocumentConstructorTable, 0 };

bool JSDocumentConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentConstructor, DOMObject>(exec, &JSDocumentConstructorTable, this, propertyName, slot);
}

bool JSDocumentConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDocumentConstructor, DOMObject>(exec, &JSDocumentConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDocumentPrototypeTableValues[38] =
{
    { "createElement", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateElement), (intptr_t)1 },
    { "createDocumentFragment", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateDocumentFragment), (intptr_t)0 },
    { "createTextNode", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateTextNode), (intptr_t)1 },
    { "createComment", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateComment), (intptr_t)1 },
    { "createCDATASection", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateCDATASection), (intptr_t)1 },
    { "createProcessingInstruction", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateProcessingInstruction), (intptr_t)2 },
    { "createAttribute", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateAttribute), (intptr_t)1 },
    { "createEntityReference", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateEntityReference), (intptr_t)1 },
    { "getElementsByTagName", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByTagName), (intptr_t)1 },
    { "importNode", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionImportNode), (intptr_t)2 },
    { "createElementNS", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateElementNS), (intptr_t)2 },
    { "createAttributeNS", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateAttributeNS), (intptr_t)2 },
    { "getElementsByTagNameNS", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByTagNameNS), (intptr_t)2 },
    { "getElementById", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementById), (intptr_t)1 },
    { "adoptNode", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionAdoptNode), (intptr_t)1 },
    { "createEvent", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateEvent), (intptr_t)1 },
    { "createRange", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateRange), (intptr_t)0 },
    { "createNodeIterator", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateNodeIterator), (intptr_t)4 },
    { "createTreeWalker", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateTreeWalker), (intptr_t)4 },
    { "getOverrideStyle", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetOverrideStyle), (intptr_t)2 },
    { "createExpression", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateExpression), (intptr_t)2 },
    { "createNSResolver", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateNSResolver), (intptr_t)1 },
    { "evaluate", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionEvaluate), (intptr_t)5 },
    { "execCommand", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionExecCommand), (intptr_t)3 },
    { "queryCommandEnabled", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandEnabled), (intptr_t)1 },
    { "queryCommandIndeterm", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandIndeterm), (intptr_t)1 },
    { "queryCommandState", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandState), (intptr_t)1 },
    { "queryCommandSupported", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandSupported), (intptr_t)1 },
    { "queryCommandValue", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandValue), (intptr_t)1 },
    { "getElementsByName", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByName), (intptr_t)1 },
    { "elementFromPoint", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionElementFromPoint), (intptr_t)2 },
    { "caretRangeFromPoint", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCaretRangeFromPoint), (intptr_t)2 },
    { "getSelection", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetSelection), (intptr_t)0 },
    { "getCSSCanvasContext", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetCSSCanvasContext), (intptr_t)4 },
    { "getElementsByClassName", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByClassName), (intptr_t)1 },
    { "querySelector", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQuerySelector), (intptr_t)1 },
    { "querySelectorAll", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQuerySelectorAll), (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDocumentPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 511, JSDocumentPrototypeTableValues, 0 };
#else
    { 135, 127, JSDocumentPrototypeTableValues, 0 };
#endif

const ClassInfo JSDocumentPrototype::s_info = { "DocumentPrototype", 0, &JSDocumentPrototypeTable, 0 };

JSObject* JSDocumentPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDocument>(exec, globalObject);
}

bool JSDocumentPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDocumentPrototypeTable, this, propertyName, slot);
}

bool JSDocumentPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDocumentPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSDocument::s_info = { "Document", &JSNode::s_info, &JSDocumentTable, 0 };

JSDocument::JSDocument(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Document> impl)
    : JSNode(structure, globalObject, impl)
{
}

JSObject* JSDocument::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDocumentPrototype(JSDocumentPrototype::createStructure(JSNodePrototype::self(exec, globalObject)));
}

JSValue jsDocumentDoctype(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->doctype()));
    return result;
}

JSValue jsDocumentImplementation(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->implementation()));
    return result;
}

JSValue jsDocumentDocumentElement(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->documentElement()));
    return result;
}

JSValue jsDocumentInputEncoding(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->inputEncoding());
    return result;
}

JSValue jsDocumentXMLEncoding(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->xmlEncoding());
    return result;
}

JSValue jsDocumentXMLVersion(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->xmlVersion());
    return result;
}

JSValue jsDocumentXMLStandalone(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsBoolean(imp->xmlStandalone());
    return result;
}

JSValue jsDocumentDocumentURI(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->documentURI());
    return result;
}

JSValue jsDocumentDefaultView(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->defaultView()));
    return result;
}

JSValue jsDocumentStyleSheets(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->styleSheets()));
    return result;
}

JSValue jsDocumentTitle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsString(exec, imp->title());
    return result;
}

JSValue jsDocumentReferrer(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsString(exec, imp->referrer());
    return result;
}

JSValue jsDocumentDomain(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsString(exec, imp->domain());
    return result;
}

JSValue jsDocumentURL(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsString(exec, imp->url());
    return result;
}

JSValue jsDocumentCookie(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSC::JSValue result = jsString(exec, imp->cookie(ec));
    setDOMException(exec, ec);
    return result;
}

JSValue jsDocumentBody(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->body()));
    return result;
}

JSValue jsDocumentHead(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->head()));
    return result;
}

JSValue jsDocumentImages(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->images()));
    return result;
}

JSValue jsDocumentApplets(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->applets()));
    return result;
}

JSValue jsDocumentLinks(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->links()));
    return result;
}

JSValue jsDocumentForms(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->forms()));
    return result;
}

JSValue jsDocumentAnchors(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->anchors()));
    return result;
}

JSValue jsDocumentLastModified(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsString(exec, imp->lastModified());
    return result;
}

JSValue jsDocumentLocation(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    return castedThis->location(exec);
}

JSValue jsDocumentCharset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrUndefined(exec, imp->charset());
    return result;
}

JSValue jsDocumentDefaultCharset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrUndefined(exec, imp->defaultCharset());
    return result;
}

JSValue jsDocumentReadyState(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrUndefined(exec, imp->readyState());
    return result;
}

JSValue jsDocumentCharacterSet(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->characterSet());
    return result;
}

JSValue jsDocumentPreferredStylesheetSet(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->preferredStylesheetSet());
    return result;
}

JSValue jsDocumentSelectedStylesheetSet(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->selectedStylesheetSet());
    return result;
}

JSValue jsDocumentOnabort(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnblur(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onblur()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnchange(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnclick(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOncontextmenu(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->oncontextmenu()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndblclick(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondblclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndrag(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondrag()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndragend(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondragend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndragenter(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondragenter()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndragleave(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondragleave()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndragover(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondragover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndragstart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondragstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndrop(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondrop()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnerror(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnfocus(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onfocus()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOninput(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->oninput()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOninvalid(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->oninvalid()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnkeydown(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onkeydown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnkeypress(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onkeypress()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnkeyup(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onkeyup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnload(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnmousedown(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onmousedown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnmousemove(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onmousemove()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnmouseout(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseout()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnmouseover(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnmouseup(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnmousewheel(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onmousewheel()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnscroll(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onscroll()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnselect(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onselect()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnsubmit(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onsubmit()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnbeforecut(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforecut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOncut(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->oncut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnbeforecopy(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforecopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOncopy(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->oncopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnbeforepaste(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforepaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnpaste(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onpaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnreset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onreset()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnsearch(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onsearch()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnselectstart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onselectstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

#if ENABLE(TOUCH_EVENTS)
JSValue jsDocumentOntouchstart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ontouchstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}
#endif

#if ENABLE(TOUCH_EVENTS)
JSValue jsDocumentOntouchmove(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ontouchmove()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}
#endif

#if ENABLE(TOUCH_EVENTS)
JSValue jsDocumentOntouchend(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ontouchend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}
#endif

#if ENABLE(TOUCH_EVENTS)
JSValue jsDocumentOntouchcancel(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ontouchcancel()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}
#endif

JSValue jsDocumentConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* domObject = static_cast<JSDocument*>(asObject(slotBase));
    return JSDocument::getConstructor(exec, domObject->globalObject());
}
void JSDocument::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSDocument, Base>(exec, propertyName, value, &JSDocumentTable, this, slot);
}

void setJSDocumentXMLVersion(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    imp->setXMLVersion(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSDocumentXMLStandalone(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    imp->setXMLStandalone(value.toBoolean(exec), ec);
    setDOMException(exec, ec);
}

void setJSDocumentDocumentURI(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    imp->setDocumentURI(valueToStringWithNullCheck(exec, value));
}

void setJSDocumentTitle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    imp->setTitle(valueToStringWithNullCheck(exec, value));
}

void setJSDocumentDomain(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    imp->setDomain(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSDocumentCookie(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    imp->setCookie(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSDocumentBody(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    imp->setBody(toHTMLElement(value), ec);
    setDOMException(exec, ec);
}

void setJSDocumentLocation(ExecState* exec, JSObject* thisObject, JSValue value)
{
    static_cast<JSDocument*>(thisObject)->setLocation(exec, value);
}

void setJSDocumentCharset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    imp->setCharset(valueToStringWithNullCheck(exec, value));
}

void setJSDocumentSelectedStylesheetSet(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThisObj = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    imp->setSelectedStylesheetSet(valueToStringWithNullCheck(exec, value));
}

void setJSDocumentOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnabort(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnblur(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnblur(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnchange(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnclick(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOncontextmenu(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOncontextmenu(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndblclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndblclick(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndrag(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndrag(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndragend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndragend(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndragenter(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndragenter(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndragleave(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndragleave(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndragover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndragover(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndragstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndragstart(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndrop(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndrop(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnfocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnfocus(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOninput(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOninput(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOninvalid(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOninvalid(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnkeydown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnkeydown(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnkeypress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnkeypress(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnkeyup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnkeyup(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnload(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnmousedown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnmousedown(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnmousemove(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnmousemove(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnmouseout(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnmouseout(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnmouseover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnmouseover(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnmouseup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnmouseup(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnmousewheel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnmousewheel(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnscroll(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnscroll(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnselect(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnselect(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnsubmit(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnsubmit(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnbeforecut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnbeforecut(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOncut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOncut(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnbeforecopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnbeforecopy(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOncopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOncopy(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnbeforepaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnbeforepaste(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnpaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnpaste(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnreset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnreset(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnsearch(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnsearch(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnselectstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnselectstart(createJSAttributeEventListener(exec, value, thisObject));
}

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOntouchstart(createJSAttributeEventListener(exec, value, thisObject));
}
#endif

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchmove(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOntouchmove(createJSAttributeEventListener(exec, value, thisObject));
}
#endif

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOntouchend(createJSAttributeEventListener(exec, value, thisObject));
}
#endif

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchcancel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOntouchcancel(createJSAttributeEventListener(exec, value, thisObject));
}
#endif

JSValue JSDocument::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDocumentConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElement(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& tagName = valueToStringWithNullCheck(exec, args.at(0));


    JSC::JSValue result = toJSNewlyCreated(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createElement(tagName, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateDocumentFragment(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createDocumentFragment()));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTextNode(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& data = args.at(0).toString(exec);


    JSC::JSValue result = toJSNewlyCreated(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createTextNode(data)));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateComment(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& data = args.at(0).toString(exec);


    JSC::JSValue result = toJSNewlyCreated(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createComment(data)));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateCDATASection(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& data = args.at(0).toString(exec);


    JSC::JSValue result = toJSNewlyCreated(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createCDATASection(data, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateProcessingInstruction(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& target = args.at(0).toString(exec);
    const UString& data = args.at(1).toString(exec);


    JSC::JSValue result = toJSNewlyCreated(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createProcessingInstruction(target, data, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJSNewlyCreated(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createAttribute(name, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateEntityReference(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJSNewlyCreated(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createEntityReference(name, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagName(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& tagname = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getElementsByTagName(tagname)));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionImportNode(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* importedNode = toNode(args.at(0));
    bool deep = args.at(1).toBoolean(exec);


    JSC::JSValue result = toJSNewlyCreated(exec, castedThisObj->globalObject(), WTF::getPtr(imp->importNode(importedNode, deep, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElementNS(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& namespaceURI = valueToStringWithNullCheck(exec, args.at(0));
    const UString& qualifiedName = valueToStringWithNullCheck(exec, args.at(1));


    JSC::JSValue result = toJSNewlyCreated(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createElementNS(namespaceURI, qualifiedName, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttributeNS(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& namespaceURI = valueToStringWithNullCheck(exec, args.at(0));
    const UString& qualifiedName = valueToStringWithNullCheck(exec, args.at(1));


    JSC::JSValue result = toJSNewlyCreated(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createAttributeNS(namespaceURI, qualifiedName, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagNameNS(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& namespaceURI = valueToStringWithNullCheck(exec, args.at(0));
    const UString& localName = args.at(1).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getElementsByTagNameNS(namespaceURI, localName)));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementById(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& elementId = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getElementById(elementId)));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionAdoptNode(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* source = toNode(args.at(0));


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->adoptNode(source, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& eventType = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createEvent(eventType, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateRange(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createRange()));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNodeIterator(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* root = toNode(args.at(0));
    unsigned whatToShow = args.at(1).toInt32(exec);
    RefPtr<NodeFilter> filter = toNodeFilter(args.at(2));
    bool expandEntityReferences = args.at(3).toBoolean(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createNodeIterator(root, whatToShow, filter.get(), expandEntityReferences, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTreeWalker(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* root = toNode(args.at(0));
    unsigned whatToShow = args.at(1).toInt32(exec);
    RefPtr<NodeFilter> filter = toNodeFilter(args.at(2));
    bool expandEntityReferences = args.at(3).toBoolean(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createTreeWalker(root, whatToShow, filter.get(), expandEntityReferences, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetOverrideStyle(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    Element* element = toElement(args.at(0));
    const UString& pseudoElement = args.at(1).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getOverrideStyle(element, pseudoElement)));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateExpression(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& expression = args.at(0).toString(exec);
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(args.at(1));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, args.at(1));
        if (exec->hadException())
            return jsUndefined();
        resolver = customResolver.get();
    }


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createExpression(expression, resolver, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNSResolver(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    Node* nodeResolver = toNode(args.at(0));


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createNSResolver(nodeResolver)));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionEvaluate(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& expression = args.at(0).toString(exec);
    Node* contextNode = toNode(args.at(1));
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(args.at(2));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, args.at(2));
        if (exec->hadException())
            return jsUndefined();
        resolver = customResolver.get();
    }
    unsigned short type = args.at(3).toInt32(exec);
    XPathResult* inResult = toXPathResult(args.at(4));


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->evaluate(expression, contextNode, resolver, type, inResult, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionExecCommand(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& command = args.at(0).toString(exec);
    bool userInterface = args.at(1).toBoolean(exec);
    const UString& value = valueToStringWithUndefinedOrNullCheck(exec, args.at(2));


    JSC::JSValue result = jsBoolean(imp->execCommand(command, userInterface, value));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandEnabled(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& command = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->queryCommandEnabled(command));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandIndeterm(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& command = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->queryCommandIndeterm(command));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandState(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& command = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->queryCommandState(command));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandSupported(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& command = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->queryCommandSupported(command));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandValue(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& command = args.at(0).toString(exec);


    JSC::JSValue result = jsStringOrFalse(exec, imp->queryCommandValue(command));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByName(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& elementName = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getElementsByName(elementName)));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionElementFromPoint(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    int x = args.at(0).toInt32(exec);
    int y = args.at(1).toInt32(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->elementFromPoint(x, y)));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCaretRangeFromPoint(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    int x = args.at(0).toInt32(exec);
    int y = args.at(1).toInt32(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->caretRangeFromPoint(x, y)));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetSelection(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getSelection()));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetCSSCanvasContext(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& contextId = args.at(0).toString(exec);
    const UString& name = args.at(1).toString(exec);
    int width = args.at(2).toInt32(exec);
    int height = args.at(3).toInt32(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getCSSCanvasContext(contextId, name, width, height)));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByClassName(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& tagname = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getElementsByClassName(tagname)));
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelector(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& selectors = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->querySelector(selectors, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelectorAll(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& selectors = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->querySelectorAll(selectors, ec)));
    setDOMException(exec, ec);
    return result;
}

Document* toDocument(JSC::JSValue value)
{
    return value.inherits(&JSDocument::s_info) ? static_cast<JSDocument*>(asObject(value))->impl() : 0;
}

}
