/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSVariablesRule.h"

#include "CSSVariablesDeclaration.h"
#include "CSSVariablesRule.h"
#include "JSCSSVariablesDeclaration.h"
#include "JSMediaList.h"
#include "MediaList.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSVariablesRule);

/* Hash table */

static const HashTableValue JSCSSVariablesRuleTableValues[4] =
{
    { "media", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSVariablesRuleMedia), (intptr_t)0 },
    { "variables", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSVariablesRuleVariables), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSVariablesRuleConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCSSVariablesRuleTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSCSSVariablesRuleTableValues, 0 };
#else
    { 9, 7, JSCSSVariablesRuleTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSCSSVariablesRuleConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCSSVariablesRuleConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCSSVariablesRuleConstructorTableValues, 0 };
#else
    { 1, 0, JSCSSVariablesRuleConstructorTableValues, 0 };
#endif

class JSCSSVariablesRuleConstructor : public DOMConstructorObject {
public:
    JSCSSVariablesRuleConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSCSSVariablesRuleConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSCSSVariablesRulePrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSCSSVariablesRuleConstructor::s_info = { "CSSVariablesRuleConstructor", 0, &JSCSSVariablesRuleConstructorTable, 0 };

bool JSCSSVariablesRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSVariablesRuleConstructor, DOMObject>(exec, &JSCSSVariablesRuleConstructorTable, this, propertyName, slot);
}

bool JSCSSVariablesRuleConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSVariablesRuleConstructor, DOMObject>(exec, &JSCSSVariablesRuleConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCSSVariablesRulePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCSSVariablesRulePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCSSVariablesRulePrototypeTableValues, 0 };
#else
    { 1, 0, JSCSSVariablesRulePrototypeTableValues, 0 };
#endif

const ClassInfo JSCSSVariablesRulePrototype::s_info = { "CSSVariablesRulePrototype", 0, &JSCSSVariablesRulePrototypeTable, 0 };

JSObject* JSCSSVariablesRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSVariablesRule>(exec, globalObject);
}

const ClassInfo JSCSSVariablesRule::s_info = { "CSSVariablesRule", &JSCSSRule::s_info, &JSCSSVariablesRuleTable, 0 };

JSCSSVariablesRule::JSCSSVariablesRule(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSVariablesRule> impl)
    : JSCSSRule(structure, globalObject, impl)
{
}

JSObject* JSCSSVariablesRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCSSVariablesRulePrototype(JSCSSVariablesRulePrototype::createStructure(JSCSSRulePrototype::self(exec, globalObject)));
}

bool JSCSSVariablesRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSVariablesRule, Base>(exec, &JSCSSVariablesRuleTable, this, propertyName, slot);
}

bool JSCSSVariablesRule::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSVariablesRule, Base>(exec, &JSCSSVariablesRuleTable, this, propertyName, descriptor);
}

JSValue jsCSSVariablesRuleMedia(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSVariablesRule* castedThis = static_cast<JSCSSVariablesRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSVariablesRule* imp = static_cast<CSSVariablesRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->media()));
    return result;
}

JSValue jsCSSVariablesRuleVariables(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSVariablesRule* castedThis = static_cast<JSCSSVariablesRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSVariablesRule* imp = static_cast<CSSVariablesRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->variables()));
    return result;
}

JSValue jsCSSVariablesRuleConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSVariablesRule* domObject = static_cast<JSCSSVariablesRule*>(asObject(slotBase));
    return JSCSSVariablesRule::getConstructor(exec, domObject->globalObject());
}
JSValue JSCSSVariablesRule::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSVariablesRuleConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
