/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server;

import info.aduna.webapp.views.SimpleResponseView;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.server.ClientHTTPException;
import org.openrdf.http.server.HTTPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class ProtocolExceptionResolver
implements HandlerExceptionResolver {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        this.logger.debug("ProtocolExceptionResolver.resolveException() called");
        int statusCode = 500;
        String errMsg = exception.getMessage();
        if (exception instanceof HTTPException) {
            HTTPException httpExc = (HTTPException)exception;
            statusCode = httpExc.getStatusCode();
            if (exception instanceof ClientHTTPException) {
                this.logger.info("Client sent bad request ({}): {}", (Object)statusCode, (Object)errMsg);
            } else {
                this.logger.error("Error while handling request ({}): {}", (Object)statusCode, (Object)errMsg);
            }
        } else {
            this.logger.error("Error while handling request", (Throwable)exception);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("sc", statusCode);
        model.put("content", errMsg);
        return new ModelAndView((View)SimpleResponseView.getInstance(), model);
    }
}

