/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.ValueExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCall
extends QueryModelNodeBase
implements ValueExpr {
    protected String uri;
    protected List<ValueExpr> args = new ArrayList<ValueExpr>();

    public FunctionCall() {
    }

    public FunctionCall(String uri, ValueExpr ... args) {
        this.setURI(uri);
        this.addArgs(args);
    }

    public FunctionCall(String uri, Iterable<ValueExpr> args) {
        this.setURI(uri);
        this.addArgs(args);
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public List<ValueExpr> getArgs() {
        return this.args;
    }

    public void setArgs(Iterable<ValueExpr> args) {
        this.args.clear();
        this.addArgs(args);
    }

    public void addArgs(ValueExpr ... args) {
        for (ValueExpr arg : args) {
            this.addArg(arg);
        }
    }

    public void addArgs(Iterable<ValueExpr> args) {
        for (ValueExpr arg : args) {
            this.addArg(arg);
        }
    }

    public void addArg(ValueExpr arg) {
        assert (arg != null) : "arg must not be null";
        this.args.add(arg);
        arg.setParentNode(this);
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (ValueExpr arg : this.args) {
            arg.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        int index = this.args.indexOf(current);
        if (index >= 0) {
            this.args.set(index, (ValueExpr)replacement);
            replacement.setParentNode(this);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public FunctionCall clone() {
        FunctionCall clone = (FunctionCall)super.clone();
        clone.args = new ArrayList<ValueExpr>(this.getArgs().size());
        for (ValueExpr arg : this.getArgs()) {
            clone.addArg(arg.clone());
        }
        return clone;
    }
}

