/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLBlockquoteElement.h"

#include <wtf/GetPtr.h>

#include "HTMLBlockquoteElement.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLBlockquoteElement)

/* Hash table */

static const HashTableValue JSHTMLBlockquoteElementTableValues[3] =
{
    { "cite", DontDelete, (intptr_t)jsHTMLBlockquoteElementCite, (intptr_t)setJSHTMLBlockquoteElementCite },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLBlockquoteElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLBlockquoteElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSHTMLBlockquoteElementTableValues, 0 };
#else
    { 5, 3, JSHTMLBlockquoteElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLBlockquoteElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLBlockquoteElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLBlockquoteElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLBlockquoteElementConstructorTableValues, 0 };
#endif

class JSHTMLBlockquoteElementConstructor : public DOMObject {
public:
    JSHTMLBlockquoteElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLBlockquoteElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLBlockquoteElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLBlockquoteElementConstructor::s_info = { "HTMLBlockquoteElementConstructor", 0, &JSHTMLBlockquoteElementConstructorTable, 0 };

bool JSHTMLBlockquoteElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBlockquoteElementConstructor, DOMObject>(exec, &JSHTMLBlockquoteElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLBlockquoteElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLBlockquoteElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLBlockquoteElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLBlockquoteElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLBlockquoteElementPrototype::s_info = { "HTMLBlockquoteElementPrototype", 0, &JSHTMLBlockquoteElementPrototypeTable, 0 };

JSObject* JSHTMLBlockquoteElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLBlockquoteElement>(exec);
}

const ClassInfo JSHTMLBlockquoteElement::s_info = { "HTMLBlockquoteElement", &JSHTMLElement::s_info, &JSHTMLBlockquoteElementTable, 0 };

JSHTMLBlockquoteElement::JSHTMLBlockquoteElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLBlockquoteElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLBlockquoteElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLBlockquoteElementPrototype(JSHTMLBlockquoteElementPrototype::createStructure(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLBlockquoteElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBlockquoteElement, Base>(exec, &JSHTMLBlockquoteElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLBlockquoteElementCite(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLBlockquoteElement* imp = static_cast<HTMLBlockquoteElement*>(static_cast<JSHTMLBlockquoteElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->cite());
}

JSValuePtr jsHTMLBlockquoteElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLBlockquoteElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLBlockquoteElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLBlockquoteElement, Base>(exec, propertyName, value, &JSHTMLBlockquoteElementTable, this, slot);
}

void setJSHTMLBlockquoteElementCite(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLBlockquoteElement* imp = static_cast<HTMLBlockquoteElement*>(static_cast<JSHTMLBlockquoteElement*>(thisObject)->impl());
    imp->setCite(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSHTMLBlockquoteElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLBlockquoteElementConstructor>(exec);
}


}
