/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDocumentType.h"

#include <wtf/GetPtr.h>

#include "DocumentType.h"
#include "JSNamedNodeMap.h"
#include "KURL.h"
#include "NamedAttrMap.h"
#include "NamedNodeMap.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDocumentType)

/* Hash table */

static const HashTableValue JSDocumentTypeTableValues[8] =
{
    { "name", DontDelete|ReadOnly, (intptr_t)jsDocumentTypeName, (intptr_t)0 },
    { "entities", DontDelete|ReadOnly, (intptr_t)jsDocumentTypeEntities, (intptr_t)0 },
    { "notations", DontDelete|ReadOnly, (intptr_t)jsDocumentTypeNotations, (intptr_t)0 },
    { "publicId", DontDelete|ReadOnly, (intptr_t)jsDocumentTypePublicId, (intptr_t)0 },
    { "systemId", DontDelete|ReadOnly, (intptr_t)jsDocumentTypeSystemId, (intptr_t)0 },
    { "internalSubset", DontDelete|ReadOnly, (intptr_t)jsDocumentTypeInternalSubset, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsDocumentTypeConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDocumentTypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSDocumentTypeTableValues, 0 };
#else
    { 18, 15, JSDocumentTypeTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSDocumentTypeConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSDocumentTypeConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSDocumentTypeConstructorTableValues, 0 };
#else
    { 1, 0, JSDocumentTypeConstructorTableValues, 0 };
#endif

class JSDocumentTypeConstructor : public DOMObject {
public:
    JSDocumentTypeConstructor(ExecState* exec)
        : DOMObject(JSDocumentTypeConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSDocumentTypePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSDocumentTypeConstructor::s_info = { "DocumentTypeConstructor", 0, &JSDocumentTypeConstructorTable, 0 };

bool JSDocumentTypeConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentTypeConstructor, DOMObject>(exec, &JSDocumentTypeConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSDocumentTypePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSDocumentTypePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSDocumentTypePrototypeTableValues, 0 };
#else
    { 1, 0, JSDocumentTypePrototypeTableValues, 0 };
#endif

const ClassInfo JSDocumentTypePrototype::s_info = { "DocumentTypePrototype", 0, &JSDocumentTypePrototypeTable, 0 };

JSObject* JSDocumentTypePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSDocumentType>(exec);
}

const ClassInfo JSDocumentType::s_info = { "DocumentType", &JSNode::s_info, &JSDocumentTypeTable, 0 };

JSDocumentType::JSDocumentType(PassRefPtr<Structure> structure, PassRefPtr<DocumentType> impl)
    : JSNode(structure, impl)
{
}

JSObject* JSDocumentType::createPrototype(ExecState* exec)
{
    return new (exec) JSDocumentTypePrototype(JSDocumentTypePrototype::createStructure(JSNodePrototype::self(exec)));
}

bool JSDocumentType::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentType, Base>(exec, &JSDocumentTypeTable, this, propertyName, slot);
}

JSValuePtr jsDocumentTypeName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DocumentType* imp = static_cast<DocumentType*>(static_cast<JSDocumentType*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->name());
}

JSValuePtr jsDocumentTypeEntities(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DocumentType* imp = static_cast<DocumentType*>(static_cast<JSDocumentType*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->entities()));
}

JSValuePtr jsDocumentTypeNotations(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DocumentType* imp = static_cast<DocumentType*>(static_cast<JSDocumentType*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->notations()));
}

JSValuePtr jsDocumentTypePublicId(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DocumentType* imp = static_cast<DocumentType*>(static_cast<JSDocumentType*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->publicId());
}

JSValuePtr jsDocumentTypeSystemId(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DocumentType* imp = static_cast<DocumentType*>(static_cast<JSDocumentType*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->systemId());
}

JSValuePtr jsDocumentTypeInternalSubset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DocumentType* imp = static_cast<DocumentType*>(static_cast<JSDocumentType*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->internalSubset());
}

JSValuePtr jsDocumentTypeConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSDocumentType*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSDocumentType::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSDocumentTypeConstructor>(exec);
}

DocumentType* toDocumentType(JSC::JSValuePtr value)
{
    return value->isObject(&JSDocumentType::s_info) ? static_cast<JSDocumentType*>(asObject(value))->impl() : 0;
}

}
