#============================================================================#
# Designer plugins for PyDateEdit and PyDateTimeEdit                         #
#----------------------------------------------------------------------------#
# Copyright (c) 2008 by Denviso GmbH, <ulrich.berning@denviso.de>            #
#                                                                            #
# All Rights Reserved                                                        #
#                                                                            #
# Permission to use, copy, modify, and distribute this software and its      #
# documentation for any purpose and without fee is hereby granted,           #
# provided that the above copyright notice appear in all copies and that     #
# both that copyright notice and this permission notice appear in            #
# supporting documentation.                                                  #
#                                                                            #
# DENVISO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS                       #
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY              #
# AND FITNESS, IN NO EVENT SHALL DENVISO BE LIABLE FOR ANY                   #
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES                  #
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,                    #
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER                      #
# TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE              #
# OR PERFORMANCE OF THIS SOFTWARE.                                           #
#----------------------------------------------------------------------------#
from PyQt4 import QtCore, QtGui, QtDesigner
from datetimeedit import PyDateEdit, PyDateTimeEdit

#============================================================================#
# The group name in designer widgetbox                                       #
#----------------------------------------------------------------------------#
DESIGNER_GROUP_NAME = "PyQt Examples"

#============================================================================#
# Plugin for PyDateEdit                                                      #
#----------------------------------------------------------------------------#
class PyDateEditPlugin(QtDesigner.QPyDesignerCustomWidgetPlugin):
    def __init__(self, parent=None):
        QtDesigner.QPyDesignerCustomWidgetPlugin.__init__(self, parent)
        self.initialized = False

    def initialize(self, formEditor):
        if self.initialized:
            return
        self.initialized = True

    def isInitialized(self):
        return self.initialized

    def isContainer(self):
        return False

    def icon(self):
        return QtGui.QIcon(_dateedit_pixmap)

    def domXml(self):
        return '<widget class="PyDateEdit" name="pyDateEdit">\n</widget>\n'
    
    def group(self):
        return DESIGNER_GROUP_NAME
              
    def includeFile(self):
        return "datetimeedit"

    def name(self):
        return "PyDateEdit"

    def toolTip(self):
        return ""

    def whatsThis(self):
        return ""

    def createWidget(self, parent):
        return PyDateEdit(parent)

#============================================================================#
# Plugin for PyDateTimeEdit                                                  #
#----------------------------------------------------------------------------#
class PyDateTimeEditPlugin(QtDesigner.QPyDesignerCustomWidgetPlugin):
    def __init__(self, parent=None):
        QtDesigner.QPyDesignerCustomWidgetPlugin.__init__(self, parent)
        self.initialized = False

    def initialize(self, formEditor):
        if self.initialized:
            return
        self.initialized = True

    def isInitialized(self):
        return self.initialized

    def isContainer(self):
        return False

    def icon(self):
        return QtGui.QIcon(_datetimeedit_pixmap)

    def domXml(self):
        return '<widget class="PyDateTimeEdit" name="pyDateTimeEdit">\n</widget>\n'
    
    def group(self):
        return DESIGNER_GROUP_NAME
              
    def includeFile(self):
        return "datetimeedit"

    def name(self):
        return "PyDateTimeEdit"

    def toolTip(self):
        return ""

    def whatsThis(self):
        return ""

    def createWidget(self, parent):
        return PyDateTimeEdit(parent)

#============================================================================#
# Embeded images                                                             #
#----------------------------------------------------------------------------#
_dateedit_png = ("\x89\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\x00\x00\x16\x00\x00\x00\x16"
                 "\x08\x06\x00\x00\x00\xc4\xb4\x6c\x3b\x00\x00\x02\x0f\x49\x44\x41\x54\x78\x9c\xb5\x95\xbf\x6e\x1a"
                 "\x41\x10\xc6\x7f\x6b\x90\x1c\x25\x22\x0a\x71\xf8\x23\x45\x31\x51\x2c\x8a\xc8\x4a\xe1\x26\x52\x4a"
                 "\x9f\xae\xb0\x68\x5c\xa5\xa4\x23\x12\x2d\x1d\x79\x17\x7a\xd3\xba\xb3\x79\x81\x08\x1a\x0a\xdf\xbd"
                 "\x40\x40\x39\x83\x0c\x2b\x5d\x90\xec\x98\xb3\x27\xc5\xdd\x91\x33\x1c\xe0\x38\xf1\x27\xad\xb4\x3b"
                 "\xbb\xf3\xed\x68\x76\xbf\x19\x25\x22\x3c\x06\x36\x1e\x85\x15\x48\x46\x17\x4a\x29\x05\x24\x02\x7b"
                 "\xe2\x9e\x17\xdf\x02\x37\x80\x07\xdc\x48\x90\x82\xe4\xdc\xa1\x44\xad\x56\x9b\x6a\xad\xd1\x5a\xaf"
                 "\x65\x74\x1c\x87\x4e\xa7\x03\xf0\x11\xf8\x01\x8c\x94\x52\xbf\x44\x44\xe6\x89\x93\x5a\x6b\xaa\xd5"
                 "\x2a\xae\xeb\xae\x25\x1e\x0c\x06\x94\xcb\x65\xf8\x70\xd8\xe1\xec\xd8\x00\xac\x20\x72\x6f\x21\x62"
                 "\xad\x35\xae\xeb\x32\x1e\x8f\xd7\x12\xf7\x7a\x3d\x7f\x72\x76\x0c\xf0\x16\xf8\x0e\xfc\x8c\x23\xde"
                 "\x70\x1c\x87\xc1\x60\xf0\xc7\x69\x05\xfa\xfd\x7e\x74\xf9\x02\x78\x8a\xff\x36\x20\x22\xb3\x01\xa4"
                 "\x00\x79\xe0\xf8\x0a\xec\x01\x29\x11\x59\x78\x3c\x00\xda\xed\x36\xa3\xd1\x68\x6d\xc4\x00\xa5\x52"
                 "\x29\x9c\x4e\xa3\xf6\x58\xe2\x62\xb1\x48\xa1\x50\x00\xe0\x22\x9f\xe7\xd5\xf9\x39\x17\xf9\xfc\x6c"
                 "\x3f\x75\x74\xc4\xe6\xfe\xfe\xbc\xdb\xd5\x5a\xe2\x74\x3a\x0d\x80\xad\x14\x00\xb9\x5c\x8e\x5c\x44"
                 "\xa1\xb6\x52\x6c\x2f\x2a\xd6\x8b\x2e\x56\x0a\x60\x37\xe2\xec\x9e\x9e\x62\x2b\x85\xad\x14\x6f\x4e"
                 "\x4e\x56\xb9\x2d\x8f\x38\x0e\xbd\x83\x03\xb2\xc3\x21\xc3\xe1\x90\x1e\x80\x6d\xff\x1f\x62\x80\x6f"
                 "\xd9\x2c\x87\xcb\xb7\xc3\xdf\x01\xdc\xa3\x16\x84\xe9\xd8\x15\x61\xc7\xb2\x00\x68\x36\x9b\x34\x1a"
                 "\x0d\x00\x4c\xd3\x0c\x8f\x7a\x7f\x45\x1c\x87\xc9\x64\x42\xa5\x52\xc1\x30\x0c\xea\xf5\x7a\x68\xbe"
                 "\x26\xfa\x80\x71\x02\x59\x06\xcb\xb2\x66\x82\x30\x0c\x43\x5a\xad\x96\x74\xbb\xdd\xd0\xf6\x19\x78"
                 "\xcf\x12\x81\xdc\x02\xa8\xe0\x9b\x2d\x83\x69\x9a\xd4\xeb\x75\xb6\xb6\xb6\xc8\x64\x32\xa1\x79\x8a"
                 "\x5f\x3e\x63\x23\x7e\x02\xec\xf0\xe9\xcb\x43\x24\x6d\x02\xef\x80\x67\x22\x82\x8a\xb6\x26\xa5\x54"
                 "\x12\x48\x03\xaf\x81\x6d\xe0\x65\x70\x59\x14\x12\xe4\xf2\x1a\x5f\x6d\x53\x60\x02\x68\xfc\x9a\xac"
                 "\x45\xe4\x6a\x9e\x58\x01\x9b\x41\xae\x9f\xe3\x57\xab\xf9\x74\x85\x11\x7a\xdc\xed\x1e\x97\xc1\x05"
                 "\x97\x22\xe2\xdd\x21\x8e\x90\xff\x73\x7b\xfa\x0d\x23\x92\x22\x8d\x75\xe5\x6e\xe4\x00\x00\x00\x00"
                 "\x49\x45\x4e\x44\xae\x42\x60\x82")
_dateedit_pixmap = QtGui.QPixmap()
_dateedit_pixmap.loadFromData(_dateedit_png, "PNG")

_datetimeedit_png = ("\x89\x50\x4e\x47\x0d\x0a\x1a\x0a\x00\x00\x00\x0d\x49\x48\x44\x52\x00\x00\x00\x16\x00\x00\x00\x16"
                     "\x08\x06\x00\x00\x00\xc4\xb4\x6c\x3b\x00\x00\x03\xdd\x49\x44\x41\x54\x78\x9c\x9d\x95\x5d\x68\x5b"
                     "\x65\x18\xc7\x7f\xef\x39\x27\xc9\x49\x9a\x34\xdf\x59\x6c\xdd\xe6\x64\xae\x8e\xe8\xe6\xb0\xba\x49"
                     "\xd1\x89\xc8\x3e\x54\x54\x10\xbc\x18\xab\xb0\x0b\x61\x57\x42\xf1\xca\x21\x88\x77\x32\xef\x04\x1d"
                     "\x78\xe1\x95\xb6\x37\x22\x1b\x74\x1f\x1d\x38\x2a\x6e\x93\xa6\x76\xd3\x6e\xb3\xcc\xd5\x8a\x4d\xba"
                     "\x34\x2e\x39\xa7\x39\x69\x9b\x26\x3d\x39\xaf\x17\xc9\xe6\xd6\x65\xad\xf8\xc0\x1f\xce\xfb\xf2\xbe"
                     "\x3f\x9e\xe7\x3d\xcf\x87\x00\xb4\xa6\x54\x40\x61\x6d\x73\x80\x3a\x60\x03\x75\x29\xa5\x6c\x75\x48"
                     "\xf4\xf5\xf5\x49\xd3\x34\x31\x4d\x73\x4d\x62\x2e\x97\x23\x9d\x4e\x03\x3c\x0b\xdc\x04\x8a\x40\xb5"
                     "\x15\x5c\x33\x4d\x93\xc3\x87\x0f\x63\x59\xd6\x9a\xe0\x7c\x3e\x4f\x6f\x6f\x2f\x3c\xf9\x46\x9a\x2b"
                     "\x27\x5e\x02\xae\x36\x3d\xb7\x5b\x82\x2d\xcb\xc2\x30\x8c\x35\xc1\x99\x4c\xa6\xf1\x71\xe5\x04\xc0"
                     "\x23\xc0\x34\x50\x6e\x09\xce\xe5\x72\xe4\xf3\xf9\x7f\x2f\xad\x62\xd9\x6c\xf6\xee\x65\x08\xf0\xd1"
                     "\xf8\x37\x2d\x4d\xfe\x4f\x7d\x00\xec\x00\x02\x52\x4a\x56\x4a\x03\x18\x19\x19\xa1\x58\x2c\xae\xe9"
                     "\x31\xc0\x6b\xaf\xbf\x89\xa2\x79\xc0\xa5\x3f\x0e\xc2\x72\x2a\x73\x8a\x10\xe2\x06\x50\x91\x52\x2e"
                     "\xdf\x3e\x27\x00\x69\x18\x06\xb5\x5a\x0d\x80\x42\x32\x49\x6c\x76\x96\x42\x32\x79\x07\x16\x18\x18"
                     "\x60\x7e\xdb\x76\x2e\x8c\x5d\x65\x60\xf0\x1c\x0f\x3d\x1c\xa7\x3d\xe8\x2f\xe7\x8c\x25\xeb\xca\xe4"
                     "\xec\xd4\xf4\xf8\xc8\xa0\x9d\xb9\x34\x08\x64\x80\x05\x29\xa5\x23\x80\x3b\xd9\x72\x4d\x08\x00\x52"
                     "\x2b\xb2\xe7\x4c\x7b\x98\x9f\x8f\x7e\x89\x60\x8e\x3d\xbb\xd6\x11\x0d\x79\xa8\x56\x6b\x44\xe3\x41"
                     "\x7e\x9d\x9c\xe7\xf3\x53\x33\xf2\xc4\xb7\x83\xa7\x99\x38\xf5\x19\x8e\x3d\x06\x18\xf7\x14\xc4\xdd"
                     "\x40\x6b\x68\x88\x6b\x42\x70\xde\xe5\x22\xfd\xe1\xa7\x74\x44\x2b\x1c\xdc\xbf\x9e\x78\xc8\x85\xbf"
                     "\xdd\xcf\x27\xfd\x25\xae\xff\x61\x91\xea\x10\x7c\x73\xa4\x5b\xbc\x73\xe8\xad\x57\xd8\xd4\xf3\x3e"
                     "\xb0\x0d\xd0\x1f\x58\x69\x99\x7d\xfb\x88\xe7\xf3\x5c\x3e\xf6\x15\x75\xbf\xc2\x33\x5b\x03\x04\x43"
                     "\x6d\x24\x12\x61\xdc\x6e\x37\x73\x4b\x2a\x89\x78\x80\x70\x34\x48\x31\x57\xe0\xe3\x03\x9b\xe8\xd9"
                     "\xb3\xf7\x45\xf4\xd0\xab\x40\x64\xd5\x12\x3e\xd5\xb9\x9e\xd3\x17\xaf\xb2\x33\x15\x20\x1a\x09\x80"
                     "\x94\xf8\x7c\x3a\x95\x6a\x9d\x25\xdb\xa1\xcd\xe7\xc6\xab\xbb\xa9\x54\xab\x6c\x48\xf8\x38\xf0\xf2"
                     "\x66\x97\x16\x7f\x74\x27\x10\xbb\x0f\x7c\xfb\x39\x52\x52\xe2\xed\xff\x1a\x6f\x28\x8a\xdf\x23\xb0"
                     "\x6d\x87\x60\xb0\x0d\x90\xe4\x8d\x1a\x85\x72\x1d\xdd\x23\x40\x68\x84\x43\x7e\x66\x6e\x16\xd9\xd1"
                     "\x15\x26\x16\x8f\x27\x81\xd0\xaa\x1e\x2f\x2c\x54\xa8\x3a\x0a\x42\x51\xd1\x75\x77\x73\x57\xd2\x99"
                     "\x70\xd3\x19\xd1\xb8\x7c\x7d\x01\x00\x5d\xd7\xf0\x78\x34\xbc\x2e\x15\xaf\x4b\xf5\xac\xfa\xc6\x8d"
                     "\x0b\x1e\x0a\x66\x19\x1b\x17\xcb\xcb\xcb\x98\x73\x0b\x80\x20\xda\xee\xe6\xe9\xae\x36\xde\x3b\x96"
                     "\xe5\xc8\xb1\x3f\xc9\xe6\x4a\xc4\x63\x41\x6e\x15\x17\x59\x9a\x2f\xd5\x00\x45\x03\x10\xcd\x34\xbb"
                     "\xcf\x14\x85\x0d\xbb\x0f\x70\xf2\x72\x17\x5b\x3a\x62\x48\x47\x52\x2a\x2d\x12\x0c\x7a\xf9\xe8\xd0"
                     "\x06\xde\xde\x1d\x62\x78\xcc\xc4\x71\x04\x35\xbb\xce\xc8\x2f\x33\xdc\x9a\x9d\x36\x00\x47\x01\x36"
                     "\xf3\xdc\xbb\xad\xc1\x8e\xc3\xdf\xe3\xc3\x0c\x8c\x96\x48\xff\x55\xc7\xa5\x08\x66\x66\x8a\x14\x8a"
                     "\x65\x7e\x9f\xbc\x49\xc4\x57\x63\x7f\xb7\x8b\x27\xb6\x6e\x64\x38\x5d\xe0\xbb\xe3\xc3\x15\xbb\x98"
                     "\x99\x02\x96\x54\x40\x23\x7b\xa9\x1f\x38\x0d\x9c\x05\x86\x80\x93\x4d\x9d\xb1\x2b\xd6\x68\xd5\x76"
                     "\xa2\xe7\x66\x63\xeb\x22\x6d\x2a\x3d\x4f\x25\xf1\xe9\x1a\xaa\xaa\x92\x48\x84\x11\x9a\x9b\xb3\xe7"
                     "\xb3\x1c\xfd\xe2\x8c\x3d\xfa\xfd\xf1\x71\xb9\x5c\xf9\x09\x18\x17\x80\x0e\x04\x80\x76\x1a\xdd\x4a"
                     "\x5b\xe1\xb7\x17\x94\xed\xda\x96\xe7\x0f\xea\x8f\xed\xea\xde\x9d\x4a\xba\x5f\x48\xc5\x68\xf7\xaa"
                     "\x54\x2a\x35\x26\x6e\xe4\xf9\xe1\xc7\x91\xc5\xc9\xb1\xe1\x6b\xce\xbc\x71\x11\xb8\x00\x8c\x0a\x1a"
                     "\xfd\x42\xe5\xc1\xe3\x49\xa1\xd1\x22\x53\x8a\x2f\xb4\xdf\x89\x6c\xec\xc6\xe5\x4f\x28\x42\x7a\x9c"
                     "\xda\x62\x95\x72\xde\xa0\x94\x9b\x02\x26\x68\x34\xfe\xdf\x80\x19\xf1\x80\x91\x75\x8f\x09\x21\x94"
                     "\x66\x64\x11\x20\x06\x04\x9b\x6b\x95\xc6\xfc\xab\x02\x16\x60\x00\x26\xb0\xf8\x9f\xc0\x4d\xb8\x68"
                     "\x46\xe5\x6e\x4a\x6b\x46\x73\x7b\xb8\xd6\x80\x65\xc0\x96\x52\xd6\xff\x01\xfd\xec\xad\x42\x74\xd2"
                     "\xce\x25\x00\x00\x00\x00\x49\x45\x4e\x44\xae\x42\x60\x82")

_datetimeedit_pixmap = QtGui.QPixmap()
_datetimeedit_pixmap.loadFromData(_datetimeedit_png, "PNG")

#============================================================================#
# EOF                                                                        #
#----------------------------------------------------------------------------#
