/*
 * This file is part of Krita
 *
 * Copyright (c) 2006 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef LENS_CORRECTIONFILTER_H
#define LENS_CORRECTIONFILTER_H

#include <kparts/plugin.h>
#include "filter/kis_filter.h"

class KisConfigWidget;

class KritaLensCorrectionFilter : public KParts::Plugin
{
public:
    KritaLensCorrectionFilter(QObject *parent, const QStringList &);
    virtual ~KritaLensCorrectionFilter();
};

class KisFilterLensCorrection : public KisFilter
{
public:
    KisFilterLensCorrection();
public:
    using KisFilter::process;
    void process(KisConstProcessingInformation src,
                 KisProcessingInformation dst,
                 const QSize& size,
                 const KisFilterConfiguration* config,
                 KoUpdater* progressUpdater
                ) const;

    static inline KoID id() {
        return KoID("lenscorrection", i18n("Lens Correction"));
    }
    virtual KisFilterConfiguration* factoryConfiguration(const KisPaintDeviceSP) const;
public:
    virtual KisConfigWidget * createConfigurationWidget(QWidget* parent, const KisPaintDeviceSP dev, const KisImageSP image = 0) const;
};

#endif
