/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __gul_tb_button_h
#define __gul_tb_button_h

#include <gtk/gtkhbox.h>
#include <gtk/gtkmenushell.h>
#include <gtk/gtkbutton.h>

/* object forward declarations */

typedef struct _GulTbButton GulTbButton;
typedef struct _GulTbButtonClass GulTbButtonClass;
typedef struct _GulTbButtonPrivate GulTbButtonPrivate;

/**
 * TbButton object
 */

#define GUL_TYPE_TB_BUTTON		(gul_tb_button_get_type())
#define GUL_TB_BUTTON(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), GUL_TYPE_TB_BUTTON,\
					 GulTbButton))
#define GUL_TB_BUTTON_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), GUL_TYPE_TB_BUTTON,\
					 GulTbButtonClass))
#define GUL_IS_TB_BUTTON(object)	(G_TYPE_CHECK_INSTANCE_TYPE((object), GUL_TYPE_TB_BUTTON))
#define GUL_IS_TB_BUTTON_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), GUL_TYPE_TB_BUTTON))
#define GUL_TB_BUTTON_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), GUL_TYPE_TB_BUTTON,\
					 GulTbButtonClass))

struct _GulTbButtonClass 
{
	GtkHBoxClass parent_class;

	void		(*menu_activated)		(GulTbButton *b);
};

/* Remember: fields are public read-only */
struct _GulTbButton
{
	GtkHBox parent_object;
	GulTbButtonPrivate *priv;
};

/* this class is abstract */

GType			gul_tb_button_get_type		(void);
GulTbButton *		gul_tb_button_new		(void);
void			gul_tb_button_set_label		(GulTbButton *b, const gchar *text);
void			gul_tb_button_set_use_stock	(GulTbButton *b, gboolean value);
void			gul_tb_button_set_priority	(GulTbButton *b, gboolean priority);
void 			gul_tb_button_set_image		(GulTbButton *b, GtkWidget *image);
void 			gul_tb_button_set_widget	(GulTbButton *b, GtkWidget *widget);
void			gul_tb_button_set_tooltip_text	(GulTbButton *b, const gchar *text);
void			gul_tb_button_set_show_arrow	(GulTbButton *b, gboolean value);
void			gul_tb_button_set_show_button	(GulTbButton *b, gboolean value);
void			gul_tb_button_set_always_image	(GulTbButton *b, gboolean value);
void			gul_tb_button_set_enable_menu	(GulTbButton *b, gboolean value);
GtkMenuShell *		gul_tb_button_get_menu		(GulTbButton *b);
GtkButton *		gul_tb_button_get_button	(GulTbButton *b);
void			gul_tb_button_set_sensitivity	(GulTbButton *b, gboolean value);
void			gul_tb_button_set_use_toggle_button (GulTbButton *b);

#endif
