%define TeXdir %(cd `kpsewhich -expand-var '$TEXMFMAIN'`/../..; pwd)

Name: jadetex
Version: 3.6
Release: 4
Group: Applications/Publishing

Summary: TeX macros used by Jade TeX output.

License: Distributable

Requires: sgml-common >= 0.5
Requires: tetex >= 0.9 tetex-latex >= 0.9
Requires: jade
Requires(post): tetex >= 0.9
BuildRequires: unzip

BuildRoot: %{_tmppath}/%{name}-%{version}

BuildArch: noarch
Source0: http://www.tug.org/applications/jadetex/jadetex.zip
Source1: jadefmtutil.cnf
Patch0: jadetex-makefile.patch
Patch1: jadetex-emergency.patch


%description
JadeTeX contains the additional LaTeX macros necessary for taking Jade
TeX output files and processing them as TeX files (to obtain DVI,
PostScript, or PDF files, for example).

%prep
%setup -c -T
unzip %{SOURCE0}
if [ `id -u` -eq 0 ]; then
  chown -R root.root .
  chmod -R a+rX,g-w,o-w .
fi
cp %{SOURCE1} .
%patch0 -p1
%patch1 -p1


%build
make


%install
DESTDIR=$RPM_BUILD_ROOT
rm -rf $DESTDIR
mkdir -p $DESTDIR
make install DESTDIR=$DESTDIR

mkdir -p ${DESTDIR}%{TeXdir}/share/texmf/tex/jadetex
cp *.ini ${DESTDIR}%{TeXdir}/share/texmf/tex/jadetex
cp *.sty ${DESTDIR}%{TeXdir}/share/texmf/tex/jadetex
cp *.cnf ${DESTDIR}%{TeXdir}/share/texmf/tex/jadetex

mkdir -p ${DESTDIR}%{TeXdir}/bin
ln -s virtex ${DESTDIR}%{TeXdir}/bin/jadetex
ln -s pdfvirtex ${DESTDIR}%{TeXdir}/bin/pdfjadetex


%clean
DESTDIR=$RPM_BUILD_ROOT
rm -rf $DESTDIR


%post
/usr/bin/env - PATH=$PATH:%{TeXdir}/bin texhash > /dev/null 2>&1
/usr/bin/env - PATH=$PATH:%{TeXdir}/bin fmtutil --cnffile %{TeXdir}/share/texmf/tex/jadetex/jadefmtutil.cnf --all > /dev/null 2>&1
exit 0


%files
%defattr (-,root,root)
%ghost %{TeXdir}/share/texmf/web2c/jadetex.fmt
%ghost %{TeXdir}/share/texmf/web2c/pdfjadetex.fmt
%{TeXdir}/share/texmf/tex/jadetex/dsssl.def
%{TeXdir}/share/texmf/tex/jadetex/jadetex.ltx
%{TeXdir}/share/texmf/tex/jadetex/jadetex.ini
%{TeXdir}/share/texmf/tex/jadetex/pdfjadetex.ini
%{TeXdir}/share/texmf/tex/jadetex/dummyels.sty
%{TeXdir}/share/texmf/tex/jadetex/mlnames.sty
%{TeXdir}/share/texmf/tex/jadetex/ucharacters.sty
%{TeXdir}/share/texmf/tex/jadetex/uentities.sty
%{TeXdir}/share/texmf/tex/jadetex/unicode.sty
%{TeXdir}/share/texmf/tex/jadetex/jadefmtutil.cnf
%{TeXdir}/bin/jadetex
%{TeXdir}/bin/pdfjadetex

%changelog
* Tue Aug 14 2001 Tim Powers <timp@redhat.com>
- rebuilt to hopefully fix rpm verify problems

* Thu Aug  9 2001 Tim Waugh <twaugh@redhat.com> 3.6-3
- Use %%ghost for the fmt files, since they get recreated (bug #49580).

* Wed Aug  1 2001 Tim Waugh <twaugh@redhat.com> 3.6-2
- Use emergencystretch (bug #47345).

* Mon Jun  4 2001 Tim Waugh <twaugh@redhat.com> 3.6-1
- 3.6.

* Mon Feb 12 2001 Tim Waugh <twaugh@redhat.com> 3.3-1
- 3.3.  Redo jadetex-makefile.patch.

* Fri Jan 19 2001 Tim Waugh <twaugh@redhat.com>
- Earlier change was wrong; jade should be required, not openjade
- Require sgml-common >= 0.5.

* Wed Jan 17 2001 Tim Waugh <twaugh@redhat.com>
- Make tetex a %%post requirement.
- Silence %%post output.
- Don't play so many macro games.
- Build requires unzip.

* Fri Jan 12 2001 Tim Waugh <twaugh@redhat.com>
- Make symlinks relative.

* Mon Jan 08 2001 Tim Waugh <twaugh@redhat.com>
- Change group.
- Require openjade not jade.
- rm before install.
- Use %%{_tmppath}.
- Require tetex-latex.
- Change Copyright: to License:.
- Remove Packager: line.

* Mon Jan 08 2001 Tim Waugh <twaugh@redhat.com>
- Based on Eric Bischoff's new-trials packages.
