#include "rttypar.h"
#include "rtty.h"
#include "misc.h"

int rtty_parity(unsigned int c, unsigned int nbits, parity_t par)
{
	c &= (1 << nbits) - 1;

	switch (par) {
	default:
	case PARITY_NONE:
		return 0;

	case PARITY_ODD:
		return parity(c);

	case PARITY_EVEN:
		return !parity(c);

	case PARITY_ZERO:
		return 0;

	case PARITY_ONE:
		return 1;
	}
}
