#include "trx.h"
#include "feld.h"
#include "filter.h"
#include "fftfilt.h"
#include "misc.h"

#undef  MAX
#define MAX(a,b)		(((a)>(b))?(a):(b))
#undef  CLAMP
#define CLAMP(x,low,high)	(((x)>(high))?(high):(((x)<(low))?(low):(x)))

static inline complex mixer(struct trx *trx, complex in)
{
	struct feld *s = (struct feld *) trx->modem;
	complex z;
	float f;

	f = trx->frequency - CenterFreq;

	z.re = cos(s->rxphacc);
	z.im = sin(s->rxphacc);

	z = cmul(z, in);

	s->rxphacc -= 2.0 * M_PI * f / SampleRate;

	if (s->rxphacc > M_PI)
		s->rxphacc -= 2.0 * M_PI;
	else if (s->rxphacc < M_PI)
		s->rxphacc += 2.0 * M_PI;

	return z;
}

void handle_column(struct trx *trx)
{
	struct feld *s = (struct feld *) trx->modem;
	double pixbuf[PixBufLen], x;
	double max = 0.0;
	int i, j;

	for (i = 0; i < PixBufLen; i++) {
		pixbuf[i] = 0.0;
		for (j = 0; j < DownSample; j++)
			pixbuf[i] += fabs(s->sndbuf[i * DownSample + j]);
		pixbuf[i] /= DownSample;
		max = MAX(max, pixbuf[i]);
	}

	if (max > s->agc)
		s->agc = max;
	else
		s->agc *= 0.95;

	for (i = 0; i < PixBufLen; i++) {
		x = pixbuf[PixBufLen - i - 1];
		x = 256 * x / s->agc;
		x = 255 - CLAMP(x, 0, 255);
		trx_put_rx_data((int) x);
	}
}

int feld_rxprocess(struct trx *trx, float *buf, int len)
{
	struct feld *s = (struct feld *) trx->modem;
	complex z, *zp;
	int i, n;

#if 0
	if (trx->bandwidth != s->bw) {
		float flo, fhi;

		s->bw = trx->bandwidth;

	        flo = (CenterFreq - s->bw / 2.0) / SampleRate;
	        fhi = (CenterFreq + s->bw / 2.0) / SampleRate;

		fftfilt_set_freqs(s->fftfilt, flo, fhi);
	}
#endif

	while (len-- > 0) {
		/* create analytic signal... */
		z.re = z.im = *buf++;
		filter_run(s->hilbert, z, &z);

		/* ...so it can be shifted in frequency */
		z = mixer(trx, z);

		n = fftfilt_run(s->fftfilt, z, &zp);

		for (i = 0; i < n; i++) {
			s->sndbuf[s->sndptr++] = zp[i].re;

			if (s->sndptr == ColumnLen) {
				handle_column(trx);
				s->sndptr = 0;
			}
		}
	}

	return 0;
}
