/* LIBGIMP - The GIMP Library 
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball                
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU  
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIMP_BILINEAR_H__
#define __GIMP_BILINEAR_H__

G_BEGIN_DECLS

/* For information look into the C source or the html documentation */


/*  bilinear interpolation functions taken from LibGCK  */


gdouble   gimp_bilinear          (gdouble    x,
                                  gdouble    y,
                                  gdouble   *values);
guchar    gimp_bilinear_8        (gdouble    x,
                                  gdouble    y,
                                  guchar    *values);
guint16   gimp_bilinear_16       (gdouble    x,
                                  gdouble    y,
                                  guint16   *values);
guint32   gimp_bilinear_32       (gdouble    x,
                                  gdouble    y,
                                  guint32   *values);
GimpRGB   gimp_bilinear_rgb      (gdouble    x,
                                  gdouble    y,
                                  GimpRGB   *values);
GimpRGB   gimp_bilinear_rgba     (gdouble    x,
                                  gdouble    y,
                                  GimpRGB   *values);
void      gimp_bilinear_pixels_8 (guchar    *dest,
                                  gdouble    x,
                                  gdouble    y,
                                  guint      bpp,
                                  gboolean   has_alpha,
                                  guchar   **values);

G_END_DECLS

#endif  /* __GIMP_BILINEAR_H__ */
