/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2002 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * callbacks_qsoframe.c - callbacks for the QSO frame, where all the entry
 * widgets are
 */

#include <time.h>
#include <ctype.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <errno.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "callbacks_qsoframe.h"
#include "interface.h"
#include "support.h"
#include "dxcc.h"
#include "types.h"
#include "utils.h"
#include "hamlib-utils.h"
#include "types.h"
#include "log.h"

/* defines and variables for shared memory support */
#define KEY 6146
#define SHMSIZE  40
void *shareCall;
extern GtkWidget *mainwindow;
extern gint callid;
extern statetype state;
extern GList *logwindowlist;

/* QSO FRAME */
/* get current date and fill in the dateentry */
void on_datebutton_clicked(GtkButton *button, gpointer user_data) {
	GtkWidget *entry;
	gchar *nowdate;

	nowdate = getdate();
	entry = lookup_widget(mainwindow, "dateentry");
	gtk_entry_set_text(GTK_ENTRY(entry), nowdate);
	g_free(nowdate);
}

/* get current time and fill in the gmtentry */
void on_gmtbutton_clicked(GtkButton *button, gpointer user_data) {
	GtkWidget *entry;
	gchar *nowtime;

	entry = lookup_widget(mainwindow, "gmtentry");
	nowtime = gettime();
	gtk_entry_set_text(GTK_ENTRY(entry), nowtime);
	g_free(nowtime);
}

/* convert callsign to uppercase */
void on_callentry_insert_text(GtkEditable *editable, gchar *new_text,
	gint new_text_length, gint *position, gpointer user_data)
{
	gint i;
	gchar *result = g_new(gchar, new_text_length);
	gchar *call, *errorstr;

	for (i = 0; i < new_text_length; i++)
		result[i] = islower(new_text[i]) ? toupper(new_text[i]) : new_text[i];

	gtk_signal_handler_block_by_func(GTK_OBJECT(editable),
		GTK_SIGNAL_FUNC(on_callentry_insert_text), user_data);
	gtk_editable_insert_text(editable, result, new_text_length, position);
	call = gtk_editable_get_chars(editable, 0 , -1);
	updatedxccframe(call);

	/* twpsk support */
	if (state.shmid == -1)   /* if no IPC ID yet, create one */
	{
		if ((state.shmid = shmget (KEY, SHMSIZE, IPC_CREAT | 0600)) < 0)
		{
               errorstr = g_strdup_printf("shmget failed: %s", g_strerror(errno));
               update_statusbar(errorstr);
               g_free(errorstr);
		}
		if ((shareCall = (shmat(state.shmid, NULL, 0))) == (gchar *)-1)
		{
			errorstr = g_strdup_printf("shmat failed: %s", g_strerror(errno));
			update_statusbar(errorstr);
			g_free(errorstr);
			state.shmid = -1;
		}
	}
	if (state.shmid != -1) strncpy(shareCall, call, SHMSIZE);  /* put call in shm */
	g_free(call);

	gtk_signal_handler_unblock_by_func(GTK_OBJECT(editable),
		GTK_SIGNAL_FUNC(on_callentry_insert_text), user_data);
	gtk_signal_emit_stop_by_name(GTK_OBJECT(editable), "insert_text");
	g_free(result);
}

/* catch return key when band-optionmenu has focus and show the menu */
gboolean on_bandoptionmenu_key_press_event(GtkWidget *widget, GdkEventKey *event, gpointer user_data) 
{
	GtkWidget *bandoptionmenu, *menu;

	switch (event->keyval) {
		case GDK_Return:
			bandoptionmenu = lookup_widget(mainwindow, "bandoptionmenu");
			menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(bandoptionmenu));
			gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, 0);
			return TRUE;
			break;
	}
	return FALSE;
}

/* catch return key when mode-optionmenu has focus and show the menu */
gboolean on_modeoptionmenu_key_press_event(GtkWidget *widget, GdkEventKey *event, gpointer user_data) {
	GtkWidget *modeoptionmenu, *menu;
	switch (event->keyval) {
		case GDK_Return:
			modeoptionmenu = lookup_widget(mainwindow, "modeoptionmenu");
			menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(modeoptionmenu));
			gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, 0);
			return TRUE;
			break;
	}
	return FALSE;
}

#if WANT_HAMLIB
void on_mhzbutton_clicked (GtkButton *button, gpointer user_data) {
	GtkWidget *entry;

	entry = lookup_widget(mainwindow, "bandentry");
	gtk_entry_set_text(GTK_ENTRY(entry), state.rigfrequency);
}

void on_modebutton_clicked (GtkButton *button, gpointer user_data) {
	GtkWidget *entry;

	entry = lookup_widget(mainwindow, "modeentry");
	gtk_entry_set_text(GTK_ENTRY(entry), state.rigmode);
}

void on_rstbutton_clicked (GtkButton *button, gpointer user_data) {
	GtkWidget *entry;

	entry = lookup_widget(mainwindow, "rstentry");
	gtk_entry_set_text(GTK_ENTRY(entry), state.rigrst);
}
#endif

/* right click with mouse button */
gboolean on_eventbox_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data) {
	if (event->button != 1) {
		gtk_menu_popup(GTK_MENU(create_qsoframemenu()), NULL, NULL, NULL, NULL, 1, 0);
		return TRUE;
	}
	return FALSE;
}

/* POP-UP MENU: clear all the fields in the qso frame */
void on_clearframe1_activate(GtkMenuItem *menuitem, gpointer user_data) {
	GtkWidget *dateentry, *gmtentry;
	GtkWidget *callentry, *rstentry, *myrstentry, *remarksentry, *modeentry,
		*bandentry, *incheckbutton, *outcheckbutton;
	GtkWidget *modeoptionmenu, *bandoptionmenu;
	GtkWidget *qsoframe;
	gchar *frametext;
	logtype *logwindow;
	gint i;

	dateentry = lookup_widget(mainwindow, "dateentry");
	gmtentry = lookup_widget(mainwindow, "gmtentry");
	gtk_editable_delete_text(GTK_EDITABLE(dateentry), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(gmtentry), 0, -1);
	callentry = lookup_widget(mainwindow, "callentry");
	bandentry = lookup_widget(mainwindow, "bandentry");
	modeentry = lookup_widget(mainwindow, "modeentry");
	rstentry = lookup_widget(mainwindow, "rstentry");
	myrstentry = lookup_widget(mainwindow, "myrstentry");
	remarksentry = lookup_widget(mainwindow, "remarksentry");
	modeoptionmenu = lookup_widget(mainwindow, "modeoptionmenu");
	bandoptionmenu = lookup_widget(mainwindow, "bandoptionmenu");
	incheckbutton = lookup_widget(mainwindow, "incheckbutton");
	outcheckbutton = lookup_widget(mainwindow, "outcheckbutton");
	for (i = 0; i < g_list_length(logwindowlist); i++)
	{
		logwindow = g_list_nth_data(logwindowlist, i);
		while(GTK_CLIST(logwindow->clist)->selection)
			gtk_clist_unselect_all(GTK_CLIST(logwindow->clist));
	}
	gtk_editable_delete_text(GTK_EDITABLE(callentry), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(modeentry), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(bandentry), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(rstentry), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(myrstentry), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(remarksentry), 0, -1);
	gtk_option_menu_set_history(GTK_OPTION_MENU(modeoptionmenu), 0);
	gtk_option_menu_set_history(GTK_OPTION_MENU(bandoptionmenu), 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(outcheckbutton), FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(incheckbutton), FALSE);
	qsoframe = lookup_widget(mainwindow, "qsoframe");
	frametext = g_strdup_printf(_("New QSO"));
	gtk_frame_set_label(GTK_FRAME(qsoframe), frametext);
	g_free(frametext);
}

