/**
 *
 * $Id: SetClientIcon.c,v 1.6 2001/04/17 22:09:09 rwscott Exp $
 *
 * Copyright (C) 1996 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Extension Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#include "../config.h"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include "Xlt.h"

#ifdef HAVE_XPM
#ifdef HAVE_XM_XPMP_H
#include <Xm/XpmP.h>
#else
#include <X11/xpm.h>
#endif
#else
#error You need Xpm for this
#endif

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif


static const char rcsid[] = "$Id: SetClientIcon.c,v 1.6 2001/04/17 22:09:09 rwscott Exp $";

void
XltSetClientIcon(Widget W, char **icon)
{
XpmAttributes attrib;
Pixmap pixmap = (Pixmap)NULL, mask = (Pixmap)NULL;

	XtVaGetValues(W,
		XtNiconMask, &mask,
		XtNiconPixmap, &pixmap,
		NULL);
	if (mask)
	{
	    XFreePixmap(XtDisplay(W),mask);
	}
	if (pixmap)
	{
	    XFreePixmap(XtDisplay(W),pixmap);
	}
	attrib.valuemask = 0;
	XpmCreatePixmapFromData(XtDisplay(W),
		XRootWindowOfScreen(XtScreen(W)),
		icon,
		&pixmap,
		&mask,
		&attrib);
	if (mask != (Pixmap)NULL)
	{
		XtVaSetValues(W,
			XtNiconMask,mask,
			NULL);
	}
	XpmFreeAttributes(&attrib);

	XtVaSetValues(W,
		XtNiconPixmap,pixmap,
		NULL);
}
