/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import netscape.ldap.DynamicInvoker;
import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.client.opers.JDAPBindRequest;
import netscape.ldap.client.opers.JDAPBindResponse;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class LDAPSaslBind
implements LDAPBind,
Serializable {
    static final long serialVersionUID = -7615315715163655443L;
    private static final String CALLBACK_HANDLER = "javax.security.auth.callback.CallbackHandler";
    private static final String CLIENTPKGS = "javax.security.sasl.client.pkgs";
    private String _dn;
    private String[] _mechanisms;
    private String _packageName;
    private Hashtable _props;
    private Object _cbh;
    private Object _saslClient;

    public LDAPSaslBind(String string, String[] stringArray, String string2, Hashtable hashtable, Object object) {
        this._dn = string;
        this._mechanisms = stringArray;
        this._packageName = string2;
        this._props = hashtable;
        this._cbh = object;
    }

    public void bind(LDAPConnection lDAPConnection) throws LDAPException {
        if (this._props == null) {
            this._props = new Hashtable();
        }
        if (!this._props.containsKey(CLIENTPKGS) && System.getProperty(CLIENTPKGS) == null) {
            this._props.put(CLIENTPKGS, "com.netscape.sasl");
        }
        this._saslClient = this.getClient(lDAPConnection, this._packageName);
        if (this._saslClient != null) {
            this.bind(lDAPConnection, true);
            return;
        }
        LDAPConnection.printDebug("LDAPSaslBind.bind: getClient returned null");
    }

    private Object getClient(LDAPConnection lDAPConnection, String string) throws LDAPException {
        try {
            Object[] objectArray = new Object[]{this._mechanisms, this._dn, "ldap", lDAPConnection.getHost(), this._props, this._cbh};
            String[] stringArray = new String[]{"[Ljava.lang.String;", "java.lang.String", "java.lang.String", "java.lang.String", "java.util.Hashtable", CALLBACK_HANDLER};
            return DynamicInvoker.invokeMethod(null, String.valueOf(string) + ".Sasl", "createSaslClient", objectArray, stringArray);
        }
        catch (Exception exception) {
            LDAPConnection.printDebug("LDAPSaslBind.getClient: " + string + ".Sasl.createSaslClient: " + exception);
            throw new LDAPException(exception.toString(), 80);
        }
    }

    void bind(LDAPConnection lDAPConnection, boolean bl) throws LDAPException {
        if (lDAPConnection.isConnected() && bl || !lDAPConnection.isConnected()) {
            try {
                String[] stringArray;
                Object[] objectArray;
                Object object;
                String string = this._saslClient.getClass().getName();
                LDAPConnection.printDebug("LDAPSaslBind.bind: calling " + string + ".createInitialResponse");
                byte[] byArray = (byte[])DynamicInvoker.invokeMethod(this._saslClient, string, "createInitialResponse", null, null);
                String string2 = (String)DynamicInvoker.invokeMethod(this._saslClient, string, "getMechanismName", null, null);
                LDAPConnection.printDebug("LDAPSaslBind.bind: mechanism name is " + string2);
                boolean bl2 = this.isExternalMechanism(string2);
                int n = 14;
                JDAPBindResponse jDAPBindResponse = null;
                while (!this.checkForSASLBindCompletion(n)) {
                    LDAPConnection.printDebug("LDAPSaslBind.bind: calling saslBind");
                    jDAPBindResponse = this.saslBind(lDAPConnection, string2, byArray);
                    n = jDAPBindResponse.getResultCode();
                    LDAPConnection.printDebug("LDAPSaslBind.bind: saslBind returned " + n);
                    if (bl2) continue;
                    object = jDAPBindResponse.getCredentials();
                    objectArray = new Object[]{object};
                    stringArray = new String[]{"[B"};
                    byArray = (byte[])DynamicInvoker.invokeMethod(this._saslClient, string, "evaluateChallenge", objectArray, stringArray);
                }
                object = (Boolean)DynamicInvoker.invokeMethod(this._saslClient, string, "isComplete", null, null);
                if (!((Boolean)object).booleanValue()) {
                    throw new LDAPException("The server indicates that authentication is successful, but the SASL driver indicates that authentication is not yet done.", 80);
                }
                objectArray = new Object[]{lDAPConnection.getInputStream()};
                stringArray = new String[]{"java.io.InputStream"};
                InputStream inputStream = (InputStream)DynamicInvoker.invokeMethod(this._saslClient, string, "getInputStream", objectArray, stringArray);
                lDAPConnection.setInputStream(inputStream);
                objectArray[0] = lDAPConnection.getOutputStream();
                stringArray[0] = "java.io.OutputStream";
                OutputStream outputStream = (OutputStream)DynamicInvoker.invokeMethod(this._saslClient, string, "getOutputStream", objectArray, stringArray);
                lDAPConnection.setOutputStream(outputStream);
                lDAPConnection.markConnAsBound();
                return;
            }
            catch (LDAPException lDAPException) {
                throw lDAPException;
            }
            catch (Exception exception) {
                throw new LDAPException(exception.toString(), 80);
            }
        }
    }

    boolean isExternalMechanism(String string) {
        return string.equalsIgnoreCase("external");
    }

    private boolean checkForSASLBindCompletion(int n) throws LDAPException {
        if (n == 0) {
            return true;
        }
        if (n == 14) {
            return false;
        }
        throw new LDAPException("Authentication failed", n);
    }

    private JDAPBindResponse saslBind(LDAPConnection lDAPConnection, String string, byte[] byArray) throws LDAPException {
        LDAPResponseListener lDAPResponseListener = lDAPConnection.getResponseListener();
        try {
            lDAPConnection.sendRequest(new JDAPBindRequest(3, this._dn, string, byArray), lDAPResponseListener, lDAPConnection.getConstraints());
            LDAPResponse lDAPResponse = lDAPResponseListener.getResponse();
            JDAPProtocolOp jDAPProtocolOp = lDAPResponse.getProtocolOp();
            if (jDAPProtocolOp instanceof JDAPBindResponse) {
                JDAPBindResponse jDAPBindResponse = (JDAPBindResponse)jDAPProtocolOp;
                Object var7_8 = null;
                lDAPConnection.releaseResponseListener(lDAPResponseListener);
                return jDAPBindResponse;
            }
            throw new LDAPException("Unknown response from the server during SASL bind", 80);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            lDAPConnection.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }
}

