/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.util.LDIF;

public class LDAPControl
implements Cloneable,
Serializable {
    static final long serialVersionUID = 5149887553272603753L;
    public static final String MANAGEDSAIT = "2.16.840.1.113730.3.4.2";
    public static final String PWEXPIRED = "2.16.840.1.113730.3.4.4";
    public static final String PWEXPIRING = "2.16.840.1.113730.3.4.5";
    private String m_oid;
    protected boolean m_critical = false;
    protected byte[] m_value;
    private static Hashtable m_controlClassHash = null;
    static /* synthetic */ Class class$netscape$ldap$controls$LDAPPasswordExpiringControl;
    static /* synthetic */ Class class$netscape$ldap$controls$LDAPPasswordExpiredControl;
    static /* synthetic */ Class class$netscape$ldap$controls$LDAPEntryChangeControl;
    static /* synthetic */ Class class$netscape$ldap$controls$LDAPSortControl;
    static /* synthetic */ Class class$netscape$ldap$controls$LDAPVirtualListResponse;
    static /* synthetic */ Class class$netscape$ldap$LDAPControl;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;

    public LDAPControl() {
    }

    public LDAPControl(String string, boolean bl, byte[] byArray) {
        this.m_oid = string;
        this.m_critical = bl;
        this.m_value = byArray;
    }

    public String getID() {
        return this.m_oid;
    }

    public boolean isCritical() {
        return this.m_critical;
    }

    public byte[] getValue() {
        return this.m_value;
    }

    BERElement getBERElement() {
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BEROctetString(this.m_oid));
        bERSequence.addElement(new BERBoolean(this.m_critical));
        if (this.m_value == null || this.m_value.length < 1) {
            bERSequence.addElement(new BEROctetString(null));
        } else {
            bERSequence.addElement(new BEROctetString(this.m_value, 0, this.m_value.length));
        }
        return bERSequence;
    }

    public static void register(String string, Class clazz) throws LDAPException {
        if (clazz == null) {
            return;
        }
        Class clazz2 = clazz;
        while (clazz2 != (class$netscape$ldap$LDAPControl != null ? class$netscape$ldap$LDAPControl : LDAPControl.class$("netscape.ldap.LDAPControl")) && clazz2 != null) {
            clazz2 = clazz2.getSuperclass();
        }
        if (clazz2 == null) {
            throw new LDAPException("controlClass must be a subclass of LDAPControl", 89);
        }
        Class[] classArray = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = LDAPControl.class$("java.lang.String")), Boolean.TYPE, array$B != null ? array$B : (array$B = LDAPControl.class$("[B"))};
        try {
            clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new LDAPException("controlClass does not implement the correct contstructor", 89);
        }
        if (m_controlClassHash == null) {
            m_controlClassHash = new Hashtable();
        }
        m_controlClassHash.put(string, clazz);
    }

    protected static Class lookupControlClass(String string) {
        if (m_controlClassHash == null) {
            return null;
        }
        return (Class)m_controlClassHash.get(string);
    }

    protected static LDAPControl createControl(String string, boolean bl, byte[] byArray) {
        Class clazz = LDAPControl.lookupControlClass(string);
        if (clazz == null) {
            return new LDAPControl(string, bl, byArray);
        }
        Class[] classArray = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = LDAPControl.class$("java.lang.String")), Boolean.TYPE, array$B != null ? array$B : (array$B = LDAPControl.class$("[B"))};
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Caught java.lang.NoSuchMethodException while attempting to instantiate a control of type " + string);
            return new LDAPControl(string, bl, byArray);
        }
        Object[] objectArray = new Object[]{string, new Boolean(bl), byArray};
        LDAPControl lDAPControl = null;
        try {
            lDAPControl = (LDAPControl)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            String string2 = null;
            string2 = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException().toString() : exception.toString();
            System.err.println("Caught " + string2 + " while attempting to" + " instantiate a control of type " + string);
            lDAPControl = new LDAPControl(string, bl, byArray);
        }
        return lDAPControl;
    }

    static LDAPControl parseControl(BERElement bERElement) {
        BERSequence bERSequence = (BERSequence)bERElement;
        String string = null;
        boolean bl = false;
        byte[] byArray = null;
        try {
            string = new String(((BEROctetString)bERSequence.elementAt(0)).getValue(), "UTF8");
        }
        catch (Throwable throwable) {}
        BERElement bERElement2 = bERSequence.elementAt(1);
        if (bERElement2 instanceof BERBoolean) {
            bl = ((BERBoolean)bERElement2).getValue();
        } else {
            byArray = ((BEROctetString)bERElement2).getValue();
        }
        if (bERSequence.size() >= 3) {
            byArray = ((BEROctetString)bERSequence.elementAt(2)).getValue();
        }
        return LDAPControl.createControl(string, bl, byArray);
    }

    /*
     * Unable to fully structure code
     */
    public static LDAPControl[] newInstance(byte[] var0) throws IOException {
        block3: {
            var1_1 = new int[]{0};
            var2_2 = BERElement.getElement(new JDAPBERTagDecoder(), new ByteArrayInputStream(var0), var1_1);
            var3_3 = null;
            try {
                var4_4 = LDAPMessage.parseMessage(var2_2);
                return var4_4.getControls();
            }
            catch (IOException v0) {
                var4_5 = (BERTag)var2_2;
                if (var4_5.getTag() != 160) break block3;
                var5_6 = (BERSequence)var4_5.getValue();
                var3_3 = new LDAPControl[var5_6.size()];
                var6_7 = 0;
                ** while (var6_7 < var5_6.size())
            }
lbl-1000:
            // 1 sources

            {
                var3_3[var6_7] = LDAPControl.parseControl(var5_6.elementAt(var6_7));
                ++var6_7;
                continue;
            }
        }
        return var3_3;
    }

    public Object clone() {
        byte[] byArray = null;
        if (this.m_value != null) {
            byArray = new byte[this.m_value.length];
            int n = 0;
            while (n < this.m_value.length) {
                byArray[n] = this.m_value[n];
                ++n;
            }
        }
        LDAPControl lDAPControl = new LDAPControl(this.m_oid, this.m_critical, byArray);
        return lDAPControl;
    }

    protected byte[] flattenBER(BERSequence bERSequence) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            bERSequence.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        String string = String.valueOf(this.getID()) + ' ' + this.isCritical();
        if (this.m_value != null) {
            string = String.valueOf(string) + ' ' + LDIF.toPrintableString(this.m_value);
        }
        return "LDAPControl {" + string + '}';
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            LDAPControl.register(PWEXPIRING, class$netscape$ldap$controls$LDAPPasswordExpiringControl != null ? class$netscape$ldap$controls$LDAPPasswordExpiringControl : (class$netscape$ldap$controls$LDAPPasswordExpiringControl = LDAPControl.class$("netscape.ldap.controls.LDAPPasswordExpiringControl")));
            LDAPControl.register(PWEXPIRED, class$netscape$ldap$controls$LDAPPasswordExpiredControl != null ? class$netscape$ldap$controls$LDAPPasswordExpiredControl : (class$netscape$ldap$controls$LDAPPasswordExpiredControl = LDAPControl.class$("netscape.ldap.controls.LDAPPasswordExpiredControl")));
            LDAPControl.register("2.16.840.1.113730.3.4.7", class$netscape$ldap$controls$LDAPEntryChangeControl != null ? class$netscape$ldap$controls$LDAPEntryChangeControl : (class$netscape$ldap$controls$LDAPEntryChangeControl = LDAPControl.class$("netscape.ldap.controls.LDAPEntryChangeControl")));
            LDAPControl.register("1.2.840.113556.1.4.474", class$netscape$ldap$controls$LDAPSortControl != null ? class$netscape$ldap$controls$LDAPSortControl : (class$netscape$ldap$controls$LDAPSortControl = LDAPControl.class$("netscape.ldap.controls.LDAPSortControl")));
            LDAPControl.register("2.16.840.1.113730.3.4.10", class$netscape$ldap$controls$LDAPVirtualListResponse != null ? class$netscape$ldap$controls$LDAPVirtualListResponse : (class$netscape$ldap$controls$LDAPVirtualListResponse = LDAPControl.class$("netscape.ldap.controls.LDAPVirtualListResponse")));
        }
        catch (LDAPException lDAPException) {}
    }
}

