/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIScrollable.idl
 */

#ifndef __gen_nsIScrollable_h__
#define __gen_nsIScrollable_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIScrollable */
#define NS_ISCROLLABLE_IID_STR "61792520-82c2-11d3-af76-00a024ffc08c"

#define NS_ISCROLLABLE_IID \
  {0x61792520, 0x82c2, 0x11d3, \
    { 0xaf, 0x76, 0x00, 0xa0, 0x24, 0xff, 0xc0, 0x8c }}

/**
 * The nsIScrollable is an interface that can be implemented by a control that
 * supports scrolling.  This is a generic interface without concern for the 
 * type of content that may be inside.  It simply deals blindly with scroll
 * position as a composite of the lowest possible scroll position, the highest
 * possible position and the current position lying somewhere between the 
 * min and the max. 
 */
class NS_NO_VTABLE nsIScrollable : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISCROLLABLE_IID)

  enum { ScrollOrientation_Y = 1 };

  enum { ScrollOrientation_X = 2 };

  /* void getCurScrollPos (in long scrollOrientation, out long curPos); */
  NS_IMETHOD GetCurScrollPos(PRInt32 scrollOrientation, PRInt32 *curPos) = 0;

  /* void setCurScrollPos (in long scrollOrientation, in long curPos); */
  NS_IMETHOD SetCurScrollPos(PRInt32 scrollOrientation, PRInt32 curPos) = 0;

  /* void setCurScrollPosEx (in long curHorizontalPos, in long curVerticalPos); */
  NS_IMETHOD SetCurScrollPosEx(PRInt32 curHorizontalPos, PRInt32 curVerticalPos) = 0;

  /* void getScrollRange (in long scrollOrientation, out long minPos, out long maxPos); */
  NS_IMETHOD GetScrollRange(PRInt32 scrollOrientation, PRInt32 *minPos, PRInt32 *maxPos) = 0;

  /* void setScrollRange (in long scrollOrientation, in long minPos, in long maxPos); */
  NS_IMETHOD SetScrollRange(PRInt32 scrollOrientation, PRInt32 minPos, PRInt32 maxPos) = 0;

  /* void setScrollRangeEx (in long minHorizontalPos, in long maxHorizontalPos, in long minVerticalPos, in long maxVerticalPos); */
  NS_IMETHOD SetScrollRangeEx(PRInt32 minHorizontalPos, PRInt32 maxHorizontalPos, PRInt32 minVerticalPos, PRInt32 maxVerticalPos) = 0;

  enum { Scrollbar_Auto = 1 };

  enum { Scrollbar_Never = 2 };

  enum { Scrollbar_Always = 3 };

  /* void getCurrentScrollbarPreferences (in long scrollOrientation, out long scrollbarPref); */
  NS_IMETHOD GetCurrentScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 *scrollbarPref) = 0;

  /* void setCurrentScrollbarPreferences (in long scrollOrientation, in long scrollbarPref); */
  NS_IMETHOD SetCurrentScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 scrollbarPref) = 0;

  /* void getDefaultScrollbarPreferences (in long scrollOrientation, out long scrollbarPref); */
  NS_IMETHOD GetDefaultScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 *scrollbarPref) = 0;

  /* void setDefaultScrollbarPreferences (in long scrollOrientation, in long scrollbarPref); */
  NS_IMETHOD SetDefaultScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 scrollbarPref) = 0;

  /* void resetScrollbarPreferences (); */
  NS_IMETHOD ResetScrollbarPreferences(void) = 0;

  /* void getScrollbarVisibility (out boolean verticalVisible, out boolean horizontalVisible); */
  NS_IMETHOD GetScrollbarVisibility(PRBool *verticalVisible, PRBool *horizontalVisible) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISCROLLABLE \
  NS_IMETHOD GetCurScrollPos(PRInt32 scrollOrientation, PRInt32 *curPos); \
  NS_IMETHOD SetCurScrollPos(PRInt32 scrollOrientation, PRInt32 curPos); \
  NS_IMETHOD SetCurScrollPosEx(PRInt32 curHorizontalPos, PRInt32 curVerticalPos); \
  NS_IMETHOD GetScrollRange(PRInt32 scrollOrientation, PRInt32 *minPos, PRInt32 *maxPos); \
  NS_IMETHOD SetScrollRange(PRInt32 scrollOrientation, PRInt32 minPos, PRInt32 maxPos); \
  NS_IMETHOD SetScrollRangeEx(PRInt32 minHorizontalPos, PRInt32 maxHorizontalPos, PRInt32 minVerticalPos, PRInt32 maxVerticalPos); \
  NS_IMETHOD GetCurrentScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 *scrollbarPref); \
  NS_IMETHOD SetCurrentScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 scrollbarPref); \
  NS_IMETHOD GetDefaultScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 *scrollbarPref); \
  NS_IMETHOD SetDefaultScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 scrollbarPref); \
  NS_IMETHOD ResetScrollbarPreferences(void); \
  NS_IMETHOD GetScrollbarVisibility(PRBool *verticalVisible, PRBool *horizontalVisible); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISCROLLABLE(_to) \
  NS_IMETHOD GetCurScrollPos(PRInt32 scrollOrientation, PRInt32 *curPos) { return _to ## GetCurScrollPos(scrollOrientation, curPos); } \
  NS_IMETHOD SetCurScrollPos(PRInt32 scrollOrientation, PRInt32 curPos) { return _to ## SetCurScrollPos(scrollOrientation, curPos); } \
  NS_IMETHOD SetCurScrollPosEx(PRInt32 curHorizontalPos, PRInt32 curVerticalPos) { return _to ## SetCurScrollPosEx(curHorizontalPos, curVerticalPos); } \
  NS_IMETHOD GetScrollRange(PRInt32 scrollOrientation, PRInt32 *minPos, PRInt32 *maxPos) { return _to ## GetScrollRange(scrollOrientation, minPos, maxPos); } \
  NS_IMETHOD SetScrollRange(PRInt32 scrollOrientation, PRInt32 minPos, PRInt32 maxPos) { return _to ## SetScrollRange(scrollOrientation, minPos, maxPos); } \
  NS_IMETHOD SetScrollRangeEx(PRInt32 minHorizontalPos, PRInt32 maxHorizontalPos, PRInt32 minVerticalPos, PRInt32 maxVerticalPos) { return _to ## SetScrollRangeEx(minHorizontalPos, maxHorizontalPos, minVerticalPos, maxVerticalPos); } \
  NS_IMETHOD GetCurrentScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 *scrollbarPref) { return _to ## GetCurrentScrollbarPreferences(scrollOrientation, scrollbarPref); } \
  NS_IMETHOD SetCurrentScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 scrollbarPref) { return _to ## SetCurrentScrollbarPreferences(scrollOrientation, scrollbarPref); } \
  NS_IMETHOD GetDefaultScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 *scrollbarPref) { return _to ## GetDefaultScrollbarPreferences(scrollOrientation, scrollbarPref); } \
  NS_IMETHOD SetDefaultScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 scrollbarPref) { return _to ## SetDefaultScrollbarPreferences(scrollOrientation, scrollbarPref); } \
  NS_IMETHOD ResetScrollbarPreferences(void) { return _to ## ResetScrollbarPreferences(); } \
  NS_IMETHOD GetScrollbarVisibility(PRBool *verticalVisible, PRBool *horizontalVisible) { return _to ## GetScrollbarVisibility(verticalVisible, horizontalVisible); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISCROLLABLE(_to) \
  NS_IMETHOD GetCurScrollPos(PRInt32 scrollOrientation, PRInt32 *curPos) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetCurScrollPos(scrollOrientation, curPos); } \
  NS_IMETHOD SetCurScrollPos(PRInt32 scrollOrientation, PRInt32 curPos) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetCurScrollPos(scrollOrientation, curPos); } \
  NS_IMETHOD SetCurScrollPosEx(PRInt32 curHorizontalPos, PRInt32 curVerticalPos) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetCurScrollPosEx(curHorizontalPos, curVerticalPos); } \
  NS_IMETHOD GetScrollRange(PRInt32 scrollOrientation, PRInt32 *minPos, PRInt32 *maxPos) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetScrollRange(scrollOrientation, minPos, maxPos); } \
  NS_IMETHOD SetScrollRange(PRInt32 scrollOrientation, PRInt32 minPos, PRInt32 maxPos) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetScrollRange(scrollOrientation, minPos, maxPos); } \
  NS_IMETHOD SetScrollRangeEx(PRInt32 minHorizontalPos, PRInt32 maxHorizontalPos, PRInt32 minVerticalPos, PRInt32 maxVerticalPos) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetScrollRangeEx(minHorizontalPos, maxHorizontalPos, minVerticalPos, maxVerticalPos); } \
  NS_IMETHOD GetCurrentScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 *scrollbarPref) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetCurrentScrollbarPreferences(scrollOrientation, scrollbarPref); } \
  NS_IMETHOD SetCurrentScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 scrollbarPref) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetCurrentScrollbarPreferences(scrollOrientation, scrollbarPref); } \
  NS_IMETHOD GetDefaultScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 *scrollbarPref) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetDefaultScrollbarPreferences(scrollOrientation, scrollbarPref); } \
  NS_IMETHOD SetDefaultScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 scrollbarPref) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetDefaultScrollbarPreferences(scrollOrientation, scrollbarPref); } \
  NS_IMETHOD ResetScrollbarPreferences(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> ResetScrollbarPreferences(); } \
  NS_IMETHOD GetScrollbarVisibility(PRBool *verticalVisible, PRBool *horizontalVisible) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetScrollbarVisibility(verticalVisible, horizontalVisible); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsScrollable : public nsIScrollable
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISCROLLABLE

  nsScrollable();
  virtual ~nsScrollable();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsScrollable, nsIScrollable)

nsScrollable::nsScrollable()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsScrollable::~nsScrollable()
{
  /* destructor code */
}

/* void getCurScrollPos (in long scrollOrientation, out long curPos); */
NS_IMETHODIMP nsScrollable::GetCurScrollPos(PRInt32 scrollOrientation, PRInt32 *curPos)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setCurScrollPos (in long scrollOrientation, in long curPos); */
NS_IMETHODIMP nsScrollable::SetCurScrollPos(PRInt32 scrollOrientation, PRInt32 curPos)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setCurScrollPosEx (in long curHorizontalPos, in long curVerticalPos); */
NS_IMETHODIMP nsScrollable::SetCurScrollPosEx(PRInt32 curHorizontalPos, PRInt32 curVerticalPos)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getScrollRange (in long scrollOrientation, out long minPos, out long maxPos); */
NS_IMETHODIMP nsScrollable::GetScrollRange(PRInt32 scrollOrientation, PRInt32 *minPos, PRInt32 *maxPos)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setScrollRange (in long scrollOrientation, in long minPos, in long maxPos); */
NS_IMETHODIMP nsScrollable::SetScrollRange(PRInt32 scrollOrientation, PRInt32 minPos, PRInt32 maxPos)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setScrollRangeEx (in long minHorizontalPos, in long maxHorizontalPos, in long minVerticalPos, in long maxVerticalPos); */
NS_IMETHODIMP nsScrollable::SetScrollRangeEx(PRInt32 minHorizontalPos, PRInt32 maxHorizontalPos, PRInt32 minVerticalPos, PRInt32 maxVerticalPos)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getCurrentScrollbarPreferences (in long scrollOrientation, out long scrollbarPref); */
NS_IMETHODIMP nsScrollable::GetCurrentScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 *scrollbarPref)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setCurrentScrollbarPreferences (in long scrollOrientation, in long scrollbarPref); */
NS_IMETHODIMP nsScrollable::SetCurrentScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 scrollbarPref)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getDefaultScrollbarPreferences (in long scrollOrientation, out long scrollbarPref); */
NS_IMETHODIMP nsScrollable::GetDefaultScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 *scrollbarPref)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setDefaultScrollbarPreferences (in long scrollOrientation, in long scrollbarPref); */
NS_IMETHODIMP nsScrollable::SetDefaultScrollbarPreferences(PRInt32 scrollOrientation, PRInt32 scrollbarPref)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void resetScrollbarPreferences (); */
NS_IMETHODIMP nsScrollable::ResetScrollbarPreferences()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getScrollbarVisibility (out boolean verticalVisible, out boolean horizontalVisible); */
NS_IMETHODIMP nsScrollable::GetScrollbarVisibility(PRBool *verticalVisible, PRBool *horizontalVisible)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIScrollable_h__ */
