/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIProtocolHandler.idl
 */

#ifndef __gen_nsIProtocolHandler_h__
#define __gen_nsIProtocolHandler_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIChannel_h__
#include "nsIChannel.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIURI; /* forward declaration */


/* starting interface:    nsIProtocolHandler */
#define NS_IPROTOCOLHANDLER_IID_STR "15fd6940-8ea7-11d3-93ad-00104ba0fd40"

#define NS_IPROTOCOLHANDLER_IID \
  {0x15fd6940, 0x8ea7, 0x11d3, \
    { 0x93, 0xad, 0x00, 0x10, 0x4b, 0xa0, 0xfd, 0x40 }}

class NS_NO_VTABLE nsIProtocolHandler : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IPROTOCOLHANDLER_IID)

  /* readonly attribute string scheme; */
  NS_IMETHOD GetScheme(char * *aScheme) = 0;

  /** 
	 * Default Port will be the port that this protocol normally
	 * uses.  If a port does not make sense for the protocol (eg about://)
	 * -1 will be returned.
	 */
  /* readonly attribute long defaultPort; */
  NS_IMETHOD GetDefaultPort(PRInt32 *aDefaultPort) = 0;

  /**
     * Makes a URI object that is suitable for loading by this protocol.
     * In the usual case (when only the accessors provided by nsIURI are 
     * needed), this method just constructs a standard URI using the
     * component manager with kStandardURLCID.  aBaseURI may be nsnull.
     */
  /* nsIURI newURI (in string aSpec, in nsIURI aBaseURI); */
  NS_IMETHOD NewURI(const char *aSpec, nsIURI *aBaseURI, nsIURI **_retval) = 0;

  /**
     * Constructs a new channel for this protocol handler. 
     *
     * @param originalURI - Specifies the original URI which caused the creation
     * of this channel. This can occur when the construction of one channel
     * (e.g. for resource:) causes another channel to be created on its behalf
     * (e.g. a file: channel), or if a redirect occurs, causing the current
     * URL to become different from the original URL. If NULL, the aURI parameter
     * will be used as the originalURI instead.
     */
  /* nsIChannel newChannel (in nsIURI aURI); */
  NS_IMETHOD NewChannel(nsIURI *aURI, nsIChannel **_retval) = 0;

  /**
     * Allows a protocol to override blacklisted ports.
     *
     * |allowPort| will be called when there is an attempt to connect to a port 
     * that is blacklisted.  For example, for most protocols, port 25 (Simple Mail
     * Transfer) is banned.  When a url containing this "known-to-do-bad-things" 
     * port number is encountered, this function will be called to ask if the 
     * protocol handler wants to override the band.  
     */
  /* boolean allowPort (in long port, in string scheme); */
  NS_IMETHOD AllowPort(PRInt32 port, const char *scheme, PRBool *_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIPROTOCOLHANDLER \
  NS_IMETHOD GetScheme(char * *aScheme); \
  NS_IMETHOD GetDefaultPort(PRInt32 *aDefaultPort); \
  NS_IMETHOD NewURI(const char *aSpec, nsIURI *aBaseURI, nsIURI **_retval); \
  NS_IMETHOD NewChannel(nsIURI *aURI, nsIChannel **_retval); \
  NS_IMETHOD AllowPort(PRInt32 port, const char *scheme, PRBool *_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIPROTOCOLHANDLER(_to) \
  NS_IMETHOD GetScheme(char * *aScheme) { return _to ## GetScheme(aScheme); } \
  NS_IMETHOD GetDefaultPort(PRInt32 *aDefaultPort) { return _to ## GetDefaultPort(aDefaultPort); } \
  NS_IMETHOD NewURI(const char *aSpec, nsIURI *aBaseURI, nsIURI **_retval) { return _to ## NewURI(aSpec, aBaseURI, _retval); } \
  NS_IMETHOD NewChannel(nsIURI *aURI, nsIChannel **_retval) { return _to ## NewChannel(aURI, _retval); } \
  NS_IMETHOD AllowPort(PRInt32 port, const char *scheme, PRBool *_retval) { return _to ## AllowPort(port, scheme, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIPROTOCOLHANDLER(_to) \
  NS_IMETHOD GetScheme(char * *aScheme) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetScheme(aScheme); } \
  NS_IMETHOD GetDefaultPort(PRInt32 *aDefaultPort) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetDefaultPort(aDefaultPort); } \
  NS_IMETHOD NewURI(const char *aSpec, nsIURI *aBaseURI, nsIURI **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> NewURI(aSpec, aBaseURI, _retval); } \
  NS_IMETHOD NewChannel(nsIURI *aURI, nsIChannel **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> NewChannel(aURI, _retval); } \
  NS_IMETHOD AllowPort(PRInt32 port, const char *scheme, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> AllowPort(port, scheme, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsProtocolHandler : public nsIProtocolHandler
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIPROTOCOLHANDLER

  nsProtocolHandler();
  virtual ~nsProtocolHandler();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsProtocolHandler, nsIProtocolHandler)

nsProtocolHandler::nsProtocolHandler()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsProtocolHandler::~nsProtocolHandler()
{
  /* destructor code */
}

/* readonly attribute string scheme; */
NS_IMETHODIMP nsProtocolHandler::GetScheme(char * *aScheme)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long defaultPort; */
NS_IMETHODIMP nsProtocolHandler::GetDefaultPort(PRInt32 *aDefaultPort)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI newURI (in string aSpec, in nsIURI aBaseURI); */
NS_IMETHODIMP nsProtocolHandler::NewURI(const char *aSpec, nsIURI *aBaseURI, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIChannel newChannel (in nsIURI aURI); */
NS_IMETHODIMP nsProtocolHandler::NewChannel(nsIURI *aURI, nsIChannel **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean allowPort (in long port, in string scheme); */
NS_IMETHODIMP nsProtocolHandler::AllowPort(PRInt32 port, const char *scheme, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define NS_NETWORK_PROTOCOL_CONTRACTID               "@mozilla.org/network/protocol;1"
#define NS_NETWORK_PROTOCOL_CONTRACTID_PREFIX        NS_NETWORK_PROTOCOL_CONTRACTID "?name="
#define NS_NETWORK_PROTOCOL_CONTRACTID_PREFIX_LENGTH 37     // nsCRT::strlen(NS_NETWORK_PROTOCOL_CONTRACTID_PREFIX)
// Unknown Protocol Error
#define NS_ERROR_UNKNOWN_PROTOCOL  NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 18)

#endif /* __gen_nsIProtocolHandler_h__ */
