/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIOutlinerView.idl
 */

#ifndef __gen_nsIOutlinerView_h__
#define __gen_nsIOutlinerView_h__


#ifndef __gen_nsIOutlinerBoxObject_h__
#include "nsIOutlinerBoxObject.h"
#endif

#ifndef __gen_nsISupportsArray_h__
#include "nsISupportsArray.h"
#endif

#ifndef __gen_domstubs_h__
#include "domstubs.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIOutlinerSelection; /* forward declaration */


/* starting interface:    nsIOutlinerView */
#define NS_IOUTLINERVIEW_IID_STR "7660811d-3cb8-441f-8e58-466de4f3fa9a"

#define NS_IOUTLINERVIEW_IID \
  {0x7660811d, 0x3cb8, 0x441f, \
    { 0x8e, 0x58, 0x46, 0x6d, 0xe4, 0xf3, 0xfa, 0x9a }}

class NS_NO_VTABLE nsIOutlinerView : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IOUTLINERVIEW_IID)

  /** 
   * The total number of rows in the outliner (including the offscreen rows).
   */
  /* readonly attribute long rowCount; */
  NS_IMETHOD GetRowCount(PRInt32 *aRowCount) = 0;

  /**
   * The selection for this view.
   */
  /* attribute nsIOutlinerSelection selection; */
  NS_IMETHOD GetSelection(nsIOutlinerSelection * *aSelection) = 0;
  NS_IMETHOD SetSelection(nsIOutlinerSelection * aSelection) = 0;

  /** 
   * An atomized list of properties for a given row.  Each property, x, that
   * the view gives back will cause the pseudoclass :moz-outliner-row-x
   * to be matched on the pseudoelement ::moz-outliner-row.
   *
   * The special property "separator" can be returned to supply the outliner
   * with the hint that there are no cells in this row and that it should draw
   * a separator.  It uses the border properties on the separator pseudoclass
   * to draw the separator.
   */
  /* void getRowProperties (in long index, in nsISupportsArray properties); */
  NS_IMETHOD GetRowProperties(PRInt32 index, nsISupportsArray *properties) = 0;

  /** 
   * An atomized list of properties for a given cell.  Each property, x, that
   * the view gives back will cause the pseudoclass :moz-outliner-cell-x
   * to be matched on the ::moz-outliner-cell pseudoelement.
   */
  /* void getCellProperties (in long row, in wstring colID, in nsISupportsArray properties); */
  NS_IMETHOD GetCellProperties(PRInt32 row, const PRUnichar *colID, nsISupportsArray *properties) = 0;

  /** 
   * Called to get properties to paint a column background.  For shading the sort
   * column, etc.
   */
  /* void getColumnProperties (in wstring colID, in nsIDOMElement colElt, in nsISupportsArray properties); */
  NS_IMETHOD GetColumnProperties(const PRUnichar *colID, nsIDOMElement *colElt, nsISupportsArray *properties) = 0;

  /** 
   * Methods that can be used to test whether or not a twisty should be drawn,
   * and if so, whether an open or closed twisty should be used.
   */
  /* boolean isContainer (in long index); */
  NS_IMETHOD IsContainer(PRInt32 index, PRBool *_retval) = 0;

  /* boolean isContainerOpen (in long index); */
  NS_IMETHOD IsContainerOpen(PRInt32 index, PRBool *_retval) = 0;

  /* boolean isContainerEmpty (in long index); */
  NS_IMETHOD IsContainerEmpty(PRInt32 index, PRBool *_retval) = 0;

  /**
   * Specifies if there is currently a sort on any column. Used mostly by dragdrop
   * to affect drop feedback.
   */
  /* boolean isSorted (); */
  NS_IMETHOD IsSorted(PRBool *_retval) = 0;

  /**
   * Methods used by the drag feedback code to determine if a drag is allowable at
   * the current location. To get the behavior where drops are only allowed on
   * items, such as the mailNews folder pane, always return false from |canDropBeforeAfter()|.
   */
  /* boolean canDropOn (in long index); */
  NS_IMETHOD CanDropOn(PRInt32 index, PRBool *_retval) = 0;

  /* boolean canDropBeforeAfter (in long index, in boolean before); */
  NS_IMETHOD CanDropBeforeAfter(PRInt32 index, PRBool before, PRBool *_retval) = 0;

  /**
   * Called when the user drops something on this view. The |orientation| param
   * specifies before/on/after the given |row|.
   */
  enum { inDropBefore = 1 };

  enum { inDropOn = 2 };

  enum { inDropAfter = 3 };

  /* void drop (in long row, in long orientation); */
  NS_IMETHOD Drop(PRInt32 row, PRInt32 orientation) = 0;

  /** 
   * Methods used by the outliner to draw vertical lines in the tree.
   * GetParentIndex is used to obtain the index of a parent row.
   */
  /* long getParentIndex (in long rowIndex); */
  NS_IMETHOD GetParentIndex(PRInt32 rowIndex, PRInt32 *_retval) = 0;

  /** 
   * HasNextSibling is used to determine if the row at rowIndex has a nextSibling
   * that occurs *after* the index specified by afterIndex.  Code that is forced
   * to march down the view looking at levels can optimize the march by starting
   * at afterIndex+1.
   */
  /* boolean hasNextSibling (in long rowIndex, in long afterIndex); */
  NS_IMETHOD HasNextSibling(PRInt32 rowIndex, PRInt32 afterIndex, PRBool *_retval) = 0;

  /** 
   * The level is an integer value that represents
   * the level of indentation.  It is multiplied by the width specified in the 
   * :moz-outliner-indentation pseudoelement to compute the exact indendation.
   */
  /* long getLevel (in long index); */
  NS_IMETHOD GetLevel(PRInt32 index, PRInt32 *_retval) = 0;

  /** 
   * The text for a given cell.  If a column consists only of an image, then
   * the empty string is returned.  
   */
  /* wstring getCellText (in long row, in wstring colID); */
  NS_IMETHOD GetCellText(PRInt32 row, const PRUnichar *colID, PRUnichar **_retval) = 0;

  /**
   * Called during initialization to link the view to the front end box object.
   */
  /* void setOutliner (in nsIOutlinerBoxObject outliner); */
  NS_IMETHOD SetOutliner(nsIOutlinerBoxObject *outliner) = 0;

  /** 
   * Called on the view when an item is opened or closed.
   */
  /* void toggleOpenState (in long index); */
  NS_IMETHOD ToggleOpenState(PRInt32 index) = 0;

  /**
   * Called on the view when a header is clicked.
   */
  /* void cycleHeader (in wstring colID, in nsIDOMElement elt); */
  NS_IMETHOD CycleHeader(const PRUnichar *colID, nsIDOMElement *elt) = 0;

  /** 
   * Should be called from a XUL onselect handler whenever the selection changes.
   * XXX Should this be done automatically?
   */
  /* void selectionChanged (); */
  NS_IMETHOD SelectionChanged(void) = 0;

  /** 
   * Called on the view when a cell in a non-selectable cycling column (e.g., unread/flag/etc.) is clicked.
   */
  /* void cycleCell (in long row, in wstring colID); */
  NS_IMETHOD CycleCell(PRInt32 row, const PRUnichar *colID) = 0;

  /** 
   * isEditable is called to ask the view if the cell contents are editable.  
   * A value of true will result in the outliner popping up a text field when 
   * the user tries to inline edit the cell.
   */
  /* boolean isEditable (in long row, in wstring colID); */
  NS_IMETHOD IsEditable(PRInt32 row, const PRUnichar *colID, PRBool *_retval) = 0;

  /** 
   * setCellText is called when the contents of the cell have been edited by the user.
   */
  /* void setCellText (in long row, in wstring colID, in wstring value); */
  NS_IMETHOD SetCellText(PRInt32 row, const PRUnichar *colID, const PRUnichar *value) = 0;

  /** 
   * A command API that can be used to invoke commands on the selection.  The outliner
   * will automatically invoke this method when certain keys are pressed.  For example,
   * when the DEL key is pressed, performAction will be called with the "delete" string.
   */
  /* void performAction (in wstring action); */
  NS_IMETHOD PerformAction(const PRUnichar *action) = 0;

  /** 
   * A command API that can be used to invoke commands on a specific row.
   */
  /* void performActionOnRow (in wstring action, in long row); */
  NS_IMETHOD PerformActionOnRow(const PRUnichar *action, PRInt32 row) = 0;

  /** 
   * A command API that can be used to invoke commands on a specific cell.
   */
  /* void performActionOnCell (in wstring action, in long row, in wstring colID); */
  NS_IMETHOD PerformActionOnCell(const PRUnichar *action, PRInt32 row, const PRUnichar *colID) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIOUTLINERVIEW \
  NS_IMETHOD GetRowCount(PRInt32 *aRowCount); \
  NS_IMETHOD GetSelection(nsIOutlinerSelection * *aSelection); \
  NS_IMETHOD SetSelection(nsIOutlinerSelection * aSelection); \
  NS_IMETHOD GetRowProperties(PRInt32 index, nsISupportsArray *properties); \
  NS_IMETHOD GetCellProperties(PRInt32 row, const PRUnichar *colID, nsISupportsArray *properties); \
  NS_IMETHOD GetColumnProperties(const PRUnichar *colID, nsIDOMElement *colElt, nsISupportsArray *properties); \
  NS_IMETHOD IsContainer(PRInt32 index, PRBool *_retval); \
  NS_IMETHOD IsContainerOpen(PRInt32 index, PRBool *_retval); \
  NS_IMETHOD IsContainerEmpty(PRInt32 index, PRBool *_retval); \
  NS_IMETHOD IsSorted(PRBool *_retval); \
  NS_IMETHOD CanDropOn(PRInt32 index, PRBool *_retval); \
  NS_IMETHOD CanDropBeforeAfter(PRInt32 index, PRBool before, PRBool *_retval); \
  NS_IMETHOD Drop(PRInt32 row, PRInt32 orientation); \
  NS_IMETHOD GetParentIndex(PRInt32 rowIndex, PRInt32 *_retval); \
  NS_IMETHOD HasNextSibling(PRInt32 rowIndex, PRInt32 afterIndex, PRBool *_retval); \
  NS_IMETHOD GetLevel(PRInt32 index, PRInt32 *_retval); \
  NS_IMETHOD GetCellText(PRInt32 row, const PRUnichar *colID, PRUnichar **_retval); \
  NS_IMETHOD SetOutliner(nsIOutlinerBoxObject *outliner); \
  NS_IMETHOD ToggleOpenState(PRInt32 index); \
  NS_IMETHOD CycleHeader(const PRUnichar *colID, nsIDOMElement *elt); \
  NS_IMETHOD SelectionChanged(void); \
  NS_IMETHOD CycleCell(PRInt32 row, const PRUnichar *colID); \
  NS_IMETHOD IsEditable(PRInt32 row, const PRUnichar *colID, PRBool *_retval); \
  NS_IMETHOD SetCellText(PRInt32 row, const PRUnichar *colID, const PRUnichar *value); \
  NS_IMETHOD PerformAction(const PRUnichar *action); \
  NS_IMETHOD PerformActionOnRow(const PRUnichar *action, PRInt32 row); \
  NS_IMETHOD PerformActionOnCell(const PRUnichar *action, PRInt32 row, const PRUnichar *colID); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIOUTLINERVIEW(_to) \
  NS_IMETHOD GetRowCount(PRInt32 *aRowCount) { return _to ## GetRowCount(aRowCount); } \
  NS_IMETHOD GetSelection(nsIOutlinerSelection * *aSelection) { return _to ## GetSelection(aSelection); } \
  NS_IMETHOD SetSelection(nsIOutlinerSelection * aSelection) { return _to ## SetSelection(aSelection); } \
  NS_IMETHOD GetRowProperties(PRInt32 index, nsISupportsArray *properties) { return _to ## GetRowProperties(index, properties); } \
  NS_IMETHOD GetCellProperties(PRInt32 row, const PRUnichar *colID, nsISupportsArray *properties) { return _to ## GetCellProperties(row, colID, properties); } \
  NS_IMETHOD GetColumnProperties(const PRUnichar *colID, nsIDOMElement *colElt, nsISupportsArray *properties) { return _to ## GetColumnProperties(colID, colElt, properties); } \
  NS_IMETHOD IsContainer(PRInt32 index, PRBool *_retval) { return _to ## IsContainer(index, _retval); } \
  NS_IMETHOD IsContainerOpen(PRInt32 index, PRBool *_retval) { return _to ## IsContainerOpen(index, _retval); } \
  NS_IMETHOD IsContainerEmpty(PRInt32 index, PRBool *_retval) { return _to ## IsContainerEmpty(index, _retval); } \
  NS_IMETHOD IsSorted(PRBool *_retval) { return _to ## IsSorted(_retval); } \
  NS_IMETHOD CanDropOn(PRInt32 index, PRBool *_retval) { return _to ## CanDropOn(index, _retval); } \
  NS_IMETHOD CanDropBeforeAfter(PRInt32 index, PRBool before, PRBool *_retval) { return _to ## CanDropBeforeAfter(index, before, _retval); } \
  NS_IMETHOD Drop(PRInt32 row, PRInt32 orientation) { return _to ## Drop(row, orientation); } \
  NS_IMETHOD GetParentIndex(PRInt32 rowIndex, PRInt32 *_retval) { return _to ## GetParentIndex(rowIndex, _retval); } \
  NS_IMETHOD HasNextSibling(PRInt32 rowIndex, PRInt32 afterIndex, PRBool *_retval) { return _to ## HasNextSibling(rowIndex, afterIndex, _retval); } \
  NS_IMETHOD GetLevel(PRInt32 index, PRInt32 *_retval) { return _to ## GetLevel(index, _retval); } \
  NS_IMETHOD GetCellText(PRInt32 row, const PRUnichar *colID, PRUnichar **_retval) { return _to ## GetCellText(row, colID, _retval); } \
  NS_IMETHOD SetOutliner(nsIOutlinerBoxObject *outliner) { return _to ## SetOutliner(outliner); } \
  NS_IMETHOD ToggleOpenState(PRInt32 index) { return _to ## ToggleOpenState(index); } \
  NS_IMETHOD CycleHeader(const PRUnichar *colID, nsIDOMElement *elt) { return _to ## CycleHeader(colID, elt); } \
  NS_IMETHOD SelectionChanged(void) { return _to ## SelectionChanged(); } \
  NS_IMETHOD CycleCell(PRInt32 row, const PRUnichar *colID) { return _to ## CycleCell(row, colID); } \
  NS_IMETHOD IsEditable(PRInt32 row, const PRUnichar *colID, PRBool *_retval) { return _to ## IsEditable(row, colID, _retval); } \
  NS_IMETHOD SetCellText(PRInt32 row, const PRUnichar *colID, const PRUnichar *value) { return _to ## SetCellText(row, colID, value); } \
  NS_IMETHOD PerformAction(const PRUnichar *action) { return _to ## PerformAction(action); } \
  NS_IMETHOD PerformActionOnRow(const PRUnichar *action, PRInt32 row) { return _to ## PerformActionOnRow(action, row); } \
  NS_IMETHOD PerformActionOnCell(const PRUnichar *action, PRInt32 row, const PRUnichar *colID) { return _to ## PerformActionOnCell(action, row, colID); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIOUTLINERVIEW(_to) \
  NS_IMETHOD GetRowCount(PRInt32 *aRowCount) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetRowCount(aRowCount); } \
  NS_IMETHOD GetSelection(nsIOutlinerSelection * *aSelection) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetSelection(aSelection); } \
  NS_IMETHOD SetSelection(nsIOutlinerSelection * aSelection) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetSelection(aSelection); } \
  NS_IMETHOD GetRowProperties(PRInt32 index, nsISupportsArray *properties) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetRowProperties(index, properties); } \
  NS_IMETHOD GetCellProperties(PRInt32 row, const PRUnichar *colID, nsISupportsArray *properties) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetCellProperties(row, colID, properties); } \
  NS_IMETHOD GetColumnProperties(const PRUnichar *colID, nsIDOMElement *colElt, nsISupportsArray *properties) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetColumnProperties(colID, colElt, properties); } \
  NS_IMETHOD IsContainer(PRInt32 index, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsContainer(index, _retval); } \
  NS_IMETHOD IsContainerOpen(PRInt32 index, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsContainerOpen(index, _retval); } \
  NS_IMETHOD IsContainerEmpty(PRInt32 index, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsContainerEmpty(index, _retval); } \
  NS_IMETHOD IsSorted(PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsSorted(_retval); } \
  NS_IMETHOD CanDropOn(PRInt32 index, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CanDropOn(index, _retval); } \
  NS_IMETHOD CanDropBeforeAfter(PRInt32 index, PRBool before, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CanDropBeforeAfter(index, before, _retval); } \
  NS_IMETHOD Drop(PRInt32 row, PRInt32 orientation) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Drop(row, orientation); } \
  NS_IMETHOD GetParentIndex(PRInt32 rowIndex, PRInt32 *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetParentIndex(rowIndex, _retval); } \
  NS_IMETHOD HasNextSibling(PRInt32 rowIndex, PRInt32 afterIndex, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> HasNextSibling(rowIndex, afterIndex, _retval); } \
  NS_IMETHOD GetLevel(PRInt32 index, PRInt32 *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetLevel(index, _retval); } \
  NS_IMETHOD GetCellText(PRInt32 row, const PRUnichar *colID, PRUnichar **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetCellText(row, colID, _retval); } \
  NS_IMETHOD SetOutliner(nsIOutlinerBoxObject *outliner) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetOutliner(outliner); } \
  NS_IMETHOD ToggleOpenState(PRInt32 index) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> ToggleOpenState(index); } \
  NS_IMETHOD CycleHeader(const PRUnichar *colID, nsIDOMElement *elt) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CycleHeader(colID, elt); } \
  NS_IMETHOD SelectionChanged(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SelectionChanged(); } \
  NS_IMETHOD CycleCell(PRInt32 row, const PRUnichar *colID) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CycleCell(row, colID); } \
  NS_IMETHOD IsEditable(PRInt32 row, const PRUnichar *colID, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsEditable(row, colID, _retval); } \
  NS_IMETHOD SetCellText(PRInt32 row, const PRUnichar *colID, const PRUnichar *value) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetCellText(row, colID, value); } \
  NS_IMETHOD PerformAction(const PRUnichar *action) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> PerformAction(action); } \
  NS_IMETHOD PerformActionOnRow(const PRUnichar *action, PRInt32 row) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> PerformActionOnRow(action, row); } \
  NS_IMETHOD PerformActionOnCell(const PRUnichar *action, PRInt32 row, const PRUnichar *colID) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> PerformActionOnCell(action, row, colID); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsOutlinerView : public nsIOutlinerView
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIOUTLINERVIEW

  nsOutlinerView();
  virtual ~nsOutlinerView();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsOutlinerView, nsIOutlinerView)

nsOutlinerView::nsOutlinerView()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsOutlinerView::~nsOutlinerView()
{
  /* destructor code */
}

/* readonly attribute long rowCount; */
NS_IMETHODIMP nsOutlinerView::GetRowCount(PRInt32 *aRowCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIOutlinerSelection selection; */
NS_IMETHODIMP nsOutlinerView::GetSelection(nsIOutlinerSelection * *aSelection)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsOutlinerView::SetSelection(nsIOutlinerSelection * aSelection)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getRowProperties (in long index, in nsISupportsArray properties); */
NS_IMETHODIMP nsOutlinerView::GetRowProperties(PRInt32 index, nsISupportsArray *properties)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getCellProperties (in long row, in wstring colID, in nsISupportsArray properties); */
NS_IMETHODIMP nsOutlinerView::GetCellProperties(PRInt32 row, const PRUnichar *colID, nsISupportsArray *properties)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getColumnProperties (in wstring colID, in nsIDOMElement colElt, in nsISupportsArray properties); */
NS_IMETHODIMP nsOutlinerView::GetColumnProperties(const PRUnichar *colID, nsIDOMElement *colElt, nsISupportsArray *properties)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isContainer (in long index); */
NS_IMETHODIMP nsOutlinerView::IsContainer(PRInt32 index, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isContainerOpen (in long index); */
NS_IMETHODIMP nsOutlinerView::IsContainerOpen(PRInt32 index, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isContainerEmpty (in long index); */
NS_IMETHODIMP nsOutlinerView::IsContainerEmpty(PRInt32 index, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isSorted (); */
NS_IMETHODIMP nsOutlinerView::IsSorted(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean canDropOn (in long index); */
NS_IMETHODIMP nsOutlinerView::CanDropOn(PRInt32 index, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean canDropBeforeAfter (in long index, in boolean before); */
NS_IMETHODIMP nsOutlinerView::CanDropBeforeAfter(PRInt32 index, PRBool before, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void drop (in long row, in long orientation); */
NS_IMETHODIMP nsOutlinerView::Drop(PRInt32 row, PRInt32 orientation)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getParentIndex (in long rowIndex); */
NS_IMETHODIMP nsOutlinerView::GetParentIndex(PRInt32 rowIndex, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean hasNextSibling (in long rowIndex, in long afterIndex); */
NS_IMETHODIMP nsOutlinerView::HasNextSibling(PRInt32 rowIndex, PRInt32 afterIndex, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getLevel (in long index); */
NS_IMETHODIMP nsOutlinerView::GetLevel(PRInt32 index, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring getCellText (in long row, in wstring colID); */
NS_IMETHODIMP nsOutlinerView::GetCellText(PRInt32 row, const PRUnichar *colID, PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setOutliner (in nsIOutlinerBoxObject outliner); */
NS_IMETHODIMP nsOutlinerView::SetOutliner(nsIOutlinerBoxObject *outliner)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void toggleOpenState (in long index); */
NS_IMETHODIMP nsOutlinerView::ToggleOpenState(PRInt32 index)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void cycleHeader (in wstring colID, in nsIDOMElement elt); */
NS_IMETHODIMP nsOutlinerView::CycleHeader(const PRUnichar *colID, nsIDOMElement *elt)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void selectionChanged (); */
NS_IMETHODIMP nsOutlinerView::SelectionChanged()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void cycleCell (in long row, in wstring colID); */
NS_IMETHODIMP nsOutlinerView::CycleCell(PRInt32 row, const PRUnichar *colID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isEditable (in long row, in wstring colID); */
NS_IMETHODIMP nsOutlinerView::IsEditable(PRInt32 row, const PRUnichar *colID, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setCellText (in long row, in wstring colID, in wstring value); */
NS_IMETHODIMP nsOutlinerView::SetCellText(PRInt32 row, const PRUnichar *colID, const PRUnichar *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void performAction (in wstring action); */
NS_IMETHODIMP nsOutlinerView::PerformAction(const PRUnichar *action)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void performActionOnRow (in wstring action, in long row); */
NS_IMETHODIMP nsOutlinerView::PerformActionOnRow(const PRUnichar *action, PRInt32 row)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void performActionOnCell (in wstring action, in long row, in wstring colID); */
NS_IMETHODIMP nsOutlinerView::PerformActionOnCell(const PRUnichar *action, PRInt32 row, const PRUnichar *colID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

// Initializer,

#endif /* __gen_nsIOutlinerView_h__ */
