/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIFile.idl
 */

#ifndef __gen_nsIFile_h__
#define __gen_nsIFile_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsISimpleEnumerator; /* forward declaration */


/* starting interface:    nsIFile */
#define NS_IFILE_IID_STR "c8c0a080-0868-11d3-915f-d9d889d48e3c"

#define NS_IFILE_IID \
  {0xc8c0a080, 0x0868, 0x11d3, \
    { 0x91, 0x5f, 0xd9, 0xd8, 0x89, 0xd4, 0x8e, 0x3c }}

class NS_NO_VTABLE nsIFile : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IFILE_IID)

  /**
     *   Create Types
     *
     *   NORMAL_FILE_TYPE - A normal file.
     *   DIRECTORY_TYPE   - A directory/folder.
     */
  enum { NORMAL_FILE_TYPE = 0U };

  enum { DIRECTORY_TYPE = 1U };

  /**
     *  appendPath
     *
     *  This function is used for constructing a descendant of the
     *  current nsIFile.
     *
     *  @param relativePath
     *      A string which is intented to be a child node of the
     *      nsIFile.
     */
  /* void append ([const] in string node); */
  NS_IMETHOD Append(const char *node) = 0;

  /* void appendUnicode ([const] in wstring node); */
  NS_IMETHOD AppendUnicode(const PRUnichar *node) = 0;

  /**
     * Normalize the pathName (e.g. removing .. and . components on Unix).
     */
  /* void normalize (); */
  NS_IMETHOD Normalize(void) = 0;

  /**
     *  create
     *
     *  This function will create a new file or directory in the
     *  file system. Any nodes that have not been created or
     *  resolved, will be.  If the file or directory already
     *  exists create() will return NS_ERROR_FILE_ALREADY_EXISTS.
     *
     *   @param type
     *       This specifies the type of file system object
     *       to be made.  The only two types at this time
     *       are file and directory which are defined above.
     *       If the type is unrecongnized, we will return an
     *       error (NS_ERROR_FILE_UNKNOWN_TYPE).
     *
     *   @param permissions
     *       The unix style octal permissions.  This may
     *       be ignored on systems that do not need to do
     *       permissions.
     */
  /* void create (in unsigned long type, in unsigned long permissions); */
  NS_IMETHOD Create(PRUint32 type, PRUint32 permissions) = 0;

  /**
     *   Accessor to the leaf name of the file itself.
     */
  /* attribute string leafName; */
  NS_IMETHOD GetLeafName(char * *aLeafName) = 0;
  NS_IMETHOD SetLeafName(const char * aLeafName) = 0;

  /* attribute wstring unicodeLeafName; */
  NS_IMETHOD GetUnicodeLeafName(PRUnichar * *aUnicodeLeafName) = 0;
  NS_IMETHOD SetUnicodeLeafName(const PRUnichar * aUnicodeLeafName) = 0;

  /**
     *  copyTo
     *
     *  This will copy this file to the specified newParentDir.
     *  If a newName is specified, the file will be renamed.
     *  If 'this' is not created we will return an error
     *  (NS_ERROR_FILE_TARGET_DOES_NOT_EXIST).
     *
     *  copyTo will NOT resolve aliases/shortcuts during the copy.
     *
     *   @param newParentDir
     *       This param is the destination directory. If the
     *       newParentDir is null, copyTo() will use the parent
     *       directory of this file. If the newParentDir is not
     *       null and is not a directory, an error will be
     *       returned (NS_ERROR_FILE_DESTINATION_NOT_DIR)
     *
     *   @param newName
     *       This param allows you to specify a new name for
     *       the file to be copied. This param may be null, in
     *       which case the current leaf name will be used.
     *
     */
  /* void copyTo (in nsIFile newParentDir, [const] in string newName); */
  NS_IMETHOD CopyTo(nsIFile *newParentDir, const char *newName) = 0;

  /* void copyToUnicode (in nsIFile newParentDir, [const] in wstring newName); */
  NS_IMETHOD CopyToUnicode(nsIFile *newParentDir, const PRUnichar *newName) = 0;

  /**
     *  copyToFollowingLinks
     *
     *  This function is identical to copyTo except it, as
     *  the name implies, follows symbolic links.  Some OSes
     *  such as Unix and Linux always follow symbolic links
     *  when copying.
     */
  /* void copyToFollowingLinks (in nsIFile newParentDir, [const] in string newName); */
  NS_IMETHOD CopyToFollowingLinks(nsIFile *newParentDir, const char *newName) = 0;

  /* void copyToFollowingLinksUnicode (in nsIFile newParentDir, [const] in wstring newName); */
  NS_IMETHOD CopyToFollowingLinksUnicode(nsIFile *newParentDir, const PRUnichar *newName) = 0;

  /**
     *  moveTo
     *
     *  This will move this file to the specified newParentDir.
     *  If a newName is specified, the file will be renamed.
     *  If 'this' is not created we will return an error
     *  (NS_ERROR_FILE_TARGET_DOES_NOT_EXIST).
     *
     *  moveTo will NOT resolve aliases/shortcuts during the copy.
     *  moveTo will do the right thing and allow copies across
     *  volumes.
     *
     *   @param newParentDir
     *       This param is the destination directory. If the
     *       newParentDir is null, moveTo() will rename the file
     *       within its current directory. If the newParentDir is
     *       not null and does not name a directory, an error will
     *       be returned (NS_ERROR_FILE_DESTINATION_NOT_DIR)
     *
     *   @param newName
     *       This param allows you to specify a new name for
     *       the file to be moved. This param may be null, in
     *       which case the current leaf name will be used.
     *
     */
  /* void moveTo (in nsIFile newParentDir, [const] in string newName); */
  NS_IMETHOD MoveTo(nsIFile *newParentDir, const char *newName) = 0;

  /* void moveToUnicode (in nsIFile newParentDir, [const] in wstring newName); */
  NS_IMETHOD MoveToUnicode(nsIFile *newParentDir, const PRUnichar *newName) = 0;

  /**
     *  This will try to execute this file.  It will not block for
     *  execution.  'args' will be passed through on the command line
     *  if the OS supports that.
     */
  /* void spawn ([array, size_is (count)] in string args, in unsigned long count); */
  NS_IMETHOD Spawn(const char **args, PRUint32 count) = 0;

  /**
     *  This will try to delete this file.  The 'recursive' flag
     *  must be PR_TRUE to delete directories which are not empty.
     *
     *  This will not resolve any symlinks.
     */
  /* void delete (in boolean recursive); */
  NS_IMETHOD Delete(PRBool recursive) = 0;

  /**
     *  Attributes of nsIFile.
     */
  /* attribute unsigned long permissions; */
  NS_IMETHOD GetPermissions(PRUint32 *aPermissions) = 0;
  NS_IMETHOD SetPermissions(PRUint32 aPermissions) = 0;

  /* attribute unsigned long permissionsOfLink; */
  NS_IMETHOD GetPermissionsOfLink(PRUint32 *aPermissionsOfLink) = 0;
  NS_IMETHOD SetPermissionsOfLink(PRUint32 aPermissionsOfLink) = 0;

  /**
     *  File Times are to be in milliseconds from
     *  midnight (00:00:00), January 1, 1970 Greenwich Mean
     *  Time (GMT).
     */
  /* attribute PRInt64 lastModificationDate; */
  NS_IMETHOD GetLastModificationDate(PRInt64 *aLastModificationDate) = 0;
  NS_IMETHOD SetLastModificationDate(PRInt64 aLastModificationDate) = 0;

  /* attribute PRInt64 lastModificationDateOfLink; */
  NS_IMETHOD GetLastModificationDateOfLink(PRInt64 *aLastModificationDateOfLink) = 0;
  NS_IMETHOD SetLastModificationDateOfLink(PRInt64 aLastModificationDateOfLink) = 0;

  /**
     * WARNING!  On the Mac getting/setting the file size with nsIFile
     * only deals with the size of the data fork.  If you need to
     * know the size of the combined data and resource forks use the
     * GetFileSizeWithResFork() method defined in nsILocalFileMac.h
     */
  /* attribute PRInt64 fileSize; */
  NS_IMETHOD GetFileSize(PRInt64 *aFileSize) = 0;
  NS_IMETHOD SetFileSize(PRInt64 aFileSize) = 0;

  /* readonly attribute PRInt64 fileSizeOfLink; */
  NS_IMETHOD GetFileSizeOfLink(PRInt64 *aFileSizeOfLink) = 0;

  /**
     *  target & path
     *
     *  Accessor to the string path.  These strings are
     *  not guaranteed to be a usable path to pass to NSPR
     *  or the C stdlib.  There are problems that affect
     *  platforms on which a path does not fully specify a
     *  file, because two volumes can have the same name.
     *  This is solved by holding "private", native data in
     *  the nsIFile implementation.  This native data is lost
     *  when you convert to a string.
     *
     *      DO NOT PASS TO USE WITH NSPR OR STDLIB.
     *
     *  target:
     *      Find out what the symlink points at.  Will give error
     *      (NS_ERROR_FILE_INVALID_PATH) if not a symlink.
     *
     *  path:
     *      Find out what the nsIFile points at.
     */
  /* readonly attribute string target; */
  NS_IMETHOD GetTarget(char * *aTarget) = 0;

  /* readonly attribute wstring unicodeTarget; */
  NS_IMETHOD GetUnicodeTarget(PRUnichar * *aUnicodeTarget) = 0;

  /* readonly attribute string path; */
  NS_IMETHOD GetPath(char * *aPath) = 0;

  /* readonly attribute wstring unicodePath; */
  NS_IMETHOD GetUnicodePath(PRUnichar * *aUnicodePath) = 0;

  /* boolean exists (); */
  NS_IMETHOD Exists(PRBool *_retval) = 0;

  /* boolean isWritable (); */
  NS_IMETHOD IsWritable(PRBool *_retval) = 0;

  /* boolean isReadable (); */
  NS_IMETHOD IsReadable(PRBool *_retval) = 0;

  /* boolean isExecutable (); */
  NS_IMETHOD IsExecutable(PRBool *_retval) = 0;

  /* boolean isHidden (); */
  NS_IMETHOD IsHidden(PRBool *_retval) = 0;

  /* boolean isDirectory (); */
  NS_IMETHOD IsDirectory(PRBool *_retval) = 0;

  /* boolean isFile (); */
  NS_IMETHOD IsFile(PRBool *_retval) = 0;

  /* boolean isSymlink (); */
  NS_IMETHOD IsSymlink(PRBool *_retval) = 0;

  /**
     * Not a regular file, not a directory, not a symlink.
     */
  /* boolean isSpecial (); */
  NS_IMETHOD IsSpecial(PRBool *_retval) = 0;

  /**
     *  createUnique
     *  
     *  This function will create a new file or directory in the
     *  file system. Any nodes that have not been created or
     *  resolved, will be.  If this file already exists, we try
     *  variations on the leaf name "suggestedName" until we find
     *  one that did not already exist.
     *
     *  If the search for nonexistent files takes too long
     *  (thousands of the variants already exist), we give up and
     *  return NS_ERROR_FILE_TOO_BIG.
     *
     *   @param type
     *       This specifies the type of file system object
     *       to be made.  The only two types at this time
     *       are file and directory which are defined above.
     *       If the type is unrecongnized, we will return an
     *       error (NS_ERROR_FILE_UNKNOWN_TYPE).
     *
     *   @param permissions
     *       The unix style octal permissions.  This may
     *       be ignored on systems that do not need to do
     *       permissions.
     */
  /* void createUnique (in string suggestedName, in unsigned long type, in unsigned long permissions); */
  NS_IMETHOD CreateUnique(const char *suggestedName, PRUint32 type, PRUint32 permissions) = 0;

  /**
      * clone()
      *
      * This function will allocate and initialize a nsIFile object to the
      * exact location of the |this| nsIFile.
      *
      *   @param file
      *          A nsIFile which this object will be initialize
      *          with.
      *
      */
  /* nsIFile clone (); */
  NS_IMETHOD Clone(nsIFile **_retval) = 0;

  /**
     *  Will determine if the inFile equals this.
     */
  /* boolean equals (in nsIFile inFile); */
  NS_IMETHOD Equals(nsIFile *inFile, PRBool *_retval) = 0;

  /**
     * Will determine if inFile is a descendant of this file
     * If |recur| is true, look in subdirectories too
     */
  /* boolean contains (in nsIFile inFile, in boolean recur); */
  NS_IMETHOD Contains(nsIFile *inFile, PRBool recur, PRBool *_retval) = 0;

  /**
     * Parent will be null when this is at the top of the volume.
     */
  /* readonly attribute nsIFile parent; */
  NS_IMETHOD GetParent(nsIFile * *aParent) = 0;

  /**
     * Returns an enumeration of the elements in a directory. Each
     * element in the enumeration is an nsIFile.
     *
     *   @return NS_ERROR_FILE_NOT_DIRECTORY if the current nsIFile does
     *           not specify a directory.
     */
  /* readonly attribute nsISimpleEnumerator directoryEntries; */
  NS_IMETHOD GetDirectoryEntries(nsISimpleEnumerator * *aDirectoryEntries) = 0;

  /**
     * Accesses the file: url for the nsIFile. Setting this causes the path
     * to be reset.
     */
  /* attribute string URL; */
  NS_IMETHOD GetURL(char * *aURL) = 0;
  NS_IMETHOD SetURL(const char * aURL) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIFILE \
  NS_IMETHOD Append(const char *node); \
  NS_IMETHOD AppendUnicode(const PRUnichar *node); \
  NS_IMETHOD Normalize(void); \
  NS_IMETHOD Create(PRUint32 type, PRUint32 permissions); \
  NS_IMETHOD GetLeafName(char * *aLeafName); \
  NS_IMETHOD SetLeafName(const char * aLeafName); \
  NS_IMETHOD GetUnicodeLeafName(PRUnichar * *aUnicodeLeafName); \
  NS_IMETHOD SetUnicodeLeafName(const PRUnichar * aUnicodeLeafName); \
  NS_IMETHOD CopyTo(nsIFile *newParentDir, const char *newName); \
  NS_IMETHOD CopyToUnicode(nsIFile *newParentDir, const PRUnichar *newName); \
  NS_IMETHOD CopyToFollowingLinks(nsIFile *newParentDir, const char *newName); \
  NS_IMETHOD CopyToFollowingLinksUnicode(nsIFile *newParentDir, const PRUnichar *newName); \
  NS_IMETHOD MoveTo(nsIFile *newParentDir, const char *newName); \
  NS_IMETHOD MoveToUnicode(nsIFile *newParentDir, const PRUnichar *newName); \
  NS_IMETHOD Spawn(const char **args, PRUint32 count); \
  NS_IMETHOD Delete(PRBool recursive); \
  NS_IMETHOD GetPermissions(PRUint32 *aPermissions); \
  NS_IMETHOD SetPermissions(PRUint32 aPermissions); \
  NS_IMETHOD GetPermissionsOfLink(PRUint32 *aPermissionsOfLink); \
  NS_IMETHOD SetPermissionsOfLink(PRUint32 aPermissionsOfLink); \
  NS_IMETHOD GetLastModificationDate(PRInt64 *aLastModificationDate); \
  NS_IMETHOD SetLastModificationDate(PRInt64 aLastModificationDate); \
  NS_IMETHOD GetLastModificationDateOfLink(PRInt64 *aLastModificationDateOfLink); \
  NS_IMETHOD SetLastModificationDateOfLink(PRInt64 aLastModificationDateOfLink); \
  NS_IMETHOD GetFileSize(PRInt64 *aFileSize); \
  NS_IMETHOD SetFileSize(PRInt64 aFileSize); \
  NS_IMETHOD GetFileSizeOfLink(PRInt64 *aFileSizeOfLink); \
  NS_IMETHOD GetTarget(char * *aTarget); \
  NS_IMETHOD GetUnicodeTarget(PRUnichar * *aUnicodeTarget); \
  NS_IMETHOD GetPath(char * *aPath); \
  NS_IMETHOD GetUnicodePath(PRUnichar * *aUnicodePath); \
  NS_IMETHOD Exists(PRBool *_retval); \
  NS_IMETHOD IsWritable(PRBool *_retval); \
  NS_IMETHOD IsReadable(PRBool *_retval); \
  NS_IMETHOD IsExecutable(PRBool *_retval); \
  NS_IMETHOD IsHidden(PRBool *_retval); \
  NS_IMETHOD IsDirectory(PRBool *_retval); \
  NS_IMETHOD IsFile(PRBool *_retval); \
  NS_IMETHOD IsSymlink(PRBool *_retval); \
  NS_IMETHOD IsSpecial(PRBool *_retval); \
  NS_IMETHOD CreateUnique(const char *suggestedName, PRUint32 type, PRUint32 permissions); \
  NS_IMETHOD Clone(nsIFile **_retval); \
  NS_IMETHOD Equals(nsIFile *inFile, PRBool *_retval); \
  NS_IMETHOD Contains(nsIFile *inFile, PRBool recur, PRBool *_retval); \
  NS_IMETHOD GetParent(nsIFile * *aParent); \
  NS_IMETHOD GetDirectoryEntries(nsISimpleEnumerator * *aDirectoryEntries); \
  NS_IMETHOD GetURL(char * *aURL); \
  NS_IMETHOD SetURL(const char * aURL); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIFILE(_to) \
  NS_IMETHOD Append(const char *node) { return _to ## Append(node); } \
  NS_IMETHOD AppendUnicode(const PRUnichar *node) { return _to ## AppendUnicode(node); } \
  NS_IMETHOD Normalize(void) { return _to ## Normalize(); } \
  NS_IMETHOD Create(PRUint32 type, PRUint32 permissions) { return _to ## Create(type, permissions); } \
  NS_IMETHOD GetLeafName(char * *aLeafName) { return _to ## GetLeafName(aLeafName); } \
  NS_IMETHOD SetLeafName(const char * aLeafName) { return _to ## SetLeafName(aLeafName); } \
  NS_IMETHOD GetUnicodeLeafName(PRUnichar * *aUnicodeLeafName) { return _to ## GetUnicodeLeafName(aUnicodeLeafName); } \
  NS_IMETHOD SetUnicodeLeafName(const PRUnichar * aUnicodeLeafName) { return _to ## SetUnicodeLeafName(aUnicodeLeafName); } \
  NS_IMETHOD CopyTo(nsIFile *newParentDir, const char *newName) { return _to ## CopyTo(newParentDir, newName); } \
  NS_IMETHOD CopyToUnicode(nsIFile *newParentDir, const PRUnichar *newName) { return _to ## CopyToUnicode(newParentDir, newName); } \
  NS_IMETHOD CopyToFollowingLinks(nsIFile *newParentDir, const char *newName) { return _to ## CopyToFollowingLinks(newParentDir, newName); } \
  NS_IMETHOD CopyToFollowingLinksUnicode(nsIFile *newParentDir, const PRUnichar *newName) { return _to ## CopyToFollowingLinksUnicode(newParentDir, newName); } \
  NS_IMETHOD MoveTo(nsIFile *newParentDir, const char *newName) { return _to ## MoveTo(newParentDir, newName); } \
  NS_IMETHOD MoveToUnicode(nsIFile *newParentDir, const PRUnichar *newName) { return _to ## MoveToUnicode(newParentDir, newName); } \
  NS_IMETHOD Spawn(const char **args, PRUint32 count) { return _to ## Spawn(args, count); } \
  NS_IMETHOD Delete(PRBool recursive) { return _to ## Delete(recursive); } \
  NS_IMETHOD GetPermissions(PRUint32 *aPermissions) { return _to ## GetPermissions(aPermissions); } \
  NS_IMETHOD SetPermissions(PRUint32 aPermissions) { return _to ## SetPermissions(aPermissions); } \
  NS_IMETHOD GetPermissionsOfLink(PRUint32 *aPermissionsOfLink) { return _to ## GetPermissionsOfLink(aPermissionsOfLink); } \
  NS_IMETHOD SetPermissionsOfLink(PRUint32 aPermissionsOfLink) { return _to ## SetPermissionsOfLink(aPermissionsOfLink); } \
  NS_IMETHOD GetLastModificationDate(PRInt64 *aLastModificationDate) { return _to ## GetLastModificationDate(aLastModificationDate); } \
  NS_IMETHOD SetLastModificationDate(PRInt64 aLastModificationDate) { return _to ## SetLastModificationDate(aLastModificationDate); } \
  NS_IMETHOD GetLastModificationDateOfLink(PRInt64 *aLastModificationDateOfLink) { return _to ## GetLastModificationDateOfLink(aLastModificationDateOfLink); } \
  NS_IMETHOD SetLastModificationDateOfLink(PRInt64 aLastModificationDateOfLink) { return _to ## SetLastModificationDateOfLink(aLastModificationDateOfLink); } \
  NS_IMETHOD GetFileSize(PRInt64 *aFileSize) { return _to ## GetFileSize(aFileSize); } \
  NS_IMETHOD SetFileSize(PRInt64 aFileSize) { return _to ## SetFileSize(aFileSize); } \
  NS_IMETHOD GetFileSizeOfLink(PRInt64 *aFileSizeOfLink) { return _to ## GetFileSizeOfLink(aFileSizeOfLink); } \
  NS_IMETHOD GetTarget(char * *aTarget) { return _to ## GetTarget(aTarget); } \
  NS_IMETHOD GetUnicodeTarget(PRUnichar * *aUnicodeTarget) { return _to ## GetUnicodeTarget(aUnicodeTarget); } \
  NS_IMETHOD GetPath(char * *aPath) { return _to ## GetPath(aPath); } \
  NS_IMETHOD GetUnicodePath(PRUnichar * *aUnicodePath) { return _to ## GetUnicodePath(aUnicodePath); } \
  NS_IMETHOD Exists(PRBool *_retval) { return _to ## Exists(_retval); } \
  NS_IMETHOD IsWritable(PRBool *_retval) { return _to ## IsWritable(_retval); } \
  NS_IMETHOD IsReadable(PRBool *_retval) { return _to ## IsReadable(_retval); } \
  NS_IMETHOD IsExecutable(PRBool *_retval) { return _to ## IsExecutable(_retval); } \
  NS_IMETHOD IsHidden(PRBool *_retval) { return _to ## IsHidden(_retval); } \
  NS_IMETHOD IsDirectory(PRBool *_retval) { return _to ## IsDirectory(_retval); } \
  NS_IMETHOD IsFile(PRBool *_retval) { return _to ## IsFile(_retval); } \
  NS_IMETHOD IsSymlink(PRBool *_retval) { return _to ## IsSymlink(_retval); } \
  NS_IMETHOD IsSpecial(PRBool *_retval) { return _to ## IsSpecial(_retval); } \
  NS_IMETHOD CreateUnique(const char *suggestedName, PRUint32 type, PRUint32 permissions) { return _to ## CreateUnique(suggestedName, type, permissions); } \
  NS_IMETHOD Clone(nsIFile **_retval) { return _to ## Clone(_retval); } \
  NS_IMETHOD Equals(nsIFile *inFile, PRBool *_retval) { return _to ## Equals(inFile, _retval); } \
  NS_IMETHOD Contains(nsIFile *inFile, PRBool recur, PRBool *_retval) { return _to ## Contains(inFile, recur, _retval); } \
  NS_IMETHOD GetParent(nsIFile * *aParent) { return _to ## GetParent(aParent); } \
  NS_IMETHOD GetDirectoryEntries(nsISimpleEnumerator * *aDirectoryEntries) { return _to ## GetDirectoryEntries(aDirectoryEntries); } \
  NS_IMETHOD GetURL(char * *aURL) { return _to ## GetURL(aURL); } \
  NS_IMETHOD SetURL(const char * aURL) { return _to ## SetURL(aURL); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIFILE(_to) \
  NS_IMETHOD Append(const char *node) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Append(node); } \
  NS_IMETHOD AppendUnicode(const PRUnichar *node) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> AppendUnicode(node); } \
  NS_IMETHOD Normalize(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Normalize(); } \
  NS_IMETHOD Create(PRUint32 type, PRUint32 permissions) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Create(type, permissions); } \
  NS_IMETHOD GetLeafName(char * *aLeafName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetLeafName(aLeafName); } \
  NS_IMETHOD SetLeafName(const char * aLeafName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetLeafName(aLeafName); } \
  NS_IMETHOD GetUnicodeLeafName(PRUnichar * *aUnicodeLeafName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetUnicodeLeafName(aUnicodeLeafName); } \
  NS_IMETHOD SetUnicodeLeafName(const PRUnichar * aUnicodeLeafName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetUnicodeLeafName(aUnicodeLeafName); } \
  NS_IMETHOD CopyTo(nsIFile *newParentDir, const char *newName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CopyTo(newParentDir, newName); } \
  NS_IMETHOD CopyToUnicode(nsIFile *newParentDir, const PRUnichar *newName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CopyToUnicode(newParentDir, newName); } \
  NS_IMETHOD CopyToFollowingLinks(nsIFile *newParentDir, const char *newName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CopyToFollowingLinks(newParentDir, newName); } \
  NS_IMETHOD CopyToFollowingLinksUnicode(nsIFile *newParentDir, const PRUnichar *newName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CopyToFollowingLinksUnicode(newParentDir, newName); } \
  NS_IMETHOD MoveTo(nsIFile *newParentDir, const char *newName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> MoveTo(newParentDir, newName); } \
  NS_IMETHOD MoveToUnicode(nsIFile *newParentDir, const PRUnichar *newName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> MoveToUnicode(newParentDir, newName); } \
  NS_IMETHOD Spawn(const char **args, PRUint32 count) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Spawn(args, count); } \
  NS_IMETHOD Delete(PRBool recursive) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Delete(recursive); } \
  NS_IMETHOD GetPermissions(PRUint32 *aPermissions) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetPermissions(aPermissions); } \
  NS_IMETHOD SetPermissions(PRUint32 aPermissions) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetPermissions(aPermissions); } \
  NS_IMETHOD GetPermissionsOfLink(PRUint32 *aPermissionsOfLink) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetPermissionsOfLink(aPermissionsOfLink); } \
  NS_IMETHOD SetPermissionsOfLink(PRUint32 aPermissionsOfLink) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetPermissionsOfLink(aPermissionsOfLink); } \
  NS_IMETHOD GetLastModificationDate(PRInt64 *aLastModificationDate) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetLastModificationDate(aLastModificationDate); } \
  NS_IMETHOD SetLastModificationDate(PRInt64 aLastModificationDate) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetLastModificationDate(aLastModificationDate); } \
  NS_IMETHOD GetLastModificationDateOfLink(PRInt64 *aLastModificationDateOfLink) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetLastModificationDateOfLink(aLastModificationDateOfLink); } \
  NS_IMETHOD SetLastModificationDateOfLink(PRInt64 aLastModificationDateOfLink) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetLastModificationDateOfLink(aLastModificationDateOfLink); } \
  NS_IMETHOD GetFileSize(PRInt64 *aFileSize) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetFileSize(aFileSize); } \
  NS_IMETHOD SetFileSize(PRInt64 aFileSize) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetFileSize(aFileSize); } \
  NS_IMETHOD GetFileSizeOfLink(PRInt64 *aFileSizeOfLink) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetFileSizeOfLink(aFileSizeOfLink); } \
  NS_IMETHOD GetTarget(char * *aTarget) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetTarget(aTarget); } \
  NS_IMETHOD GetUnicodeTarget(PRUnichar * *aUnicodeTarget) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetUnicodeTarget(aUnicodeTarget); } \
  NS_IMETHOD GetPath(char * *aPath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetPath(aPath); } \
  NS_IMETHOD GetUnicodePath(PRUnichar * *aUnicodePath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetUnicodePath(aUnicodePath); } \
  NS_IMETHOD Exists(PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Exists(_retval); } \
  NS_IMETHOD IsWritable(PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsWritable(_retval); } \
  NS_IMETHOD IsReadable(PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsReadable(_retval); } \
  NS_IMETHOD IsExecutable(PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsExecutable(_retval); } \
  NS_IMETHOD IsHidden(PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsHidden(_retval); } \
  NS_IMETHOD IsDirectory(PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsDirectory(_retval); } \
  NS_IMETHOD IsFile(PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsFile(_retval); } \
  NS_IMETHOD IsSymlink(PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsSymlink(_retval); } \
  NS_IMETHOD IsSpecial(PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsSpecial(_retval); } \
  NS_IMETHOD CreateUnique(const char *suggestedName, PRUint32 type, PRUint32 permissions) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CreateUnique(suggestedName, type, permissions); } \
  NS_IMETHOD Clone(nsIFile **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Clone(_retval); } \
  NS_IMETHOD Equals(nsIFile *inFile, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Equals(inFile, _retval); } \
  NS_IMETHOD Contains(nsIFile *inFile, PRBool recur, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Contains(inFile, recur, _retval); } \
  NS_IMETHOD GetParent(nsIFile * *aParent) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetParent(aParent); } \
  NS_IMETHOD GetDirectoryEntries(nsISimpleEnumerator * *aDirectoryEntries) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetDirectoryEntries(aDirectoryEntries); } \
  NS_IMETHOD GetURL(char * *aURL) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetURL(aURL); } \
  NS_IMETHOD SetURL(const char * aURL) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetURL(aURL); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsFile : public nsIFile
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIFILE

  nsFile();
  virtual ~nsFile();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsFile, nsIFile)

nsFile::nsFile()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsFile::~nsFile()
{
  /* destructor code */
}

/* void append ([const] in string node); */
NS_IMETHODIMP nsFile::Append(const char *node)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void appendUnicode ([const] in wstring node); */
NS_IMETHODIMP nsFile::AppendUnicode(const PRUnichar *node)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void normalize (); */
NS_IMETHODIMP nsFile::Normalize()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void create (in unsigned long type, in unsigned long permissions); */
NS_IMETHODIMP nsFile::Create(PRUint32 type, PRUint32 permissions)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string leafName; */
NS_IMETHODIMP nsFile::GetLeafName(char * *aLeafName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsFile::SetLeafName(const char * aLeafName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute wstring unicodeLeafName; */
NS_IMETHODIMP nsFile::GetUnicodeLeafName(PRUnichar * *aUnicodeLeafName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsFile::SetUnicodeLeafName(const PRUnichar * aUnicodeLeafName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void copyTo (in nsIFile newParentDir, [const] in string newName); */
NS_IMETHODIMP nsFile::CopyTo(nsIFile *newParentDir, const char *newName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void copyToUnicode (in nsIFile newParentDir, [const] in wstring newName); */
NS_IMETHODIMP nsFile::CopyToUnicode(nsIFile *newParentDir, const PRUnichar *newName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void copyToFollowingLinks (in nsIFile newParentDir, [const] in string newName); */
NS_IMETHODIMP nsFile::CopyToFollowingLinks(nsIFile *newParentDir, const char *newName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void copyToFollowingLinksUnicode (in nsIFile newParentDir, [const] in wstring newName); */
NS_IMETHODIMP nsFile::CopyToFollowingLinksUnicode(nsIFile *newParentDir, const PRUnichar *newName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void moveTo (in nsIFile newParentDir, [const] in string newName); */
NS_IMETHODIMP nsFile::MoveTo(nsIFile *newParentDir, const char *newName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void moveToUnicode (in nsIFile newParentDir, [const] in wstring newName); */
NS_IMETHODIMP nsFile::MoveToUnicode(nsIFile *newParentDir, const PRUnichar *newName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void spawn ([array, size_is (count)] in string args, in unsigned long count); */
NS_IMETHODIMP nsFile::Spawn(const char **args, PRUint32 count)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void delete (in boolean recursive); */
NS_IMETHODIMP nsFile::Delete(PRBool recursive)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long permissions; */
NS_IMETHODIMP nsFile::GetPermissions(PRUint32 *aPermissions)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsFile::SetPermissions(PRUint32 aPermissions)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long permissionsOfLink; */
NS_IMETHODIMP nsFile::GetPermissionsOfLink(PRUint32 *aPermissionsOfLink)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsFile::SetPermissionsOfLink(PRUint32 aPermissionsOfLink)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute PRInt64 lastModificationDate; */
NS_IMETHODIMP nsFile::GetLastModificationDate(PRInt64 *aLastModificationDate)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsFile::SetLastModificationDate(PRInt64 aLastModificationDate)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute PRInt64 lastModificationDateOfLink; */
NS_IMETHODIMP nsFile::GetLastModificationDateOfLink(PRInt64 *aLastModificationDateOfLink)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsFile::SetLastModificationDateOfLink(PRInt64 aLastModificationDateOfLink)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute PRInt64 fileSize; */
NS_IMETHODIMP nsFile::GetFileSize(PRInt64 *aFileSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsFile::SetFileSize(PRInt64 aFileSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute PRInt64 fileSizeOfLink; */
NS_IMETHODIMP nsFile::GetFileSizeOfLink(PRInt64 *aFileSizeOfLink)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string target; */
NS_IMETHODIMP nsFile::GetTarget(char * *aTarget)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute wstring unicodeTarget; */
NS_IMETHODIMP nsFile::GetUnicodeTarget(PRUnichar * *aUnicodeTarget)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string path; */
NS_IMETHODIMP nsFile::GetPath(char * *aPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute wstring unicodePath; */
NS_IMETHODIMP nsFile::GetUnicodePath(PRUnichar * *aUnicodePath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean exists (); */
NS_IMETHODIMP nsFile::Exists(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isWritable (); */
NS_IMETHODIMP nsFile::IsWritable(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isReadable (); */
NS_IMETHODIMP nsFile::IsReadable(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isExecutable (); */
NS_IMETHODIMP nsFile::IsExecutable(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isHidden (); */
NS_IMETHODIMP nsFile::IsHidden(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isDirectory (); */
NS_IMETHODIMP nsFile::IsDirectory(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isFile (); */
NS_IMETHODIMP nsFile::IsFile(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isSymlink (); */
NS_IMETHODIMP nsFile::IsSymlink(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isSpecial (); */
NS_IMETHODIMP nsFile::IsSpecial(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void createUnique (in string suggestedName, in unsigned long type, in unsigned long permissions); */
NS_IMETHODIMP nsFile::CreateUnique(const char *suggestedName, PRUint32 type, PRUint32 permissions)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIFile clone (); */
NS_IMETHODIMP nsFile::Clone(nsIFile **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean equals (in nsIFile inFile); */
NS_IMETHODIMP nsFile::Equals(nsIFile *inFile, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean contains (in nsIFile inFile, in boolean recur); */
NS_IMETHODIMP nsFile::Contains(nsIFile *inFile, PRBool recur, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIFile parent; */
NS_IMETHODIMP nsFile::GetParent(nsIFile * *aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISimpleEnumerator directoryEntries; */
NS_IMETHODIMP nsFile::GetDirectoryEntries(nsISimpleEnumerator * *aDirectoryEntries)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string URL; */
NS_IMETHODIMP nsFile::GetURL(char * *aURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsFile::SetURL(const char * aURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define NS_FILE_CONTRACTID "@mozilla.org/file;1"
#define NS_FILE_CLASSNAME "File Specification"
////////////////////////////////////////////////////////////////////////////////
// Special Directories
#include "nsIServiceManager.h"
#include "nsIProperties.h"
#include "nsCOMPtr.h"
#define NS_DIRECTORY_SERVICE_CID  {0xf00152d0,0xb40b,0x11d3,{0x8c, 0x9c, 0x00, 0x00, 0x64, 0x65, 0x73, 0x74}}
inline nsresult
NS_GetSpecialDirectory(const char* specialDirName, nsIFile* *result)
{
    nsresult rv;
    static NS_DEFINE_CID(kDirectoryServiceCID, NS_DIRECTORY_SERVICE_CID);
    NS_WITH_SERVICE(nsIProperties, serv, kDirectoryServiceCID, &rv);
    if (NS_FAILED(rv)) return rv;
    nsCOMPtr<nsISupports> dir;
    rv = serv->Get(specialDirName, NS_GET_IID(nsIFile), getter_AddRefs(dir));
    if (NS_FAILED(rv)) return rv;
    *result = (nsIFile*)dir.get();
    if (*result)
        NS_ADDREF(*result);
    return NS_OK;
}

#endif /* __gen_nsIFile_h__ */
