/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAuthenticator.idl
 */

#ifndef __gen_nsIAuthenticator_h__
#define __gen_nsIAuthenticator_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIAuthPrompt_h__
#include "nsIAuthPrompt.h"
#endif

#ifndef __gen_nsIURL_h__
#include "nsIURL.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIAuthenticator */
#define NS_IAUTHENTICATOR_IID_STR "adf74d2a-1dd1-11b2-b129-f3154be37959"

#define NS_IAUTHENTICATOR_IID \
  {0xadf74d2a, 0x1dd1, 0x11b2, \
    { 0xb1, 0x29, 0xf3, 0x15, 0x4b, 0xe3, 0x79, 0x59 }}

class NS_NO_VTABLE nsIAuthenticator : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IAUTHENTICATOR_IID)

  /**
     * @param uri The URI for which authentication is required.
     * @param uri The protocol, for selecting authentication-style.  Variant
     *            protocols, such as http/https and imap/imaps will likely all
     *            use the primary protocol name ("http", "imap"), to reduce
     *            
     * @param challenge The complete value of the WWW-Authenticate header from
     *                  the response.
     * @param username The username provided in the prehost portion of the URI,
     *                 if any.
     * @param password The password provided in the prehost portion of the URI,
     *                 if any.
     * @param prompter  The standard prompter for interacting with the user.
     * @param 
     * @return The complete authentication value to return.  For Basic HTTP
     *         auth, as an example, the returned string would be
     *         "Basic BASE64(<user>:<pass>)".  The format is dependent on the
     *         provided protocol parameter.
     */
  /* string authenticate (in nsIURI uri, in string protocol, in string challenge, in wstring username, in wstring password, in nsIAuthPrompt prompter); */
  NS_IMETHOD Authenticate(nsIURI *uri, const char *protocol, const char *challenge, const PRUnichar *username, const PRUnichar *password, nsIAuthPrompt *prompter, char **_retval) = 0;

  /**
   * No interaction with the user required.  This indicates that the 
   * authenticate method can be called with a null prompter argument, though
   * calling code should strive to provide it if at all possible.  (While
   * interaction with the user may not be _required_, it might still be
   * desire
   */
  enum { INTERACTION_NONE = 0U };

  /**
   * Standard username and optional password required, and the caller should
   * prompt for it.
   */
  enum { INTERACTION_STANDARD = 1U };

  /**
   * Custom interaction required: Mozilla must provide a non-null prompter
   * argument when calling authenticate.
   */
  enum { INTERACTION_CUSTOM = 2U };

  /**
   * What kind of interaction with the user does this authentication method
   * require?
   */
  /* readonly attribute PRUint32 interactionType; */
  NS_IMETHOD GetInteractionType(PRUint32 *aInteractionType) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIAUTHENTICATOR \
  NS_IMETHOD Authenticate(nsIURI *uri, const char *protocol, const char *challenge, const PRUnichar *username, const PRUnichar *password, nsIAuthPrompt *prompter, char **_retval); \
  NS_IMETHOD GetInteractionType(PRUint32 *aInteractionType); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIAUTHENTICATOR(_to) \
  NS_IMETHOD Authenticate(nsIURI *uri, const char *protocol, const char *challenge, const PRUnichar *username, const PRUnichar *password, nsIAuthPrompt *prompter, char **_retval) { return _to ## Authenticate(uri, protocol, challenge, username, password, prompter, _retval); } \
  NS_IMETHOD GetInteractionType(PRUint32 *aInteractionType) { return _to ## GetInteractionType(aInteractionType); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIAUTHENTICATOR(_to) \
  NS_IMETHOD Authenticate(nsIURI *uri, const char *protocol, const char *challenge, const PRUnichar *username, const PRUnichar *password, nsIAuthPrompt *prompter, char **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Authenticate(uri, protocol, challenge, username, password, prompter, _retval); } \
  NS_IMETHOD GetInteractionType(PRUint32 *aInteractionType) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetInteractionType(aInteractionType); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAuthenticator : public nsIAuthenticator
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIAUTHENTICATOR

  nsAuthenticator();
  virtual ~nsAuthenticator();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAuthenticator, nsIAuthenticator)

nsAuthenticator::nsAuthenticator()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsAuthenticator::~nsAuthenticator()
{
  /* destructor code */
}

/* string authenticate (in nsIURI uri, in string protocol, in string challenge, in wstring username, in wstring password, in nsIAuthPrompt prompter); */
NS_IMETHODIMP nsAuthenticator::Authenticate(nsIURI *uri, const char *protocol, const char *challenge, const PRUnichar *username, const PRUnichar *password, nsIAuthPrompt *prompter, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute PRUint32 interactionType; */
NS_IMETHODIMP nsAuthenticator::GetInteractionType(PRUint32 *aInteractionType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAuthenticator_h__ */
