/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIURI.idl
 */

#ifndef __gen_nsIURI_h__
#define __gen_nsIURI_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#undef GetPort  // XXX Windows!
#undef SetPort  // XXX Windows!
#ifdef XP_OS2 // OS2 has UNKNOWN problems :)
#undef UNKNOWN
#endif

/* starting interface:    nsIURI */
#define NS_IURI_IID_STR "07a22cc0-0ce5-11d3-9331-00104ba0fd40"

#define NS_IURI_IID \
  {0x07a22cc0, 0x0ce5, 0x11d3, \
    { 0x93, 0x31, 0x00, 0x10, 0x4b, 0xa0, 0xfd, 0x40 }}

/**
 * URIs are essentially structured names for things -- anything.
 * This interface provides accessors to destructure those names.
 *
 * This interface follows Tim Berners-Lee's URI spec:
 *
 *     http://www.w3.org/Addressing/URI/URI_Overview.html
 *  
 * essentially:
 *  
 *      ftp://username:password@hostname:portnumber/pathname
 *      \ /   \               / \      / \        /\       /
 *       -     ---------------   ------   --------  -------
 *       |            |             |        |         |
 *       |            |             |        |        Path
 *       |            |             |       Port         
 *       |            |            Host      /
 *       |         PreHost                  /
 *     Scheme                              /
 *       \                                /
 *        --------------------------------
 *                       |
 *                    PrePath
 *
 * The subclass nsIURL provides a means to open an input or output              
 * stream to a URI as a source/destination, as well as providing additional     
 * accessors to destructure the path, query and reference portions typically    
 * associated with URLs.                                                        
 *
 * @status UNDER_REVIEW
 */
class NS_NO_VTABLE nsIURI : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IURI_IID)

  /**
     * Returns a string representation of the URI. Setting the spec 
     * causes the new spec to be parsed, initializing the URI. Setting
     * the spec (or any of the accessors) causes also any currently
     * open streams on the URI's channel to be closed.
     */
  /* attribute string spec; */
  NS_IMETHOD GetSpec(char * *aSpec) = 0;
  NS_IMETHOD SetSpec(const char * aSpec) = 0;

  /**
     * The prePath returns the stuff before the path
     * (e.g. protocol://user:password@host:port/). This is useful for
     * authentication, or managing sessions.
     */
  /* attribute string prePath; */
  NS_IMETHOD GetPrePath(char * *aPrePath) = 0;
  NS_IMETHOD SetPrePath(const char * aPrePath) = 0;

  /**
     * The Scheme is the protocol to which this URI refers. Setting
     * the scheme is a special operation that builds up an equivalent
     * URI string from the new scheme and all the other URI attributes
     * and passes the it to the nsIOService to create a new URI for
     * the new scheme.
     */
  /* attribute string scheme; */
  NS_IMETHOD GetScheme(char * *aScheme) = 0;
  NS_IMETHOD SetScheme(const char * aScheme) = 0;

  /**
     * The PreHost portion includes elements like the optional 
     * username:password, or maybe other scheme specific items. 
     */
  /* attribute string preHost; */
  NS_IMETHOD GetPreHost(char * *aPreHost) = 0;
  NS_IMETHOD SetPreHost(const char * aPreHost) = 0;

  /* attribute string username; */
  NS_IMETHOD GetUsername(char * *aUsername) = 0;
  NS_IMETHOD SetUsername(const char * aUsername) = 0;

  /* attribute string password; */
  NS_IMETHOD GetPassword(char * *aPassword) = 0;
  NS_IMETHOD SetPassword(const char * aPassword) = 0;

  /**
     * The Host is the internet domain name to which this URI refers. 
     * Note that it could be an IP address as well. 
     */
  /* attribute string host; */
  NS_IMETHOD GetHost(char * *aHost) = 0;
  NS_IMETHOD SetHost(const char * aHost) = 0;

  /**
     * A return value of -1 indicates that no port value is set and the 
     * implementor of the specific scheme will use its default port. 
     * Similarly setting a value of -1 indicates that the default is to be used.
     * Thus as an example:
     *     for HTTP, Port 80 is same as a return value of -1. 
     * However after setting a port (even if its default), the port number will
     * appear in the ToNewCString function.
     */
  /* attribute long port; */
  NS_IMETHOD GetPort(PRInt32 *aPort) = 0;
  NS_IMETHOD SetPort(PRInt32 aPort) = 0;

  /**
     * Note that the path includes the leading '/' Thus if no path is 
     * available the Path accessor will return a "/" 
     * For SetPath if none is provided, one would be prefixed to the path. 
     */
  /* attribute string path; */
  NS_IMETHOD GetPath(char * *aPath) = 0;
  NS_IMETHOD SetPath(const char * aPath) = 0;

  /**
     * Note that this comparison is only on char* level. Use 
     * the scheme specific URI to do a more thorough check. For example,
     * in HTTP:
     *     http://foo.com:80 == http://foo.com
     * but this function through nsIURI alone will not return equality
     * for this case.
     */
  /* boolean equals (in nsIURI other); */
  NS_IMETHOD Equals(nsIURI *other, PRBool *_retval) = 0;

  /**
    * An optimization to do scheme checks without requiring the users of nsIURI
    * to GetScheme thereby saving extra allocating and freeing. Returns true if
    * the schemes match (case ignored). Note that for unknown cases this will 
    * always return false.
    */
  /* boolean schemeIs (in string scheme); */
  NS_IMETHOD SchemeIs(const char *scheme, PRBool *_retval) = 0;

  /**
     * Clones the current URI. The newly created URI will be in a closed
     * state even if the underlying channel of the cloned URI is open.
     * Cloning allows the current location to be retained since once the
     * channel is opened the URI may get redirected to a new location.
     */
  /* nsIURI clone (); */
  NS_IMETHOD Clone(nsIURI **_retval) = 0;

  /**
     * This method resolves a relative string into an absolute URI string,
     * using the URI as the base. 
     *
     * This method subsumes the deprecated method nsIIOService::MakeAbsolute.
     */
  /* string resolve (in string relativePath); */
  NS_IMETHOD Resolve(const char *relativePath, char **_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIURI \
  NS_IMETHOD GetSpec(char * *aSpec); \
  NS_IMETHOD SetSpec(const char * aSpec); \
  NS_IMETHOD GetPrePath(char * *aPrePath); \
  NS_IMETHOD SetPrePath(const char * aPrePath); \
  NS_IMETHOD GetScheme(char * *aScheme); \
  NS_IMETHOD SetScheme(const char * aScheme); \
  NS_IMETHOD GetPreHost(char * *aPreHost); \
  NS_IMETHOD SetPreHost(const char * aPreHost); \
  NS_IMETHOD GetUsername(char * *aUsername); \
  NS_IMETHOD SetUsername(const char * aUsername); \
  NS_IMETHOD GetPassword(char * *aPassword); \
  NS_IMETHOD SetPassword(const char * aPassword); \
  NS_IMETHOD GetHost(char * *aHost); \
  NS_IMETHOD SetHost(const char * aHost); \
  NS_IMETHOD GetPort(PRInt32 *aPort); \
  NS_IMETHOD SetPort(PRInt32 aPort); \
  NS_IMETHOD GetPath(char * *aPath); \
  NS_IMETHOD SetPath(const char * aPath); \
  NS_IMETHOD Equals(nsIURI *other, PRBool *_retval); \
  NS_IMETHOD SchemeIs(const char *scheme, PRBool *_retval); \
  NS_IMETHOD Clone(nsIURI **_retval); \
  NS_IMETHOD Resolve(const char *relativePath, char **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIURI(_to) \
  NS_IMETHOD GetSpec(char * *aSpec) { return _to ## GetSpec(aSpec); } \
  NS_IMETHOD SetSpec(const char * aSpec) { return _to ## SetSpec(aSpec); } \
  NS_IMETHOD GetPrePath(char * *aPrePath) { return _to ## GetPrePath(aPrePath); } \
  NS_IMETHOD SetPrePath(const char * aPrePath) { return _to ## SetPrePath(aPrePath); } \
  NS_IMETHOD GetScheme(char * *aScheme) { return _to ## GetScheme(aScheme); } \
  NS_IMETHOD SetScheme(const char * aScheme) { return _to ## SetScheme(aScheme); } \
  NS_IMETHOD GetPreHost(char * *aPreHost) { return _to ## GetPreHost(aPreHost); } \
  NS_IMETHOD SetPreHost(const char * aPreHost) { return _to ## SetPreHost(aPreHost); } \
  NS_IMETHOD GetUsername(char * *aUsername) { return _to ## GetUsername(aUsername); } \
  NS_IMETHOD SetUsername(const char * aUsername) { return _to ## SetUsername(aUsername); } \
  NS_IMETHOD GetPassword(char * *aPassword) { return _to ## GetPassword(aPassword); } \
  NS_IMETHOD SetPassword(const char * aPassword) { return _to ## SetPassword(aPassword); } \
  NS_IMETHOD GetHost(char * *aHost) { return _to ## GetHost(aHost); } \
  NS_IMETHOD SetHost(const char * aHost) { return _to ## SetHost(aHost); } \
  NS_IMETHOD GetPort(PRInt32 *aPort) { return _to ## GetPort(aPort); } \
  NS_IMETHOD SetPort(PRInt32 aPort) { return _to ## SetPort(aPort); } \
  NS_IMETHOD GetPath(char * *aPath) { return _to ## GetPath(aPath); } \
  NS_IMETHOD SetPath(const char * aPath) { return _to ## SetPath(aPath); } \
  NS_IMETHOD Equals(nsIURI *other, PRBool *_retval) { return _to ## Equals(other, _retval); } \
  NS_IMETHOD SchemeIs(const char *scheme, PRBool *_retval) { return _to ## SchemeIs(scheme, _retval); } \
  NS_IMETHOD Clone(nsIURI **_retval) { return _to ## Clone(_retval); } \
  NS_IMETHOD Resolve(const char *relativePath, char **_retval) { return _to ## Resolve(relativePath, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIURI(_to) \
  NS_IMETHOD GetSpec(char * *aSpec) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetSpec(aSpec); } \
  NS_IMETHOD SetSpec(const char * aSpec) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetSpec(aSpec); } \
  NS_IMETHOD GetPrePath(char * *aPrePath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetPrePath(aPrePath); } \
  NS_IMETHOD SetPrePath(const char * aPrePath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetPrePath(aPrePath); } \
  NS_IMETHOD GetScheme(char * *aScheme) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetScheme(aScheme); } \
  NS_IMETHOD SetScheme(const char * aScheme) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetScheme(aScheme); } \
  NS_IMETHOD GetPreHost(char * *aPreHost) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetPreHost(aPreHost); } \
  NS_IMETHOD SetPreHost(const char * aPreHost) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetPreHost(aPreHost); } \
  NS_IMETHOD GetUsername(char * *aUsername) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetUsername(aUsername); } \
  NS_IMETHOD SetUsername(const char * aUsername) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetUsername(aUsername); } \
  NS_IMETHOD GetPassword(char * *aPassword) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetPassword(aPassword); } \
  NS_IMETHOD SetPassword(const char * aPassword) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetPassword(aPassword); } \
  NS_IMETHOD GetHost(char * *aHost) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetHost(aHost); } \
  NS_IMETHOD SetHost(const char * aHost) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetHost(aHost); } \
  NS_IMETHOD GetPort(PRInt32 *aPort) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetPort(aPort); } \
  NS_IMETHOD SetPort(PRInt32 aPort) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetPort(aPort); } \
  NS_IMETHOD GetPath(char * *aPath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetPath(aPath); } \
  NS_IMETHOD SetPath(const char * aPath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetPath(aPath); } \
  NS_IMETHOD Equals(nsIURI *other, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Equals(other, _retval); } \
  NS_IMETHOD SchemeIs(const char *scheme, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SchemeIs(scheme, _retval); } \
  NS_IMETHOD Clone(nsIURI **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Clone(_retval); } \
  NS_IMETHOD Resolve(const char *relativePath, char **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Resolve(relativePath, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsURI : public nsIURI
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIURI

  nsURI();
  virtual ~nsURI();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsURI, nsIURI)

nsURI::nsURI()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsURI::~nsURI()
{
  /* destructor code */
}

/* attribute string spec; */
NS_IMETHODIMP nsURI::GetSpec(char * *aSpec)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURI::SetSpec(const char * aSpec)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string prePath; */
NS_IMETHODIMP nsURI::GetPrePath(char * *aPrePath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURI::SetPrePath(const char * aPrePath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string scheme; */
NS_IMETHODIMP nsURI::GetScheme(char * *aScheme)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURI::SetScheme(const char * aScheme)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string preHost; */
NS_IMETHODIMP nsURI::GetPreHost(char * *aPreHost)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURI::SetPreHost(const char * aPreHost)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string username; */
NS_IMETHODIMP nsURI::GetUsername(char * *aUsername)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURI::SetUsername(const char * aUsername)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string password; */
NS_IMETHODIMP nsURI::GetPassword(char * *aPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURI::SetPassword(const char * aPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string host; */
NS_IMETHODIMP nsURI::GetHost(char * *aHost)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURI::SetHost(const char * aHost)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long port; */
NS_IMETHODIMP nsURI::GetPort(PRInt32 *aPort)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURI::SetPort(PRInt32 aPort)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string path; */
NS_IMETHODIMP nsURI::GetPath(char * *aPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURI::SetPath(const char * aPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean equals (in nsIURI other); */
NS_IMETHODIMP nsURI::Equals(nsIURI *other, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean schemeIs (in string scheme); */
NS_IMETHODIMP nsURI::SchemeIs(const char *scheme, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI clone (); */
NS_IMETHODIMP nsURI::Clone(nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string resolve (in string relativePath); */
NS_IMETHODIMP nsURI::Resolve(const char *relativePath, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define NS_ERROR_MALFORMED_URI  NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 10)

#endif /* __gen_nsIURI_h__ */
