/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIStreamIO.idl
 */

#ifndef __gen_nsIStreamIO_h__
#define __gen_nsIStreamIO_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIInputStream; /* forward declaration */

class nsIOutputStream; /* forward declaration */

class nsIURI; /* forward declaration */

class nsIFile; /* forward declaration */


/* starting interface:    nsIStreamIO */
#define NS_ISTREAMIO_IID_STR "d6c01ab2-0d04-11d4-986e-00c04fa0cf4a"

#define NS_ISTREAMIO_IID \
  {0xd6c01ab2, 0x0d04, 0x11d4, \
    { 0x98, 0x6e, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4a }}

/**
 * nsIStreamIO is an abstract interface that gives access to input and output
 * streams on an object. Perhaps the most interesting subclass of this is
 * nsIFileIO which allows access to input and output streams to files.
 */
class NS_NO_VTABLE nsIStreamIO : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISTREAMIO_IID)

  /**
     * Logically opens a stream I/O object, returning its content type
     * and length. If either of these are unknown, the value -1 is returned.
     */
  /* void open (out string contentType, out long contentLength); */
  NS_IMETHOD Open(char **contentType, PRInt32 *contentLength) = 0;

  /**
     * Logically closes a stream I/O object. A status value is passed in
     * to indicate a successful close (NS_OK) or failure.
     */
  /* void close (in nsresult status); */
  NS_IMETHOD Close(nsresult status) = 0;

  /**
     * Gets an input stream from a stream I/O object. 
     */
  /* readonly attribute nsIInputStream inputStream; */
  NS_IMETHOD GetInputStream(nsIInputStream * *aInputStream) = 0;

  /**
     * Gets an output stream from a stream I/O object. 
     */
  /* readonly attribute nsIOutputStream outputStream; */
  NS_IMETHOD GetOutputStream(nsIOutputStream * *aOutputStream) = 0;

  /**
     * Returns the 'name' of a stream I/O object. This name is often
     * used for display purposes.
     */
  /* readonly attribute string name; */
  NS_IMETHOD GetName(char * *aName) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISTREAMIO \
  NS_IMETHOD Open(char **contentType, PRInt32 *contentLength); \
  NS_IMETHOD Close(nsresult status); \
  NS_IMETHOD GetInputStream(nsIInputStream * *aInputStream); \
  NS_IMETHOD GetOutputStream(nsIOutputStream * *aOutputStream); \
  NS_IMETHOD GetName(char * *aName); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISTREAMIO(_to) \
  NS_IMETHOD Open(char **contentType, PRInt32 *contentLength) { return _to ## Open(contentType, contentLength); } \
  NS_IMETHOD Close(nsresult status) { return _to ## Close(status); } \
  NS_IMETHOD GetInputStream(nsIInputStream * *aInputStream) { return _to ## GetInputStream(aInputStream); } \
  NS_IMETHOD GetOutputStream(nsIOutputStream * *aOutputStream) { return _to ## GetOutputStream(aOutputStream); } \
  NS_IMETHOD GetName(char * *aName) { return _to ## GetName(aName); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISTREAMIO(_to) \
  NS_IMETHOD Open(char **contentType, PRInt32 *contentLength) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Open(contentType, contentLength); } \
  NS_IMETHOD Close(nsresult status) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Close(status); } \
  NS_IMETHOD GetInputStream(nsIInputStream * *aInputStream) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetInputStream(aInputStream); } \
  NS_IMETHOD GetOutputStream(nsIOutputStream * *aOutputStream) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetOutputStream(aOutputStream); } \
  NS_IMETHOD GetName(char * *aName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetName(aName); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsStreamIO : public nsIStreamIO
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISTREAMIO

  nsStreamIO();
  virtual ~nsStreamIO();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsStreamIO, nsIStreamIO)

nsStreamIO::nsStreamIO()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsStreamIO::~nsStreamIO()
{
  /* destructor code */
}

/* void open (out string contentType, out long contentLength); */
NS_IMETHODIMP nsStreamIO::Open(char **contentType, PRInt32 *contentLength)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void close (in nsresult status); */
NS_IMETHODIMP nsStreamIO::Close(nsresult status)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIInputStream inputStream; */
NS_IMETHODIMP nsStreamIO::GetInputStream(nsIInputStream * *aInputStream)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIOutputStream outputStream; */
NS_IMETHODIMP nsStreamIO::GetOutputStream(nsIOutputStream * *aOutputStream)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string name; */
NS_IMETHODIMP nsStreamIO::GetName(char * *aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIFileIO */
#define NS_IFILEIO_IID_STR "2a45fb42-0d06-11d4-986e-00c04fa0cf4a"

#define NS_IFILEIO_IID \
  {0x2a45fb42, 0x0d06, 0x11d4, \
    { 0x98, 0x6e, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4a }}

/**
 * nsIFileIO specializes nsIStreamIO to allow initialization from an nsIFile
 * object. For this implementation, the name attribute will correspond to the
 * path to the file.
 */
class NS_NO_VTABLE nsIFileIO : public nsIStreamIO {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IFILEIO_IID)

  /* void init (in nsIFile file, in long ioFlags, in long perm); */
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm) = 0;

  /* readonly attribute nsIFile file; */
  NS_IMETHOD GetFile(nsIFile * *aFile) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIFILEIO \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm); \
  NS_IMETHOD GetFile(nsIFile * *aFile); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIFILEIO(_to) \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm) { return _to ## Init(file, ioFlags, perm); } \
  NS_IMETHOD GetFile(nsIFile * *aFile) { return _to ## GetFile(aFile); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIFILEIO(_to) \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(file, ioFlags, perm); } \
  NS_IMETHOD GetFile(nsIFile * *aFile) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetFile(aFile); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsFileIO : public nsIFileIO
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIFILEIO

  nsFileIO();
  virtual ~nsFileIO();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsFileIO, nsIFileIO)

nsFileIO::nsFileIO()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsFileIO::~nsFileIO()
{
  /* destructor code */
}

/* void init (in nsIFile file, in long ioFlags, in long perm); */
NS_IMETHODIMP nsFileIO::Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIFile file; */
NS_IMETHODIMP nsFileIO::GetFile(nsIFile * *aFile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#include "nsCOMPtr.h"
#include "nsIComponentManager.h"
#define NS_FILEIO_CLASSNAME     "File I/O"
#define NS_FILEIO_CONTRACTID        "@mozilla.org/network/file-io;1"
#define NS_FILEIO_CID                                \
{ /* 0965ce3e-0d06-11d4-986e-00c04fa0cf4a */         \
    0x0965ce3e,                                      \
    0x0d06,                                          \
    0x11d4,                                          \
    {0x98, 0x6e, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4a} \
}
inline nsresult
NS_NewFileIO(nsIFileIO **result,
             nsIFile* file,
             PRInt32 ioFlags = -1,
             PRInt32 perm = -1)
{
    nsresult rv;
    nsCOMPtr<nsIFileIO> fileIO;
    static NS_DEFINE_CID(kFileIOCID, NS_FILEIO_CID);
    rv = nsComponentManager::CreateInstance(kFileIOCID,
                                            nsnull, 
                                            NS_GET_IID(nsIFileIO),
                                            getter_AddRefs(fileIO));
    if (NS_FAILED(rv)) return rv;
    rv = fileIO->Init(file, ioFlags, perm);
    if (NS_FAILED(rv)) return rv;
    *result = fileIO;
    NS_ADDREF(*result);
    return NS_OK;
}

/* starting interface:    nsIInputStreamIO */
#define NS_IINPUTSTREAMIO_IID_STR "2d64af08-0d06-11d4-986e-00c04fa0cf4a"

#define NS_IINPUTSTREAMIO_IID \
  {0x2d64af08, 0x0d06, 0x11d4, \
    { 0x98, 0x6e, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4a }}

/**
 * nsIInputStreamIO specializes nsIStreamIO to allow initialization from an
 * input stream, name, content type and length. Note that attempts to access
 * the output stream of an nsIInputStreamIO will fail. This implementation
 * is provided as a convenience, to avoid the need to implement the complete
 * nsIStreamIO interface, when all you need is the input stream part.
 */
class NS_NO_VTABLE nsIInputStreamIO : public nsIStreamIO {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IINPUTSTREAMIO_IID)

  /* void init (in string name, in nsIInputStream input, in string contentType, in long contentLength); */
  NS_IMETHOD Init(const char *name, nsIInputStream *input, const char *contentType, PRInt32 contentLength) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIINPUTSTREAMIO \
  NS_IMETHOD Init(const char *name, nsIInputStream *input, const char *contentType, PRInt32 contentLength); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIINPUTSTREAMIO(_to) \
  NS_IMETHOD Init(const char *name, nsIInputStream *input, const char *contentType, PRInt32 contentLength) { return _to ## Init(name, input, contentType, contentLength); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIINPUTSTREAMIO(_to) \
  NS_IMETHOD Init(const char *name, nsIInputStream *input, const char *contentType, PRInt32 contentLength) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(name, input, contentType, contentLength); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsInputStreamIO : public nsIInputStreamIO
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIINPUTSTREAMIO

  nsInputStreamIO();
  virtual ~nsInputStreamIO();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsInputStreamIO, nsIInputStreamIO)

nsInputStreamIO::nsInputStreamIO()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsInputStreamIO::~nsInputStreamIO()
{
  /* destructor code */
}

/* void init (in string name, in nsIInputStream input, in string contentType, in long contentLength); */
NS_IMETHODIMP nsInputStreamIO::Init(const char *name, nsIInputStream *input, const char *contentType, PRInt32 contentLength)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define NS_INPUTSTREAMIO_CLASSNAME "Input Stream I/O"
#define NS_INPUTSTREAMIO_CONTRACTID    "@mozilla.org/network/input-stream-io;1"
#define NS_INPUTSTREAMIO_CID                         \
{ /* 0f5e1198-0d06-11d4-986e-00c04fa0cf4a */         \
    0x0f5e1198,                                      \
    0x0d06,                                          \
    0x11d4,                                          \
    {0x98, 0x6e, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4a} \
}
inline nsresult
NS_NewInputStreamIO(nsIInputStreamIO* *result,
                    const char* name,
                    nsIInputStream* inStr,
                    const char* contentType,
                    PRInt32 contentLength)
{
    nsresult rv;
    nsCOMPtr<nsIInputStreamIO> io;
    static NS_DEFINE_CID(kInputStreamIOCID, NS_INPUTSTREAMIO_CID);
    rv = nsComponentManager::CreateInstance(kInputStreamIOCID,
                                            nsnull, 
                                            NS_GET_IID(nsIInputStreamIO),
                                            getter_AddRefs(io));
    if (NS_FAILED(rv)) return rv;
    rv = io->Init(name, inStr, contentType, contentLength);
    if (NS_FAILED(rv)) return rv;
    *result = io;
    NS_ADDREF(*result);
    return NS_OK;
}

#endif /* __gen_nsIStreamIO_h__ */
