/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIOutputStream.idl
 */

#ifndef __gen_nsIOutputStream_h__
#define __gen_nsIOutputStream_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIOutputStream; /* forward declaration */

class nsIOutputStreamObserver; /* forward declaration */

class nsIInputStream; /* forward declaration */

/**
 * The signature for the reader function passed to WriteSegment. This 
 * specifies where the data should come from that gets written into the buffer.
 * Implementers should return the following:
 * @return NS_OK and readCount > 0 - if successfully read something
 * @return NS_OK and readCount == 0 - if no more to read (EOF)
 * @return NS_BASE_STREAM_WOULD_BLOCK - if there is currently no data (in
 *   a non-blocking mode)
 * @return <other-error> - on failure
 */
typedef NS_CALLBACK(nsReadSegmentFun)(nsIOutputStream* out,
                                      void* closure,
                                      char* toRawSegment,
                                      PRUint32 fromOffset,
                                      PRUint32 count,
                                      PRUint32 *readCount);

/* starting interface:    nsIOutputStream */
#define NS_IOUTPUTSTREAM_IID_STR "0d0acd2a-61b4-11d4-9877-00c04fa0cf4a"

#define NS_IOUTPUTSTREAM_IID \
  {0x0d0acd2a, 0x61b4, 0x11d4, \
    { 0x98, 0x77, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4a }}

class NS_NO_VTABLE nsIOutputStream : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IOUTPUTSTREAM_IID)

  /** 
     * Closes the stream. 
     */
  /* void close (); */
  NS_IMETHOD Close(void) = 0;

  /**
     * Flushes the stream.
     */
  /* void flush (); */
  NS_IMETHOD Flush(void) = 0;

  /** Write data into the stream.
     *  @param aBuf the buffer from which the data is read
     *  @param aCount the maximum number of bytes to write
     *  @return aWriteCount out parameter to hold the number of
     *         bytes written. if an error occurs, the writecount
     *         is undefined
     */
  /* unsigned long write (in string buf, in unsigned long count); */
  NS_IMETHOD Write(const char *buf, PRUint32 count, PRUint32 *_retval) = 0;

  /**
     * Writes data into the stream from an input stream.
     * Implementer's note: This method is defined by this interface in order
     * to allow the output stream to efficiently copy the data from the input
     * stream into its internal buffer (if any). If this method was provide
     * as an external facility, a separate char* buffer would need to be used
     * in order to call the output stream's other Write method.
     * @param fromStream the stream from which the data is read
     * @param count the maximun number of bytes to write
     * @return aWriteCount out parameter to hold the number of
     *         bytes written. if an error occurs, the writecount
     *         is undefined
     */
  /* unsigned long writeFrom (in nsIInputStream inStr, in unsigned long count); */
  NS_IMETHOD WriteFrom(nsIInputStream *inStr, PRUint32 count, PRUint32 *_retval) = 0;

  /**
     * Low-level write method that has access to the stream's underlying buffer. The
     * reader function may be called multiple times for segmented buffers.
     */
  /* [noscript] unsigned long writeSegments (in nsReadSegmentFun reader, in voidPtr closure, in unsigned long count); */
  NS_IMETHOD WriteSegments(nsReadSegmentFun reader, void * closure, PRUint32 count, PRUint32 *_retval) = 0;

  /**
     * Set this attribute to put the stream in non-blocking mode.
     */
  /* attribute boolean nonBlocking; */
  NS_IMETHOD GetNonBlocking(PRBool *aNonBlocking) = 0;
  NS_IMETHOD SetNonBlocking(PRBool aNonBlocking) = 0;

  /**
     * Allows users to set an observer on an output stream to receive notifications
     * about the producer writing data into the output stream, or filling the buffer.
     * This is necessary for non-blocking streams so that the consumer can suspend
     * itself until more data is available.
     */
  /* attribute nsIOutputStreamObserver observer; */
  NS_IMETHOD GetObserver(nsIOutputStreamObserver * *aObserver) = 0;
  NS_IMETHOD SetObserver(nsIOutputStreamObserver * aObserver) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIOUTPUTSTREAM \
  NS_IMETHOD Close(void); \
  NS_IMETHOD Flush(void); \
  NS_IMETHOD Write(const char *buf, PRUint32 count, PRUint32 *_retval); \
  NS_IMETHOD WriteFrom(nsIInputStream *inStr, PRUint32 count, PRUint32 *_retval); \
  NS_IMETHOD WriteSegments(nsReadSegmentFun reader, void * closure, PRUint32 count, PRUint32 *_retval); \
  NS_IMETHOD GetNonBlocking(PRBool *aNonBlocking); \
  NS_IMETHOD SetNonBlocking(PRBool aNonBlocking); \
  NS_IMETHOD GetObserver(nsIOutputStreamObserver * *aObserver); \
  NS_IMETHOD SetObserver(nsIOutputStreamObserver * aObserver); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIOUTPUTSTREAM(_to) \
  NS_IMETHOD Close(void) { return _to ## Close(); } \
  NS_IMETHOD Flush(void) { return _to ## Flush(); } \
  NS_IMETHOD Write(const char *buf, PRUint32 count, PRUint32 *_retval) { return _to ## Write(buf, count, _retval); } \
  NS_IMETHOD WriteFrom(nsIInputStream *inStr, PRUint32 count, PRUint32 *_retval) { return _to ## WriteFrom(inStr, count, _retval); } \
  NS_IMETHOD WriteSegments(nsReadSegmentFun reader, void * closure, PRUint32 count, PRUint32 *_retval) { return _to ## WriteSegments(reader, closure, count, _retval); } \
  NS_IMETHOD GetNonBlocking(PRBool *aNonBlocking) { return _to ## GetNonBlocking(aNonBlocking); } \
  NS_IMETHOD SetNonBlocking(PRBool aNonBlocking) { return _to ## SetNonBlocking(aNonBlocking); } \
  NS_IMETHOD GetObserver(nsIOutputStreamObserver * *aObserver) { return _to ## GetObserver(aObserver); } \
  NS_IMETHOD SetObserver(nsIOutputStreamObserver * aObserver) { return _to ## SetObserver(aObserver); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIOUTPUTSTREAM(_to) \
  NS_IMETHOD Close(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Close(); } \
  NS_IMETHOD Flush(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Flush(); } \
  NS_IMETHOD Write(const char *buf, PRUint32 count, PRUint32 *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Write(buf, count, _retval); } \
  NS_IMETHOD WriteFrom(nsIInputStream *inStr, PRUint32 count, PRUint32 *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> WriteFrom(inStr, count, _retval); } \
  NS_IMETHOD WriteSegments(nsReadSegmentFun reader, void * closure, PRUint32 count, PRUint32 *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> WriteSegments(reader, closure, count, _retval); } \
  NS_IMETHOD GetNonBlocking(PRBool *aNonBlocking) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetNonBlocking(aNonBlocking); } \
  NS_IMETHOD SetNonBlocking(PRBool aNonBlocking) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetNonBlocking(aNonBlocking); } \
  NS_IMETHOD GetObserver(nsIOutputStreamObserver * *aObserver) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetObserver(aObserver); } \
  NS_IMETHOD SetObserver(nsIOutputStreamObserver * aObserver) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetObserver(aObserver); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsOutputStream : public nsIOutputStream
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIOUTPUTSTREAM

  nsOutputStream();
  virtual ~nsOutputStream();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsOutputStream, nsIOutputStream)

nsOutputStream::nsOutputStream()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsOutputStream::~nsOutputStream()
{
  /* destructor code */
}

/* void close (); */
NS_IMETHODIMP nsOutputStream::Close()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void flush (); */
NS_IMETHODIMP nsOutputStream::Flush()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned long write (in string buf, in unsigned long count); */
NS_IMETHODIMP nsOutputStream::Write(const char *buf, PRUint32 count, PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned long writeFrom (in nsIInputStream inStr, in unsigned long count); */
NS_IMETHODIMP nsOutputStream::WriteFrom(nsIInputStream *inStr, PRUint32 count, PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] unsigned long writeSegments (in nsReadSegmentFun reader, in voidPtr closure, in unsigned long count); */
NS_IMETHODIMP nsOutputStream::WriteSegments(nsReadSegmentFun reader, void * closure, PRUint32 count, PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean nonBlocking; */
NS_IMETHODIMP nsOutputStream::GetNonBlocking(PRBool *aNonBlocking)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsOutputStream::SetNonBlocking(PRBool aNonBlocking)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIOutputStreamObserver observer; */
NS_IMETHODIMP nsOutputStream::GetObserver(nsIOutputStreamObserver * *aObserver)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsOutputStream::SetObserver(nsIOutputStreamObserver * aObserver)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIOutputStreamObserver */
#define NS_IOUTPUTSTREAMOBSERVER_IID_STR "12314194-61b4-11d4-9877-00c04fa0cf4a"

#define NS_IOUTPUTSTREAMOBSERVER_IID \
  {0x12314194, 0x61b4, 0x11d4, \
    { 0x98, 0x77, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4a }}

class NS_NO_VTABLE nsIOutputStreamObserver : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IOUTPUTSTREAMOBSERVER_IID)

  /**
     * Called when the output stream's producer has written more data into the stream.
     */
  /* void onWrite (in nsIOutputStream inStr, in unsigned long amount); */
  NS_IMETHOD OnWrite(nsIOutputStream *inStr, PRUint32 amount) = 0;

  /**
     * Called when the stream's underlying buffer becomes full.
     */
  /* void onFull (in nsIOutputStream inStr); */
  NS_IMETHOD OnFull(nsIOutputStream *inStr) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIOUTPUTSTREAMOBSERVER \
  NS_IMETHOD OnWrite(nsIOutputStream *inStr, PRUint32 amount); \
  NS_IMETHOD OnFull(nsIOutputStream *inStr); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIOUTPUTSTREAMOBSERVER(_to) \
  NS_IMETHOD OnWrite(nsIOutputStream *inStr, PRUint32 amount) { return _to ## OnWrite(inStr, amount); } \
  NS_IMETHOD OnFull(nsIOutputStream *inStr) { return _to ## OnFull(inStr); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIOUTPUTSTREAMOBSERVER(_to) \
  NS_IMETHOD OnWrite(nsIOutputStream *inStr, PRUint32 amount) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> OnWrite(inStr, amount); } \
  NS_IMETHOD OnFull(nsIOutputStream *inStr) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> OnFull(inStr); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsOutputStreamObserver : public nsIOutputStreamObserver
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIOUTPUTSTREAMOBSERVER

  nsOutputStreamObserver();
  virtual ~nsOutputStreamObserver();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsOutputStreamObserver, nsIOutputStreamObserver)

nsOutputStreamObserver::nsOutputStreamObserver()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsOutputStreamObserver::~nsOutputStreamObserver()
{
  /* destructor code */
}

/* void onWrite (in nsIOutputStream inStr, in unsigned long amount); */
NS_IMETHODIMP nsOutputStreamObserver::OnWrite(nsIOutputStream *inStr, PRUint32 amount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onFull (in nsIOutputStream inStr); */
NS_IMETHODIMP nsOutputStreamObserver::OnFull(nsIOutputStream *inStr)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIOutputStream_h__ */
