/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsILoadGroup.idl
 */

#ifndef __gen_nsILoadGroup_h__
#define __gen_nsILoadGroup_h__


#ifndef __gen_nsIRequest_h__
#include "nsIRequest.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsISimpleEnumerator; /* forward declaration */

class nsIRequestObserver; /* forward declaration */

class nsIInterfaceRequestor; /* forward declaration */


/* starting interface:    nsILoadGroup */
#define NS_ILOADGROUP_IID_STR "19845248-29ab-11d3-8cce-0060b0fc14a3"

#define NS_ILOADGROUP_IID \
  {0x19845248, 0x29ab, 0x11d3, \
    { 0x8c, 0xce, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

class NS_NO_VTABLE nsILoadGroup : public nsIRequest {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ILOADGROUP_IID)

  /**
 * A load group maintains a collection of active URL requests. 
 *
 * @status UNDER_REVIEW
 */
/**
     * The group observer is notified when requests are added to and removed
     * from this load group.  The groupObserver is weak referenced.
     */
  /* attribute nsIRequestObserver groupObserver; */
  NS_IMETHOD GetGroupObserver(nsIRequestObserver * *aGroupObserver) = 0;
  NS_IMETHOD SetGroupObserver(nsIRequestObserver * aGroupObserver) = 0;

  /**
     * Accesses the default load request for the group.  Each time a number
     * of requests are added to a group, the defaultLoadRequest may be set
     * to indicate that all of the requests are related to a base request.
     */
  /* attribute nsIRequest defaultLoadRequest; */
  NS_IMETHOD GetDefaultLoadRequest(nsIRequest * *aDefaultLoadRequest) = 0;
  NS_IMETHOD SetDefaultLoadRequest(nsIRequest * aDefaultLoadRequest) = 0;

  /**
     * Adds a new request to the group.  This will cause the default load
     * attributes to be applied to the request.  If this is a foreground
     * request then the groupObserver's onStartRequest will be called.
     */
  /* void addRequest (in nsIRequest request, in nsISupports ctxt); */
  NS_IMETHOD AddRequest(nsIRequest *request, nsISupports *ctxt) = 0;

  /**
     * Removes a request from the group.  If this is a foreground request
     * then the groupObserver's onStopRequest will be called.
     */
  /* void removeRequest (in nsIRequest request, in nsISupports ctxt, in nsresult status); */
  NS_IMETHOD RemoveRequest(nsIRequest *request, nsISupports *ctxt, nsresult status) = 0;

  /**
     * Returns the requests contained directly in this group.
     * Enumerator element type: nsIRequest.
     */
  /* readonly attribute nsISimpleEnumerator requests; */
  NS_IMETHOD GetRequests(nsISimpleEnumerator * *aRequests) = 0;

  /**
     * Returns the count of "active" requests (ie. requests without the
     * LOAD_BACKGROUND bit set).
     */
  /* readonly attribute unsigned long activeCount; */
  NS_IMETHOD GetActiveCount(PRUint32 *aActiveCount) = 0;

  /**
     * Notification callbacks for the load group.
     */
  /* attribute nsIInterfaceRequestor notificationCallbacks; */
  NS_IMETHOD GetNotificationCallbacks(nsIInterfaceRequestor * *aNotificationCallbacks) = 0;
  NS_IMETHOD SetNotificationCallbacks(nsIInterfaceRequestor * aNotificationCallbacks) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSILOADGROUP \
  NS_IMETHOD GetGroupObserver(nsIRequestObserver * *aGroupObserver); \
  NS_IMETHOD SetGroupObserver(nsIRequestObserver * aGroupObserver); \
  NS_IMETHOD GetDefaultLoadRequest(nsIRequest * *aDefaultLoadRequest); \
  NS_IMETHOD SetDefaultLoadRequest(nsIRequest * aDefaultLoadRequest); \
  NS_IMETHOD AddRequest(nsIRequest *request, nsISupports *ctxt); \
  NS_IMETHOD RemoveRequest(nsIRequest *request, nsISupports *ctxt, nsresult status); \
  NS_IMETHOD GetRequests(nsISimpleEnumerator * *aRequests); \
  NS_IMETHOD GetActiveCount(PRUint32 *aActiveCount); \
  NS_IMETHOD GetNotificationCallbacks(nsIInterfaceRequestor * *aNotificationCallbacks); \
  NS_IMETHOD SetNotificationCallbacks(nsIInterfaceRequestor * aNotificationCallbacks); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSILOADGROUP(_to) \
  NS_IMETHOD GetGroupObserver(nsIRequestObserver * *aGroupObserver) { return _to ## GetGroupObserver(aGroupObserver); } \
  NS_IMETHOD SetGroupObserver(nsIRequestObserver * aGroupObserver) { return _to ## SetGroupObserver(aGroupObserver); } \
  NS_IMETHOD GetDefaultLoadRequest(nsIRequest * *aDefaultLoadRequest) { return _to ## GetDefaultLoadRequest(aDefaultLoadRequest); } \
  NS_IMETHOD SetDefaultLoadRequest(nsIRequest * aDefaultLoadRequest) { return _to ## SetDefaultLoadRequest(aDefaultLoadRequest); } \
  NS_IMETHOD AddRequest(nsIRequest *request, nsISupports *ctxt) { return _to ## AddRequest(request, ctxt); } \
  NS_IMETHOD RemoveRequest(nsIRequest *request, nsISupports *ctxt, nsresult status) { return _to ## RemoveRequest(request, ctxt, status); } \
  NS_IMETHOD GetRequests(nsISimpleEnumerator * *aRequests) { return _to ## GetRequests(aRequests); } \
  NS_IMETHOD GetActiveCount(PRUint32 *aActiveCount) { return _to ## GetActiveCount(aActiveCount); } \
  NS_IMETHOD GetNotificationCallbacks(nsIInterfaceRequestor * *aNotificationCallbacks) { return _to ## GetNotificationCallbacks(aNotificationCallbacks); } \
  NS_IMETHOD SetNotificationCallbacks(nsIInterfaceRequestor * aNotificationCallbacks) { return _to ## SetNotificationCallbacks(aNotificationCallbacks); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSILOADGROUP(_to) \
  NS_IMETHOD GetGroupObserver(nsIRequestObserver * *aGroupObserver) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetGroupObserver(aGroupObserver); } \
  NS_IMETHOD SetGroupObserver(nsIRequestObserver * aGroupObserver) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetGroupObserver(aGroupObserver); } \
  NS_IMETHOD GetDefaultLoadRequest(nsIRequest * *aDefaultLoadRequest) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetDefaultLoadRequest(aDefaultLoadRequest); } \
  NS_IMETHOD SetDefaultLoadRequest(nsIRequest * aDefaultLoadRequest) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetDefaultLoadRequest(aDefaultLoadRequest); } \
  NS_IMETHOD AddRequest(nsIRequest *request, nsISupports *ctxt) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> AddRequest(request, ctxt); } \
  NS_IMETHOD RemoveRequest(nsIRequest *request, nsISupports *ctxt, nsresult status) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> RemoveRequest(request, ctxt, status); } \
  NS_IMETHOD GetRequests(nsISimpleEnumerator * *aRequests) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetRequests(aRequests); } \
  NS_IMETHOD GetActiveCount(PRUint32 *aActiveCount) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetActiveCount(aActiveCount); } \
  NS_IMETHOD GetNotificationCallbacks(nsIInterfaceRequestor * *aNotificationCallbacks) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetNotificationCallbacks(aNotificationCallbacks); } \
  NS_IMETHOD SetNotificationCallbacks(nsIInterfaceRequestor * aNotificationCallbacks) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetNotificationCallbacks(aNotificationCallbacks); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsLoadGroup : public nsILoadGroup
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSILOADGROUP

  nsLoadGroup();
  virtual ~nsLoadGroup();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsLoadGroup, nsILoadGroup)

nsLoadGroup::nsLoadGroup()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsLoadGroup::~nsLoadGroup()
{
  /* destructor code */
}

/* attribute nsIRequestObserver groupObserver; */
NS_IMETHODIMP nsLoadGroup::GetGroupObserver(nsIRequestObserver * *aGroupObserver)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLoadGroup::SetGroupObserver(nsIRequestObserver * aGroupObserver)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIRequest defaultLoadRequest; */
NS_IMETHODIMP nsLoadGroup::GetDefaultLoadRequest(nsIRequest * *aDefaultLoadRequest)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLoadGroup::SetDefaultLoadRequest(nsIRequest * aDefaultLoadRequest)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addRequest (in nsIRequest request, in nsISupports ctxt); */
NS_IMETHODIMP nsLoadGroup::AddRequest(nsIRequest *request, nsISupports *ctxt)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeRequest (in nsIRequest request, in nsISupports ctxt, in nsresult status); */
NS_IMETHODIMP nsLoadGroup::RemoveRequest(nsIRequest *request, nsISupports *ctxt, nsresult status)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISimpleEnumerator requests; */
NS_IMETHODIMP nsLoadGroup::GetRequests(nsISimpleEnumerator * *aRequests)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long activeCount; */
NS_IMETHODIMP nsLoadGroup::GetActiveCount(PRUint32 *aActiveCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIInterfaceRequestor notificationCallbacks; */
NS_IMETHODIMP nsLoadGroup::GetNotificationCallbacks(nsIInterfaceRequestor * *aNotificationCallbacks)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLoadGroup::SetNotificationCallbacks(nsIInterfaceRequestor * aNotificationCallbacks)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsILoadGroup_h__ */
