/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIHttpChannel.idl
 */

#ifndef __gen_nsIHttpChannel_h__
#define __gen_nsIHttpChannel_h__


#ifndef __gen_nsIChannel_h__
#include "nsIChannel.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIHttpHeaderVisitor; /* forward declaration */


/* starting interface:    nsIHttpChannel */
#define NS_IHTTPCHANNEL_IID_STR "d78b53c8-d03f-4fd8-b2ee-7b36fcd150d1"

#define NS_IHTTPCHANNEL_IID \
  {0xd78b53c8, 0xd03f, 0x4fd8, \
    { 0xb2, 0xee, 0x7b, 0x36, 0xfc, 0xd1, 0x50, 0xd1 }}

class NS_NO_VTABLE nsIHttpChannel : public nsIChannel {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IHTTPCHANNEL_IID)

  /**************************************************************************
     * Request info...
     */
/**
     * The request method is case insensitive
     */
  /* attribute string requestMethod; */
  NS_IMETHOD GetRequestMethod(char * *aRequestMethod) = 0;
  NS_IMETHOD SetRequestMethod(const char * aRequestMethod) = 0;

  /**
     * Get/set the referrer URI on the request.  This is the address (URI) of
     * the resource from which this channel's URI was obtained (see RFC2616
     * section 14.36).  The referrer type may be used to block the referrer
     * from being sent in certain cases.
     */
  /* readonly attribute nsIURI referrer; */
  NS_IMETHOD GetReferrer(nsIURI * *aReferrer) = 0;

  /* void setReferrer (in nsIURI referrer, in unsigned long referrerType); */
  NS_IMETHOD SetReferrer(nsIURI *referrer, PRUint32 referrerType) = 0;

  enum { REFERRER_NONE = 0U };

  enum { REFERRER_LINK_CLICK = 1U };

  enum { REFERRER_INLINES = 2U };

  enum { REFERRER_NON_HTTP = 3U };

  /**
     * Header strings are case insensitive
     */
  /* string getRequestHeader (in string header); */
  NS_IMETHOD GetRequestHeader(const char *header, char **_retval) = 0;

  /* void setRequestHeader (in string header, in string value); */
  NS_IMETHOD SetRequestHeader(const char *header, const char *value) = 0;

  /* void visitRequestHeaders (in nsIHttpHeaderVisitor visitor); */
  NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *visitor) = 0;

  /**
     * Set the stream to be uploaded by this HTTP channel.  Setting this causes
     * the HTTP method to be changed to POST.  For PUT requests, the method
     * must be explicitly set.
     */
  /* attribute nsIInputStream uploadStream; */
  NS_IMETHOD GetUploadStream(nsIInputStream * *aUploadStream) = 0;
  NS_IMETHOD SetUploadStream(nsIInputStream * aUploadStream) = 0;

  /**************************************************************************
     * Response info...
     */
  /* readonly attribute unsigned long responseStatus; */
  NS_IMETHOD GetResponseStatus(PRUint32 *aResponseStatus) = 0;

  /* readonly attribute string responseStatusText; */
  NS_IMETHOD GetResponseStatusText(char * *aResponseStatusText) = 0;

  /**
     * Header strings are case insensitive
     */
  /* string getResponseHeader (in string header); */
  NS_IMETHOD GetResponseHeader(const char *header, char **_retval) = 0;

  /* void setResponseHeader (in string header, in string value); */
  NS_IMETHOD SetResponseHeader(const char *header, const char *value) = 0;

  /* void visitResponseHeaders (in nsIHttpHeaderVisitor visitor); */
  NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *visitor) = 0;

  /**
     * Get the charset for the response, which may be NULL if not specified
     * by the server (ie. the Content-Type header may not specify a charset).
     */
  /* readonly attribute string charset; */
  NS_IMETHOD GetCharset(char * *aCharset) = 0;

  /**
     * This attribute controls whether or not content conversion should be
     * done per the Content-Encoding response header.  Its value is true
     * by default.
     */
  /* attribute boolean applyConversion; */
  NS_IMETHOD GetApplyConversion(PRBool *aApplyConversion) = 0;
  NS_IMETHOD SetApplyConversion(PRBool aApplyConversion) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPCHANNEL \
  NS_IMETHOD GetRequestMethod(char * *aRequestMethod); \
  NS_IMETHOD SetRequestMethod(const char * aRequestMethod); \
  NS_IMETHOD GetReferrer(nsIURI * *aReferrer); \
  NS_IMETHOD SetReferrer(nsIURI *referrer, PRUint32 referrerType); \
  NS_IMETHOD GetRequestHeader(const char *header, char **_retval); \
  NS_IMETHOD SetRequestHeader(const char *header, const char *value); \
  NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *visitor); \
  NS_IMETHOD GetUploadStream(nsIInputStream * *aUploadStream); \
  NS_IMETHOD SetUploadStream(nsIInputStream * aUploadStream); \
  NS_IMETHOD GetResponseStatus(PRUint32 *aResponseStatus); \
  NS_IMETHOD GetResponseStatusText(char * *aResponseStatusText); \
  NS_IMETHOD GetResponseHeader(const char *header, char **_retval); \
  NS_IMETHOD SetResponseHeader(const char *header, const char *value); \
  NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *visitor); \
  NS_IMETHOD GetCharset(char * *aCharset); \
  NS_IMETHOD GetApplyConversion(PRBool *aApplyConversion); \
  NS_IMETHOD SetApplyConversion(PRBool aApplyConversion); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPCHANNEL(_to) \
  NS_IMETHOD GetRequestMethod(char * *aRequestMethod) { return _to ## GetRequestMethod(aRequestMethod); } \
  NS_IMETHOD SetRequestMethod(const char * aRequestMethod) { return _to ## SetRequestMethod(aRequestMethod); } \
  NS_IMETHOD GetReferrer(nsIURI * *aReferrer) { return _to ## GetReferrer(aReferrer); } \
  NS_IMETHOD SetReferrer(nsIURI *referrer, PRUint32 referrerType) { return _to ## SetReferrer(referrer, referrerType); } \
  NS_IMETHOD GetRequestHeader(const char *header, char **_retval) { return _to ## GetRequestHeader(header, _retval); } \
  NS_IMETHOD SetRequestHeader(const char *header, const char *value) { return _to ## SetRequestHeader(header, value); } \
  NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *visitor) { return _to ## VisitRequestHeaders(visitor); } \
  NS_IMETHOD GetUploadStream(nsIInputStream * *aUploadStream) { return _to ## GetUploadStream(aUploadStream); } \
  NS_IMETHOD SetUploadStream(nsIInputStream * aUploadStream) { return _to ## SetUploadStream(aUploadStream); } \
  NS_IMETHOD GetResponseStatus(PRUint32 *aResponseStatus) { return _to ## GetResponseStatus(aResponseStatus); } \
  NS_IMETHOD GetResponseStatusText(char * *aResponseStatusText) { return _to ## GetResponseStatusText(aResponseStatusText); } \
  NS_IMETHOD GetResponseHeader(const char *header, char **_retval) { return _to ## GetResponseHeader(header, _retval); } \
  NS_IMETHOD SetResponseHeader(const char *header, const char *value) { return _to ## SetResponseHeader(header, value); } \
  NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *visitor) { return _to ## VisitResponseHeaders(visitor); } \
  NS_IMETHOD GetCharset(char * *aCharset) { return _to ## GetCharset(aCharset); } \
  NS_IMETHOD GetApplyConversion(PRBool *aApplyConversion) { return _to ## GetApplyConversion(aApplyConversion); } \
  NS_IMETHOD SetApplyConversion(PRBool aApplyConversion) { return _to ## SetApplyConversion(aApplyConversion); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPCHANNEL(_to) \
  NS_IMETHOD GetRequestMethod(char * *aRequestMethod) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetRequestMethod(aRequestMethod); } \
  NS_IMETHOD SetRequestMethod(const char * aRequestMethod) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetRequestMethod(aRequestMethod); } \
  NS_IMETHOD GetReferrer(nsIURI * *aReferrer) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetReferrer(aReferrer); } \
  NS_IMETHOD SetReferrer(nsIURI *referrer, PRUint32 referrerType) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetReferrer(referrer, referrerType); } \
  NS_IMETHOD GetRequestHeader(const char *header, char **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetRequestHeader(header, _retval); } \
  NS_IMETHOD SetRequestHeader(const char *header, const char *value) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetRequestHeader(header, value); } \
  NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *visitor) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> VisitRequestHeaders(visitor); } \
  NS_IMETHOD GetUploadStream(nsIInputStream * *aUploadStream) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetUploadStream(aUploadStream); } \
  NS_IMETHOD SetUploadStream(nsIInputStream * aUploadStream) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetUploadStream(aUploadStream); } \
  NS_IMETHOD GetResponseStatus(PRUint32 *aResponseStatus) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetResponseStatus(aResponseStatus); } \
  NS_IMETHOD GetResponseStatusText(char * *aResponseStatusText) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetResponseStatusText(aResponseStatusText); } \
  NS_IMETHOD GetResponseHeader(const char *header, char **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetResponseHeader(header, _retval); } \
  NS_IMETHOD SetResponseHeader(const char *header, const char *value) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetResponseHeader(header, value); } \
  NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *visitor) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> VisitResponseHeaders(visitor); } \
  NS_IMETHOD GetCharset(char * *aCharset) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetCharset(aCharset); } \
  NS_IMETHOD GetApplyConversion(PRBool *aApplyConversion) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetApplyConversion(aApplyConversion); } \
  NS_IMETHOD SetApplyConversion(PRBool aApplyConversion) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetApplyConversion(aApplyConversion); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsHttpChannel : public nsIHttpChannel
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIHTTPCHANNEL

  nsHttpChannel();
  virtual ~nsHttpChannel();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsHttpChannel, nsIHttpChannel)

nsHttpChannel::nsHttpChannel()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsHttpChannel::~nsHttpChannel()
{
  /* destructor code */
}

/* attribute string requestMethod; */
NS_IMETHODIMP nsHttpChannel::GetRequestMethod(char * *aRequestMethod)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsHttpChannel::SetRequestMethod(const char * aRequestMethod)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIURI referrer; */
NS_IMETHODIMP nsHttpChannel::GetReferrer(nsIURI * *aReferrer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setReferrer (in nsIURI referrer, in unsigned long referrerType); */
NS_IMETHODIMP nsHttpChannel::SetReferrer(nsIURI *referrer, PRUint32 referrerType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getRequestHeader (in string header); */
NS_IMETHODIMP nsHttpChannel::GetRequestHeader(const char *header, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setRequestHeader (in string header, in string value); */
NS_IMETHODIMP nsHttpChannel::SetRequestHeader(const char *header, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void visitRequestHeaders (in nsIHttpHeaderVisitor visitor); */
NS_IMETHODIMP nsHttpChannel::VisitRequestHeaders(nsIHttpHeaderVisitor *visitor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIInputStream uploadStream; */
NS_IMETHODIMP nsHttpChannel::GetUploadStream(nsIInputStream * *aUploadStream)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsHttpChannel::SetUploadStream(nsIInputStream * aUploadStream)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long responseStatus; */
NS_IMETHODIMP nsHttpChannel::GetResponseStatus(PRUint32 *aResponseStatus)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string responseStatusText; */
NS_IMETHODIMP nsHttpChannel::GetResponseStatusText(char * *aResponseStatusText)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getResponseHeader (in string header); */
NS_IMETHODIMP nsHttpChannel::GetResponseHeader(const char *header, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setResponseHeader (in string header, in string value); */
NS_IMETHODIMP nsHttpChannel::SetResponseHeader(const char *header, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void visitResponseHeaders (in nsIHttpHeaderVisitor visitor); */
NS_IMETHODIMP nsHttpChannel::VisitResponseHeaders(nsIHttpHeaderVisitor *visitor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string charset; */
NS_IMETHODIMP nsHttpChannel::GetCharset(char * *aCharset)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean applyConversion; */
NS_IMETHODIMP nsHttpChannel::GetApplyConversion(PRBool *aApplyConversion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsHttpChannel::SetApplyConversion(PRBool aApplyConversion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIHttpHeaderVisitor */
#define NS_IHTTPHEADERVISITOR_IID_STR "0cf40717-d7c1-4a94-8c1e-d6c9734101bb"

#define NS_IHTTPHEADERVISITOR_IID \
  {0x0cf40717, 0xd7c1, 0x4a94, \
    { 0x8c, 0x1e, 0xd6, 0xc9, 0x73, 0x41, 0x01, 0xbb }}

class NS_NO_VTABLE nsIHttpHeaderVisitor : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IHTTPHEADERVISITOR_IID)

  /**
 * Implement this interface to visit http headers.
 */
  /* void visitHeader (in string header, in string value); */
  NS_IMETHOD VisitHeader(const char *header, const char *value) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPHEADERVISITOR \
  NS_IMETHOD VisitHeader(const char *header, const char *value); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPHEADERVISITOR(_to) \
  NS_IMETHOD VisitHeader(const char *header, const char *value) { return _to ## VisitHeader(header, value); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPHEADERVISITOR(_to) \
  NS_IMETHOD VisitHeader(const char *header, const char *value) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> VisitHeader(header, value); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsHttpHeaderVisitor : public nsIHttpHeaderVisitor
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIHTTPHEADERVISITOR

  nsHttpHeaderVisitor();
  virtual ~nsHttpHeaderVisitor();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsHttpHeaderVisitor, nsIHttpHeaderVisitor)

nsHttpHeaderVisitor::nsHttpHeaderVisitor()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsHttpHeaderVisitor::~nsHttpHeaderVisitor()
{
  /* destructor code */
}

/* void visitHeader (in string header, in string value); */
NS_IMETHODIMP nsHttpHeaderVisitor::VisitHeader(const char *header, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIHttpChannel_h__ */
