/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIHTMLEditor.idl
 */

#ifndef __gen_nsIHTMLEditor_h__
#define __gen_nsIHTMLEditor_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_domstubs_h__
#include "domstubs.h"
#endif

#ifndef __gen_nsIAtom_h__
#include "nsIAtom.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#define NS_EDITOR_ELEMENT_NOT_FOUND \
  NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_EDITOR, 1)

/* starting interface:    nsIHTMLEditor */
#define NS_IHTMLEDITOR_IID_STR "4b0fd0d0-1dd2-11b2-bf2e-ef20fbca2c88"

#define NS_IHTMLEDITOR_IID \
  {0x4b0fd0d0, 0x1dd2, 0x11b2, \
    { 0xbf, 0x2e, 0xef, 0x20, 0xfb, 0xca, 0x2c, 0x88 }}

class nsIHTMLEditor : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IHTMLEDITOR_IID)

  typedef short EAlignment;
  enum { eLeft = 0 };

  enum { eCenter = 1 };

  enum { eRight = 2 };

  enum { eJustify = 3 };

  /**
   * SetInlineProperty() sets the aggregate properties on the current selection
   *
   * @param aProperty   the property to set on the selection 
   * @param aAttribute  the attribute of the property, if applicable.  May be null.
   *                    Example: aProperty="font", aAttribute="color"
   * @param aValue      if aAttribute is not null, the value of the attribute.  May be null.
   *                    Example: aProperty="font", aAttribute="color", aValue="0x00FFFF"
   */
  /* void SetInlineProperty (in nsIAtom aProperty, in DOMString aAttribute, in DOMString aValue); */
  NS_IMETHOD SetInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue) = 0;

  /**
   * GetInlineProperty() gets the aggregate properties of the current selection.
   * All object in the current selection are scanned and their attributes are
   * represented in a list of Property object.
   *
   * @param aProperty   the property to get on the selection 
   * @param aAttribute  the attribute of the property, if applicable.  May be null.
   *                    Example: aProperty="font", aAttribute="color"
   * @param aValue      if aAttribute is not null, the value of the attribute.  May be null.
   *                    Example: aProperty="font", aAttribute="color", aValue="0x00FFFF"
   * @param aFirst      [OUT] PR_TRUE if the first text node in the selection has the property
   * @param aAny        [OUT] PR_TRUE if any of the text nodes in the selection have the property
   * @param aAll        [OUT] PR_TRUE if all of the text nodes in the selection have the property
   */
  /* void GetInlineProperty (in nsIAtom aProperty, in DOMString aAttribute, in DOMString aValue, out boolean aFirst, out boolean aAny, out boolean aAll); */
  NS_IMETHOD GetInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll) = 0;

  /* void GetInlinePropertyWithAttrValue (in nsIAtom aProperty, in DOMString aAttribute, in DOMString aValue, out boolean aFirst, out boolean aAny, out boolean aAll, out DOMString outValue); */
  NS_IMETHOD GetInlinePropertyWithAttrValue(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll, nsAWritableString & outValue) = 0;

  /**
   * RemoveAllInlineProperties() deletes all the inline properties from all 
   * text in the current selection.
   */
  /* void RemoveAllInlineProperties (); */
  NS_IMETHOD RemoveAllInlineProperties(void) = 0;

  /**
   * RemoveInlineProperty() deletes the properties from all text in the current selection.
   * If aProperty is not set on the selection, nothing is done.
   *
   * @param aProperty   the property to remove from the selection 
   *                    All atoms are for normal HTML tags (e.g.: nsIEditorProptery::font)
   *                      except when you want to remove just links and not named anchors
   *                      For that, use nsIEditorProperty::href
   * @param aAttribute  the attribute of the property, if applicable.  May be null.
   *                    Example: aProperty=nsIEditorProptery::font, aAttribute="color"
   *                    nsIEditProperty::allAttributes is special.  It indicates that
   *                    all content-based text properties are to be removed from the selection.
   */
  /* void RemoveInlineProperty (in nsIAtom aProperty, in DOMString aAttribute); */
  NS_IMETHOD RemoveInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute) = 0;

  /**
   *  Increase font size for text in selection by 1 HTML unit
   *  All existing text is scanned for existing <FONT SIZE> attributes
   *    so they will be incremented instead of inserting new <FONT> tag
   */
  /* void IncreaseFontSize (); */
  NS_IMETHOD IncreaseFontSize(void) = 0;

  /**
   *  Decrease font size for text in selection by 1 HTML unit
   *  All existing text is scanned for existing <FONT SIZE> attributes
   *    so they will be decreased instead of inserting new <FONT> tag
   */
  /* void DecreaseFontSize (); */
  NS_IMETHOD DecreaseFontSize(void) = 0;

  /** 
   * CanDrag decides if a drag should be started
   * (for example, based on the current selection and mousepoint).
   */
  /* void CanDrag (in nsIDOMEvent aEvent, out boolean aCanDrag); */
  NS_IMETHOD CanDrag(nsIDOMEvent *aEvent, PRBool *aCanDrag) = 0;

  /** 
   * DoDrag transfers the relevant data (as appropriate)
   * to a transferable so it can later be dropped.
   */
  /* void DoDrag (in nsIDOMEvent aEvent); */
  NS_IMETHOD DoDrag(nsIDOMEvent *aEvent) = 0;

  /** 
   * InsertFromDrop looks for a dragsession and inserts the
   * relevant data in response to a drop.
   */
  /* void InsertFromDrop (in nsIDOMEvent aEvent); */
  NS_IMETHOD InsertFromDrop(nsIDOMEvent *aEvent) = 0;

  /**
   * Tests if a node is a BLOCK element according the the HTML 4.0 DTD
   *   This does NOT consider CSS effect on display type
   *
   * @param aNode      the node to test
   */
  /* void NodeIsBlock (in nsIDOMNode node, out boolean isBlock); */
  NS_IMETHOD NodeIsBlock(nsIDOMNode *node, PRBool *isBlock) = 0;

  /**
   * Insert some HTML source at the current location
   *
   * @param aInputString   the string to be inserted
   */
  /* void InsertHTML (in DOMString aInputString); */
  NS_IMETHOD InsertHTML(const nsAReadableString & aInputString) = 0;

  /** Rebuild the entire document from source HTML
   *  Needed to be able to edit HEAD and other outside-of-BODY content
   *
   *  @param aSourceString   HTML source string of the entire new document
   */
  /* void RebuildDocumentFromSource (in DOMString aSourceString); */
  NS_IMETHOD RebuildDocumentFromSource(const nsAReadableString & aSourceString) = 0;

  /**
   * Insert some HTML source, interpreting
   * the string argument according to the given charset.
   *
   * @param aInputString   the string to be inserted
   * @param aCharset       Charset of string
   * @param aParentNode    Parent to insert under.
   *                       If null, insert at the current location.
   */
  /* void InsertHTMLWithCharset (in DOMString aInputString, in DOMString aCharset); */
  NS_IMETHOD InsertHTMLWithCharset(const nsAReadableString & aInputString, const nsAReadableString & aCharset) = 0;

  /** Insert an element, which may have child nodes, at the selection
    * Used primarily to insert a new element for various insert element dialogs,
    *   but it enforces the HTML 4.0 DTD "CanContain" rules, so it should
    *   be useful for other elements.
    *
    * @param aElement           The element to insert
    * @param aDeleteSelection   Delete the selection before inserting
    *     If aDeleteSelection is PR_FALSE, then the element is inserted 
    *     after the end of the selection for all element except
    *     Named Anchors, which insert before the selection
    */
  /* void InsertElementAtSelection (in nsIDOMElement aElement, in boolean aDeleteSelection); */
  NS_IMETHOD InsertElementAtSelection(nsIDOMElement *aElement, PRBool aDeleteSelection) = 0;

  /** Set the documents title.
   */
  /* void SetDocumentTitle (in DOMString aTitle); */
  NS_IMETHOD SetDocumentTitle(const nsAReadableString & aTitle) = 0;

  /** Set the selection at the suppled element
    *
    * @param aElement   An element in the document
    */
  /* void SelectElement (in nsIDOMElement aElement); */
  NS_IMETHOD SelectElement(nsIDOMElement *aElement) = 0;

  /** Create a collapsed selection just after aElement
    * 
    * XXX could we parameterize SelectElement(before/select/after>?
    *
    * The selection is set to parent-of-aElement with an
    *   offset 1 greater than aElement's offset
    *   but it enforces the HTML 4.0 DTD "CanContain" rules, so it should
    *   be useful for other elements.
    *
    * @param aElement  An element in the document
    */
  /* void SetCaretAfterElement (in nsIDOMElement aElement); */
  NS_IMETHOD SetCaretAfterElement(nsIDOMElement *aElement) = 0;

  /**
   * SetParagraphFormat       Insert a block paragraph tag around selection
   * @param aParagraphFormat  "p", "h1" to "h6", "address", "pre", or "blockquote"
   */
  /* void SetParagraphFormat (in DOMString aParagraphFormat); */
  NS_IMETHOD SetParagraphFormat(const nsAReadableString & aParagraphFormat) = 0;

  /**
   * GetParagraphState returns what block tag paragraph format is in the selection.
   * @param aMixed     True if there is more than one format
   * @param outState   Name of block tag. "" is returned for none.
   */
  /* void GetParagraphState (out boolean aMixed, out DOMString outState); */
  NS_IMETHOD GetParagraphState(PRBool *aMixed, nsAWritableString & outState) = 0;

  /** 
   * GetFontFaceState returns what font face is in the selection.
   * @param aMixed    True if there is more than one font face
   * @param outFace   Name of face.  Note: "tt" is returned for
   *                  tt tag.  "" is returned for none.
   */
  /* void GetFontFaceState (out boolean aMixed, out DOMString outFont); */
  NS_IMETHOD GetFontFaceState(PRBool *aMixed, nsAWritableString & outFont) = 0;

  /** 
   * GetFontColorState returns what font face is in the selection.
   * @param aMixed     True if there is more than one font color
   * @param outColor   Color string. "" is returned for none.
   */
  /* void GetFontColorState (out boolean aMixed, out DOMString outColor); */
  NS_IMETHOD GetFontColorState(PRBool *aMixed, nsAWritableString & outColor) = 0;

  /** 
   * GetFontColorState returns what font face is in the selection.
   * @param aMixed     True if there is more than one font color
   * @param outColor   Color string. "" is returned for none.
   */
  /* void GetBackgroundColorState (out boolean aMixed, out DOMString outColor); */
  NS_IMETHOD GetBackgroundColorState(PRBool *aMixed, nsAWritableString & outColor) = 0;

  /** 
   * GetListState returns what list type is in the selection.
   * @param aMixed    True if there is more than one type of list, or
   *                  if there is some list and non-list
   * @param aOL       The company that employs me.  No, really, it's 
   *                  true if an "ol" list is selected.
   * @param aUL       true if an "ul" list is selected.
   * @param aDL       true if a "dl" list is selected.
   */
  /* void GetListState (out boolean aMixed, out boolean aOL, out boolean aUL, out boolean aDL); */
  NS_IMETHOD GetListState(PRBool *aMixed, PRBool *aOL, PRBool *aUL, PRBool *aDL) = 0;

  /** 
   * GetListItemState returns what list item type is in the selection.
   * @param aMixed    True if there is more than one type of list item, or
   *                  if there is some list and non-list
   * @param aLI       true if "li" list items are selected.
   * @param aDT       true if "dt" list items are selected.
   * @param aDD       true if "dd" list items are selected.
   */
  /* void GetListItemState (out boolean aMixed, out boolean aLI, out boolean aDT, out boolean aDD); */
  NS_IMETHOD GetListItemState(PRBool *aMixed, PRBool *aLI, PRBool *aDT, PRBool *aDD) = 0;

  /** 
   * GetAlignment     returns what alignment is in the selection.
   * @param aMixed    True if there is more than one type of list item, or
   *                  if there is some list and non-list
   * @param aAlign    enum value for first encountered alignment (left/center/right)
   */
  /* void GetAlignment (out boolean aMixed, out short aAlign); */
  NS_IMETHOD GetAlignment(PRBool *aMixed, PRInt16 *aAlign) = 0;

  /**
   * Document me!
   * 
   */
  /* void GetIndentState (out boolean aCanIndent, out boolean aCanOutdent); */
  NS_IMETHOD GetIndentState(PRBool *aCanIndent, PRBool *aCanOutdent) = 0;

  /**
   * Document me!
   * 
   */
  /* void MakeOrChangeList (in DOMString aListType, in boolean entireList); */
  NS_IMETHOD MakeOrChangeList(const nsAReadableString & aListType, PRBool entireList) = 0;

  /**
   * Document me!
   * 
   */
  /* void RemoveList (in DOMString aListType); */
  NS_IMETHOD RemoveList(const nsAReadableString & aListType) = 0;

  /**
   * Document me!
   * 
   */
  /* void Indent (in DOMString aIndent); */
  NS_IMETHOD Indent(const nsAReadableString & aIndent) = 0;

  /**
   * Document me!
   * 
   */
  /* void Align (in DOMString aAlign); */
  NS_IMETHOD Align(const nsAReadableString & aAlign) = 0;

  /** Return the input node or a parent matching the given aTagName,
    *   starting the search at the supplied node.
    * An example of use is for testing if a node is in a table cell
    *   given a selection anchor node.
    *
    * @param aTagName  The HTML tagname
    *  Special input values:
    *    Use "href" to get a link node 
    *      (an "A" tag with the "href" attribute set)
    *    Use "anchor" or "namedanchor" to get a named anchor node
    *      (an "A" tag with the "name" attribute set)
    *    Use "list" to get an OL, UL, or DL list node
    *    Use "td" to get either a TD or TH cell node
    *
    * @param aNode    The node in the document to start the search
    *     If it is null, the anchor node of the current selection is used
    * Returns NS_EDITOR_ELEMENT_NOT_FOUND if an element is not found (passes NS_SUCCEEDED macro)
    */
  /* void GetElementOrParentByTagName (in DOMString aTagName, in nsIDOMNode aNode, out nsIDOMElement aReturn); */
  NS_IMETHOD GetElementOrParentByTagName(const nsAReadableString & aTagName, nsIDOMNode *aNode, nsIDOMElement **aReturn) = 0;

  /** Return an element only if it is the only node selected,
    *    such as an image, horizontal rule, etc.
    * The exception is a link, which is more like a text attribute:
    *    The Anchor tag is returned if the selection is within the textnode(s)
    *    that are children of the "A" node.
    *    This could be a collapsed selection, i.e., a caret within the link text.
    *
    * @param aTagName  The HTML tagname or and empty string 
    *       to get any element (but only if it is the only element selected)
    *    Special input values for Links and Named anchors:
    *    Use "href" to get a link node
    *      (an "A" tag with the "href" attribute set)
    *    Use "anchor" or "namedanchor" to get a named anchor node
    *      (an "A" tag with the "name" attribute set)
    * Returns NS_EDITOR_ELEMENT_NOT_FOUND if an element is not found (passes NS_SUCCEEDED macro)
    */
  /* void GetSelectedElement (in DOMString aTagName, out nsIDOMElement aReturn); */
  NS_IMETHOD GetSelectedElement(const nsAReadableString & aTagName, nsIDOMElement **aReturn) = 0;

  /** Output the contents of the <HEAD> section as text/HTML format
    */
  /* void GetHeadContentsAsHTML (out DOMString aOutputString); */
  NS_IMETHOD GetHeadContentsAsHTML(nsAWritableString & aOutputString) = 0;

  /** Replace all children of <HEAD> with string of HTML source
    */
  /* void ReplaceHeadContentsWithHTML (in DOMString aSourceToInsert); */
  NS_IMETHOD ReplaceHeadContentsWithHTML(const nsAReadableString & aSourceToInsert) = 0;

  /** Return a new element with default attribute values
    * 
    * This does not rely on the selection, and is not sensitive to context.
    * 
    * Used primarily to supply new element for various insert element dialogs
    *  (Image, Link, NamedAnchor, Table, and HorizontalRule 
    *   are the only returned elements as of 7/25/99)
    *
    * @param aTagName  The HTML tagname
    *    Special input values for Links and Named anchors:
    *    Use "href" to get a link node
    *      (an "A" tag with the "href" attribute set)
    *    Use "anchor" or "namedanchor" to get a named anchor node
    *      (an "A" tag with the "name" attribute set)
    */
  /* void CreateElementWithDefaults (in DOMString aTagName, out nsIDOMElement aReturn); */
  NS_IMETHOD CreateElementWithDefaults(const nsAReadableString & aTagName, nsIDOMElement **aReturn) = 0;

  /** Insert an link element as the parent of the current selection
    *
    * @param aElement   An "A" element with a non-empty "href" attribute
    */
  /* void InsertLinkAroundSelection (in nsIDOMElement aAnchorElement); */
  NS_IMETHOD InsertLinkAroundSelection(nsIDOMElement *aAnchorElement) = 0;

  /** Set the value of the "bgcolor" attribute on the document's <body> element
    *
    * @param aColor  The HTML color string, such as "#ffccff" or "yellow"
    */
  /* void SetBackgroundColor (in DOMString aColor); */
  NS_IMETHOD SetBackgroundColor(const nsAReadableString & aColor) = 0;

  /** Set an attribute on the document's <body> element
    *    such as text, link, background colors
    *
    * 8/31/00 THIS ISN'T BEING USED? SHOULD WE DROP IT?
    *
    * @param aAttr   The attribute to be set
    * @param aValue  The value of the attribute
    */
  /* void SetBodyAttribute (in DOMString aAttr, in DOMString aValue); */
  NS_IMETHOD SetBodyAttribute(const nsAReadableString & aAttr, const nsAReadableString & aValue) = 0;

  /* void IgnoreSpuriousDragEvent (in boolean aIgnoreSpuriousDragEvent); */
  NS_IMETHOD IgnoreSpuriousDragEvent(PRBool aIgnoreSpuriousDragEvent) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTMLEDITOR \
  NS_IMETHOD SetInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue); \
  NS_IMETHOD GetInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll); \
  NS_IMETHOD GetInlinePropertyWithAttrValue(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll, nsAWritableString & outValue); \
  NS_IMETHOD RemoveAllInlineProperties(void); \
  NS_IMETHOD RemoveInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute); \
  NS_IMETHOD IncreaseFontSize(void); \
  NS_IMETHOD DecreaseFontSize(void); \
  NS_IMETHOD CanDrag(nsIDOMEvent *aEvent, PRBool *aCanDrag); \
  NS_IMETHOD DoDrag(nsIDOMEvent *aEvent); \
  NS_IMETHOD InsertFromDrop(nsIDOMEvent *aEvent); \
  NS_IMETHOD NodeIsBlock(nsIDOMNode *node, PRBool *isBlock); \
  NS_IMETHOD InsertHTML(const nsAReadableString & aInputString); \
  NS_IMETHOD RebuildDocumentFromSource(const nsAReadableString & aSourceString); \
  NS_IMETHOD InsertHTMLWithCharset(const nsAReadableString & aInputString, const nsAReadableString & aCharset); \
  NS_IMETHOD InsertElementAtSelection(nsIDOMElement *aElement, PRBool aDeleteSelection); \
  NS_IMETHOD SetDocumentTitle(const nsAReadableString & aTitle); \
  NS_IMETHOD SelectElement(nsIDOMElement *aElement); \
  NS_IMETHOD SetCaretAfterElement(nsIDOMElement *aElement); \
  NS_IMETHOD SetParagraphFormat(const nsAReadableString & aParagraphFormat); \
  NS_IMETHOD GetParagraphState(PRBool *aMixed, nsAWritableString & outState); \
  NS_IMETHOD GetFontFaceState(PRBool *aMixed, nsAWritableString & outFont); \
  NS_IMETHOD GetFontColorState(PRBool *aMixed, nsAWritableString & outColor); \
  NS_IMETHOD GetBackgroundColorState(PRBool *aMixed, nsAWritableString & outColor); \
  NS_IMETHOD GetListState(PRBool *aMixed, PRBool *aOL, PRBool *aUL, PRBool *aDL); \
  NS_IMETHOD GetListItemState(PRBool *aMixed, PRBool *aLI, PRBool *aDT, PRBool *aDD); \
  NS_IMETHOD GetAlignment(PRBool *aMixed, PRInt16 *aAlign); \
  NS_IMETHOD GetIndentState(PRBool *aCanIndent, PRBool *aCanOutdent); \
  NS_IMETHOD MakeOrChangeList(const nsAReadableString & aListType, PRBool entireList); \
  NS_IMETHOD RemoveList(const nsAReadableString & aListType); \
  NS_IMETHOD Indent(const nsAReadableString & aIndent); \
  NS_IMETHOD Align(const nsAReadableString & aAlign); \
  NS_IMETHOD GetElementOrParentByTagName(const nsAReadableString & aTagName, nsIDOMNode *aNode, nsIDOMElement **aReturn); \
  NS_IMETHOD GetSelectedElement(const nsAReadableString & aTagName, nsIDOMElement **aReturn); \
  NS_IMETHOD GetHeadContentsAsHTML(nsAWritableString & aOutputString); \
  NS_IMETHOD ReplaceHeadContentsWithHTML(const nsAReadableString & aSourceToInsert); \
  NS_IMETHOD CreateElementWithDefaults(const nsAReadableString & aTagName, nsIDOMElement **aReturn); \
  NS_IMETHOD InsertLinkAroundSelection(nsIDOMElement *aAnchorElement); \
  NS_IMETHOD SetBackgroundColor(const nsAReadableString & aColor); \
  NS_IMETHOD SetBodyAttribute(const nsAReadableString & aAttr, const nsAReadableString & aValue); \
  NS_IMETHOD IgnoreSpuriousDragEvent(PRBool aIgnoreSpuriousDragEvent); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTMLEDITOR(_to) \
  NS_IMETHOD SetInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue) { return _to ## SetInlineProperty(aProperty, aAttribute, aValue); } \
  NS_IMETHOD GetInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll) { return _to ## GetInlineProperty(aProperty, aAttribute, aValue, aFirst, aAny, aAll); } \
  NS_IMETHOD GetInlinePropertyWithAttrValue(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll, nsAWritableString & outValue) { return _to ## GetInlinePropertyWithAttrValue(aProperty, aAttribute, aValue, aFirst, aAny, aAll, outValue); } \
  NS_IMETHOD RemoveAllInlineProperties(void) { return _to ## RemoveAllInlineProperties(); } \
  NS_IMETHOD RemoveInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute) { return _to ## RemoveInlineProperty(aProperty, aAttribute); } \
  NS_IMETHOD IncreaseFontSize(void) { return _to ## IncreaseFontSize(); } \
  NS_IMETHOD DecreaseFontSize(void) { return _to ## DecreaseFontSize(); } \
  NS_IMETHOD CanDrag(nsIDOMEvent *aEvent, PRBool *aCanDrag) { return _to ## CanDrag(aEvent, aCanDrag); } \
  NS_IMETHOD DoDrag(nsIDOMEvent *aEvent) { return _to ## DoDrag(aEvent); } \
  NS_IMETHOD InsertFromDrop(nsIDOMEvent *aEvent) { return _to ## InsertFromDrop(aEvent); } \
  NS_IMETHOD NodeIsBlock(nsIDOMNode *node, PRBool *isBlock) { return _to ## NodeIsBlock(node, isBlock); } \
  NS_IMETHOD InsertHTML(const nsAReadableString & aInputString) { return _to ## InsertHTML(aInputString); } \
  NS_IMETHOD RebuildDocumentFromSource(const nsAReadableString & aSourceString) { return _to ## RebuildDocumentFromSource(aSourceString); } \
  NS_IMETHOD InsertHTMLWithCharset(const nsAReadableString & aInputString, const nsAReadableString & aCharset) { return _to ## InsertHTMLWithCharset(aInputString, aCharset); } \
  NS_IMETHOD InsertElementAtSelection(nsIDOMElement *aElement, PRBool aDeleteSelection) { return _to ## InsertElementAtSelection(aElement, aDeleteSelection); } \
  NS_IMETHOD SetDocumentTitle(const nsAReadableString & aTitle) { return _to ## SetDocumentTitle(aTitle); } \
  NS_IMETHOD SelectElement(nsIDOMElement *aElement) { return _to ## SelectElement(aElement); } \
  NS_IMETHOD SetCaretAfterElement(nsIDOMElement *aElement) { return _to ## SetCaretAfterElement(aElement); } \
  NS_IMETHOD SetParagraphFormat(const nsAReadableString & aParagraphFormat) { return _to ## SetParagraphFormat(aParagraphFormat); } \
  NS_IMETHOD GetParagraphState(PRBool *aMixed, nsAWritableString & outState) { return _to ## GetParagraphState(aMixed, outState); } \
  NS_IMETHOD GetFontFaceState(PRBool *aMixed, nsAWritableString & outFont) { return _to ## GetFontFaceState(aMixed, outFont); } \
  NS_IMETHOD GetFontColorState(PRBool *aMixed, nsAWritableString & outColor) { return _to ## GetFontColorState(aMixed, outColor); } \
  NS_IMETHOD GetBackgroundColorState(PRBool *aMixed, nsAWritableString & outColor) { return _to ## GetBackgroundColorState(aMixed, outColor); } \
  NS_IMETHOD GetListState(PRBool *aMixed, PRBool *aOL, PRBool *aUL, PRBool *aDL) { return _to ## GetListState(aMixed, aOL, aUL, aDL); } \
  NS_IMETHOD GetListItemState(PRBool *aMixed, PRBool *aLI, PRBool *aDT, PRBool *aDD) { return _to ## GetListItemState(aMixed, aLI, aDT, aDD); } \
  NS_IMETHOD GetAlignment(PRBool *aMixed, PRInt16 *aAlign) { return _to ## GetAlignment(aMixed, aAlign); } \
  NS_IMETHOD GetIndentState(PRBool *aCanIndent, PRBool *aCanOutdent) { return _to ## GetIndentState(aCanIndent, aCanOutdent); } \
  NS_IMETHOD MakeOrChangeList(const nsAReadableString & aListType, PRBool entireList) { return _to ## MakeOrChangeList(aListType, entireList); } \
  NS_IMETHOD RemoveList(const nsAReadableString & aListType) { return _to ## RemoveList(aListType); } \
  NS_IMETHOD Indent(const nsAReadableString & aIndent) { return _to ## Indent(aIndent); } \
  NS_IMETHOD Align(const nsAReadableString & aAlign) { return _to ## Align(aAlign); } \
  NS_IMETHOD GetElementOrParentByTagName(const nsAReadableString & aTagName, nsIDOMNode *aNode, nsIDOMElement **aReturn) { return _to ## GetElementOrParentByTagName(aTagName, aNode, aReturn); } \
  NS_IMETHOD GetSelectedElement(const nsAReadableString & aTagName, nsIDOMElement **aReturn) { return _to ## GetSelectedElement(aTagName, aReturn); } \
  NS_IMETHOD GetHeadContentsAsHTML(nsAWritableString & aOutputString) { return _to ## GetHeadContentsAsHTML(aOutputString); } \
  NS_IMETHOD ReplaceHeadContentsWithHTML(const nsAReadableString & aSourceToInsert) { return _to ## ReplaceHeadContentsWithHTML(aSourceToInsert); } \
  NS_IMETHOD CreateElementWithDefaults(const nsAReadableString & aTagName, nsIDOMElement **aReturn) { return _to ## CreateElementWithDefaults(aTagName, aReturn); } \
  NS_IMETHOD InsertLinkAroundSelection(nsIDOMElement *aAnchorElement) { return _to ## InsertLinkAroundSelection(aAnchorElement); } \
  NS_IMETHOD SetBackgroundColor(const nsAReadableString & aColor) { return _to ## SetBackgroundColor(aColor); } \
  NS_IMETHOD SetBodyAttribute(const nsAReadableString & aAttr, const nsAReadableString & aValue) { return _to ## SetBodyAttribute(aAttr, aValue); } \
  NS_IMETHOD IgnoreSpuriousDragEvent(PRBool aIgnoreSpuriousDragEvent) { return _to ## IgnoreSpuriousDragEvent(aIgnoreSpuriousDragEvent); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTMLEDITOR(_to) \
  NS_IMETHOD SetInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetInlineProperty(aProperty, aAttribute, aValue); } \
  NS_IMETHOD GetInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetInlineProperty(aProperty, aAttribute, aValue, aFirst, aAny, aAll); } \
  NS_IMETHOD GetInlinePropertyWithAttrValue(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll, nsAWritableString & outValue) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetInlinePropertyWithAttrValue(aProperty, aAttribute, aValue, aFirst, aAny, aAll, outValue); } \
  NS_IMETHOD RemoveAllInlineProperties(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> RemoveAllInlineProperties(); } \
  NS_IMETHOD RemoveInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> RemoveInlineProperty(aProperty, aAttribute); } \
  NS_IMETHOD IncreaseFontSize(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IncreaseFontSize(); } \
  NS_IMETHOD DecreaseFontSize(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> DecreaseFontSize(); } \
  NS_IMETHOD CanDrag(nsIDOMEvent *aEvent, PRBool *aCanDrag) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CanDrag(aEvent, aCanDrag); } \
  NS_IMETHOD DoDrag(nsIDOMEvent *aEvent) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> DoDrag(aEvent); } \
  NS_IMETHOD InsertFromDrop(nsIDOMEvent *aEvent) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> InsertFromDrop(aEvent); } \
  NS_IMETHOD NodeIsBlock(nsIDOMNode *node, PRBool *isBlock) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> NodeIsBlock(node, isBlock); } \
  NS_IMETHOD InsertHTML(const nsAReadableString & aInputString) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> InsertHTML(aInputString); } \
  NS_IMETHOD RebuildDocumentFromSource(const nsAReadableString & aSourceString) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> RebuildDocumentFromSource(aSourceString); } \
  NS_IMETHOD InsertHTMLWithCharset(const nsAReadableString & aInputString, const nsAReadableString & aCharset) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> InsertHTMLWithCharset(aInputString, aCharset); } \
  NS_IMETHOD InsertElementAtSelection(nsIDOMElement *aElement, PRBool aDeleteSelection) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> InsertElementAtSelection(aElement, aDeleteSelection); } \
  NS_IMETHOD SetDocumentTitle(const nsAReadableString & aTitle) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetDocumentTitle(aTitle); } \
  NS_IMETHOD SelectElement(nsIDOMElement *aElement) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SelectElement(aElement); } \
  NS_IMETHOD SetCaretAfterElement(nsIDOMElement *aElement) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetCaretAfterElement(aElement); } \
  NS_IMETHOD SetParagraphFormat(const nsAReadableString & aParagraphFormat) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetParagraphFormat(aParagraphFormat); } \
  NS_IMETHOD GetParagraphState(PRBool *aMixed, nsAWritableString & outState) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetParagraphState(aMixed, outState); } \
  NS_IMETHOD GetFontFaceState(PRBool *aMixed, nsAWritableString & outFont) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetFontFaceState(aMixed, outFont); } \
  NS_IMETHOD GetFontColorState(PRBool *aMixed, nsAWritableString & outColor) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetFontColorState(aMixed, outColor); } \
  NS_IMETHOD GetBackgroundColorState(PRBool *aMixed, nsAWritableString & outColor) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetBackgroundColorState(aMixed, outColor); } \
  NS_IMETHOD GetListState(PRBool *aMixed, PRBool *aOL, PRBool *aUL, PRBool *aDL) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetListState(aMixed, aOL, aUL, aDL); } \
  NS_IMETHOD GetListItemState(PRBool *aMixed, PRBool *aLI, PRBool *aDT, PRBool *aDD) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetListItemState(aMixed, aLI, aDT, aDD); } \
  NS_IMETHOD GetAlignment(PRBool *aMixed, PRInt16 *aAlign) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetAlignment(aMixed, aAlign); } \
  NS_IMETHOD GetIndentState(PRBool *aCanIndent, PRBool *aCanOutdent) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetIndentState(aCanIndent, aCanOutdent); } \
  NS_IMETHOD MakeOrChangeList(const nsAReadableString & aListType, PRBool entireList) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> MakeOrChangeList(aListType, entireList); } \
  NS_IMETHOD RemoveList(const nsAReadableString & aListType) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> RemoveList(aListType); } \
  NS_IMETHOD Indent(const nsAReadableString & aIndent) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Indent(aIndent); } \
  NS_IMETHOD Align(const nsAReadableString & aAlign) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Align(aAlign); } \
  NS_IMETHOD GetElementOrParentByTagName(const nsAReadableString & aTagName, nsIDOMNode *aNode, nsIDOMElement **aReturn) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetElementOrParentByTagName(aTagName, aNode, aReturn); } \
  NS_IMETHOD GetSelectedElement(const nsAReadableString & aTagName, nsIDOMElement **aReturn) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetSelectedElement(aTagName, aReturn); } \
  NS_IMETHOD GetHeadContentsAsHTML(nsAWritableString & aOutputString) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetHeadContentsAsHTML(aOutputString); } \
  NS_IMETHOD ReplaceHeadContentsWithHTML(const nsAReadableString & aSourceToInsert) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> ReplaceHeadContentsWithHTML(aSourceToInsert); } \
  NS_IMETHOD CreateElementWithDefaults(const nsAReadableString & aTagName, nsIDOMElement **aReturn) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CreateElementWithDefaults(aTagName, aReturn); } \
  NS_IMETHOD InsertLinkAroundSelection(nsIDOMElement *aAnchorElement) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> InsertLinkAroundSelection(aAnchorElement); } \
  NS_IMETHOD SetBackgroundColor(const nsAReadableString & aColor) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetBackgroundColor(aColor); } \
  NS_IMETHOD SetBodyAttribute(const nsAReadableString & aAttr, const nsAReadableString & aValue) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetBodyAttribute(aAttr, aValue); } \
  NS_IMETHOD IgnoreSpuriousDragEvent(PRBool aIgnoreSpuriousDragEvent) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IgnoreSpuriousDragEvent(aIgnoreSpuriousDragEvent); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsHTMLEditor : public nsIHTMLEditor
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIHTMLEDITOR

  nsHTMLEditor();
  virtual ~nsHTMLEditor();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsHTMLEditor, nsIHTMLEditor)

nsHTMLEditor::nsHTMLEditor()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsHTMLEditor::~nsHTMLEditor()
{
  /* destructor code */
}

/* void SetInlineProperty (in nsIAtom aProperty, in DOMString aAttribute, in DOMString aValue); */
NS_IMETHODIMP nsHTMLEditor::SetInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetInlineProperty (in nsIAtom aProperty, in DOMString aAttribute, in DOMString aValue, out boolean aFirst, out boolean aAny, out boolean aAll); */
NS_IMETHODIMP nsHTMLEditor::GetInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetInlinePropertyWithAttrValue (in nsIAtom aProperty, in DOMString aAttribute, in DOMString aValue, out boolean aFirst, out boolean aAny, out boolean aAll, out DOMString outValue); */
NS_IMETHODIMP nsHTMLEditor::GetInlinePropertyWithAttrValue(nsIAtom *aProperty, const nsAReadableString & aAttribute, const nsAReadableString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll, nsAWritableString & outValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RemoveAllInlineProperties (); */
NS_IMETHODIMP nsHTMLEditor::RemoveAllInlineProperties()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RemoveInlineProperty (in nsIAtom aProperty, in DOMString aAttribute); */
NS_IMETHODIMP nsHTMLEditor::RemoveInlineProperty(nsIAtom *aProperty, const nsAReadableString & aAttribute)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void IncreaseFontSize (); */
NS_IMETHODIMP nsHTMLEditor::IncreaseFontSize()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DecreaseFontSize (); */
NS_IMETHODIMP nsHTMLEditor::DecreaseFontSize()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CanDrag (in nsIDOMEvent aEvent, out boolean aCanDrag); */
NS_IMETHODIMP nsHTMLEditor::CanDrag(nsIDOMEvent *aEvent, PRBool *aCanDrag)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DoDrag (in nsIDOMEvent aEvent); */
NS_IMETHODIMP nsHTMLEditor::DoDrag(nsIDOMEvent *aEvent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertFromDrop (in nsIDOMEvent aEvent); */
NS_IMETHODIMP nsHTMLEditor::InsertFromDrop(nsIDOMEvent *aEvent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void NodeIsBlock (in nsIDOMNode node, out boolean isBlock); */
NS_IMETHODIMP nsHTMLEditor::NodeIsBlock(nsIDOMNode *node, PRBool *isBlock)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertHTML (in DOMString aInputString); */
NS_IMETHODIMP nsHTMLEditor::InsertHTML(const nsAReadableString & aInputString)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RebuildDocumentFromSource (in DOMString aSourceString); */
NS_IMETHODIMP nsHTMLEditor::RebuildDocumentFromSource(const nsAReadableString & aSourceString)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertHTMLWithCharset (in DOMString aInputString, in DOMString aCharset); */
NS_IMETHODIMP nsHTMLEditor::InsertHTMLWithCharset(const nsAReadableString & aInputString, const nsAReadableString & aCharset)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertElementAtSelection (in nsIDOMElement aElement, in boolean aDeleteSelection); */
NS_IMETHODIMP nsHTMLEditor::InsertElementAtSelection(nsIDOMElement *aElement, PRBool aDeleteSelection)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetDocumentTitle (in DOMString aTitle); */
NS_IMETHODIMP nsHTMLEditor::SetDocumentTitle(const nsAReadableString & aTitle)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SelectElement (in nsIDOMElement aElement); */
NS_IMETHODIMP nsHTMLEditor::SelectElement(nsIDOMElement *aElement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetCaretAfterElement (in nsIDOMElement aElement); */
NS_IMETHODIMP nsHTMLEditor::SetCaretAfterElement(nsIDOMElement *aElement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetParagraphFormat (in DOMString aParagraphFormat); */
NS_IMETHODIMP nsHTMLEditor::SetParagraphFormat(const nsAReadableString & aParagraphFormat)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetParagraphState (out boolean aMixed, out DOMString outState); */
NS_IMETHODIMP nsHTMLEditor::GetParagraphState(PRBool *aMixed, nsAWritableString & outState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetFontFaceState (out boolean aMixed, out DOMString outFont); */
NS_IMETHODIMP nsHTMLEditor::GetFontFaceState(PRBool *aMixed, nsAWritableString & outFont)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetFontColorState (out boolean aMixed, out DOMString outColor); */
NS_IMETHODIMP nsHTMLEditor::GetFontColorState(PRBool *aMixed, nsAWritableString & outColor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetBackgroundColorState (out boolean aMixed, out DOMString outColor); */
NS_IMETHODIMP nsHTMLEditor::GetBackgroundColorState(PRBool *aMixed, nsAWritableString & outColor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetListState (out boolean aMixed, out boolean aOL, out boolean aUL, out boolean aDL); */
NS_IMETHODIMP nsHTMLEditor::GetListState(PRBool *aMixed, PRBool *aOL, PRBool *aUL, PRBool *aDL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetListItemState (out boolean aMixed, out boolean aLI, out boolean aDT, out boolean aDD); */
NS_IMETHODIMP nsHTMLEditor::GetListItemState(PRBool *aMixed, PRBool *aLI, PRBool *aDT, PRBool *aDD)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetAlignment (out boolean aMixed, out short aAlign); */
NS_IMETHODIMP nsHTMLEditor::GetAlignment(PRBool *aMixed, PRInt16 *aAlign)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetIndentState (out boolean aCanIndent, out boolean aCanOutdent); */
NS_IMETHODIMP nsHTMLEditor::GetIndentState(PRBool *aCanIndent, PRBool *aCanOutdent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void MakeOrChangeList (in DOMString aListType, in boolean entireList); */
NS_IMETHODIMP nsHTMLEditor::MakeOrChangeList(const nsAReadableString & aListType, PRBool entireList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RemoveList (in DOMString aListType); */
NS_IMETHODIMP nsHTMLEditor::RemoveList(const nsAReadableString & aListType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Indent (in DOMString aIndent); */
NS_IMETHODIMP nsHTMLEditor::Indent(const nsAReadableString & aIndent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Align (in DOMString aAlign); */
NS_IMETHODIMP nsHTMLEditor::Align(const nsAReadableString & aAlign)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetElementOrParentByTagName (in DOMString aTagName, in nsIDOMNode aNode, out nsIDOMElement aReturn); */
NS_IMETHODIMP nsHTMLEditor::GetElementOrParentByTagName(const nsAReadableString & aTagName, nsIDOMNode *aNode, nsIDOMElement **aReturn)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetSelectedElement (in DOMString aTagName, out nsIDOMElement aReturn); */
NS_IMETHODIMP nsHTMLEditor::GetSelectedElement(const nsAReadableString & aTagName, nsIDOMElement **aReturn)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetHeadContentsAsHTML (out DOMString aOutputString); */
NS_IMETHODIMP nsHTMLEditor::GetHeadContentsAsHTML(nsAWritableString & aOutputString)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void ReplaceHeadContentsWithHTML (in DOMString aSourceToInsert); */
NS_IMETHODIMP nsHTMLEditor::ReplaceHeadContentsWithHTML(const nsAReadableString & aSourceToInsert)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CreateElementWithDefaults (in DOMString aTagName, out nsIDOMElement aReturn); */
NS_IMETHODIMP nsHTMLEditor::CreateElementWithDefaults(const nsAReadableString & aTagName, nsIDOMElement **aReturn)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertLinkAroundSelection (in nsIDOMElement aAnchorElement); */
NS_IMETHODIMP nsHTMLEditor::InsertLinkAroundSelection(nsIDOMElement *aAnchorElement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetBackgroundColor (in DOMString aColor); */
NS_IMETHODIMP nsHTMLEditor::SetBackgroundColor(const nsAReadableString & aColor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetBodyAttribute (in DOMString aAttr, in DOMString aValue); */
NS_IMETHODIMP nsHTMLEditor::SetBodyAttribute(const nsAReadableString & aAttr, const nsAReadableString & aValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void IgnoreSpuriousDragEvent (in boolean aIgnoreSpuriousDragEvent); */
NS_IMETHODIMP nsHTMLEditor::IgnoreSpuriousDragEvent(PRBool aIgnoreSpuriousDragEvent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIHTMLEditor_h__ */
