/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIEnumerator.idl
 */

#ifndef __gen_nsIEnumerator_h__
#define __gen_nsIEnumerator_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#define NS_ENUMERATOR_FALSE 1

/* starting interface:    nsISimpleEnumerator */
#define NS_ISIMPLEENUMERATOR_IID_STR "d1899240-f9d2-11d2-bdd6-000064657374"

#define NS_ISIMPLEENUMERATOR_IID \
  {0xd1899240, 0xf9d2, 0x11d2, \
    { 0xbd, 0xd6, 0x00, 0x00, 0x64, 0x65, 0x73, 0x74 }}

/**
 * Used to enumerate over elements defined by its implementor.
 * Although hasMoreElements() can be called independently of getNext(),
 * getNext() must be pre-ceeded by a call to hasMoreElements(). There is
 * no way to "reset" an enumerator, once you obtain one.
 *
 * @status FROZEN
 * @version 1.0
 */
class NS_NO_VTABLE nsISimpleEnumerator : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISIMPLEENUMERATOR_IID)

  /**
   * Called to determine whether or not the enumerator has
   * any elements that can be returned via getNext(). This method
   * is generally used to determine whether or not to initiate or
   * continue iteration over the enumerator, though it can be
   * called without subsequent getNext() calls. Does not affect
   * internal state of enumerator.
   *
   * @see getNext()
   * @return PR_TRUE if there are remaining elements in the enumerator.
   *         PR_FALSE if there are no more elements in the enumerator.
   */
  /* boolean hasMoreElements (); */
  NS_IMETHOD HasMoreElements(PRBool *_retval) = 0;

  /**
   * Called to retrieve the next element in the enumerator. The "next"
   * element is the first element upon the first call. Must be
   * pre-ceeded by a call to hasMoreElements() which returns PR_TRUE.
   * This method is generally called within a loop to iterate over
   * the elements in the enumerator.
   *
   * @see hasMoreElements()
   * @return NS_OK if the call succeeded in returning a non-null
   *               value through the out parameter.
   *         NS_ERROR_FAILURE if there are no more elements
   *                          to enumerate.
   * @return the next element in the enumeration.
   */
  /* nsISupports getNext (); */
  NS_IMETHOD GetNext(nsISupports **_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISIMPLEENUMERATOR \
  NS_IMETHOD HasMoreElements(PRBool *_retval); \
  NS_IMETHOD GetNext(nsISupports **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISIMPLEENUMERATOR(_to) \
  NS_IMETHOD HasMoreElements(PRBool *_retval) { return _to ## HasMoreElements(_retval); } \
  NS_IMETHOD GetNext(nsISupports **_retval) { return _to ## GetNext(_retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISIMPLEENUMERATOR(_to) \
  NS_IMETHOD HasMoreElements(PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> HasMoreElements(_retval); } \
  NS_IMETHOD GetNext(nsISupports **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetNext(_retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsSimpleEnumerator : public nsISimpleEnumerator
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISIMPLEENUMERATOR

  nsSimpleEnumerator();
  virtual ~nsSimpleEnumerator();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsSimpleEnumerator, nsISimpleEnumerator)

nsSimpleEnumerator::nsSimpleEnumerator()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsSimpleEnumerator::~nsSimpleEnumerator()
{
  /* destructor code */
}

/* boolean hasMoreElements (); */
NS_IMETHODIMP nsSimpleEnumerator::HasMoreElements(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupports getNext (); */
NS_IMETHODIMP nsSimpleEnumerator::GetNext(nsISupports **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIEnumerator */
#define NS_IENUMERATOR_IID_STR "ad385286-cbc4-11d2-8cca-0060b0fc14a3"

#define NS_IENUMERATOR_IID \
  {0xad385286, 0xcbc4, 0x11d2, \
    { 0x8c, 0xca, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

class NS_NO_VTABLE nsIEnumerator : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IENUMERATOR_IID)

  /** First will reset the list. will return NS_FAILED if no items
   */
  /* void first (); */
  NS_IMETHOD First(void) = 0;

  /** Next will advance the list. will return failed if already at end
   */
  /* void next (); */
  NS_IMETHOD Next(void) = 0;

  /** CurrentItem will return the CurrentItem item it will fail if the 
   *  list is empty
   */
  /* nsISupports currentItem (); */
  NS_IMETHOD CurrentItem(nsISupports **_retval) = 0;

  /** return if the collection is at the end.  that is the beginning following 
   *  a call to Prev and it is the end of the list following a call to next
   */
  /* void isDone (); */
  NS_IMETHOD IsDone(void) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIENUMERATOR \
  NS_IMETHOD First(void); \
  NS_IMETHOD Next(void); \
  NS_IMETHOD CurrentItem(nsISupports **_retval); \
  NS_IMETHOD IsDone(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIENUMERATOR(_to) \
  NS_IMETHOD First(void) { return _to ## First(); } \
  NS_IMETHOD Next(void) { return _to ## Next(); } \
  NS_IMETHOD CurrentItem(nsISupports **_retval) { return _to ## CurrentItem(_retval); } \
  NS_IMETHOD IsDone(void) { return _to ## IsDone(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIENUMERATOR(_to) \
  NS_IMETHOD First(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> First(); } \
  NS_IMETHOD Next(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Next(); } \
  NS_IMETHOD CurrentItem(nsISupports **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CurrentItem(_retval); } \
  NS_IMETHOD IsDone(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> IsDone(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsEnumerator : public nsIEnumerator
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIENUMERATOR

  nsEnumerator();
  virtual ~nsEnumerator();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsEnumerator, nsIEnumerator)

nsEnumerator::nsEnumerator()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsEnumerator::~nsEnumerator()
{
  /* destructor code */
}

/* void first (); */
NS_IMETHODIMP nsEnumerator::First()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void next (); */
NS_IMETHODIMP nsEnumerator::Next()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupports currentItem (); */
NS_IMETHODIMP nsEnumerator::CurrentItem(nsISupports **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void isDone (); */
NS_IMETHODIMP nsEnumerator::IsDone()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIBidirectionalEnumerator */
#define NS_IBIDIRECTIONALENUMERATOR_IID_STR "75f158a0-cadd-11d2-8cca-0060b0fc14a3"

#define NS_IBIDIRECTIONALENUMERATOR_IID \
  {0x75f158a0, 0xcadd, 0x11d2, \
    { 0x8c, 0xca, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

class NS_NO_VTABLE nsIBidirectionalEnumerator : public nsIEnumerator {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IBIDIRECTIONALENUMERATOR_IID)

  /** Last will reset the list to the end. will return NS_FAILED if no items
   */
  /* void last (); */
  NS_IMETHOD Last(void) = 0;

  /** Prev will decrement the list. will return failed if already at beginning
   */
  /* void prev (); */
  NS_IMETHOD Prev(void) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIBIDIRECTIONALENUMERATOR \
  NS_IMETHOD Last(void); \
  NS_IMETHOD Prev(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIBIDIRECTIONALENUMERATOR(_to) \
  NS_IMETHOD Last(void) { return _to ## Last(); } \
  NS_IMETHOD Prev(void) { return _to ## Prev(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIBIDIRECTIONALENUMERATOR(_to) \
  NS_IMETHOD Last(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Last(); } \
  NS_IMETHOD Prev(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Prev(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsBidirectionalEnumerator : public nsIBidirectionalEnumerator
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIBIDIRECTIONALENUMERATOR

  nsBidirectionalEnumerator();
  virtual ~nsBidirectionalEnumerator();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsBidirectionalEnumerator, nsIBidirectionalEnumerator)

nsBidirectionalEnumerator::nsBidirectionalEnumerator()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsBidirectionalEnumerator::~nsBidirectionalEnumerator()
{
  /* destructor code */
}

/* void last (); */
NS_IMETHODIMP nsBidirectionalEnumerator::Last()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void prev (); */
NS_IMETHODIMP nsBidirectionalEnumerator::Prev()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

extern "C" NS_COM nsresult
NS_NewEmptyEnumerator(nsISimpleEnumerator** aResult);
// Construct and return an implementation of a "conjoining enumerator." This
// enumerator lets you string together two other enumerators into one sequence.
// The result is an nsIBidirectionalEnumerator, but if either input is not
// also bidirectional, the Last and Prev operations will fail.
extern "C" NS_COM nsresult
NS_NewConjoiningEnumerator(nsIEnumerator* first, nsIEnumerator* second,
                           nsIBidirectionalEnumerator* *aInstancePtrResult);
// Construct and return an implementation of a "union enumerator." This
// enumerator will only return elements that are found in both constituent
// enumerators.
extern "C" NS_COM nsresult
NS_NewUnionEnumerator(nsIEnumerator* first, nsIEnumerator* second,
                      nsIEnumerator* *aInstancePtrResult);
// Construct and return an implementation of an "intersection enumerator." This
// enumerator will return elements that are found in either constituent
// enumerators, eliminating duplicates.
extern "C" NS_COM nsresult
NS_NewIntersectionEnumerator(nsIEnumerator* first, nsIEnumerator* second,
                             nsIEnumerator* *aInstancePtrResult);

#endif /* __gen_nsIEnumerator_h__ */
