/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIXMLHttpRequest.idl
 */

#ifndef __gen_nsIXMLHttpRequest_h__
#define __gen_nsIXMLHttpRequest_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDOMDocument; /* forward declaration */

class nsIDOMEventListener; /* forward declaration */

class nsIHttpChannel; /* forward declaration */


/* starting interface:    nsIXMLHttpRequest */
#define NS_IXMLHTTPREQUEST_IID_STR "b7215e70-4157-11d4-9a42-000064657374"

#define NS_IXMLHTTPREQUEST_IID \
  {0xb7215e70, 0x4157, 0x11d4, \
    { 0x9a, 0x42, 0x00, 0x00, 0x64, 0x65, 0x73, 0x74 }}

class NS_NO_VTABLE nsIXMLHttpRequest : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IXMLHTTPREQUEST_IID)

  /**
   * Meant to be a script-only mechanism for setting a load event listener.
   * The attribute is expected to be JavaScript function object. When
   * the load event occurs, the function is invoked. 
   * This attribute should not be used from native code!!
   */
  /* attribute nsISupports onload; */
  NS_IMETHOD GetOnload(nsISupports * *aOnload) = 0;
  NS_IMETHOD SetOnload(nsISupports * aOnload) = 0;

  /**
   * Meant to be a script-only mechanism for setting an error event listener.
   * The attribute is expected to be JavaScript function object. When
   * the error event occurs, the function is invoked. 
   * This attribute should not be used from native code!!
   */
  /* attribute nsISupports onerror; */
  NS_IMETHOD GetOnerror(nsISupports * *aOnerror) = 0;
  NS_IMETHOD SetOnerror(nsISupports * aOnerror) = 0;

  /**
   * The HTTP request uses an HTTP channel in order to perform the
   * request.  This attribute represents the HTTP channel used
   * for the request.  NULL if the HTTP channel has not yet been
   * created.
   */
  /* readonly attribute nsIHttpChannel channel; */
  NS_IMETHOD GetChannel(nsIHttpChannel * *aChannel) = 0;

  /**
   * The response to the HTTP request is parsed as if it were a
   * text/xml stream. This attributes represents the response as 
   * a DOM Document object. NULL if the request is unsuccessful or
   * has not yet been sent.
   */
  /* readonly attribute nsIDOMDocument responseXML; */
  NS_IMETHOD GetResponseXML(nsIDOMDocument * *aResponseXML) = 0;

  /**
   * The response to the HTTP request as text. 
   * NULL if the request is unsuccessful or
   * has not yet been sent.
   */
  /* readonly attribute wstring responseText; */
  NS_IMETHOD GetResponseText(PRUnichar * *aResponseText) = 0;

  /**
   * The status of the response to the HTTP request.
   */
  /* readonly attribute unsigned long status; */
  NS_IMETHOD GetStatus(PRUint32 *aStatus) = 0;

  /**
   * The string representing the status of the response to the
   * HTTP request.
   */
  /* readonly attribute string statusText; */
  NS_IMETHOD GetStatusText(char * *aStatusText) = 0;

  /**
   * If the HTTP request has been sent already, this method will
   * abort the request.
   */
  /* void abort (); */
  NS_IMETHOD Abort(void) = 0;

  /**
   * Returns all of the HTTP response headers as a string string.
   * 
   * @returns A string containing all of the response headers. 
   *          NULL if the response has not yet been received.
   */
  /* string getAllResponseHeaders (); */
  NS_IMETHOD GetAllResponseHeaders(char **_retval) = 0;

  /**
   * Returns the text of the header with the specified name.
   *
   * @param header The name of the header to retrieve
   * @returns A string containing the text of the header specified.
   *          NULL if the response has not yet been received or the
   *          header does not exist in the response.
   */
  /* string getResponseHeader (in string header); */
  NS_IMETHOD GetResponseHeader(const char *header, char **_retval) = 0;

  /**
   * Native (non-script) method to initialize a request. Note that
   * the HTTP request is not sent until the <code>send</code> method 
   * is invoked.
   *
   * @param method The HTTP method - either "POST" or "GET".
   * @param url The URL to which to send the request.
   * @param async Whether the request is synchronous or asynchronous
   *              i.e. whether send returns only after the response
   *              is received or if it returns immediately after
   *              sending the request. In the latter case, notification
   *              of completion is sent through the event listeners.
   * @param user A username for authentication if necessary.
   * @param password A password for authentication if necessary.
   */
  /* [noscript] void openRequest (in string method, in string url, in boolean async, in string user, in string password); */
  NS_IMETHOD OpenRequest(const char *method, const char *url, PRBool async, const char *user, const char *password) = 0;

  /**
   * Meant to be a script-only method for initializing a request.
   * The parameters are similar to the ones detailed in the
   * description of <code>openRequest</code>, but the last
   * 3 are optional.
   *
   * @param method The HTTP method - either "POST" or "GET".
   * @param url The URL to which to send the request.
   * @param async (optional) Whether the request is synchronous or 
   *              asynchronous i.e. whether send returns only after 
   *              the response is received or if it returns immediately after
   *              sending the request. In the latter case, notification
   *              of completion is sent through the event listeners.
   *              The default value is true.
   * @param user (optional) A username for authentication if necessary. 
   *             The default value is the empty string
   * @param password (optional) A password for authentication if necessary.
   *                 The default value is the empty string
   */
  /* void open (in string method, in string url); */
  NS_IMETHOD Open(const char *method, const char *url) = 0;

  /**
   * Sends the HTTP request. If the request is asynchronous, returns
   * immediately after sending the request. If it is synchronous
   * returns only after the response has been received.
   *
   * @param body Either an instance of nsIDOMDocument, nsIInputStream
   *             or a string (nsISupportsWString in the native calling
   *             case). This is used to populate the body of the
   *             HTTP request if the HTTP request method is "POST".
   *             If the parameter is a nsIDOMDocument, it is serialized.
   *             If the parameter is a nsIInputStream, it is expected
   *             to contain the ContentType: and ContentLength: headers
   *             and trailing carriage-return/line-feed pairs.
   */
  /* void send (in nsISupports body); */
  NS_IMETHOD Send(nsISupports *body) = 0;

  /**
   * Sets a HTTP request header.
   *
   * @param header The name of the header to set in the request.
   * @param value The body of the header.
   */
  /* void setRequestHeader (in string header, in string value); */
  NS_IMETHOD SetRequestHeader(const char *header, const char *value) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIXMLHTTPREQUEST \
  NS_IMETHOD GetOnload(nsISupports * *aOnload); \
  NS_IMETHOD SetOnload(nsISupports * aOnload); \
  NS_IMETHOD GetOnerror(nsISupports * *aOnerror); \
  NS_IMETHOD SetOnerror(nsISupports * aOnerror); \
  NS_IMETHOD GetChannel(nsIHttpChannel * *aChannel); \
  NS_IMETHOD GetResponseXML(nsIDOMDocument * *aResponseXML); \
  NS_IMETHOD GetResponseText(PRUnichar * *aResponseText); \
  NS_IMETHOD GetStatus(PRUint32 *aStatus); \
  NS_IMETHOD GetStatusText(char * *aStatusText); \
  NS_IMETHOD Abort(void); \
  NS_IMETHOD GetAllResponseHeaders(char **_retval); \
  NS_IMETHOD GetResponseHeader(const char *header, char **_retval); \
  NS_IMETHOD OpenRequest(const char *method, const char *url, PRBool async, const char *user, const char *password); \
  NS_IMETHOD Open(const char *method, const char *url); \
  NS_IMETHOD Send(nsISupports *body); \
  NS_IMETHOD SetRequestHeader(const char *header, const char *value); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIXMLHTTPREQUEST(_to) \
  NS_IMETHOD GetOnload(nsISupports * *aOnload) { return _to ## GetOnload(aOnload); } \
  NS_IMETHOD SetOnload(nsISupports * aOnload) { return _to ## SetOnload(aOnload); } \
  NS_IMETHOD GetOnerror(nsISupports * *aOnerror) { return _to ## GetOnerror(aOnerror); } \
  NS_IMETHOD SetOnerror(nsISupports * aOnerror) { return _to ## SetOnerror(aOnerror); } \
  NS_IMETHOD GetChannel(nsIHttpChannel * *aChannel) { return _to ## GetChannel(aChannel); } \
  NS_IMETHOD GetResponseXML(nsIDOMDocument * *aResponseXML) { return _to ## GetResponseXML(aResponseXML); } \
  NS_IMETHOD GetResponseText(PRUnichar * *aResponseText) { return _to ## GetResponseText(aResponseText); } \
  NS_IMETHOD GetStatus(PRUint32 *aStatus) { return _to ## GetStatus(aStatus); } \
  NS_IMETHOD GetStatusText(char * *aStatusText) { return _to ## GetStatusText(aStatusText); } \
  NS_IMETHOD Abort(void) { return _to ## Abort(); } \
  NS_IMETHOD GetAllResponseHeaders(char **_retval) { return _to ## GetAllResponseHeaders(_retval); } \
  NS_IMETHOD GetResponseHeader(const char *header, char **_retval) { return _to ## GetResponseHeader(header, _retval); } \
  NS_IMETHOD OpenRequest(const char *method, const char *url, PRBool async, const char *user, const char *password) { return _to ## OpenRequest(method, url, async, user, password); } \
  NS_IMETHOD Open(const char *method, const char *url) { return _to ## Open(method, url); } \
  NS_IMETHOD Send(nsISupports *body) { return _to ## Send(body); } \
  NS_IMETHOD SetRequestHeader(const char *header, const char *value) { return _to ## SetRequestHeader(header, value); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIXMLHTTPREQUEST(_to) \
  NS_IMETHOD GetOnload(nsISupports * *aOnload) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetOnload(aOnload); } \
  NS_IMETHOD SetOnload(nsISupports * aOnload) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetOnload(aOnload); } \
  NS_IMETHOD GetOnerror(nsISupports * *aOnerror) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetOnerror(aOnerror); } \
  NS_IMETHOD SetOnerror(nsISupports * aOnerror) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetOnerror(aOnerror); } \
  NS_IMETHOD GetChannel(nsIHttpChannel * *aChannel) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetChannel(aChannel); } \
  NS_IMETHOD GetResponseXML(nsIDOMDocument * *aResponseXML) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetResponseXML(aResponseXML); } \
  NS_IMETHOD GetResponseText(PRUnichar * *aResponseText) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetResponseText(aResponseText); } \
  NS_IMETHOD GetStatus(PRUint32 *aStatus) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetStatus(aStatus); } \
  NS_IMETHOD GetStatusText(char * *aStatusText) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetStatusText(aStatusText); } \
  NS_IMETHOD Abort(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Abort(); } \
  NS_IMETHOD GetAllResponseHeaders(char **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetAllResponseHeaders(_retval); } \
  NS_IMETHOD GetResponseHeader(const char *header, char **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetResponseHeader(header, _retval); } \
  NS_IMETHOD OpenRequest(const char *method, const char *url, PRBool async, const char *user, const char *password) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> OpenRequest(method, url, async, user, password); } \
  NS_IMETHOD Open(const char *method, const char *url) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Open(method, url); } \
  NS_IMETHOD Send(nsISupports *body) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Send(body); } \
  NS_IMETHOD SetRequestHeader(const char *header, const char *value) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetRequestHeader(header, value); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsXMLHttpRequest : public nsIXMLHttpRequest
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIXMLHTTPREQUEST

  nsXMLHttpRequest();
  virtual ~nsXMLHttpRequest();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsXMLHttpRequest, nsIXMLHttpRequest)

nsXMLHttpRequest::nsXMLHttpRequest()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsXMLHttpRequest::~nsXMLHttpRequest()
{
  /* destructor code */
}

/* attribute nsISupports onload; */
NS_IMETHODIMP nsXMLHttpRequest::GetOnload(nsISupports * *aOnload)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsXMLHttpRequest::SetOnload(nsISupports * aOnload)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsISupports onerror; */
NS_IMETHODIMP nsXMLHttpRequest::GetOnerror(nsISupports * *aOnerror)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsXMLHttpRequest::SetOnerror(nsISupports * aOnerror)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIHttpChannel channel; */
NS_IMETHODIMP nsXMLHttpRequest::GetChannel(nsIHttpChannel * *aChannel)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMDocument responseXML; */
NS_IMETHODIMP nsXMLHttpRequest::GetResponseXML(nsIDOMDocument * *aResponseXML)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute wstring responseText; */
NS_IMETHODIMP nsXMLHttpRequest::GetResponseText(PRUnichar * *aResponseText)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long status; */
NS_IMETHODIMP nsXMLHttpRequest::GetStatus(PRUint32 *aStatus)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string statusText; */
NS_IMETHODIMP nsXMLHttpRequest::GetStatusText(char * *aStatusText)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void abort (); */
NS_IMETHODIMP nsXMLHttpRequest::Abort()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getAllResponseHeaders (); */
NS_IMETHODIMP nsXMLHttpRequest::GetAllResponseHeaders(char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getResponseHeader (in string header); */
NS_IMETHODIMP nsXMLHttpRequest::GetResponseHeader(const char *header, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void openRequest (in string method, in string url, in boolean async, in string user, in string password); */
NS_IMETHODIMP nsXMLHttpRequest::OpenRequest(const char *method, const char *url, PRBool async, const char *user, const char *password)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void open (in string method, in string url); */
NS_IMETHODIMP nsXMLHttpRequest::Open(const char *method, const char *url)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void send (in nsISupports body); */
NS_IMETHODIMP nsXMLHttpRequest::Send(nsISupports *body)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setRequestHeader (in string header, in string value); */
NS_IMETHODIMP nsXMLHttpRequest::SetRequestHeader(const char *header, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define NS_XMLHTTPREQUEST_CID                       \
 { /* d164e770-4157-11d4-9a42-000064657374 */       \
  0xd164e770, 0x4157, 0x11d4,                       \
 {0x9a, 0x42, 0x00, 0x00, 0x64, 0x65, 0x73, 0x74} }
#define NS_XMLHTTPREQUEST_CONTRACTID \
"@mozilla.org/xmlextras/xmlhttprequest;1"

#endif /* __gen_nsIXMLHttpRequest_h__ */
