/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIWebNavigation.idl
 */

#ifndef __gen_nsIWebNavigation_h__
#define __gen_nsIWebNavigation_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDOMDocument; /* forward declaration */

/**
 * The nsIWebNavigation interface defines an interface for navigating the web.
 * It provides methods and attributes to direct an object to navigate to a new
 * location, stop or restart an in process load or determine where the object,
 * has previously gone.   
 *
 * @status UNDER_REVIEW
 */
class nsISHistory; /* forward declaration */

class nsISHEntry; /* forward declaration */

class nsIURI; /* forward declaration */


/* starting interface:    nsIWebNavigation */
#define NS_IWEBNAVIGATION_IID_STR "f5d9e7b0-d930-11d3-b057-00a024ffc08c"

#define NS_IWEBNAVIGATION_IID \
  {0xf5d9e7b0, 0xd930, 0x11d3, \
    { 0xb0, 0x57, 0x00, 0xa0, 0x24, 0xff, 0xc0, 0x8c }}

class NS_NO_VTABLE nsIWebNavigation : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IWEBNAVIGATION_IID)

  /* readonly attribute boolean canGoBack; */
  NS_IMETHOD GetCanGoBack(PRBool *aCanGoBack) = 0;

  /* readonly attribute boolean canGoForward; */
  NS_IMETHOD GetCanGoForward(PRBool *aCanGoForward) = 0;

  /* void goBack (); */
  NS_IMETHOD GoBack(void) = 0;

  /* void goForward (); */
  NS_IMETHOD GoForward(void) = 0;

  /* void gotoIndex (in long index); */
  NS_IMETHOD GotoIndex(PRInt32 index) = 0;

  enum { LOAD_FLAGS_NONE = 0U };

  enum { LOAD_FLAGS_MASK = 65535U };

  enum { LOAD_FLAGS_IS_REFRESH = 16U };

  enum { LOAD_FLAGS_IS_LINK = 32U };

  enum { LOAD_FLAGS_BYPASS_HISTORY = 64U };

  enum { LOAD_FLAGS_REPLACE_HISTORY = 128U };

  enum { LOAD_FLAGS_BYPASS_CACHE = 256U };

  enum { LOAD_FLAGS_BYPASS_PROXY = 512U };

  /* void loadURI (in wstring uri, in unsigned long loadFlags); */
  NS_IMETHOD LoadURI(const PRUnichar *uri, PRUint32 loadFlags) = 0;

  /* void reload (in unsigned long reloadFlags); */
  NS_IMETHOD Reload(PRUint32 reloadFlags) = 0;

  /* void stop (); */
  NS_IMETHOD Stop(void) = 0;

  /* readonly attribute nsIDOMDocument document; */
  NS_IMETHOD GetDocument(nsIDOMDocument * *aDocument) = 0;

  /* readonly attribute nsIURI currentURI; */
  NS_IMETHOD GetCurrentURI(nsIURI * *aCurrentURI) = 0;

  /* attribute nsISHistory sessionHistory; */
  NS_IMETHOD GetSessionHistory(nsISHistory * *aSessionHistory) = 0;
  NS_IMETHOD SetSessionHistory(nsISHistory * aSessionHistory) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIWEBNAVIGATION \
  NS_IMETHOD GetCanGoBack(PRBool *aCanGoBack); \
  NS_IMETHOD GetCanGoForward(PRBool *aCanGoForward); \
  NS_IMETHOD GoBack(void); \
  NS_IMETHOD GoForward(void); \
  NS_IMETHOD GotoIndex(PRInt32 index); \
  NS_IMETHOD LoadURI(const PRUnichar *uri, PRUint32 loadFlags); \
  NS_IMETHOD Reload(PRUint32 reloadFlags); \
  NS_IMETHOD Stop(void); \
  NS_IMETHOD GetDocument(nsIDOMDocument * *aDocument); \
  NS_IMETHOD GetCurrentURI(nsIURI * *aCurrentURI); \
  NS_IMETHOD GetSessionHistory(nsISHistory * *aSessionHistory); \
  NS_IMETHOD SetSessionHistory(nsISHistory * aSessionHistory); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIWEBNAVIGATION(_to) \
  NS_IMETHOD GetCanGoBack(PRBool *aCanGoBack) { return _to ## GetCanGoBack(aCanGoBack); } \
  NS_IMETHOD GetCanGoForward(PRBool *aCanGoForward) { return _to ## GetCanGoForward(aCanGoForward); } \
  NS_IMETHOD GoBack(void) { return _to ## GoBack(); } \
  NS_IMETHOD GoForward(void) { return _to ## GoForward(); } \
  NS_IMETHOD GotoIndex(PRInt32 index) { return _to ## GotoIndex(index); } \
  NS_IMETHOD LoadURI(const PRUnichar *uri, PRUint32 loadFlags) { return _to ## LoadURI(uri, loadFlags); } \
  NS_IMETHOD Reload(PRUint32 reloadFlags) { return _to ## Reload(reloadFlags); } \
  NS_IMETHOD Stop(void) { return _to ## Stop(); } \
  NS_IMETHOD GetDocument(nsIDOMDocument * *aDocument) { return _to ## GetDocument(aDocument); } \
  NS_IMETHOD GetCurrentURI(nsIURI * *aCurrentURI) { return _to ## GetCurrentURI(aCurrentURI); } \
  NS_IMETHOD GetSessionHistory(nsISHistory * *aSessionHistory) { return _to ## GetSessionHistory(aSessionHistory); } \
  NS_IMETHOD SetSessionHistory(nsISHistory * aSessionHistory) { return _to ## SetSessionHistory(aSessionHistory); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIWEBNAVIGATION(_to) \
  NS_IMETHOD GetCanGoBack(PRBool *aCanGoBack) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetCanGoBack(aCanGoBack); } \
  NS_IMETHOD GetCanGoForward(PRBool *aCanGoForward) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetCanGoForward(aCanGoForward); } \
  NS_IMETHOD GoBack(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GoBack(); } \
  NS_IMETHOD GoForward(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GoForward(); } \
  NS_IMETHOD GotoIndex(PRInt32 index) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GotoIndex(index); } \
  NS_IMETHOD LoadURI(const PRUnichar *uri, PRUint32 loadFlags) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> LoadURI(uri, loadFlags); } \
  NS_IMETHOD Reload(PRUint32 reloadFlags) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Reload(reloadFlags); } \
  NS_IMETHOD Stop(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Stop(); } \
  NS_IMETHOD GetDocument(nsIDOMDocument * *aDocument) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetDocument(aDocument); } \
  NS_IMETHOD GetCurrentURI(nsIURI * *aCurrentURI) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetCurrentURI(aCurrentURI); } \
  NS_IMETHOD GetSessionHistory(nsISHistory * *aSessionHistory) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetSessionHistory(aSessionHistory); } \
  NS_IMETHOD SetSessionHistory(nsISHistory * aSessionHistory) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetSessionHistory(aSessionHistory); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsWebNavigation : public nsIWebNavigation
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIWEBNAVIGATION

  nsWebNavigation();
  virtual ~nsWebNavigation();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsWebNavigation, nsIWebNavigation)

nsWebNavigation::nsWebNavigation()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsWebNavigation::~nsWebNavigation()
{
  /* destructor code */
}

/* readonly attribute boolean canGoBack; */
NS_IMETHODIMP nsWebNavigation::GetCanGoBack(PRBool *aCanGoBack)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canGoForward; */
NS_IMETHODIMP nsWebNavigation::GetCanGoForward(PRBool *aCanGoForward)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void goBack (); */
NS_IMETHODIMP nsWebNavigation::GoBack()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void goForward (); */
NS_IMETHODIMP nsWebNavigation::GoForward()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void gotoIndex (in long index); */
NS_IMETHODIMP nsWebNavigation::GotoIndex(PRInt32 index)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void loadURI (in wstring uri, in unsigned long loadFlags); */
NS_IMETHODIMP nsWebNavigation::LoadURI(const PRUnichar *uri, PRUint32 loadFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void reload (in unsigned long reloadFlags); */
NS_IMETHODIMP nsWebNavigation::Reload(PRUint32 reloadFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void stop (); */
NS_IMETHODIMP nsWebNavigation::Stop()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMDocument document; */
NS_IMETHODIMP nsWebNavigation::GetDocument(nsIDOMDocument * *aDocument)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIURI currentURI; */
NS_IMETHODIMP nsWebNavigation::GetCurrentURI(nsIURI * *aCurrentURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsISHistory sessionHistory; */
NS_IMETHODIMP nsWebNavigation::GetSessionHistory(nsISHistory * *aSessionHistory)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsWebNavigation::SetSessionHistory(nsISHistory * aSessionHistory)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIWebNavigation_h__ */
