/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIStreamListener.idl
 */

#ifndef __gen_nsIStreamListener_h__
#define __gen_nsIStreamListener_h__


#ifndef __gen_nsIRequestObserver_h__
#include "nsIRequestObserver.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIRequest; /* forward declaration */

class nsIInputStream; /* forward declaration */

class nsIOutputStream; /* forward declaration */

class nsIEventQueue; /* forward declaration */


/* starting interface:    nsIStreamListener */
#define NS_ISTREAMLISTENER_IID_STR "1a637020-1482-11d3-9333-00104ba0fd40"

#define NS_ISTREAMLISTENER_IID \
  {0x1a637020, 0x1482, 0x11d3, \
    { 0x93, 0x33, 0x00, 0x10, 0x4b, 0xa0, 0xfd, 0x40 }}

/**
 * The nsIChannel::AsyncRead notification handler.  It accepts
 * data from the channel, when the channel is ready to provide it.
 */
class NS_NO_VTABLE nsIStreamListener : public nsIRequestObserver {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISTREAMLISTENER_IID)

  /**
     * Called when there is data to be read from the channel.
     *
     * @param request - the request returned by AsyncRead
     * @param ctxt - opaque parameter passed to AsyncRead
     * @param input - temporary input stream for reading data chunk
     * @param offset - current stream position (informational)
     * @param count - number of bytes that can be read without blocking
     *
     * @return NS_OK - if successfully read something.
     * @return NS_BASE_STREAM_CLOSED - if done reading data. NOTE: this is
     *   NOT equivalent to reading zero bytes and returning NS_OK.
     * @return NS_BASE_STREAM_WOULD_BLOCK - if no data can be read at
     *   this time.  This implicitly calls Suspend on the channel.  Call
     *   Resume on the channel to continue the AsyncRead when more data
     *   becomes available.
     * @return <other-error> - if failure.
     */
  /* void onDataAvailable (in nsIRequest request, in nsISupports ctxt, in nsIInputStream input, in unsigned long offset, in unsigned long count); */
  NS_IMETHOD OnDataAvailable(nsIRequest *request, nsISupports *ctxt, nsIInputStream *input, PRUint32 offset, PRUint32 count) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISTREAMLISTENER \
  NS_IMETHOD OnDataAvailable(nsIRequest *request, nsISupports *ctxt, nsIInputStream *input, PRUint32 offset, PRUint32 count); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISTREAMLISTENER(_to) \
  NS_IMETHOD OnDataAvailable(nsIRequest *request, nsISupports *ctxt, nsIInputStream *input, PRUint32 offset, PRUint32 count) { return _to ## OnDataAvailable(request, ctxt, input, offset, count); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISTREAMLISTENER(_to) \
  NS_IMETHOD OnDataAvailable(nsIRequest *request, nsISupports *ctxt, nsIInputStream *input, PRUint32 offset, PRUint32 count) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> OnDataAvailable(request, ctxt, input, offset, count); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsStreamListener : public nsIStreamListener
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISTREAMLISTENER

  nsStreamListener();
  virtual ~nsStreamListener();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsStreamListener, nsIStreamListener)

nsStreamListener::nsStreamListener()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsStreamListener::~nsStreamListener()
{
  /* destructor code */
}

/* void onDataAvailable (in nsIRequest request, in nsISupports ctxt, in nsIInputStream input, in unsigned long offset, in unsigned long count); */
NS_IMETHODIMP nsStreamListener::OnDataAvailable(nsIRequest *request, nsISupports *ctxt, nsIInputStream *input, PRUint32 offset, PRUint32 count)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIStreamListenerProxy */
#define NS_ISTREAMLISTENERPROXY_IID_STR "e400e688-6b54-4a84-8c4e-56b40281981a"

#define NS_ISTREAMLISTENERPROXY_IID \
  {0xe400e688, 0x6b54, 0x4a84, \
    { 0x8c, 0x4e, 0x56, 0xb4, 0x02, 0x81, 0x98, 0x1a }}

/**
 * A stream listener proxy is used to ship data over to another thread specified
 * by the thread's event queue.  The "true" stream listener's methods are
 * invoked on the other thread.
 *
 * This interface only provides the initialization needed after construction. 
 * Otherwise, these objects may be used as a nsIStreamListener.
 */
class NS_NO_VTABLE nsIStreamListenerProxy : public nsIStreamListener {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISTREAMLISTENERPROXY_IID)

  /**
     * Initializes an nsIStreamListenerProxy.
     *
     * @param listener - receives listener notifications on the other thread
     * @param eventQ - may be NULL indicating the calling thread's event queue
     * @param bufferSegmentSize - passing zero indicates the default
     * @param bufferMaxSize - passing zero indicates the default
     */
  /* void init (in nsIStreamListener listener, in nsIEventQueue eventQ, in unsigned long bufferSegmentSize, in unsigned long bufferMaxSize); */
  NS_IMETHOD Init(nsIStreamListener *listener, nsIEventQueue *eventQ, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISTREAMLISTENERPROXY \
  NS_IMETHOD Init(nsIStreamListener *listener, nsIEventQueue *eventQ, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISTREAMLISTENERPROXY(_to) \
  NS_IMETHOD Init(nsIStreamListener *listener, nsIEventQueue *eventQ, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize) { return _to ## Init(listener, eventQ, bufferSegmentSize, bufferMaxSize); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISTREAMLISTENERPROXY(_to) \
  NS_IMETHOD Init(nsIStreamListener *listener, nsIEventQueue *eventQ, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(listener, eventQ, bufferSegmentSize, bufferMaxSize); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsStreamListenerProxy : public nsIStreamListenerProxy
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISTREAMLISTENERPROXY

  nsStreamListenerProxy();
  virtual ~nsStreamListenerProxy();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsStreamListenerProxy, nsIStreamListenerProxy)

nsStreamListenerProxy::nsStreamListenerProxy()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsStreamListenerProxy::~nsStreamListenerProxy()
{
  /* destructor code */
}

/* void init (in nsIStreamListener listener, in nsIEventQueue eventQ, in unsigned long bufferSegmentSize, in unsigned long bufferMaxSize); */
NS_IMETHODIMP nsStreamListenerProxy::Init(nsIStreamListener *listener, nsIEventQueue *eventQ, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsISimpleStreamListener */
#define NS_ISIMPLESTREAMLISTENER_IID_STR "a9b84f6a-0824-4278-bae6-bfca0570a26e"

#define NS_ISIMPLESTREAMLISTENER_IID \
  {0xa9b84f6a, 0x0824, 0x4278, \
    { 0xba, 0xe6, 0xbf, 0xca, 0x05, 0x70, 0xa2, 0x6e }}

/**
 * A simple stream listener can be used with AsyncRead to supply data to
 * a output stream.
 */
class NS_NO_VTABLE nsISimpleStreamListener : public nsIStreamListener {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISIMPLESTREAMLISTENER_IID)

  /**
     * Initialize the simple stream listener.
     *
     * @param sink - data will be read from the channel to this output stream
     * @param observer - optional stream observer (can be NULL)
     */
  /* void init (in nsIOutputStream sink, in nsIRequestObserver observer); */
  NS_IMETHOD Init(nsIOutputStream *sink, nsIRequestObserver *observer) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISIMPLESTREAMLISTENER \
  NS_IMETHOD Init(nsIOutputStream *sink, nsIRequestObserver *observer); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISIMPLESTREAMLISTENER(_to) \
  NS_IMETHOD Init(nsIOutputStream *sink, nsIRequestObserver *observer) { return _to ## Init(sink, observer); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISIMPLESTREAMLISTENER(_to) \
  NS_IMETHOD Init(nsIOutputStream *sink, nsIRequestObserver *observer) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(sink, observer); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsSimpleStreamListener : public nsISimpleStreamListener
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISIMPLESTREAMLISTENER

  nsSimpleStreamListener();
  virtual ~nsSimpleStreamListener();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsSimpleStreamListener, nsISimpleStreamListener)

nsSimpleStreamListener::nsSimpleStreamListener()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsSimpleStreamListener::~nsSimpleStreamListener()
{
  /* destructor code */
}

/* void init (in nsIOutputStream sink, in nsIRequestObserver observer); */
NS_IMETHODIMP nsSimpleStreamListener::Init(nsIOutputStream *sink, nsIRequestObserver *observer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIAsyncStreamListener */
#define NS_IASYNCSTREAMLISTENER_IID_STR "1b012ade-91bf-11d3-8cd9-0060b0fc14a3"

#define NS_IASYNCSTREAMLISTENER_IID \
  {0x1b012ade, 0x91bf, 0x11d3, \
    { 0x8c, 0xd9, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

/**
 * An asynchronous stream listener is used to ship data over to another thread specified
 * by the thread's event queue. The receiver stream listener is then used to receive
 * the notifications on the other thread. 
 *
 * This interface only provides the initialization needed after construction. Otherwise,
 * these objects are used simply as nsIStreamListener.
 */
class NS_NO_VTABLE nsIAsyncStreamListener : public nsIStreamListener {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IASYNCSTREAMLISTENER_IID)

  /**
     * Initializes an nsIAsyncStreamListener. 
     * @param eventQueue - may be null indicating the calling thread's event queue
     */
  /* void init (in nsIStreamListener receiver, in nsIEventQueue eventQueue); */
  NS_IMETHOD Init(nsIStreamListener *receiver, nsIEventQueue *eventQueue) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIASYNCSTREAMLISTENER \
  NS_IMETHOD Init(nsIStreamListener *receiver, nsIEventQueue *eventQueue); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIASYNCSTREAMLISTENER(_to) \
  NS_IMETHOD Init(nsIStreamListener *receiver, nsIEventQueue *eventQueue) { return _to ## Init(receiver, eventQueue); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIASYNCSTREAMLISTENER(_to) \
  NS_IMETHOD Init(nsIStreamListener *receiver, nsIEventQueue *eventQueue) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(receiver, eventQueue); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAsyncStreamListener : public nsIAsyncStreamListener
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIASYNCSTREAMLISTENER

  nsAsyncStreamListener();
  virtual ~nsAsyncStreamListener();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAsyncStreamListener, nsIAsyncStreamListener)

nsAsyncStreamListener::nsAsyncStreamListener()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsAsyncStreamListener::~nsAsyncStreamListener()
{
  /* destructor code */
}

/* void init (in nsIStreamListener receiver, in nsIEventQueue eventQueue); */
NS_IMETHODIMP nsAsyncStreamListener::Init(nsIStreamListener *receiver, nsIEventQueue *eventQueue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIStreamListenerTee */
#define NS_ISTREAMLISTENERTEE_IID_STR "fb683e76-d42b-41a4-8ae6-65a6c2b146e5"

#define NS_ISTREAMLISTENERTEE_IID \
  {0xfb683e76, 0xd42b, 0x41a4, \
    { 0x8a, 0xe6, 0x65, 0xa6, 0xc2, 0xb1, 0x46, 0xe5 }}

/**
 * As data "flows" into a stream listener tee, it is copied to the output stream
 * and then forwarded onto the real listener.
 */
class NS_NO_VTABLE nsIStreamListenerTee : public nsIStreamListener {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISTREAMLISTENERTEE_IID)

  /* void init (in nsIStreamListener listener, in nsIOutputStream sink); */
  NS_IMETHOD Init(nsIStreamListener *listener, nsIOutputStream *sink) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISTREAMLISTENERTEE \
  NS_IMETHOD Init(nsIStreamListener *listener, nsIOutputStream *sink); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISTREAMLISTENERTEE(_to) \
  NS_IMETHOD Init(nsIStreamListener *listener, nsIOutputStream *sink) { return _to ## Init(listener, sink); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISTREAMLISTENERTEE(_to) \
  NS_IMETHOD Init(nsIStreamListener *listener, nsIOutputStream *sink) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(listener, sink); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsStreamListenerTee : public nsIStreamListenerTee
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISTREAMLISTENERTEE

  nsStreamListenerTee();
  virtual ~nsStreamListenerTee();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsStreamListenerTee, nsIStreamListenerTee)

nsStreamListenerTee::nsStreamListenerTee()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsStreamListenerTee::~nsStreamListenerTee()
{
  /* destructor code */
}

/* void init (in nsIStreamListener listener, in nsIOutputStream sink); */
NS_IMETHODIMP nsStreamListenerTee::Init(nsIStreamListener *listener, nsIOutputStream *sink)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIStreamListener_h__ */
