/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIMsgIncomingServer.idl
 */

#ifndef __gen_nsIMsgIncomingServer_h__
#define __gen_nsIMsgIncomingServer_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIFileSpec_h__
#include "nsIFileSpec.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIFolder; /* forward declaration */

class nsIMsgFolderCache; /* forward declaration */

class nsIMsgWindow; /* forward declaration */

class nsIMsgFilterList; /* forward declaration */

class nsIMsgRetentionSettings; /* forward declaration */

class nsIMsgDownloadSettings; /* forward declaration */


/* starting interface:    nsIMsgIncomingServer */
#define NS_IMSGINCOMINGSERVER_IID_STR "60dcb100-e3f2-11d2-b7fc-00805f05ffa5"

#define NS_IMSGINCOMINGSERVER_IID \
  {0x60dcb100, 0xe3f2, 0x11d2, \
    { 0xb7, 0xfc, 0x00, 0x80, 0x5f, 0x05, 0xff, 0xa5 }}

class NS_NO_VTABLE nsIMsgIncomingServer : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IMSGINCOMINGSERVER_IID)

  /**
   * internal pref key - guaranteed to be unique across all servers
   */
  /* attribute string key; */
  NS_IMETHOD GetKey(char * *aKey) = 0;
  NS_IMETHOD SetKey(const char * aKey) = 0;

  /**
   * pretty name - should be "userid on hostname"
   * if the pref is not set
   */
  /* attribute wstring prettyName; */
  NS_IMETHOD GetPrettyName(PRUnichar * *aPrettyName) = 0;
  NS_IMETHOD SetPrettyName(const PRUnichar * aPrettyName) = 0;

  /**
  * helper function to construct the pretty name in a server type
  * specific way - e.g., mail for foo@test.com, news on news.mozilla.org
  */
  /* readonly attribute wstring constructedPrettyName; */
  NS_IMETHOD GetConstructedPrettyName(PRUnichar * *aConstructedPrettyName) = 0;

  /**
   * hostname of the server
   */
  /* attribute string hostName; */
  NS_IMETHOD GetHostName(char * *aHostName) = 0;
  NS_IMETHOD SetHostName(const char * aHostName) = 0;

  /* attribute long port; */
  NS_IMETHOD GetPort(PRInt32 *aPort) = 0;
  NS_IMETHOD SetPort(PRInt32 aPort) = 0;

  /**
   * userid to log into the server
   */
  /* attribute string username; */
  NS_IMETHOD GetUsername(char * *aUsername) = 0;
  NS_IMETHOD SetUsername(const char * aUsername) = 0;

  /**
   * protocol type, i.e. "pop3", "imap", "nntp", "none", etc
   * used to construct URLs
   */
  /* attribute string type; */
  NS_IMETHOD GetType(char * *aType) = 0;
  NS_IMETHOD SetType(const char * aType) = 0;

  /**
   * the schema for the local mail store, such
   * as "mailbox", "imap", or "news"
   * used to construct URIs
   */
  /* readonly attribute string localStoreType; */
  NS_IMETHOD GetLocalStoreType(char * *aLocalStoreType) = 0;

  /* attribute boolean rememberPassword; */
  NS_IMETHOD GetRememberPassword(PRBool *aRememberPassword) = 0;
  NS_IMETHOD SetRememberPassword(PRBool aRememberPassword) = 0;

  /* attribute string password; */
  NS_IMETHOD GetPassword(char * *aPassword) = 0;
  NS_IMETHOD SetPassword(const char * aPassword) = 0;

  /* string getPasswordWithUI (in wstring aPromptString, in wstring aPromptTitle, in nsIMsgWindow aMsgWindow, out boolean okayValue); */
  NS_IMETHOD GetPasswordWithUI(const PRUnichar *aPromptString, const PRUnichar *aPromptTitle, nsIMsgWindow *aMsgWindow, PRBool *okayValue, char **_retval) = 0;

  /* void forgetPassword (); */
  NS_IMETHOD ForgetPassword(void) = 0;

  /* attribute boolean downloadOnBiff; */
  NS_IMETHOD GetDownloadOnBiff(PRBool *aDownloadOnBiff) = 0;
  NS_IMETHOD SetDownloadOnBiff(PRBool aDownloadOnBiff) = 0;

  /* attribute boolean doBiff; */
  NS_IMETHOD GetDoBiff(PRBool *aDoBiff) = 0;
  NS_IMETHOD SetDoBiff(PRBool aDoBiff) = 0;

  /* attribute long biffMinutes; */
  NS_IMETHOD GetBiffMinutes(PRInt32 *aBiffMinutes) = 0;
  NS_IMETHOD SetBiffMinutes(PRInt32 aBiffMinutes) = 0;

  /* attribute nsIFileSpec localPath; */
  NS_IMETHOD GetLocalPath(nsIFileSpec * *aLocalPath) = 0;
  NS_IMETHOD SetLocalPath(nsIFileSpec * aLocalPath) = 0;

  /* readonly attribute string serverURI; */
  NS_IMETHOD GetServerURI(char * *aServerURI) = 0;

  /* attribute nsIFolder RootFolder; */
  NS_IMETHOD GetRootFolder(nsIFolder * *aRootFolder) = 0;
  NS_IMETHOD SetRootFolder(nsIFolder * aRootFolder) = 0;

  /* attribute boolean serverBusy; */
  NS_IMETHOD GetServerBusy(PRBool *aServerBusy) = 0;
  NS_IMETHOD SetServerBusy(PRBool aServerBusy) = 0;

  /* attribute boolean isSecure; */
  NS_IMETHOD GetIsSecure(PRBool *aIsSecure) = 0;
  NS_IMETHOD SetIsSecure(PRBool aIsSecure) = 0;

  /* attribute string redirectorType; */
  NS_IMETHOD GetRedirectorType(char * *aRedirectorType) = 0;
  NS_IMETHOD SetRedirectorType(const char * aRedirectorType) = 0;

  /* attribute boolean emptyTrashOnExit; */
  NS_IMETHOD GetEmptyTrashOnExit(PRBool *aEmptyTrashOnExit) = 0;
  NS_IMETHOD SetEmptyTrashOnExit(PRBool aEmptyTrashOnExit) = 0;

  /* readonly attribute nsIMsgFilterList filterList; */
  NS_IMETHOD GetFilterList(nsIMsgFilterList * *aFilterList) = 0;

  /* void SetDefaultLocalPath (in nsIFileSpec aDefaultLocalPath); */
  NS_IMETHOD SetDefaultLocalPath(nsIFileSpec *aDefaultLocalPath) = 0;

  /* void PerformBiff (); */
  NS_IMETHOD PerformBiff(void) = 0;

  /* readonly attribute boolean serverRequiresPasswordForBiff; */
  NS_IMETHOD GetServerRequiresPasswordForBiff(PRBool *aServerRequiresPasswordForBiff) = 0;

  /* void PerformExpand (in nsIMsgWindow aMsgWindow); */
  NS_IMETHOD PerformExpand(nsIMsgWindow *aMsgWindow) = 0;

  /* void WriteToFolderCache (in nsIMsgFolderCache folderCache); */
  NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache) = 0;

  /* void CloseCachedConnections (); */
  NS_IMETHOD CloseCachedConnections(void) = 0;

  /* boolean getBoolValue (in string attr); */
  NS_IMETHOD GetBoolValue(const char *attr, PRBool *_retval) = 0;

  /* void setBoolValue (in string attr, in boolean value); */
  NS_IMETHOD SetBoolValue(const char *attr, PRBool value) = 0;

  /* string getCharValue (in string attr); */
  NS_IMETHOD GetCharValue(const char *attr, char **_retval) = 0;

  /* void setCharValue (in string attr, in string value); */
  NS_IMETHOD SetCharValue(const char *attr, const char *value) = 0;

  /* wstring getUnicharValue (in string attr); */
  NS_IMETHOD GetUnicharValue(const char *attr, PRUnichar **_retval) = 0;

  /* void setUnicharValue (in string attr, in wstring value); */
  NS_IMETHOD SetUnicharValue(const char *attr, const PRUnichar *value) = 0;

  /* long getIntValue (in string attr); */
  NS_IMETHOD GetIntValue(const char *attr, PRInt32 *_retval) = 0;

  /* void setIntValue (in string attr, in long value); */
  NS_IMETHOD SetIntValue(const char *attr, PRInt32 value) = 0;

  /* nsIFileSpec getFileValue (in string attr); */
  NS_IMETHOD GetFileValue(const char *attr, nsIFileSpec **_retval) = 0;

  /* void setFileValue (in string attr, in nsIFileSpec value); */
  NS_IMETHOD SetFileValue(const char *attr, nsIFileSpec *value) = 0;

  /**
   * this is really dangerous. this destroys all pref values
   * do not call this unless you know what you're doing!
   */
  /* void clearAllValues (); */
  NS_IMETHOD ClearAllValues(void) = 0;

  /** 
   * this is also very dangerous.  this will remove the files
   * associated with this server on disk.
   */
  /* void removeFiles (); */
  NS_IMETHOD RemoveFiles(void) = 0;

  /* attribute boolean valid; */
  NS_IMETHOD GetValid(PRBool *aValid) = 0;
  NS_IMETHOD SetValid(PRBool aValid) = 0;

  /* wstring toString (); */
  NS_IMETHOD ToString(PRUnichar **_retval) = 0;

  /* void displayOfflineMsg (in nsIMsgWindow aWindow); */
  NS_IMETHOD DisplayOfflineMsg(nsIMsgWindow *aWindow) = 0;

  /* boolean equals (in nsIMsgIncomingServer server); */
  NS_IMETHOD Equals(nsIMsgIncomingServer *server, PRBool *_retval) = 0;

  /* readonly attribute boolean downloadMessagesAtStartup; */
  NS_IMETHOD GetDownloadMessagesAtStartup(PRBool *aDownloadMessagesAtStartup) = 0;

  /* attribute boolean canHaveFilters; */
  NS_IMETHOD GetCanHaveFilters(PRBool *aCanHaveFilters) = 0;
  NS_IMETHOD SetCanHaveFilters(PRBool aCanHaveFilters) = 0;

  /**
   * can this server be removed from the account manager?  for
   * instance, local mail is not removable, but an imported folder is 
   */
  /* attribute boolean canDelete; */
  NS_IMETHOD GetCanDelete(PRBool *aCanDelete) = 0;
  NS_IMETHOD SetCanDelete(PRBool aCanDelete) = 0;

  /* attribute boolean loginAtStartUp; */
  NS_IMETHOD GetLoginAtStartUp(PRBool *aLoginAtStartUp) = 0;
  NS_IMETHOD SetLoginAtStartUp(PRBool aLoginAtStartUp) = 0;

  /* attribute boolean limitMessageSize; */
  NS_IMETHOD GetLimitMessageSize(PRBool *aLimitMessageSize) = 0;
  NS_IMETHOD SetLimitMessageSize(PRBool aLimitMessageSize) = 0;

  /* attribute boolean limitOfflineMessageSize; */
  NS_IMETHOD GetLimitOfflineMessageSize(PRBool *aLimitOfflineMessageSize) = 0;
  NS_IMETHOD SetLimitOfflineMessageSize(PRBool aLimitOfflineMessageSize) = 0;

  /* attribute long maxMessageSize; */
  NS_IMETHOD GetMaxMessageSize(PRInt32 *aMaxMessageSize) = 0;
  NS_IMETHOD SetMaxMessageSize(PRInt32 aMaxMessageSize) = 0;

  /* attribute nsIMsgRetentionSettings retentionSettings; */
  NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings * *aRetentionSettings) = 0;
  NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings * aRetentionSettings) = 0;

  /* readonly attribute boolean canBeDefaultServer; */
  NS_IMETHOD GetCanBeDefaultServer(PRBool *aCanBeDefaultServer) = 0;

  /* readonly attribute boolean canSearchMessages; */
  NS_IMETHOD GetCanSearchMessages(PRBool *aCanSearchMessages) = 0;

  /* attribute boolean displayStartupPage; */
  NS_IMETHOD GetDisplayStartupPage(PRBool *aDisplayStartupPage) = 0;
  NS_IMETHOD SetDisplayStartupPage(PRBool aDisplayStartupPage) = 0;

  /* attribute nsIMsgDownloadSettings downloadSettings; */
  NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings * *aDownloadSettings) = 0;
  NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings * aDownloadSettings) = 0;

  /* attribute long offlineSupportLevel; */
  NS_IMETHOD GetOfflineSupportLevel(PRInt32 *aOfflineSupportLevel) = 0;
  NS_IMETHOD SetOfflineSupportLevel(PRInt32 aOfflineSupportLevel) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGINCOMINGSERVER \
  NS_IMETHOD GetKey(char * *aKey); \
  NS_IMETHOD SetKey(const char * aKey); \
  NS_IMETHOD GetPrettyName(PRUnichar * *aPrettyName); \
  NS_IMETHOD SetPrettyName(const PRUnichar * aPrettyName); \
  NS_IMETHOD GetConstructedPrettyName(PRUnichar * *aConstructedPrettyName); \
  NS_IMETHOD GetHostName(char * *aHostName); \
  NS_IMETHOD SetHostName(const char * aHostName); \
  NS_IMETHOD GetPort(PRInt32 *aPort); \
  NS_IMETHOD SetPort(PRInt32 aPort); \
  NS_IMETHOD GetUsername(char * *aUsername); \
  NS_IMETHOD SetUsername(const char * aUsername); \
  NS_IMETHOD GetType(char * *aType); \
  NS_IMETHOD SetType(const char * aType); \
  NS_IMETHOD GetLocalStoreType(char * *aLocalStoreType); \
  NS_IMETHOD GetRememberPassword(PRBool *aRememberPassword); \
  NS_IMETHOD SetRememberPassword(PRBool aRememberPassword); \
  NS_IMETHOD GetPassword(char * *aPassword); \
  NS_IMETHOD SetPassword(const char * aPassword); \
  NS_IMETHOD GetPasswordWithUI(const PRUnichar *aPromptString, const PRUnichar *aPromptTitle, nsIMsgWindow *aMsgWindow, PRBool *okayValue, char **_retval); \
  NS_IMETHOD ForgetPassword(void); \
  NS_IMETHOD GetDownloadOnBiff(PRBool *aDownloadOnBiff); \
  NS_IMETHOD SetDownloadOnBiff(PRBool aDownloadOnBiff); \
  NS_IMETHOD GetDoBiff(PRBool *aDoBiff); \
  NS_IMETHOD SetDoBiff(PRBool aDoBiff); \
  NS_IMETHOD GetBiffMinutes(PRInt32 *aBiffMinutes); \
  NS_IMETHOD SetBiffMinutes(PRInt32 aBiffMinutes); \
  NS_IMETHOD GetLocalPath(nsIFileSpec * *aLocalPath); \
  NS_IMETHOD SetLocalPath(nsIFileSpec * aLocalPath); \
  NS_IMETHOD GetServerURI(char * *aServerURI); \
  NS_IMETHOD GetRootFolder(nsIFolder * *aRootFolder); \
  NS_IMETHOD SetRootFolder(nsIFolder * aRootFolder); \
  NS_IMETHOD GetServerBusy(PRBool *aServerBusy); \
  NS_IMETHOD SetServerBusy(PRBool aServerBusy); \
  NS_IMETHOD GetIsSecure(PRBool *aIsSecure); \
  NS_IMETHOD SetIsSecure(PRBool aIsSecure); \
  NS_IMETHOD GetRedirectorType(char * *aRedirectorType); \
  NS_IMETHOD SetRedirectorType(const char * aRedirectorType); \
  NS_IMETHOD GetEmptyTrashOnExit(PRBool *aEmptyTrashOnExit); \
  NS_IMETHOD SetEmptyTrashOnExit(PRBool aEmptyTrashOnExit); \
  NS_IMETHOD GetFilterList(nsIMsgFilterList * *aFilterList); \
  NS_IMETHOD SetDefaultLocalPath(nsIFileSpec *aDefaultLocalPath); \
  NS_IMETHOD PerformBiff(void); \
  NS_IMETHOD GetServerRequiresPasswordForBiff(PRBool *aServerRequiresPasswordForBiff); \
  NS_IMETHOD PerformExpand(nsIMsgWindow *aMsgWindow); \
  NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache); \
  NS_IMETHOD CloseCachedConnections(void); \
  NS_IMETHOD GetBoolValue(const char *attr, PRBool *_retval); \
  NS_IMETHOD SetBoolValue(const char *attr, PRBool value); \
  NS_IMETHOD GetCharValue(const char *attr, char **_retval); \
  NS_IMETHOD SetCharValue(const char *attr, const char *value); \
  NS_IMETHOD GetUnicharValue(const char *attr, PRUnichar **_retval); \
  NS_IMETHOD SetUnicharValue(const char *attr, const PRUnichar *value); \
  NS_IMETHOD GetIntValue(const char *attr, PRInt32 *_retval); \
  NS_IMETHOD SetIntValue(const char *attr, PRInt32 value); \
  NS_IMETHOD GetFileValue(const char *attr, nsIFileSpec **_retval); \
  NS_IMETHOD SetFileValue(const char *attr, nsIFileSpec *value); \
  NS_IMETHOD ClearAllValues(void); \
  NS_IMETHOD RemoveFiles(void); \
  NS_IMETHOD GetValid(PRBool *aValid); \
  NS_IMETHOD SetValid(PRBool aValid); \
  NS_IMETHOD ToString(PRUnichar **_retval); \
  NS_IMETHOD DisplayOfflineMsg(nsIMsgWindow *aWindow); \
  NS_IMETHOD Equals(nsIMsgIncomingServer *server, PRBool *_retval); \
  NS_IMETHOD GetDownloadMessagesAtStartup(PRBool *aDownloadMessagesAtStartup); \
  NS_IMETHOD GetCanHaveFilters(PRBool *aCanHaveFilters); \
  NS_IMETHOD SetCanHaveFilters(PRBool aCanHaveFilters); \
  NS_IMETHOD GetCanDelete(PRBool *aCanDelete); \
  NS_IMETHOD SetCanDelete(PRBool aCanDelete); \
  NS_IMETHOD GetLoginAtStartUp(PRBool *aLoginAtStartUp); \
  NS_IMETHOD SetLoginAtStartUp(PRBool aLoginAtStartUp); \
  NS_IMETHOD GetLimitMessageSize(PRBool *aLimitMessageSize); \
  NS_IMETHOD SetLimitMessageSize(PRBool aLimitMessageSize); \
  NS_IMETHOD GetLimitOfflineMessageSize(PRBool *aLimitOfflineMessageSize); \
  NS_IMETHOD SetLimitOfflineMessageSize(PRBool aLimitOfflineMessageSize); \
  NS_IMETHOD GetMaxMessageSize(PRInt32 *aMaxMessageSize); \
  NS_IMETHOD SetMaxMessageSize(PRInt32 aMaxMessageSize); \
  NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings * *aRetentionSettings); \
  NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings * aRetentionSettings); \
  NS_IMETHOD GetCanBeDefaultServer(PRBool *aCanBeDefaultServer); \
  NS_IMETHOD GetCanSearchMessages(PRBool *aCanSearchMessages); \
  NS_IMETHOD GetDisplayStartupPage(PRBool *aDisplayStartupPage); \
  NS_IMETHOD SetDisplayStartupPage(PRBool aDisplayStartupPage); \
  NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings * *aDownloadSettings); \
  NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings * aDownloadSettings); \
  NS_IMETHOD GetOfflineSupportLevel(PRInt32 *aOfflineSupportLevel); \
  NS_IMETHOD SetOfflineSupportLevel(PRInt32 aOfflineSupportLevel); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGINCOMINGSERVER(_to) \
  NS_IMETHOD GetKey(char * *aKey) { return _to ## GetKey(aKey); } \
  NS_IMETHOD SetKey(const char * aKey) { return _to ## SetKey(aKey); } \
  NS_IMETHOD GetPrettyName(PRUnichar * *aPrettyName) { return _to ## GetPrettyName(aPrettyName); } \
  NS_IMETHOD SetPrettyName(const PRUnichar * aPrettyName) { return _to ## SetPrettyName(aPrettyName); } \
  NS_IMETHOD GetConstructedPrettyName(PRUnichar * *aConstructedPrettyName) { return _to ## GetConstructedPrettyName(aConstructedPrettyName); } \
  NS_IMETHOD GetHostName(char * *aHostName) { return _to ## GetHostName(aHostName); } \
  NS_IMETHOD SetHostName(const char * aHostName) { return _to ## SetHostName(aHostName); } \
  NS_IMETHOD GetPort(PRInt32 *aPort) { return _to ## GetPort(aPort); } \
  NS_IMETHOD SetPort(PRInt32 aPort) { return _to ## SetPort(aPort); } \
  NS_IMETHOD GetUsername(char * *aUsername) { return _to ## GetUsername(aUsername); } \
  NS_IMETHOD SetUsername(const char * aUsername) { return _to ## SetUsername(aUsername); } \
  NS_IMETHOD GetType(char * *aType) { return _to ## GetType(aType); } \
  NS_IMETHOD SetType(const char * aType) { return _to ## SetType(aType); } \
  NS_IMETHOD GetLocalStoreType(char * *aLocalStoreType) { return _to ## GetLocalStoreType(aLocalStoreType); } \
  NS_IMETHOD GetRememberPassword(PRBool *aRememberPassword) { return _to ## GetRememberPassword(aRememberPassword); } \
  NS_IMETHOD SetRememberPassword(PRBool aRememberPassword) { return _to ## SetRememberPassword(aRememberPassword); } \
  NS_IMETHOD GetPassword(char * *aPassword) { return _to ## GetPassword(aPassword); } \
  NS_IMETHOD SetPassword(const char * aPassword) { return _to ## SetPassword(aPassword); } \
  NS_IMETHOD GetPasswordWithUI(const PRUnichar *aPromptString, const PRUnichar *aPromptTitle, nsIMsgWindow *aMsgWindow, PRBool *okayValue, char **_retval) { return _to ## GetPasswordWithUI(aPromptString, aPromptTitle, aMsgWindow, okayValue, _retval); } \
  NS_IMETHOD ForgetPassword(void) { return _to ## ForgetPassword(); } \
  NS_IMETHOD GetDownloadOnBiff(PRBool *aDownloadOnBiff) { return _to ## GetDownloadOnBiff(aDownloadOnBiff); } \
  NS_IMETHOD SetDownloadOnBiff(PRBool aDownloadOnBiff) { return _to ## SetDownloadOnBiff(aDownloadOnBiff); } \
  NS_IMETHOD GetDoBiff(PRBool *aDoBiff) { return _to ## GetDoBiff(aDoBiff); } \
  NS_IMETHOD SetDoBiff(PRBool aDoBiff) { return _to ## SetDoBiff(aDoBiff); } \
  NS_IMETHOD GetBiffMinutes(PRInt32 *aBiffMinutes) { return _to ## GetBiffMinutes(aBiffMinutes); } \
  NS_IMETHOD SetBiffMinutes(PRInt32 aBiffMinutes) { return _to ## SetBiffMinutes(aBiffMinutes); } \
  NS_IMETHOD GetLocalPath(nsIFileSpec * *aLocalPath) { return _to ## GetLocalPath(aLocalPath); } \
  NS_IMETHOD SetLocalPath(nsIFileSpec * aLocalPath) { return _to ## SetLocalPath(aLocalPath); } \
  NS_IMETHOD GetServerURI(char * *aServerURI) { return _to ## GetServerURI(aServerURI); } \
  NS_IMETHOD GetRootFolder(nsIFolder * *aRootFolder) { return _to ## GetRootFolder(aRootFolder); } \
  NS_IMETHOD SetRootFolder(nsIFolder * aRootFolder) { return _to ## SetRootFolder(aRootFolder); } \
  NS_IMETHOD GetServerBusy(PRBool *aServerBusy) { return _to ## GetServerBusy(aServerBusy); } \
  NS_IMETHOD SetServerBusy(PRBool aServerBusy) { return _to ## SetServerBusy(aServerBusy); } \
  NS_IMETHOD GetIsSecure(PRBool *aIsSecure) { return _to ## GetIsSecure(aIsSecure); } \
  NS_IMETHOD SetIsSecure(PRBool aIsSecure) { return _to ## SetIsSecure(aIsSecure); } \
  NS_IMETHOD GetRedirectorType(char * *aRedirectorType) { return _to ## GetRedirectorType(aRedirectorType); } \
  NS_IMETHOD SetRedirectorType(const char * aRedirectorType) { return _to ## SetRedirectorType(aRedirectorType); } \
  NS_IMETHOD GetEmptyTrashOnExit(PRBool *aEmptyTrashOnExit) { return _to ## GetEmptyTrashOnExit(aEmptyTrashOnExit); } \
  NS_IMETHOD SetEmptyTrashOnExit(PRBool aEmptyTrashOnExit) { return _to ## SetEmptyTrashOnExit(aEmptyTrashOnExit); } \
  NS_IMETHOD GetFilterList(nsIMsgFilterList * *aFilterList) { return _to ## GetFilterList(aFilterList); } \
  NS_IMETHOD SetDefaultLocalPath(nsIFileSpec *aDefaultLocalPath) { return _to ## SetDefaultLocalPath(aDefaultLocalPath); } \
  NS_IMETHOD PerformBiff(void) { return _to ## PerformBiff(); } \
  NS_IMETHOD GetServerRequiresPasswordForBiff(PRBool *aServerRequiresPasswordForBiff) { return _to ## GetServerRequiresPasswordForBiff(aServerRequiresPasswordForBiff); } \
  NS_IMETHOD PerformExpand(nsIMsgWindow *aMsgWindow) { return _to ## PerformExpand(aMsgWindow); } \
  NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache) { return _to ## WriteToFolderCache(folderCache); } \
  NS_IMETHOD CloseCachedConnections(void) { return _to ## CloseCachedConnections(); } \
  NS_IMETHOD GetBoolValue(const char *attr, PRBool *_retval) { return _to ## GetBoolValue(attr, _retval); } \
  NS_IMETHOD SetBoolValue(const char *attr, PRBool value) { return _to ## SetBoolValue(attr, value); } \
  NS_IMETHOD GetCharValue(const char *attr, char **_retval) { return _to ## GetCharValue(attr, _retval); } \
  NS_IMETHOD SetCharValue(const char *attr, const char *value) { return _to ## SetCharValue(attr, value); } \
  NS_IMETHOD GetUnicharValue(const char *attr, PRUnichar **_retval) { return _to ## GetUnicharValue(attr, _retval); } \
  NS_IMETHOD SetUnicharValue(const char *attr, const PRUnichar *value) { return _to ## SetUnicharValue(attr, value); } \
  NS_IMETHOD GetIntValue(const char *attr, PRInt32 *_retval) { return _to ## GetIntValue(attr, _retval); } \
  NS_IMETHOD SetIntValue(const char *attr, PRInt32 value) { return _to ## SetIntValue(attr, value); } \
  NS_IMETHOD GetFileValue(const char *attr, nsIFileSpec **_retval) { return _to ## GetFileValue(attr, _retval); } \
  NS_IMETHOD SetFileValue(const char *attr, nsIFileSpec *value) { return _to ## SetFileValue(attr, value); } \
  NS_IMETHOD ClearAllValues(void) { return _to ## ClearAllValues(); } \
  NS_IMETHOD RemoveFiles(void) { return _to ## RemoveFiles(); } \
  NS_IMETHOD GetValid(PRBool *aValid) { return _to ## GetValid(aValid); } \
  NS_IMETHOD SetValid(PRBool aValid) { return _to ## SetValid(aValid); } \
  NS_IMETHOD ToString(PRUnichar **_retval) { return _to ## ToString(_retval); } \
  NS_IMETHOD DisplayOfflineMsg(nsIMsgWindow *aWindow) { return _to ## DisplayOfflineMsg(aWindow); } \
  NS_IMETHOD Equals(nsIMsgIncomingServer *server, PRBool *_retval) { return _to ## Equals(server, _retval); } \
  NS_IMETHOD GetDownloadMessagesAtStartup(PRBool *aDownloadMessagesAtStartup) { return _to ## GetDownloadMessagesAtStartup(aDownloadMessagesAtStartup); } \
  NS_IMETHOD GetCanHaveFilters(PRBool *aCanHaveFilters) { return _to ## GetCanHaveFilters(aCanHaveFilters); } \
  NS_IMETHOD SetCanHaveFilters(PRBool aCanHaveFilters) { return _to ## SetCanHaveFilters(aCanHaveFilters); } \
  NS_IMETHOD GetCanDelete(PRBool *aCanDelete) { return _to ## GetCanDelete(aCanDelete); } \
  NS_IMETHOD SetCanDelete(PRBool aCanDelete) { return _to ## SetCanDelete(aCanDelete); } \
  NS_IMETHOD GetLoginAtStartUp(PRBool *aLoginAtStartUp) { return _to ## GetLoginAtStartUp(aLoginAtStartUp); } \
  NS_IMETHOD SetLoginAtStartUp(PRBool aLoginAtStartUp) { return _to ## SetLoginAtStartUp(aLoginAtStartUp); } \
  NS_IMETHOD GetLimitMessageSize(PRBool *aLimitMessageSize) { return _to ## GetLimitMessageSize(aLimitMessageSize); } \
  NS_IMETHOD SetLimitMessageSize(PRBool aLimitMessageSize) { return _to ## SetLimitMessageSize(aLimitMessageSize); } \
  NS_IMETHOD GetLimitOfflineMessageSize(PRBool *aLimitOfflineMessageSize) { return _to ## GetLimitOfflineMessageSize(aLimitOfflineMessageSize); } \
  NS_IMETHOD SetLimitOfflineMessageSize(PRBool aLimitOfflineMessageSize) { return _to ## SetLimitOfflineMessageSize(aLimitOfflineMessageSize); } \
  NS_IMETHOD GetMaxMessageSize(PRInt32 *aMaxMessageSize) { return _to ## GetMaxMessageSize(aMaxMessageSize); } \
  NS_IMETHOD SetMaxMessageSize(PRInt32 aMaxMessageSize) { return _to ## SetMaxMessageSize(aMaxMessageSize); } \
  NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings * *aRetentionSettings) { return _to ## GetRetentionSettings(aRetentionSettings); } \
  NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings * aRetentionSettings) { return _to ## SetRetentionSettings(aRetentionSettings); } \
  NS_IMETHOD GetCanBeDefaultServer(PRBool *aCanBeDefaultServer) { return _to ## GetCanBeDefaultServer(aCanBeDefaultServer); } \
  NS_IMETHOD GetCanSearchMessages(PRBool *aCanSearchMessages) { return _to ## GetCanSearchMessages(aCanSearchMessages); } \
  NS_IMETHOD GetDisplayStartupPage(PRBool *aDisplayStartupPage) { return _to ## GetDisplayStartupPage(aDisplayStartupPage); } \
  NS_IMETHOD SetDisplayStartupPage(PRBool aDisplayStartupPage) { return _to ## SetDisplayStartupPage(aDisplayStartupPage); } \
  NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings * *aDownloadSettings) { return _to ## GetDownloadSettings(aDownloadSettings); } \
  NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings * aDownloadSettings) { return _to ## SetDownloadSettings(aDownloadSettings); } \
  NS_IMETHOD GetOfflineSupportLevel(PRInt32 *aOfflineSupportLevel) { return _to ## GetOfflineSupportLevel(aOfflineSupportLevel); } \
  NS_IMETHOD SetOfflineSupportLevel(PRInt32 aOfflineSupportLevel) { return _to ## SetOfflineSupportLevel(aOfflineSupportLevel); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGINCOMINGSERVER(_to) \
  NS_IMETHOD GetKey(char * *aKey) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetKey(aKey); } \
  NS_IMETHOD SetKey(const char * aKey) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetKey(aKey); } \
  NS_IMETHOD GetPrettyName(PRUnichar * *aPrettyName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetPrettyName(aPrettyName); } \
  NS_IMETHOD SetPrettyName(const PRUnichar * aPrettyName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetPrettyName(aPrettyName); } \
  NS_IMETHOD GetConstructedPrettyName(PRUnichar * *aConstructedPrettyName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetConstructedPrettyName(aConstructedPrettyName); } \
  NS_IMETHOD GetHostName(char * *aHostName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetHostName(aHostName); } \
  NS_IMETHOD SetHostName(const char * aHostName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetHostName(aHostName); } \
  NS_IMETHOD GetPort(PRInt32 *aPort) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetPort(aPort); } \
  NS_IMETHOD SetPort(PRInt32 aPort) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetPort(aPort); } \
  NS_IMETHOD GetUsername(char * *aUsername) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetUsername(aUsername); } \
  NS_IMETHOD SetUsername(const char * aUsername) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetUsername(aUsername); } \
  NS_IMETHOD GetType(char * *aType) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetType(aType); } \
  NS_IMETHOD SetType(const char * aType) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetType(aType); } \
  NS_IMETHOD GetLocalStoreType(char * *aLocalStoreType) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetLocalStoreType(aLocalStoreType); } \
  NS_IMETHOD GetRememberPassword(PRBool *aRememberPassword) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetRememberPassword(aRememberPassword); } \
  NS_IMETHOD SetRememberPassword(PRBool aRememberPassword) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetRememberPassword(aRememberPassword); } \
  NS_IMETHOD GetPassword(char * *aPassword) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetPassword(aPassword); } \
  NS_IMETHOD SetPassword(const char * aPassword) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetPassword(aPassword); } \
  NS_IMETHOD GetPasswordWithUI(const PRUnichar *aPromptString, const PRUnichar *aPromptTitle, nsIMsgWindow *aMsgWindow, PRBool *okayValue, char **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetPasswordWithUI(aPromptString, aPromptTitle, aMsgWindow, okayValue, _retval); } \
  NS_IMETHOD ForgetPassword(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> ForgetPassword(); } \
  NS_IMETHOD GetDownloadOnBiff(PRBool *aDownloadOnBiff) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetDownloadOnBiff(aDownloadOnBiff); } \
  NS_IMETHOD SetDownloadOnBiff(PRBool aDownloadOnBiff) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetDownloadOnBiff(aDownloadOnBiff); } \
  NS_IMETHOD GetDoBiff(PRBool *aDoBiff) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetDoBiff(aDoBiff); } \
  NS_IMETHOD SetDoBiff(PRBool aDoBiff) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetDoBiff(aDoBiff); } \
  NS_IMETHOD GetBiffMinutes(PRInt32 *aBiffMinutes) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetBiffMinutes(aBiffMinutes); } \
  NS_IMETHOD SetBiffMinutes(PRInt32 aBiffMinutes) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetBiffMinutes(aBiffMinutes); } \
  NS_IMETHOD GetLocalPath(nsIFileSpec * *aLocalPath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetLocalPath(aLocalPath); } \
  NS_IMETHOD SetLocalPath(nsIFileSpec * aLocalPath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetLocalPath(aLocalPath); } \
  NS_IMETHOD GetServerURI(char * *aServerURI) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetServerURI(aServerURI); } \
  NS_IMETHOD GetRootFolder(nsIFolder * *aRootFolder) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetRootFolder(aRootFolder); } \
  NS_IMETHOD SetRootFolder(nsIFolder * aRootFolder) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetRootFolder(aRootFolder); } \
  NS_IMETHOD GetServerBusy(PRBool *aServerBusy) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetServerBusy(aServerBusy); } \
  NS_IMETHOD SetServerBusy(PRBool aServerBusy) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetServerBusy(aServerBusy); } \
  NS_IMETHOD GetIsSecure(PRBool *aIsSecure) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetIsSecure(aIsSecure); } \
  NS_IMETHOD SetIsSecure(PRBool aIsSecure) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetIsSecure(aIsSecure); } \
  NS_IMETHOD GetRedirectorType(char * *aRedirectorType) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetRedirectorType(aRedirectorType); } \
  NS_IMETHOD SetRedirectorType(const char * aRedirectorType) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetRedirectorType(aRedirectorType); } \
  NS_IMETHOD GetEmptyTrashOnExit(PRBool *aEmptyTrashOnExit) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetEmptyTrashOnExit(aEmptyTrashOnExit); } \
  NS_IMETHOD SetEmptyTrashOnExit(PRBool aEmptyTrashOnExit) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetEmptyTrashOnExit(aEmptyTrashOnExit); } \
  NS_IMETHOD GetFilterList(nsIMsgFilterList * *aFilterList) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetFilterList(aFilterList); } \
  NS_IMETHOD SetDefaultLocalPath(nsIFileSpec *aDefaultLocalPath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetDefaultLocalPath(aDefaultLocalPath); } \
  NS_IMETHOD PerformBiff(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> PerformBiff(); } \
  NS_IMETHOD GetServerRequiresPasswordForBiff(PRBool *aServerRequiresPasswordForBiff) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetServerRequiresPasswordForBiff(aServerRequiresPasswordForBiff); } \
  NS_IMETHOD PerformExpand(nsIMsgWindow *aMsgWindow) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> PerformExpand(aMsgWindow); } \
  NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> WriteToFolderCache(folderCache); } \
  NS_IMETHOD CloseCachedConnections(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CloseCachedConnections(); } \
  NS_IMETHOD GetBoolValue(const char *attr, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetBoolValue(attr, _retval); } \
  NS_IMETHOD SetBoolValue(const char *attr, PRBool value) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetBoolValue(attr, value); } \
  NS_IMETHOD GetCharValue(const char *attr, char **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetCharValue(attr, _retval); } \
  NS_IMETHOD SetCharValue(const char *attr, const char *value) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetCharValue(attr, value); } \
  NS_IMETHOD GetUnicharValue(const char *attr, PRUnichar **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetUnicharValue(attr, _retval); } \
  NS_IMETHOD SetUnicharValue(const char *attr, const PRUnichar *value) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetUnicharValue(attr, value); } \
  NS_IMETHOD GetIntValue(const char *attr, PRInt32 *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetIntValue(attr, _retval); } \
  NS_IMETHOD SetIntValue(const char *attr, PRInt32 value) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetIntValue(attr, value); } \
  NS_IMETHOD GetFileValue(const char *attr, nsIFileSpec **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetFileValue(attr, _retval); } \
  NS_IMETHOD SetFileValue(const char *attr, nsIFileSpec *value) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetFileValue(attr, value); } \
  NS_IMETHOD ClearAllValues(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> ClearAllValues(); } \
  NS_IMETHOD RemoveFiles(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> RemoveFiles(); } \
  NS_IMETHOD GetValid(PRBool *aValid) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetValid(aValid); } \
  NS_IMETHOD SetValid(PRBool aValid) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetValid(aValid); } \
  NS_IMETHOD ToString(PRUnichar **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> ToString(_retval); } \
  NS_IMETHOD DisplayOfflineMsg(nsIMsgWindow *aWindow) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> DisplayOfflineMsg(aWindow); } \
  NS_IMETHOD Equals(nsIMsgIncomingServer *server, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Equals(server, _retval); } \
  NS_IMETHOD GetDownloadMessagesAtStartup(PRBool *aDownloadMessagesAtStartup) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetDownloadMessagesAtStartup(aDownloadMessagesAtStartup); } \
  NS_IMETHOD GetCanHaveFilters(PRBool *aCanHaveFilters) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetCanHaveFilters(aCanHaveFilters); } \
  NS_IMETHOD SetCanHaveFilters(PRBool aCanHaveFilters) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetCanHaveFilters(aCanHaveFilters); } \
  NS_IMETHOD GetCanDelete(PRBool *aCanDelete) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetCanDelete(aCanDelete); } \
  NS_IMETHOD SetCanDelete(PRBool aCanDelete) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetCanDelete(aCanDelete); } \
  NS_IMETHOD GetLoginAtStartUp(PRBool *aLoginAtStartUp) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetLoginAtStartUp(aLoginAtStartUp); } \
  NS_IMETHOD SetLoginAtStartUp(PRBool aLoginAtStartUp) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetLoginAtStartUp(aLoginAtStartUp); } \
  NS_IMETHOD GetLimitMessageSize(PRBool *aLimitMessageSize) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetLimitMessageSize(aLimitMessageSize); } \
  NS_IMETHOD SetLimitMessageSize(PRBool aLimitMessageSize) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetLimitMessageSize(aLimitMessageSize); } \
  NS_IMETHOD GetLimitOfflineMessageSize(PRBool *aLimitOfflineMessageSize) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetLimitOfflineMessageSize(aLimitOfflineMessageSize); } \
  NS_IMETHOD SetLimitOfflineMessageSize(PRBool aLimitOfflineMessageSize) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetLimitOfflineMessageSize(aLimitOfflineMessageSize); } \
  NS_IMETHOD GetMaxMessageSize(PRInt32 *aMaxMessageSize) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetMaxMessageSize(aMaxMessageSize); } \
  NS_IMETHOD SetMaxMessageSize(PRInt32 aMaxMessageSize) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetMaxMessageSize(aMaxMessageSize); } \
  NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings * *aRetentionSettings) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetRetentionSettings(aRetentionSettings); } \
  NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings * aRetentionSettings) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetRetentionSettings(aRetentionSettings); } \
  NS_IMETHOD GetCanBeDefaultServer(PRBool *aCanBeDefaultServer) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetCanBeDefaultServer(aCanBeDefaultServer); } \
  NS_IMETHOD GetCanSearchMessages(PRBool *aCanSearchMessages) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetCanSearchMessages(aCanSearchMessages); } \
  NS_IMETHOD GetDisplayStartupPage(PRBool *aDisplayStartupPage) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetDisplayStartupPage(aDisplayStartupPage); } \
  NS_IMETHOD SetDisplayStartupPage(PRBool aDisplayStartupPage) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetDisplayStartupPage(aDisplayStartupPage); } \
  NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings * *aDownloadSettings) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetDownloadSettings(aDownloadSettings); } \
  NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings * aDownloadSettings) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetDownloadSettings(aDownloadSettings); } \
  NS_IMETHOD GetOfflineSupportLevel(PRInt32 *aOfflineSupportLevel) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetOfflineSupportLevel(aOfflineSupportLevel); } \
  NS_IMETHOD SetOfflineSupportLevel(PRInt32 aOfflineSupportLevel) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetOfflineSupportLevel(aOfflineSupportLevel); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgIncomingServer : public nsIMsgIncomingServer
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGINCOMINGSERVER

  nsMsgIncomingServer();
  virtual ~nsMsgIncomingServer();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgIncomingServer, nsIMsgIncomingServer)

nsMsgIncomingServer::nsMsgIncomingServer()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsMsgIncomingServer::~nsMsgIncomingServer()
{
  /* destructor code */
}

/* attribute string key; */
NS_IMETHODIMP nsMsgIncomingServer::GetKey(char * *aKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetKey(const char * aKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute wstring prettyName; */
NS_IMETHODIMP nsMsgIncomingServer::GetPrettyName(PRUnichar * *aPrettyName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetPrettyName(const PRUnichar * aPrettyName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute wstring constructedPrettyName; */
NS_IMETHODIMP nsMsgIncomingServer::GetConstructedPrettyName(PRUnichar * *aConstructedPrettyName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string hostName; */
NS_IMETHODIMP nsMsgIncomingServer::GetHostName(char * *aHostName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetHostName(const char * aHostName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long port; */
NS_IMETHODIMP nsMsgIncomingServer::GetPort(PRInt32 *aPort)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetPort(PRInt32 aPort)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string username; */
NS_IMETHODIMP nsMsgIncomingServer::GetUsername(char * *aUsername)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetUsername(const char * aUsername)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string type; */
NS_IMETHODIMP nsMsgIncomingServer::GetType(char * *aType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetType(const char * aType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string localStoreType; */
NS_IMETHODIMP nsMsgIncomingServer::GetLocalStoreType(char * *aLocalStoreType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean rememberPassword; */
NS_IMETHODIMP nsMsgIncomingServer::GetRememberPassword(PRBool *aRememberPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetRememberPassword(PRBool aRememberPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string password; */
NS_IMETHODIMP nsMsgIncomingServer::GetPassword(char * *aPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetPassword(const char * aPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getPasswordWithUI (in wstring aPromptString, in wstring aPromptTitle, in nsIMsgWindow aMsgWindow, out boolean okayValue); */
NS_IMETHODIMP nsMsgIncomingServer::GetPasswordWithUI(const PRUnichar *aPromptString, const PRUnichar *aPromptTitle, nsIMsgWindow *aMsgWindow, PRBool *okayValue, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void forgetPassword (); */
NS_IMETHODIMP nsMsgIncomingServer::ForgetPassword()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean downloadOnBiff; */
NS_IMETHODIMP nsMsgIncomingServer::GetDownloadOnBiff(PRBool *aDownloadOnBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetDownloadOnBiff(PRBool aDownloadOnBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean doBiff; */
NS_IMETHODIMP nsMsgIncomingServer::GetDoBiff(PRBool *aDoBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetDoBiff(PRBool aDoBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long biffMinutes; */
NS_IMETHODIMP nsMsgIncomingServer::GetBiffMinutes(PRInt32 *aBiffMinutes)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetBiffMinutes(PRInt32 aBiffMinutes)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIFileSpec localPath; */
NS_IMETHODIMP nsMsgIncomingServer::GetLocalPath(nsIFileSpec * *aLocalPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetLocalPath(nsIFileSpec * aLocalPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string serverURI; */
NS_IMETHODIMP nsMsgIncomingServer::GetServerURI(char * *aServerURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIFolder RootFolder; */
NS_IMETHODIMP nsMsgIncomingServer::GetRootFolder(nsIFolder * *aRootFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetRootFolder(nsIFolder * aRootFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean serverBusy; */
NS_IMETHODIMP nsMsgIncomingServer::GetServerBusy(PRBool *aServerBusy)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetServerBusy(PRBool aServerBusy)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean isSecure; */
NS_IMETHODIMP nsMsgIncomingServer::GetIsSecure(PRBool *aIsSecure)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetIsSecure(PRBool aIsSecure)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string redirectorType; */
NS_IMETHODIMP nsMsgIncomingServer::GetRedirectorType(char * *aRedirectorType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetRedirectorType(const char * aRedirectorType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean emptyTrashOnExit; */
NS_IMETHODIMP nsMsgIncomingServer::GetEmptyTrashOnExit(PRBool *aEmptyTrashOnExit)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetEmptyTrashOnExit(PRBool aEmptyTrashOnExit)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIMsgFilterList filterList; */
NS_IMETHODIMP nsMsgIncomingServer::GetFilterList(nsIMsgFilterList * *aFilterList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetDefaultLocalPath (in nsIFileSpec aDefaultLocalPath); */
NS_IMETHODIMP nsMsgIncomingServer::SetDefaultLocalPath(nsIFileSpec *aDefaultLocalPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void PerformBiff (); */
NS_IMETHODIMP nsMsgIncomingServer::PerformBiff()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean serverRequiresPasswordForBiff; */
NS_IMETHODIMP nsMsgIncomingServer::GetServerRequiresPasswordForBiff(PRBool *aServerRequiresPasswordForBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void PerformExpand (in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsMsgIncomingServer::PerformExpand(nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void WriteToFolderCache (in nsIMsgFolderCache folderCache); */
NS_IMETHODIMP nsMsgIncomingServer::WriteToFolderCache(nsIMsgFolderCache *folderCache)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CloseCachedConnections (); */
NS_IMETHODIMP nsMsgIncomingServer::CloseCachedConnections()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean getBoolValue (in string attr); */
NS_IMETHODIMP nsMsgIncomingServer::GetBoolValue(const char *attr, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setBoolValue (in string attr, in boolean value); */
NS_IMETHODIMP nsMsgIncomingServer::SetBoolValue(const char *attr, PRBool value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getCharValue (in string attr); */
NS_IMETHODIMP nsMsgIncomingServer::GetCharValue(const char *attr, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setCharValue (in string attr, in string value); */
NS_IMETHODIMP nsMsgIncomingServer::SetCharValue(const char *attr, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring getUnicharValue (in string attr); */
NS_IMETHODIMP nsMsgIncomingServer::GetUnicharValue(const char *attr, PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setUnicharValue (in string attr, in wstring value); */
NS_IMETHODIMP nsMsgIncomingServer::SetUnicharValue(const char *attr, const PRUnichar *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getIntValue (in string attr); */
NS_IMETHODIMP nsMsgIncomingServer::GetIntValue(const char *attr, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setIntValue (in string attr, in long value); */
NS_IMETHODIMP nsMsgIncomingServer::SetIntValue(const char *attr, PRInt32 value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIFileSpec getFileValue (in string attr); */
NS_IMETHODIMP nsMsgIncomingServer::GetFileValue(const char *attr, nsIFileSpec **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setFileValue (in string attr, in nsIFileSpec value); */
NS_IMETHODIMP nsMsgIncomingServer::SetFileValue(const char *attr, nsIFileSpec *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void clearAllValues (); */
NS_IMETHODIMP nsMsgIncomingServer::ClearAllValues()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeFiles (); */
NS_IMETHODIMP nsMsgIncomingServer::RemoveFiles()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean valid; */
NS_IMETHODIMP nsMsgIncomingServer::GetValid(PRBool *aValid)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetValid(PRBool aValid)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring toString (); */
NS_IMETHODIMP nsMsgIncomingServer::ToString(PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void displayOfflineMsg (in nsIMsgWindow aWindow); */
NS_IMETHODIMP nsMsgIncomingServer::DisplayOfflineMsg(nsIMsgWindow *aWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean equals (in nsIMsgIncomingServer server); */
NS_IMETHODIMP nsMsgIncomingServer::Equals(nsIMsgIncomingServer *server, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean downloadMessagesAtStartup; */
NS_IMETHODIMP nsMsgIncomingServer::GetDownloadMessagesAtStartup(PRBool *aDownloadMessagesAtStartup)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean canHaveFilters; */
NS_IMETHODIMP nsMsgIncomingServer::GetCanHaveFilters(PRBool *aCanHaveFilters)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetCanHaveFilters(PRBool aCanHaveFilters)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean canDelete; */
NS_IMETHODIMP nsMsgIncomingServer::GetCanDelete(PRBool *aCanDelete)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetCanDelete(PRBool aCanDelete)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean loginAtStartUp; */
NS_IMETHODIMP nsMsgIncomingServer::GetLoginAtStartUp(PRBool *aLoginAtStartUp)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetLoginAtStartUp(PRBool aLoginAtStartUp)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean limitMessageSize; */
NS_IMETHODIMP nsMsgIncomingServer::GetLimitMessageSize(PRBool *aLimitMessageSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetLimitMessageSize(PRBool aLimitMessageSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean limitOfflineMessageSize; */
NS_IMETHODIMP nsMsgIncomingServer::GetLimitOfflineMessageSize(PRBool *aLimitOfflineMessageSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetLimitOfflineMessageSize(PRBool aLimitOfflineMessageSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long maxMessageSize; */
NS_IMETHODIMP nsMsgIncomingServer::GetMaxMessageSize(PRInt32 *aMaxMessageSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetMaxMessageSize(PRInt32 aMaxMessageSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIMsgRetentionSettings retentionSettings; */
NS_IMETHODIMP nsMsgIncomingServer::GetRetentionSettings(nsIMsgRetentionSettings * *aRetentionSettings)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetRetentionSettings(nsIMsgRetentionSettings * aRetentionSettings)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canBeDefaultServer; */
NS_IMETHODIMP nsMsgIncomingServer::GetCanBeDefaultServer(PRBool *aCanBeDefaultServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canSearchMessages; */
NS_IMETHODIMP nsMsgIncomingServer::GetCanSearchMessages(PRBool *aCanSearchMessages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean displayStartupPage; */
NS_IMETHODIMP nsMsgIncomingServer::GetDisplayStartupPage(PRBool *aDisplayStartupPage)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetDisplayStartupPage(PRBool aDisplayStartupPage)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIMsgDownloadSettings downloadSettings; */
NS_IMETHODIMP nsMsgIncomingServer::GetDownloadSettings(nsIMsgDownloadSettings * *aDownloadSettings)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetDownloadSettings(nsIMsgDownloadSettings * aDownloadSettings)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long offlineSupportLevel; */
NS_IMETHODIMP nsMsgIncomingServer::GetOfflineSupportLevel(PRInt32 *aOfflineSupportLevel)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetOfflineSupportLevel(PRInt32 aOfflineSupportLevel)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

/* some useful macros to implement nsIMsgIncomingServer accessors */
#define NS_IMPL_SERVERPREF_STR(_class, _postfix, _prefname)	\
NS_IMETHODIMP								   	\
_class::Get##_postfix(char **retval)   			\
{											   	\
  return GetCharValue(_prefname, retval);		\
}												\
NS_IMETHODIMP	   								\
_class::Set##_postfix(const char *chvalue)			\
{												\
  return SetCharValue(_prefname, chvalue);		\
}
#define NS_IMPL_SERVERPREF_BOOL(_class, _postfix, _prefname)\
NS_IMETHODIMP								   	\
_class::Get##_postfix(PRBool *retval)   		\
{											   	\
  return GetBoolValue(_prefname, retval);		\
}												\
NS_IMETHODIMP	   								\
_class::Set##_postfix(PRBool bvalue)			\
{												\
  return SetBoolValue(_prefname, bvalue);		\
}
#define NS_IMPL_SERVERPREF_INT(_class, _postfix, _prefname)\
NS_IMETHODIMP								   	\
_class::Get##_postfix(PRInt32 *retval)   		\
{											   	\
  return GetIntValue(_prefname, retval);			\
}												\
NS_IMETHODIMP	   								\
_class::Set##_postfix(PRInt32 ivalue)			\
{												\
  return SetIntValue(_prefname, ivalue);			\
}
#define NS_IMPL_SERVERPREF_FILE(_class, _postfix, _prefname)\
NS_IMETHODIMP								   	\
_class::Get##_postfix(nsIFileSpec **retval)   		\
{											   	\
  return GetFileValue(_prefname, retval);			\
}												\
NS_IMETHODIMP	   								\
_class::Set##_postfix(nsIFileSpec* ivalue)			\
{												\
  return SetFileValue(_prefname, ivalue);			\
}

#endif /* __gen_nsIMsgIncomingServer_h__ */
