#!/bin/sh

# libmove sourcelib targetlib
#
# This allows you to move a new shared library into place,
# even on a running system.
libmove() {
  LIBSOURCE=$1
  LIBTARGET=$2
  LIBFOO="`dirname $LIBTARGET`/libfoo.so.0.0.0"
  # link duplicate of target lib so we can safely copy over it:
  if [ -r $LIBTARGET ]; then
    cp -a $LIBTARGET $LIBFOO
    if [ -x /sbin/ldconfig ]; then
      ldconfig -l $LIBFOO
    fi
  fi
  mv $LIBSOURCE $LIBTARGET
  if [ -x /sbin/ldconfig ]; then
    ldconfig -l $LIBTARGET
  fi
  rm -f $LIBFOO
}

( cd lib/incoming
  for file in * ; do
    libmove $file ../$file
  done )
( cd usr/lib/incoming
  for file in * ; do
    libmove $file ../$file
  done )
#### Now, get rid of the temporary directory:
rm -rf usr/lib/incoming lib/incoming

( cd usr/lib ; rm -rf libtermcap.so )
( cd usr/lib ; ln -sf /lib/libtermcap.so.2.0.8 libtermcap.so )

if [ -x /sbin/ldconfig ]; then
  ( cd lib ; /sbin/ldconfig . )
else
  ( cd lib ; rm -rf libtermcap.so.2 )
  ( cd lib ; ln -sf libtermcap.so.2.0.8 libtermcap.so.2 )
  ( cd lib ; rm -rf libncurses.so.5 )
  ( cd lib ; ln -sf libncurses.so.5.2 libncurses.so.5 )
  ( cd lib ; rm -rf libbz2.so.1.0 )
  ( cd lib ; ln -sf libbz2.so.1.0.1 libbz2.so.1.0 )
  ( cd usr/lib ; rm -rf libz.so.1 )
  ( cd usr/lib ; ln -sf libz.so.1.1.3 libz.so.1 )
  ( cd usr/lib ; rm -rf libvgagl.so.1 )
  ( cd usr/lib ; ln -sf libvgagl.so.1.4.3 libvgagl.so.1 )
  ( cd usr/lib ; rm -rf libvga.so.1 )
  ( cd usr/lib ; ln -sf libvga.so.1.4.3 libvga.so.1 )
  ( cd usr/lib ; rm -rf libtiff.so.3 )
  ( cd usr/lib ; ln -sf libtiff.so.3.5.5 libtiff.so.3 )
  ( cd usr/lib ; rm -rf libslang.so.1 )
  ( cd usr/lib ; ln -sf libslang.so.1.4.3 libslang.so.1 )
  ( cd usr/lib ; rm -rf librle.so.1 )
  ( cd usr/lib ; ln -sf librle.so.1.0.0 librle.so.1 )
  ( cd usr/lib ; rm -rf libppm.so.1 )
  ( cd usr/lib ; ln -sf libppm.so.1.0.0 libppm.so.1 )
  ( cd usr/lib ; rm -rf libpnm.so.1 )
  ( cd usr/lib ; ln -sf libpnm.so.1.0.0 libpnm.so.1 )
  ( cd usr/lib ; rm -rf libpng.so.2 )
  ( cd usr/lib ; ln -sf libpng.so.2.1.0.11 libpng.so.2 )
  ( cd usr/lib ; rm -rf libpgm.so.1 )
  ( cd usr/lib ; ln -sf libpgm.so.1.0.0 libpgm.so.1 )
  ( cd usr/lib ; rm -rf libpbm.so.1 )
  ( cd usr/lib ; ln -sf libpbm.so.1.0.0 libpbm.so.1 )
  ( cd usr/lib ; rm -rf libpanel.so.5 )
  ( cd usr/lib ; ln -sf libpanel.so.5.2 libpanel.so.5 )
  ( cd usr/lib ; rm -rf libmenu.so.5 )
  ( cd usr/lib ; ln -sf libmenu.so.5.2 libmenu.so.5 )
  ( cd usr/lib ; rm -rf libltdl.so.0 )
  ( cd usr/lib ; ln -sf libltdl.so.0.1.2 libltdl.so.0 )
  ( cd usr/lib ; rm -rf libjpeg.so.62 )
  ( cd usr/lib ; ln -sf libjpeg.so.62.0.0 libjpeg.so.62 )
  ( cd usr/lib ; rm -rf libhistory.so.3 )
  ( cd usr/lib ; ln -sf libhistory.so.3.0 libhistory.so.3 )
  ( cd usr/lib ; rm -rf libhistory.so.4 )
  ( cd usr/lib ; ln -sf libhistory.so.4.1 libhistory.so.4 )
  ( cd usr/lib ; rm -rf libreadline.so.3 )
  ( cd usr/lib ; ln -sf libreadline.so.3.0 libreadline.so.3 )
  ( cd usr/lib ; rm -rf libreadline.so.4 )
  ( cd usr/lib ; ln -sf libreadline.so.4.1 libreadline.so.4 )
  ( cd usr/lib ; rm -rf libgpm.so.1 )
  ( cd usr/lib ; ln -sf libgpm.so.1.18.0 libgpm.so.1 )
  ( cd usr/lib ; rm -rf libgmp.so.3 )
  ( cd usr/lib ; ln -sf libgmp.so.3.1.1 libgmp.so.3 )
  ( cd usr/lib ; rm -rf libgdbm.so.2 )
  ( cd usr/lib ; ln -sf libgdbm.so.2.0.0 libgdbm.so.2 )
  ( cd usr/lib ; rm -rf libform.so.5 )
  ( cd usr/lib ; ln -sf libform.so.5.2 libform.so.5 )
  ( cd usr/lib ; rm -rf libfbm.so.1 )
  ( cd usr/lib ; ln -sf libfbm.so.1.0.0 libfbm.so.1 )
  ( cd usr/lib ; rm -rf libpopt.so.0 )
  ( cd usr/lib ; ln -sf libpopt.so.0.0.0 libpopt.so.0 )
fi
