/*
Donut Bump Mapping Demo
This demo shows how to use a bump mapping technique using Glide(tm)
Copyright (C) 1999  3Dfx Interactive, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef __TEXCACHE_H__
#define __TEXCACHE_H__

#include "basics.h"

#define MAX_TMUS  2

// tga image types
#define TGA_NULL	0
#define TGA_CMAP	1
#define TGA_TRUE	2
#define TGA_MONO	3
#define TGA_CMAP_RLE	9
#define TGA_TRUE_RLE	10
#define TGA_MONO_RLE	11

typedef struct
{
	FxU8 id_length;
	FxU8 b_color_mapped;
	FxU8 image_type;
	FxU8 color_map_start_lo; // tmu_index of first...
	FxU8 color_map_start_hi; // ...color map entry
	FxU8 color_map_entries_lo; // number of entries...
	FxU8 color_map_entries_hi; // ...in color map
	FxU8 color_map_entry_size;
	FxU8 x_origin_lo;
	FxU8 x_origin_hi;
	FxU8 y_origin_lo;
	FxU8 y_origin_hi;
	FxU8 width_lo;
	FxU8 width_hi;
	FxU8 height_lo;
	FxU8 height_hi;
	FxU8 bpp;
	FxU8 reserved;
} TGA_Header;

class GlideTexture;

typedef struct _cache_info
{
	FxU32 start_address;
	FxBool b_cached;
	FxU32 time_last_used;
	GlideTexture *prev;
	GlideTexture *next;
} CacheInfo;

class GlideTexture
{
	friend class TextureCache;

public:
	GlideTexture();
	~GlideTexture();

	GrTexInfo tex_info;

private: // only TextureCache should access these members
	FxU32 memory_required;
	CacheInfo cache_info[MAX_TMUS];
};

class TextureCache
{
public:
	TextureCache(GrChipID_t tmu);
	~TextureCache();

	void DestroyGlideTexture(GlideTexture *texture);
	void CacheTexture(GlideTexture *texture);
	void ReloadTexture(GlideTexture *texture);
	void TexSource(GlideTexture *texture);
	void DefragmentTexCache();

private:
	void AppendGlideTexture(GlideTexture *texture);
	void RemoveGlideTexture(GlideTexture *texture);
	int CountFragments();
	void TexCacheDump();

	GrChipID_t m_tmu;
	int m_fragments;
	GlideTexture *m_start_tex_list;
	GlideTexture *m_end_tex_list;
};

// function prototypes
FxBool LoadGlideTextureTGA(char *filename, GrTexInfo *tex_info, GrTextureFormat_t tex_format, FxU8 alpha, FxU8 lods);
FxBool SpherizeTexture(GrTexInfo *tex_info);

#endif // __TEXCACHE_H__
