/*
Donut Bump Mapping Demo
This demo shows how to use a bump mapping technique using Glide(tm)
Copyright (C) 1999  3Dfx Interactive, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

//#define PRINT_ERROR

#ifdef PRINT_ERROR

#include "basics.h"
#include <stdarg.h>
#include "Printerr.h"

#define ERROR_FILE  "error.txt"

void PrintError(const char *format, ...)
{
	FILE *stream;
	va_list arg_list;
	static int first_time = 1;

	if (first_time)
	{
		first_time = 0;
		stream = fopen(ERROR_FILE, "w");
	}
	else
	{
		stream = fopen(ERROR_FILE, "a");
	}

	if (stream)
	{
		va_start(arg_list, format);
		vfprintf(stream, format, arg_list);
		va_end(arg_list);
		fflush(stream);
		fclose(stream);
	}
}
#else
void PrintError(const char *format, ...) { return; }
#endif // PRINT_ERROR










