/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import sun.awt.motif.MDataTransferer;
import sun.awt.motif.X11Selection;

final class FullyRenderedTransferable
implements Transferable {
    private final HashMap flavorsToData = new HashMap();
    private final DataFlavor[] flavors;
    private static DataFlavor plainTextStringFlavor;

    public FullyRenderedTransferable(X11Selection x11Selection) {
        Object object;
        Object object2;
        Object object3;
        int[] nArray = x11Selection.getSelectionTargets();
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if ((nArray[n2] == MDataTransferer.StringAtom || nArray[n2] == MDataTransferer.TextAtom) && n < nArray[n2]) {
                try {
                    object3 = x11Selection.getSelectionData(nArray[n2]);
                    if (object3 != null) {
                        object2 = MDataTransferer.getInstance().translateBytes((byte[])object3, plainTextStringFlavor, nArray[n2]);
                        object = new DataFactory(nArray[n2], (byte[])object3);
                        this.flavorsToData.put(DataFlavor.stringFlavor, object);
                        this.flavorsToData.put(DataFlavor.plainTextFlavor, object);
                        n = nArray[n2];
                    }
                }
                catch (IOException iOException) {
                    if (n == 0) {
                        this.flavorsToData.put(DataFlavor.stringFlavor, iOException);
                        this.flavorsToData.put(DataFlavor.plainTextFlavor, iOException);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            ++n2;
        }
        object3 = MDataTransferer.getInstance().getFlavorsForFormats(nArray, X11Selection.flavorMap);
        object2 = object3.keySet().iterator();
        while (object2.hasNext()) {
            object = (DataFlavor)object2.next();
            if (this.flavorsToData.containsKey(object)) continue;
            int n3 = (Integer)object3.get(object);
            try {
                byte[] byArray = x11Selection.getSelectionData(n3);
                DataFactory dataFactory = new DataFactory(n3, byArray);
                this.flavorsToData.put(object, dataFactory);
            }
            catch (IOException iOException) {
                this.flavorsToData.put(object, iOException);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.flavors = MDataTransferer.getInstance().setToSortedDataFlavorArray(this.flavorsToData.keySet(), (Map)object3);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.flavorsToData.containsKey(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        Object object = this.flavorsToData.get(dataFlavor);
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof DataFactory) {
            DataFactory dataFactory = (DataFactory)object;
            if (DataFlavor.stringFlavor.equals(dataFlavor) || DataFlavor.plainTextFlavor.equals(dataFlavor)) {
                object = dataFactory.getTransferData(plainTextStringFlavor);
                if (DataFlavor.plainTextFlavor.equals(dataFlavor) && object instanceof String) {
                    object = new StringReader((String)object);
                }
            } else {
                object = dataFactory.getTransferData(dataFlavor);
            }
        }
        return object;
    }

    static {
        try {
            plainTextStringFlavor = new DataFlavor("text/plain;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    static class DataFactory {
        final int format;
        final byte[] data;

        DataFactory(int n, byte[] byArray) {
            this.format = n;
            this.data = byArray;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws IOException {
            return MDataTransferer.getInstance().translateBytes(this.data, dataFlavor, this.format);
        }
    }
}

