/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicPopupMenuUI
extends PopupMenuUI {
    protected JPopupMenu popupMenu = null;
    private Frame frame;
    private static transient MouseGrabber mouseGrabber = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPopupMenuUI();
    }

    public void installUI(JComponent jComponent) {
        this.popupMenu = (JPopupMenu)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void installDefaults() {
        if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        }
        this.popupMenu.setOpaque(true);
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
    }

    protected void installListeners() {
        if (mouseGrabber == null) {
            mouseGrabber = new MouseGrabber();
        }
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.popupMenu = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.popupMenu);
    }

    protected void uninstallListeners() {
    }

    protected void uninstallKeyboardActions() {
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    private static Window getWindow(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Window) && component2 != null) {
            component2 = component2.getParent();
        }
        return (Window)component2;
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 502 && (mouseEvent.getModifiers() & 4) != 0;
    }

    private static class MouseGrabber
    implements MouseListener,
    MouseMotionListener,
    WindowListener,
    ComponentListener,
    ChangeListener {
        Vector grabbed = new Vector();
        MenuElement lastGrabbed = null;
        boolean lastGrabbedMenuBarChild = false;
        MenuElement[] lastPathSelected = new MenuElement[0];

        public MouseGrabber() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(this);
        }

        private void requestAddGrab(Component component) {
            Window window = BasicPopupMenuUI.getWindow(component);
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            Component component2 = null;
            int n = 0;
            while (component2 == null && n < menuElementArray.length) {
                if (menuElementArray[n] instanceof JPopupMenu) {
                    component2 = menuElementArray[n].getComponent();
                }
                ++n;
            }
            this.grabContainer(window, component2);
        }

        private void requestRemoveGrab() {
            this.ungrabContainers();
        }

        void cancelPopupMenu() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (this.lastGrabbed == this.getFirstPopup()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                this.ungrabContainers();
            } else {
                this.lastGrabbed = this.getFirstPopup();
                this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (this.lastPathSelected.length == 0 && menuElementArray.length != 0) {
                Component component = menuElementArray[0].getComponent();
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                }
                this.requestAddGrab(component);
            }
            if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                this.requestRemoveGrab();
            }
            if (menuElementArray != null && menuElementArray.length > 2 && menuElementArray[0] instanceof JMenuBar && this.lastGrabbedMenuBarChild && this.lastGrabbed != this.getFirstPopup()) {
                this.lastGrabbed = this.getFirstPopup();
                this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            }
            this.lastPathSelected = menuElementArray;
        }

        private MenuElement getFirstPopup() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            MenuElement menuElement = null;
            int n = 0;
            while (menuElement == null && n < menuElementArray.length) {
                if (menuElementArray[n] instanceof JPopupMenu) {
                    menuElement = menuElementArray[n];
                }
                ++n;
            }
            return menuElement;
        }

        void grabContainer(Container container, Component component) {
            if (container == component) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            this.lastGrabbed = this.getFirstPopup();
            this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            if (container instanceof Window) {
                ((Window)container).addWindowListener(this);
                ((Window)container).addComponentListener(this);
                this.grabbed.addElement(container);
            }
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getComponentCount();
                Component[] componentArray = container.getComponents();
                int n2 = 0;
                while (n2 < n) {
                    Component component2 = componentArray[n2];
                    if (component2.isVisible()) {
                        component2.addMouseListener(this);
                        component2.addMouseMotionListener(this);
                        this.grabbed.addElement(component2);
                        if (component2 instanceof Container) {
                            Container container2 = (Container)component2;
                            this.grabContainer(container2, component);
                        }
                    }
                    ++n2;
                }
            }
        }

        void ungrabContainers() {
            int n = 0;
            int n2 = this.grabbed.size();
            while (n < n2) {
                Component component = (Component)this.grabbed.elementAt(n);
                if (component instanceof Window) {
                    ((Window)component).removeWindowListener(this);
                    ((Window)component).removeComponentListener(this);
                } else {
                    component.removeMouseListener(this);
                    component.removeMouseMotionListener(this);
                }
                ++n;
            }
            this.grabbed = new Vector();
            this.lastGrabbed = null;
            this.lastGrabbedMenuBarChild = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            this.cancelPopupMenu();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowIconified(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

