/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class Package {
    private static Map pkgs = new HashMap(31);
    private static Map urls = new HashMap(10);
    private static Map mans = new HashMap(10);
    private String pkgName;
    private String specTitle;
    private String specVersion;
    private String specVendor;
    private String implTitle;
    private String implVersion;
    private String implVendor;
    private URL sealBase;

    public String getName() {
        return this.pkgName;
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public String getImplementationTitle() {
        return this.implTitle;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public boolean isSealed() {
        return this.sealBase != null;
    }

    public boolean isSealed(URL uRL) {
        return uRL.equals(this.sealBase);
    }

    public boolean isCompatibleWith(String string) throws NumberFormatException {
        if (this.specVersion == null || this.specVersion.length() < 1) {
            throw new NumberFormatException("Empty version string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.specVersion, ".", true);
        while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
            int n = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
            int n2 = stringTokenizer2.hasMoreTokens() ? Integer.parseInt(stringTokenizer2.nextToken()) : 0;
            if (n2 < n) {
                return false;
            }
            if (n2 > n) {
                return true;
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (!stringTokenizer2.hasMoreTokens()) continue;
            stringTokenizer2.nextToken();
        }
        return true;
    }

    public static Package getPackage(String string) {
        ClassLoader classLoader = ClassLoader.getCallerClassLoader();
        if (classLoader != null) {
            return classLoader.getPackage(string);
        }
        return Package.getSystemPackage(string);
    }

    public static Package[] getPackages() {
        ClassLoader classLoader = ClassLoader.getCallerClassLoader();
        if (classLoader != null) {
            return classLoader.getPackages();
        }
        return Package.getSystemPackages();
    }

    static Package getPackage(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != null) {
                return classLoader.getPackage(string);
            }
            return Package.getSystemPackage(string);
        }
        return null;
    }

    public int hashCode() {
        return this.pkgName.hashCode();
    }

    public String toString() {
        String string = this.specTitle;
        String string2 = this.specVersion;
        string = string != null && string.length() > 0 ? ", " + string : "";
        string2 = string2 != null && string2.length() > 0 ? ", version " + string2 : "";
        return "package " + this.pkgName + string + string2;
    }

    Package(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
        this.pkgName = string;
        this.implTitle = string5;
        this.implVersion = string6;
        this.implVendor = string7;
        this.specTitle = string2;
        this.specVersion = string3;
        this.specVendor = string4;
        this.sealBase = uRL;
    }

    private Package(String string, Manifest manifest, URL uRL) {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            this.specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            this.specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            this.specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            this.implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            this.implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            this.implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (this.specTitle == null) {
                this.specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (this.specVersion == null) {
                this.specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (this.specVendor == null) {
                this.specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (this.implTitle == null) {
                this.implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (this.implVersion == null) {
                this.implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (this.implVendor == null) {
                this.implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string3)) {
            this.sealBase = uRL;
        }
        this.pkgName = string;
    }

    static Package getSystemPackage(String string) {
        Map map = pkgs;
        synchronized (map) {
            Object object;
            Package package_ = (Package)pkgs.get(string);
            if (package_ == null && (object = Package.getSystemPackage0(string = string.replace('.', '/').concat("/"))) != null) {
                package_ = Package.defineSystemPackage(string, (String)object);
            }
            object = package_;
            return object;
        }
    }

    static Package[] getSystemPackages() {
        String[] stringArray = Package.getSystemPackages0();
        Map map = pkgs;
        synchronized (map) {
            int n = 0;
            while (n < stringArray.length) {
                Package.defineSystemPackage(stringArray[n], Package.getSystemPackage0(stringArray[n]));
                ++n;
            }
            Package[] packageArray = (Package[])pkgs.values().toArray(new Package[pkgs.size()]);
            return packageArray;
        }
    }

    private static Package defineSystemPackage(final String string, final String string2) {
        return (Package)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object object;
                String string3 = string;
                URL uRL = (URL)urls.get(string2);
                if (uRL == null) {
                    object = new File(string2);
                    try {
                        uRL = ((File)object).toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (uRL != null) {
                        urls.put(string2, uRL);
                        if (((File)object).isFile()) {
                            mans.put(string2, Package.loadManifest(string2));
                        }
                    }
                }
                string3 = string3.substring(0, string3.length() - 1).replace('/', '.');
                Manifest manifest = (Manifest)mans.get(string2);
                object = manifest != null ? new Package(string3, manifest, uRL) : new Package(string3, null, null, null, null, null, null, null);
                pkgs.put(string3, object);
                return object;
            }
        });
    }

    private static Manifest loadManifest(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            JarInputStream jarInputStream = new JarInputStream((InputStream)fileInputStream, false);
            Manifest manifest = jarInputStream.getManifest();
            jarInputStream.close();
            return manifest;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static native String getSystemPackage0(String var0);

    private static native String[] getSystemPackages0();
}

