/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ListPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class List
extends Component
implements ItemSelectable,
Accessible {
    Vector items = new Vector();
    int rows = 0;
    boolean multipleMode = false;
    int[] selected = new int[0];
    int visibleIndex = -1;
    transient ActionListener actionListener;
    transient ItemListener itemListener;
    private static final String base = "list";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -3304312411574666869L;
    static final int DEFAULT_VISIBLE_ROWS = 4;
    private int listSerializedDataVersion = 1;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public List() {
        this(0, false);
    }

    public List(int n) {
        this(n, false);
    }

    public List(int n, boolean bl) {
        this.rows = n != 0 ? n : 4;
        this.multipleMode = bl;
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            return string;
        }
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createList(this);
            }
            super.addNotify();
            this.visibleIndex = -1;
        }
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            ListPeer listPeer = (ListPeer)this.peer;
            if (listPeer != null) {
                this.selected = listPeer.getSelectedIndexes();
            }
            super.removeNotify();
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.items.size();
    }

    public String getItem(int n) {
        return this.getItemImpl(n);
    }

    final String getItemImpl(int n) {
        return (String)this.items.elementAt(n);
    }

    public synchronized String[] getItems() {
        Object[] objectArray = new String[this.items.size()];
        this.items.copyInto(objectArray);
        return objectArray;
    }

    public void add(String string) {
        this.addItem(string);
    }

    public void addItem(String string) {
        this.addItem(string, -1);
    }

    public void add(String string, int n) {
        this.addItem(string, n);
    }

    public synchronized void addItem(String string, int n) {
        if (n < -1 || n >= this.items.size()) {
            n = -1;
        }
        if (string == null) {
            string = "";
        }
        if (n == -1) {
            this.items.addElement(string);
        } else {
            this.items.insertElementAt(string, n);
        }
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.addItem(string, n);
        }
    }

    public synchronized void replaceItem(String string, int n) {
        this.remove(n);
        this.add(string, n);
    }

    public void removeAll() {
        this.clear();
    }

    public synchronized void clear() {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.clear();
        }
        this.items = new Vector();
        this.selected = new int[0];
    }

    public synchronized void remove(String string) {
        int n = this.items.indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("item " + string + " not found in list");
        }
        this.remove(n);
    }

    public void remove(int n) {
        this.delItem(n);
    }

    public void delItem(int n) {
        this.delItems(n, n);
    }

    public synchronized int getSelectedIndex() {
        int[] nArray = this.getSelectedIndexes();
        return nArray.length == 1 ? nArray[0] : -1;
    }

    public synchronized int[] getSelectedIndexes() {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            this.selected = listPeer.getSelectedIndexes();
        }
        return this.selected;
    }

    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        return n < 0 ? null : this.getItem(n);
    }

    public synchronized String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = this.getItem(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    public void select(int n) {
        ListPeer listPeer;
        do {
            if ((listPeer = (ListPeer)this.peer) != null) {
                listPeer.select(n);
                return;
            }
            List list = this;
            synchronized (list) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < this.selected.length) {
                    if (this.selected[n2] == n) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    if (!this.multipleMode) {
                        this.selected = new int[1];
                        this.selected[0] = n;
                    } else {
                        int[] nArray = new int[this.selected.length + 1];
                        System.arraycopy(this.selected, 0, nArray, 0, this.selected.length);
                        nArray[this.selected.length] = n;
                        this.selected = nArray;
                    }
                }
            }
        } while (listPeer != this.peer);
    }

    public synchronized void deselect(int n) {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.deselect(n);
        }
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2] == n) {
                int[] nArray = new int[this.selected.length - 1];
                System.arraycopy(this.selected, 0, nArray, 0, n2);
                System.arraycopy(this.selected, n2 + 1, nArray, n2, this.selected.length - (n2 + 1));
                this.selected = nArray;
                return;
            }
            ++n2;
        }
    }

    public boolean isIndexSelected(int n) {
        return this.isSelected(n);
    }

    public boolean isSelected(int n) {
        int[] nArray = this.getSelectedIndexes();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isMultipleMode() {
        return this.allowsMultipleSelections();
    }

    public boolean allowsMultipleSelections() {
        return this.multipleMode;
    }

    public void setMultipleMode(boolean bl) {
        this.setMultipleSelections(bl);
    }

    public synchronized void setMultipleSelections(boolean bl) {
        if (bl != this.multipleMode) {
            this.multipleMode = bl;
            ListPeer listPeer = (ListPeer)this.peer;
            if (listPeer != null) {
                listPeer.setMultipleSelections(bl);
            }
        }
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public synchronized void makeVisible(int n) {
        this.visibleIndex = n;
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.makeVisible(n);
        }
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public Dimension preferredSize(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            ListPeer listPeer = (ListPeer)this.peer;
            Dimension dimension = listPeer != null ? listPeer.preferredSize(n) : super.preferredSize();
            return dimension;
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension = this.rows > 0 ? this.preferredSize(this.rows) : super.preferredSize();
            return dimension;
        }
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension minimumSize(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            ListPeer listPeer = (ListPeer)this.peer;
            Dimension dimension = listPeer != null ? listPeer.minimumSize(n) : super.minimumSize();
            return dimension;
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension = this.rows > 0 ? this.minimumSize(this.rows) : super.minimumSize();
            return dimension;
        }
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public EventListener[] getListeners(Class clazz) {
        EventListener eventListener = null;
        if (clazz == (class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = List.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener)) {
            eventListener = this.actionListener;
        } else if (clazz == (class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = List.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener)) {
            eventListener = this.itemListener;
        } else {
            return super.getListeners(clazz);
        }
        return AWTEventMulticaster.getListeners(eventListener, clazz);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        switch (aWTEvent.id) {
            case 1001: {
                return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
            }
            case 701: {
                return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
            }
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    protected String paramString() {
        return super.paramString() + ",selected=" + this.getSelectedItem();
    }

    public synchronized void delItems(int n, int n2) {
        int n3 = n2;
        while (n3 >= n) {
            this.items.removeElementAt(n3);
            --n3;
        }
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.delItems(n, n2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        List list = this;
        synchronized (list) {
            ListPeer listPeer = (ListPeer)this.peer;
            if (listPeer != null) {
                this.selected = listPeer.getSelectedIndexes();
            }
        }
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("itemL" == string) {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            if ("actionL" == string) {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTList();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleAWTList
    extends Component.AccessibleAWTComponent
    implements AccessibleSelection,
    ItemListener,
    ActionListener {
        public AccessibleAWTList() {
            List.this.addActionListener(this);
            List.this.addItemListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (List.this.isMultipleMode()) {
                accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public int getAccessibleChildrenCount() {
            return List.this.getItemCount();
        }

        public Accessible getAccessibleChild(int n) {
            List list = List.this;
            synchronized (list) {
                if (n >= List.this.getItemCount()) {
                    Accessible accessible = null;
                    return accessible;
                }
                AccessibleAWTListChild accessibleAWTListChild = new AccessibleAWTListChild(List.this, n);
                return accessibleAWTListChild;
            }
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            return List.this.getSelectedIndexes().length;
        }

        public Accessible getAccessibleSelection(int n) {
            List list = List.this;
            synchronized (list) {
                int n2 = this.getAccessibleSelectionCount();
                if (n <= 0 || n >= n2) {
                    Accessible accessible = null;
                    return accessible;
                }
                Accessible accessible = this.getAccessibleChild(List.this.getSelectedIndexes()[n]);
                return accessible;
            }
        }

        public boolean isAccessibleChildSelected(int n) {
            return List.this.isIndexSelected(n);
        }

        public void addAccessibleSelection(int n) {
            List.this.select(n);
        }

        public void removeAccessibleSelection(int n) {
            List.this.deselect(n);
        }

        public void clearAccessibleSelection() {
            List list = List.this;
            synchronized (list) {
                int[] nArray = List.this.getSelectedIndexes();
                if (nArray == null) {
                    return;
                }
                int n = nArray.length;
                while (n >= 0) {
                    List.this.deselect(nArray[n]);
                    --n;
                }
            }
        }

        public void selectAllAccessibleSelection() {
            List list = List.this;
            synchronized (list) {
                int n = List.this.getItemCount() - 1;
                while (n >= 0) {
                    List.this.select(n);
                    --n;
                }
            }
        }

        static /* synthetic */ List access$000(AccessibleAWTList accessibleAWTList) {
            return accessibleAWTList.List.this;
        }

        protected class AccessibleAWTListChild
        extends Component.AccessibleAWTComponent
        implements Accessible {
            private List parent;
            private int indexInParent;

            public AccessibleAWTListChild(List list, int n) {
                this.parent = list;
                this.setAccessibleParent(list);
                this.indexInParent = n;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LIST_ITEM;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
                if (this.parent.isIndexSelected(this.indexInParent)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                return accessibleStateSet;
            }

            public Locale getLocale() {
                return this.parent.getLocale();
            }

            public int getAccessibleIndexInParent() {
                return this.indexInParent;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                return null;
            }

            public Color getBackground() {
                return this.parent.getBackground();
            }

            public void setBackground(Color color) {
                this.parent.setBackground(color);
            }

            public Color getForeground() {
                return this.parent.getForeground();
            }

            public void setForeground(Color color) {
                this.parent.setForeground(color);
            }

            public Cursor getCursor() {
                return this.parent.getCursor();
            }

            public void setCursor(Cursor cursor) {
                this.parent.setCursor(cursor);
            }

            public Font getFont() {
                return this.parent.getFont();
            }

            public void setFont(Font font) {
                this.parent.setFont(font);
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.parent.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return this.parent.isEnabled();
            }

            public void setEnabled(boolean bl) {
                this.parent.setEnabled(bl);
            }

            public boolean isVisible() {
                return false;
            }

            public void setVisible(boolean bl) {
                this.parent.setVisible(bl);
            }

            public boolean isShowing() {
                return false;
            }

            public boolean contains(Point point) {
                return false;
            }

            public Point getLocationOnScreen() {
                return null;
            }

            public Point getLocation() {
                return null;
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                return null;
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                return null;
            }

            public void setSize(Dimension dimension) {
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }

            public boolean isFocusTraversable() {
                return false;
            }

            public void requestFocus() {
            }

            public void addFocusListener(FocusListener focusListener) {
            }

            public void removeFocusListener(FocusListener focusListener) {
            }
        }
    }
}

